/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.proto = (function() {

    /**
     * Namespace proto.
     * @exports proto
     * @namespace
     */
    var proto = {};

    proto.AppVersion = (function() {

        /**
         * Properties of an AppVersion.
         * @memberof proto
         * @interface IAppVersion
         * @property {number|null} [primary] AppVersion primary
         * @property {number|null} [secondary] AppVersion secondary
         * @property {number|null} [tertiary] AppVersion tertiary
         * @property {number|null} [quaternary] AppVersion quaternary
         * @property {number|null} [quinary] AppVersion quinary
         */

        /**
         * Constructs a new AppVersion.
         * @memberof proto
         * @classdesc Represents an AppVersion.
         * @implements IAppVersion
         * @constructor
         * @param {proto.IAppVersion=} [properties] Properties to set
         */
        function AppVersion(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppVersion primary.
         * @member {number} primary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.primary = 0;

        /**
         * AppVersion secondary.
         * @member {number} secondary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.secondary = 0;

        /**
         * AppVersion tertiary.
         * @member {number} tertiary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.tertiary = 0;

        /**
         * AppVersion quaternary.
         * @member {number} quaternary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.quaternary = 0;

        /**
         * AppVersion quinary.
         * @member {number} quinary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.quinary = 0;

        /**
         * Creates a new AppVersion instance using the specified properties.
         * @function create
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion=} [properties] Properties to set
         * @returns {proto.AppVersion} AppVersion instance
         */
        AppVersion.create = function create(properties) {
            return new AppVersion(properties);
        };

        /**
         * Encodes the specified AppVersion message. Does not implicitly {@link proto.AppVersion.verify|verify} messages.
         * @function encode
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion} message AppVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppVersion.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.primary != null && Object.hasOwnProperty.call(message, "primary"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.primary);
            if (message.secondary != null && Object.hasOwnProperty.call(message, "secondary"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.secondary);
            if (message.tertiary != null && Object.hasOwnProperty.call(message, "tertiary"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.tertiary);
            if (message.quaternary != null && Object.hasOwnProperty.call(message, "quaternary"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.quaternary);
            if (message.quinary != null && Object.hasOwnProperty.call(message, "quinary"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.quinary);
            return writer;
        };

        /**
         * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.AppVersion.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion} message AppVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppVersion.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppVersion message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppVersion} AppVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppVersion.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppVersion();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.primary = reader.uint32();
                    break;
                case 2:
                    message.secondary = reader.uint32();
                    break;
                case 3:
                    message.tertiary = reader.uint32();
                    break;
                case 4:
                    message.quaternary = reader.uint32();
                    break;
                case 5:
                    message.quinary = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppVersion message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppVersion} AppVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppVersion.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppVersion message.
         * @function verify
         * @memberof proto.AppVersion
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppVersion.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.primary != null && message.hasOwnProperty("primary"))
                if (!$util.isInteger(message.primary))
                    return "primary: integer expected";
            if (message.secondary != null && message.hasOwnProperty("secondary"))
                if (!$util.isInteger(message.secondary))
                    return "secondary: integer expected";
            if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                if (!$util.isInteger(message.tertiary))
                    return "tertiary: integer expected";
            if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                if (!$util.isInteger(message.quaternary))
                    return "quaternary: integer expected";
            if (message.quinary != null && message.hasOwnProperty("quinary"))
                if (!$util.isInteger(message.quinary))
                    return "quinary: integer expected";
            return null;
        };

        /**
         * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppVersion
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppVersion} AppVersion
         */
        AppVersion.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppVersion)
                return object;
            var message = new $root.proto.AppVersion();
            if (object.primary != null)
                message.primary = object.primary >>> 0;
            if (object.secondary != null)
                message.secondary = object.secondary >>> 0;
            if (object.tertiary != null)
                message.tertiary = object.tertiary >>> 0;
            if (object.quaternary != null)
                message.quaternary = object.quaternary >>> 0;
            if (object.quinary != null)
                message.quinary = object.quinary >>> 0;
            return message;
        };

        /**
         * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppVersion
         * @static
         * @param {proto.AppVersion} message AppVersion
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppVersion.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.primary = 0;
                object.secondary = 0;
                object.tertiary = 0;
                object.quaternary = 0;
                object.quinary = 0;
            }
            if (message.primary != null && message.hasOwnProperty("primary"))
                object.primary = message.primary;
            if (message.secondary != null && message.hasOwnProperty("secondary"))
                object.secondary = message.secondary;
            if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                object.tertiary = message.tertiary;
            if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                object.quaternary = message.quaternary;
            if (message.quinary != null && message.hasOwnProperty("quinary"))
                object.quinary = message.quinary;
            return object;
        };

        /**
         * Converts this AppVersion to JSON.
         * @function toJSON
         * @memberof proto.AppVersion
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppVersion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppVersion;
    })();

    proto.UserAgent = (function() {

        /**
         * Properties of a UserAgent.
         * @memberof proto
         * @interface IUserAgent
         * @property {proto.UserAgent.UserAgentPlatform|null} [platform] UserAgent platform
         * @property {proto.IAppVersion|null} [appVersion] UserAgent appVersion
         * @property {string|null} [mcc] UserAgent mcc
         * @property {string|null} [mnc] UserAgent mnc
         * @property {string|null} [osVersion] UserAgent osVersion
         * @property {string|null} [manufacturer] UserAgent manufacturer
         * @property {string|null} [device] UserAgent device
         * @property {string|null} [osBuildNumber] UserAgent osBuildNumber
         * @property {string|null} [phoneId] UserAgent phoneId
         * @property {proto.UserAgent.UserAgentReleaseChannel|null} [releaseChannel] UserAgent releaseChannel
         * @property {string|null} [localeLanguageIso6391] UserAgent localeLanguageIso6391
         * @property {string|null} [localeCountryIso31661Alpha2] UserAgent localeCountryIso31661Alpha2
         * @property {string|null} [deviceBoard] UserAgent deviceBoard
         */

        /**
         * Constructs a new UserAgent.
         * @memberof proto
         * @classdesc Represents a UserAgent.
         * @implements IUserAgent
         * @constructor
         * @param {proto.IUserAgent=} [properties] Properties to set
         */
        function UserAgent(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UserAgent platform.
         * @member {proto.UserAgent.UserAgentPlatform} platform
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.platform = 0;

        /**
         * UserAgent appVersion.
         * @member {proto.IAppVersion|null|undefined} appVersion
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.appVersion = null;

        /**
         * UserAgent mcc.
         * @member {string} mcc
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.mcc = "";

        /**
         * UserAgent mnc.
         * @member {string} mnc
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.mnc = "";

        /**
         * UserAgent osVersion.
         * @member {string} osVersion
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.osVersion = "";

        /**
         * UserAgent manufacturer.
         * @member {string} manufacturer
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.manufacturer = "";

        /**
         * UserAgent device.
         * @member {string} device
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.device = "";

        /**
         * UserAgent osBuildNumber.
         * @member {string} osBuildNumber
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.osBuildNumber = "";

        /**
         * UserAgent phoneId.
         * @member {string} phoneId
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.phoneId = "";

        /**
         * UserAgent releaseChannel.
         * @member {proto.UserAgent.UserAgentReleaseChannel} releaseChannel
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.releaseChannel = 0;

        /**
         * UserAgent localeLanguageIso6391.
         * @member {string} localeLanguageIso6391
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.localeLanguageIso6391 = "";

        /**
         * UserAgent localeCountryIso31661Alpha2.
         * @member {string} localeCountryIso31661Alpha2
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.localeCountryIso31661Alpha2 = "";

        /**
         * UserAgent deviceBoard.
         * @member {string} deviceBoard
         * @memberof proto.UserAgent
         * @instance
         */
        UserAgent.prototype.deviceBoard = "";

        /**
         * Creates a new UserAgent instance using the specified properties.
         * @function create
         * @memberof proto.UserAgent
         * @static
         * @param {proto.IUserAgent=} [properties] Properties to set
         * @returns {proto.UserAgent} UserAgent instance
         */
        UserAgent.create = function create(properties) {
            return new UserAgent(properties);
        };

        /**
         * Encodes the specified UserAgent message. Does not implicitly {@link proto.UserAgent.verify|verify} messages.
         * @function encode
         * @memberof proto.UserAgent
         * @static
         * @param {proto.IUserAgent} message UserAgent message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserAgent.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.platform != null && Object.hasOwnProperty.call(message, "platform"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.platform);
            if (message.appVersion != null && Object.hasOwnProperty.call(message, "appVersion"))
                $root.proto.AppVersion.encode(message.appVersion, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.mcc != null && Object.hasOwnProperty.call(message, "mcc"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.mcc);
            if (message.mnc != null && Object.hasOwnProperty.call(message, "mnc"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.mnc);
            if (message.osVersion != null && Object.hasOwnProperty.call(message, "osVersion"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.osVersion);
            if (message.manufacturer != null && Object.hasOwnProperty.call(message, "manufacturer"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.manufacturer);
            if (message.device != null && Object.hasOwnProperty.call(message, "device"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.device);
            if (message.osBuildNumber != null && Object.hasOwnProperty.call(message, "osBuildNumber"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.osBuildNumber);
            if (message.phoneId != null && Object.hasOwnProperty.call(message, "phoneId"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.phoneId);
            if (message.releaseChannel != null && Object.hasOwnProperty.call(message, "releaseChannel"))
                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.releaseChannel);
            if (message.localeLanguageIso6391 != null && Object.hasOwnProperty.call(message, "localeLanguageIso6391"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.localeLanguageIso6391);
            if (message.localeCountryIso31661Alpha2 != null && Object.hasOwnProperty.call(message, "localeCountryIso31661Alpha2"))
                writer.uint32(/* id 12, wireType 2 =*/98).string(message.localeCountryIso31661Alpha2);
            if (message.deviceBoard != null && Object.hasOwnProperty.call(message, "deviceBoard"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.deviceBoard);
            return writer;
        };

        /**
         * Encodes the specified UserAgent message, length delimited. Does not implicitly {@link proto.UserAgent.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.UserAgent
         * @static
         * @param {proto.IUserAgent} message UserAgent message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserAgent.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a UserAgent message from the specified reader or buffer.
         * @function decode
         * @memberof proto.UserAgent
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.UserAgent} UserAgent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserAgent.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.UserAgent();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.platform = reader.int32();
                    break;
                case 2:
                    message.appVersion = $root.proto.AppVersion.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.mcc = reader.string();
                    break;
                case 4:
                    message.mnc = reader.string();
                    break;
                case 5:
                    message.osVersion = reader.string();
                    break;
                case 6:
                    message.manufacturer = reader.string();
                    break;
                case 7:
                    message.device = reader.string();
                    break;
                case 8:
                    message.osBuildNumber = reader.string();
                    break;
                case 9:
                    message.phoneId = reader.string();
                    break;
                case 10:
                    message.releaseChannel = reader.int32();
                    break;
                case 11:
                    message.localeLanguageIso6391 = reader.string();
                    break;
                case 12:
                    message.localeCountryIso31661Alpha2 = reader.string();
                    break;
                case 13:
                    message.deviceBoard = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a UserAgent message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.UserAgent
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.UserAgent} UserAgent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserAgent.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a UserAgent message.
         * @function verify
         * @memberof proto.UserAgent
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UserAgent.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.platform != null && message.hasOwnProperty("platform"))
                switch (message.platform) {
                default:
                    return "platform: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                case 17:
                case 18:
                case 19:
                case 20:
                case 21:
                case 22:
                case 23:
                case 24:
                case 25:
                case 26:
                case 27:
                case 28:
                    break;
                }
            if (message.appVersion != null && message.hasOwnProperty("appVersion")) {
                var error = $root.proto.AppVersion.verify(message.appVersion);
                if (error)
                    return "appVersion." + error;
            }
            if (message.mcc != null && message.hasOwnProperty("mcc"))
                if (!$util.isString(message.mcc))
                    return "mcc: string expected";
            if (message.mnc != null && message.hasOwnProperty("mnc"))
                if (!$util.isString(message.mnc))
                    return "mnc: string expected";
            if (message.osVersion != null && message.hasOwnProperty("osVersion"))
                if (!$util.isString(message.osVersion))
                    return "osVersion: string expected";
            if (message.manufacturer != null && message.hasOwnProperty("manufacturer"))
                if (!$util.isString(message.manufacturer))
                    return "manufacturer: string expected";
            if (message.device != null && message.hasOwnProperty("device"))
                if (!$util.isString(message.device))
                    return "device: string expected";
            if (message.osBuildNumber != null && message.hasOwnProperty("osBuildNumber"))
                if (!$util.isString(message.osBuildNumber))
                    return "osBuildNumber: string expected";
            if (message.phoneId != null && message.hasOwnProperty("phoneId"))
                if (!$util.isString(message.phoneId))
                    return "phoneId: string expected";
            if (message.releaseChannel != null && message.hasOwnProperty("releaseChannel"))
                switch (message.releaseChannel) {
                default:
                    return "releaseChannel: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                }
            if (message.localeLanguageIso6391 != null && message.hasOwnProperty("localeLanguageIso6391"))
                if (!$util.isString(message.localeLanguageIso6391))
                    return "localeLanguageIso6391: string expected";
            if (message.localeCountryIso31661Alpha2 != null && message.hasOwnProperty("localeCountryIso31661Alpha2"))
                if (!$util.isString(message.localeCountryIso31661Alpha2))
                    return "localeCountryIso31661Alpha2: string expected";
            if (message.deviceBoard != null && message.hasOwnProperty("deviceBoard"))
                if (!$util.isString(message.deviceBoard))
                    return "deviceBoard: string expected";
            return null;
        };

        /**
         * Creates a UserAgent message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.UserAgent
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.UserAgent} UserAgent
         */
        UserAgent.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.UserAgent)
                return object;
            var message = new $root.proto.UserAgent();
            switch (object.platform) {
            case "ANDROID":
            case 0:
                message.platform = 0;
                break;
            case "IOS":
            case 1:
                message.platform = 1;
                break;
            case "WINDOWS_PHONE":
            case 2:
                message.platform = 2;
                break;
            case "BLACKBERRY":
            case 3:
                message.platform = 3;
                break;
            case "BLACKBERRYX":
            case 4:
                message.platform = 4;
                break;
            case "S40":
            case 5:
                message.platform = 5;
                break;
            case "S60":
            case 6:
                message.platform = 6;
                break;
            case "PYTHON_CLIENT":
            case 7:
                message.platform = 7;
                break;
            case "TIZEN":
            case 8:
                message.platform = 8;
                break;
            case "ENTERPRISE":
            case 9:
                message.platform = 9;
                break;
            case "SMB_ANDROID":
            case 10:
                message.platform = 10;
                break;
            case "KAIOS":
            case 11:
                message.platform = 11;
                break;
            case "SMB_IOS":
            case 12:
                message.platform = 12;
                break;
            case "WINDOWS":
            case 13:
                message.platform = 13;
                break;
            case "WEB":
            case 14:
                message.platform = 14;
                break;
            case "PORTAL":
            case 15:
                message.platform = 15;
                break;
            case "GREEN_ANDROID":
            case 16:
                message.platform = 16;
                break;
            case "GREEN_IPHONE":
            case 17:
                message.platform = 17;
                break;
            case "BLUE_ANDROID":
            case 18:
                message.platform = 18;
                break;
            case "BLUE_IPHONE":
            case 19:
                message.platform = 19;
                break;
            case "FBLITE_ANDROID":
            case 20:
                message.platform = 20;
                break;
            case "MLITE_ANDROID":
            case 21:
                message.platform = 21;
                break;
            case "IGLITE_ANDROID":
            case 22:
                message.platform = 22;
                break;
            case "PAGE":
            case 23:
                message.platform = 23;
                break;
            case "MACOS":
            case 24:
                message.platform = 24;
                break;
            case "OCULUS_MSG":
            case 25:
                message.platform = 25;
                break;
            case "OCULUS_CALL":
            case 26:
                message.platform = 26;
                break;
            case "MILAN":
            case 27:
                message.platform = 27;
                break;
            case "CAPI":
            case 28:
                message.platform = 28;
                break;
            }
            if (object.appVersion != null) {
                if (typeof object.appVersion !== "object")
                    throw TypeError(".proto.UserAgent.appVersion: object expected");
                message.appVersion = $root.proto.AppVersion.fromObject(object.appVersion);
            }
            if (object.mcc != null)
                message.mcc = String(object.mcc);
            if (object.mnc != null)
                message.mnc = String(object.mnc);
            if (object.osVersion != null)
                message.osVersion = String(object.osVersion);
            if (object.manufacturer != null)
                message.manufacturer = String(object.manufacturer);
            if (object.device != null)
                message.device = String(object.device);
            if (object.osBuildNumber != null)
                message.osBuildNumber = String(object.osBuildNumber);
            if (object.phoneId != null)
                message.phoneId = String(object.phoneId);
            switch (object.releaseChannel) {
            case "RELEASE":
            case 0:
                message.releaseChannel = 0;
                break;
            case "BETA":
            case 1:
                message.releaseChannel = 1;
                break;
            case "ALPHA":
            case 2:
                message.releaseChannel = 2;
                break;
            case "DEBUG":
            case 3:
                message.releaseChannel = 3;
                break;
            }
            if (object.localeLanguageIso6391 != null)
                message.localeLanguageIso6391 = String(object.localeLanguageIso6391);
            if (object.localeCountryIso31661Alpha2 != null)
                message.localeCountryIso31661Alpha2 = String(object.localeCountryIso31661Alpha2);
            if (object.deviceBoard != null)
                message.deviceBoard = String(object.deviceBoard);
            return message;
        };

        /**
         * Creates a plain object from a UserAgent message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.UserAgent
         * @static
         * @param {proto.UserAgent} message UserAgent
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UserAgent.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.platform = options.enums === String ? "ANDROID" : 0;
                object.appVersion = null;
                object.mcc = "";
                object.mnc = "";
                object.osVersion = "";
                object.manufacturer = "";
                object.device = "";
                object.osBuildNumber = "";
                object.phoneId = "";
                object.releaseChannel = options.enums === String ? "RELEASE" : 0;
                object.localeLanguageIso6391 = "";
                object.localeCountryIso31661Alpha2 = "";
                object.deviceBoard = "";
            }
            if (message.platform != null && message.hasOwnProperty("platform"))
                object.platform = options.enums === String ? $root.proto.UserAgent.UserAgentPlatform[message.platform] : message.platform;
            if (message.appVersion != null && message.hasOwnProperty("appVersion"))
                object.appVersion = $root.proto.AppVersion.toObject(message.appVersion, options);
            if (message.mcc != null && message.hasOwnProperty("mcc"))
                object.mcc = message.mcc;
            if (message.mnc != null && message.hasOwnProperty("mnc"))
                object.mnc = message.mnc;
            if (message.osVersion != null && message.hasOwnProperty("osVersion"))
                object.osVersion = message.osVersion;
            if (message.manufacturer != null && message.hasOwnProperty("manufacturer"))
                object.manufacturer = message.manufacturer;
            if (message.device != null && message.hasOwnProperty("device"))
                object.device = message.device;
            if (message.osBuildNumber != null && message.hasOwnProperty("osBuildNumber"))
                object.osBuildNumber = message.osBuildNumber;
            if (message.phoneId != null && message.hasOwnProperty("phoneId"))
                object.phoneId = message.phoneId;
            if (message.releaseChannel != null && message.hasOwnProperty("releaseChannel"))
                object.releaseChannel = options.enums === String ? $root.proto.UserAgent.UserAgentReleaseChannel[message.releaseChannel] : message.releaseChannel;
            if (message.localeLanguageIso6391 != null && message.hasOwnProperty("localeLanguageIso6391"))
                object.localeLanguageIso6391 = message.localeLanguageIso6391;
            if (message.localeCountryIso31661Alpha2 != null && message.hasOwnProperty("localeCountryIso31661Alpha2"))
                object.localeCountryIso31661Alpha2 = message.localeCountryIso31661Alpha2;
            if (message.deviceBoard != null && message.hasOwnProperty("deviceBoard"))
                object.deviceBoard = message.deviceBoard;
            return object;
        };

        /**
         * Converts this UserAgent to JSON.
         * @function toJSON
         * @memberof proto.UserAgent
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UserAgent.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * UserAgentPlatform enum.
         * @name proto.UserAgent.UserAgentPlatform
         * @enum {number}
         * @property {number} ANDROID=0 ANDROID value
         * @property {number} IOS=1 IOS value
         * @property {number} WINDOWS_PHONE=2 WINDOWS_PHONE value
         * @property {number} BLACKBERRY=3 BLACKBERRY value
         * @property {number} BLACKBERRYX=4 BLACKBERRYX value
         * @property {number} S40=5 S40 value
         * @property {number} S60=6 S60 value
         * @property {number} PYTHON_CLIENT=7 PYTHON_CLIENT value
         * @property {number} TIZEN=8 TIZEN value
         * @property {number} ENTERPRISE=9 ENTERPRISE value
         * @property {number} SMB_ANDROID=10 SMB_ANDROID value
         * @property {number} KAIOS=11 KAIOS value
         * @property {number} SMB_IOS=12 SMB_IOS value
         * @property {number} WINDOWS=13 WINDOWS value
         * @property {number} WEB=14 WEB value
         * @property {number} PORTAL=15 PORTAL value
         * @property {number} GREEN_ANDROID=16 GREEN_ANDROID value
         * @property {number} GREEN_IPHONE=17 GREEN_IPHONE value
         * @property {number} BLUE_ANDROID=18 BLUE_ANDROID value
         * @property {number} BLUE_IPHONE=19 BLUE_IPHONE value
         * @property {number} FBLITE_ANDROID=20 FBLITE_ANDROID value
         * @property {number} MLITE_ANDROID=21 MLITE_ANDROID value
         * @property {number} IGLITE_ANDROID=22 IGLITE_ANDROID value
         * @property {number} PAGE=23 PAGE value
         * @property {number} MACOS=24 MACOS value
         * @property {number} OCULUS_MSG=25 OCULUS_MSG value
         * @property {number} OCULUS_CALL=26 OCULUS_CALL value
         * @property {number} MILAN=27 MILAN value
         * @property {number} CAPI=28 CAPI value
         */
        UserAgent.UserAgentPlatform = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ANDROID"] = 0;
            values[valuesById[1] = "IOS"] = 1;
            values[valuesById[2] = "WINDOWS_PHONE"] = 2;
            values[valuesById[3] = "BLACKBERRY"] = 3;
            values[valuesById[4] = "BLACKBERRYX"] = 4;
            values[valuesById[5] = "S40"] = 5;
            values[valuesById[6] = "S60"] = 6;
            values[valuesById[7] = "PYTHON_CLIENT"] = 7;
            values[valuesById[8] = "TIZEN"] = 8;
            values[valuesById[9] = "ENTERPRISE"] = 9;
            values[valuesById[10] = "SMB_ANDROID"] = 10;
            values[valuesById[11] = "KAIOS"] = 11;
            values[valuesById[12] = "SMB_IOS"] = 12;
            values[valuesById[13] = "WINDOWS"] = 13;
            values[valuesById[14] = "WEB"] = 14;
            values[valuesById[15] = "PORTAL"] = 15;
            values[valuesById[16] = "GREEN_ANDROID"] = 16;
            values[valuesById[17] = "GREEN_IPHONE"] = 17;
            values[valuesById[18] = "BLUE_ANDROID"] = 18;
            values[valuesById[19] = "BLUE_IPHONE"] = 19;
            values[valuesById[20] = "FBLITE_ANDROID"] = 20;
            values[valuesById[21] = "MLITE_ANDROID"] = 21;
            values[valuesById[22] = "IGLITE_ANDROID"] = 22;
            values[valuesById[23] = "PAGE"] = 23;
            values[valuesById[24] = "MACOS"] = 24;
            values[valuesById[25] = "OCULUS_MSG"] = 25;
            values[valuesById[26] = "OCULUS_CALL"] = 26;
            values[valuesById[27] = "MILAN"] = 27;
            values[valuesById[28] = "CAPI"] = 28;
            return values;
        })();

        /**
         * UserAgentReleaseChannel enum.
         * @name proto.UserAgent.UserAgentReleaseChannel
         * @enum {number}
         * @property {number} RELEASE=0 RELEASE value
         * @property {number} BETA=1 BETA value
         * @property {number} ALPHA=2 ALPHA value
         * @property {number} DEBUG=3 DEBUG value
         */
        UserAgent.UserAgentReleaseChannel = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "RELEASE"] = 0;
            values[valuesById[1] = "BETA"] = 1;
            values[valuesById[2] = "ALPHA"] = 2;
            values[valuesById[3] = "DEBUG"] = 3;
            return values;
        })();

        return UserAgent;
    })();

    proto.WebdPayload = (function() {

        /**
         * Properties of a WebdPayload.
         * @memberof proto
         * @interface IWebdPayload
         * @property {boolean|null} [usesParticipantInKey] WebdPayload usesParticipantInKey
         * @property {boolean|null} [supportsStarredMessages] WebdPayload supportsStarredMessages
         * @property {boolean|null} [supportsDocumentMessages] WebdPayload supportsDocumentMessages
         * @property {boolean|null} [supportsUrlMessages] WebdPayload supportsUrlMessages
         * @property {boolean|null} [supportsMediaRetry] WebdPayload supportsMediaRetry
         * @property {boolean|null} [supportsE2EImage] WebdPayload supportsE2EImage
         * @property {boolean|null} [supportsE2EVideo] WebdPayload supportsE2EVideo
         * @property {boolean|null} [supportsE2EAudio] WebdPayload supportsE2EAudio
         * @property {boolean|null} [supportsE2EDocument] WebdPayload supportsE2EDocument
         * @property {string|null} [documentTypes] WebdPayload documentTypes
         * @property {Uint8Array|null} [features] WebdPayload features
         */

        /**
         * Constructs a new WebdPayload.
         * @memberof proto
         * @classdesc Represents a WebdPayload.
         * @implements IWebdPayload
         * @constructor
         * @param {proto.IWebdPayload=} [properties] Properties to set
         */
        function WebdPayload(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * WebdPayload usesParticipantInKey.
         * @member {boolean} usesParticipantInKey
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.usesParticipantInKey = false;

        /**
         * WebdPayload supportsStarredMessages.
         * @member {boolean} supportsStarredMessages
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsStarredMessages = false;

        /**
         * WebdPayload supportsDocumentMessages.
         * @member {boolean} supportsDocumentMessages
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsDocumentMessages = false;

        /**
         * WebdPayload supportsUrlMessages.
         * @member {boolean} supportsUrlMessages
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsUrlMessages = false;

        /**
         * WebdPayload supportsMediaRetry.
         * @member {boolean} supportsMediaRetry
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsMediaRetry = false;

        /**
         * WebdPayload supportsE2EImage.
         * @member {boolean} supportsE2EImage
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsE2EImage = false;

        /**
         * WebdPayload supportsE2EVideo.
         * @member {boolean} supportsE2EVideo
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsE2EVideo = false;

        /**
         * WebdPayload supportsE2EAudio.
         * @member {boolean} supportsE2EAudio
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsE2EAudio = false;

        /**
         * WebdPayload supportsE2EDocument.
         * @member {boolean} supportsE2EDocument
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.supportsE2EDocument = false;

        /**
         * WebdPayload documentTypes.
         * @member {string} documentTypes
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.documentTypes = "";

        /**
         * WebdPayload features.
         * @member {Uint8Array} features
         * @memberof proto.WebdPayload
         * @instance
         */
        WebdPayload.prototype.features = $util.newBuffer([]);

        /**
         * Creates a new WebdPayload instance using the specified properties.
         * @function create
         * @memberof proto.WebdPayload
         * @static
         * @param {proto.IWebdPayload=} [properties] Properties to set
         * @returns {proto.WebdPayload} WebdPayload instance
         */
        WebdPayload.create = function create(properties) {
            return new WebdPayload(properties);
        };

        /**
         * Encodes the specified WebdPayload message. Does not implicitly {@link proto.WebdPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.WebdPayload
         * @static
         * @param {proto.IWebdPayload} message WebdPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WebdPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.usesParticipantInKey != null && Object.hasOwnProperty.call(message, "usesParticipantInKey"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.usesParticipantInKey);
            if (message.supportsStarredMessages != null && Object.hasOwnProperty.call(message, "supportsStarredMessages"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.supportsStarredMessages);
            if (message.supportsDocumentMessages != null && Object.hasOwnProperty.call(message, "supportsDocumentMessages"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.supportsDocumentMessages);
            if (message.supportsUrlMessages != null && Object.hasOwnProperty.call(message, "supportsUrlMessages"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.supportsUrlMessages);
            if (message.supportsMediaRetry != null && Object.hasOwnProperty.call(message, "supportsMediaRetry"))
                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.supportsMediaRetry);
            if (message.supportsE2EImage != null && Object.hasOwnProperty.call(message, "supportsE2EImage"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.supportsE2EImage);
            if (message.supportsE2EVideo != null && Object.hasOwnProperty.call(message, "supportsE2EVideo"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.supportsE2EVideo);
            if (message.supportsE2EAudio != null && Object.hasOwnProperty.call(message, "supportsE2EAudio"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.supportsE2EAudio);
            if (message.supportsE2EDocument != null && Object.hasOwnProperty.call(message, "supportsE2EDocument"))
                writer.uint32(/* id 9, wireType 0 =*/72).bool(message.supportsE2EDocument);
            if (message.documentTypes != null && Object.hasOwnProperty.call(message, "documentTypes"))
                writer.uint32(/* id 10, wireType 2 =*/82).string(message.documentTypes);
            if (message.features != null && Object.hasOwnProperty.call(message, "features"))
                writer.uint32(/* id 11, wireType 2 =*/90).bytes(message.features);
            return writer;
        };

        /**
         * Encodes the specified WebdPayload message, length delimited. Does not implicitly {@link proto.WebdPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.WebdPayload
         * @static
         * @param {proto.IWebdPayload} message WebdPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WebdPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WebdPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.WebdPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.WebdPayload} WebdPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WebdPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.WebdPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.usesParticipantInKey = reader.bool();
                    break;
                case 2:
                    message.supportsStarredMessages = reader.bool();
                    break;
                case 3:
                    message.supportsDocumentMessages = reader.bool();
                    break;
                case 4:
                    message.supportsUrlMessages = reader.bool();
                    break;
                case 5:
                    message.supportsMediaRetry = reader.bool();
                    break;
                case 6:
                    message.supportsE2EImage = reader.bool();
                    break;
                case 7:
                    message.supportsE2EVideo = reader.bool();
                    break;
                case 8:
                    message.supportsE2EAudio = reader.bool();
                    break;
                case 9:
                    message.supportsE2EDocument = reader.bool();
                    break;
                case 10:
                    message.documentTypes = reader.string();
                    break;
                case 11:
                    message.features = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a WebdPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.WebdPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.WebdPayload} WebdPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WebdPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WebdPayload message.
         * @function verify
         * @memberof proto.WebdPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WebdPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.usesParticipantInKey != null && message.hasOwnProperty("usesParticipantInKey"))
                if (typeof message.usesParticipantInKey !== "boolean")
                    return "usesParticipantInKey: boolean expected";
            if (message.supportsStarredMessages != null && message.hasOwnProperty("supportsStarredMessages"))
                if (typeof message.supportsStarredMessages !== "boolean")
                    return "supportsStarredMessages: boolean expected";
            if (message.supportsDocumentMessages != null && message.hasOwnProperty("supportsDocumentMessages"))
                if (typeof message.supportsDocumentMessages !== "boolean")
                    return "supportsDocumentMessages: boolean expected";
            if (message.supportsUrlMessages != null && message.hasOwnProperty("supportsUrlMessages"))
                if (typeof message.supportsUrlMessages !== "boolean")
                    return "supportsUrlMessages: boolean expected";
            if (message.supportsMediaRetry != null && message.hasOwnProperty("supportsMediaRetry"))
                if (typeof message.supportsMediaRetry !== "boolean")
                    return "supportsMediaRetry: boolean expected";
            if (message.supportsE2EImage != null && message.hasOwnProperty("supportsE2EImage"))
                if (typeof message.supportsE2EImage !== "boolean")
                    return "supportsE2EImage: boolean expected";
            if (message.supportsE2EVideo != null && message.hasOwnProperty("supportsE2EVideo"))
                if (typeof message.supportsE2EVideo !== "boolean")
                    return "supportsE2EVideo: boolean expected";
            if (message.supportsE2EAudio != null && message.hasOwnProperty("supportsE2EAudio"))
                if (typeof message.supportsE2EAudio !== "boolean")
                    return "supportsE2EAudio: boolean expected";
            if (message.supportsE2EDocument != null && message.hasOwnProperty("supportsE2EDocument"))
                if (typeof message.supportsE2EDocument !== "boolean")
                    return "supportsE2EDocument: boolean expected";
            if (message.documentTypes != null && message.hasOwnProperty("documentTypes"))
                if (!$util.isString(message.documentTypes))
                    return "documentTypes: string expected";
            if (message.features != null && message.hasOwnProperty("features"))
                if (!(message.features && typeof message.features.length === "number" || $util.isString(message.features)))
                    return "features: buffer expected";
            return null;
        };

        /**
         * Creates a WebdPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.WebdPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.WebdPayload} WebdPayload
         */
        WebdPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.WebdPayload)
                return object;
            var message = new $root.proto.WebdPayload();
            if (object.usesParticipantInKey != null)
                message.usesParticipantInKey = Boolean(object.usesParticipantInKey);
            if (object.supportsStarredMessages != null)
                message.supportsStarredMessages = Boolean(object.supportsStarredMessages);
            if (object.supportsDocumentMessages != null)
                message.supportsDocumentMessages = Boolean(object.supportsDocumentMessages);
            if (object.supportsUrlMessages != null)
                message.supportsUrlMessages = Boolean(object.supportsUrlMessages);
            if (object.supportsMediaRetry != null)
                message.supportsMediaRetry = Boolean(object.supportsMediaRetry);
            if (object.supportsE2EImage != null)
                message.supportsE2EImage = Boolean(object.supportsE2EImage);
            if (object.supportsE2EVideo != null)
                message.supportsE2EVideo = Boolean(object.supportsE2EVideo);
            if (object.supportsE2EAudio != null)
                message.supportsE2EAudio = Boolean(object.supportsE2EAudio);
            if (object.supportsE2EDocument != null)
                message.supportsE2EDocument = Boolean(object.supportsE2EDocument);
            if (object.documentTypes != null)
                message.documentTypes = String(object.documentTypes);
            if (object.features != null)
                if (typeof object.features === "string")
                    $util.base64.decode(object.features, message.features = $util.newBuffer($util.base64.length(object.features)), 0);
                else if (object.features.length)
                    message.features = object.features;
            return message;
        };

        /**
         * Creates a plain object from a WebdPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.WebdPayload
         * @static
         * @param {proto.WebdPayload} message WebdPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WebdPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.usesParticipantInKey = false;
                object.supportsStarredMessages = false;
                object.supportsDocumentMessages = false;
                object.supportsUrlMessages = false;
                object.supportsMediaRetry = false;
                object.supportsE2EImage = false;
                object.supportsE2EVideo = false;
                object.supportsE2EAudio = false;
                object.supportsE2EDocument = false;
                object.documentTypes = "";
                if (options.bytes === String)
                    object.features = "";
                else {
                    object.features = [];
                    if (options.bytes !== Array)
                        object.features = $util.newBuffer(object.features);
                }
            }
            if (message.usesParticipantInKey != null && message.hasOwnProperty("usesParticipantInKey"))
                object.usesParticipantInKey = message.usesParticipantInKey;
            if (message.supportsStarredMessages != null && message.hasOwnProperty("supportsStarredMessages"))
                object.supportsStarredMessages = message.supportsStarredMessages;
            if (message.supportsDocumentMessages != null && message.hasOwnProperty("supportsDocumentMessages"))
                object.supportsDocumentMessages = message.supportsDocumentMessages;
            if (message.supportsUrlMessages != null && message.hasOwnProperty("supportsUrlMessages"))
                object.supportsUrlMessages = message.supportsUrlMessages;
            if (message.supportsMediaRetry != null && message.hasOwnProperty("supportsMediaRetry"))
                object.supportsMediaRetry = message.supportsMediaRetry;
            if (message.supportsE2EImage != null && message.hasOwnProperty("supportsE2EImage"))
                object.supportsE2EImage = message.supportsE2EImage;
            if (message.supportsE2EVideo != null && message.hasOwnProperty("supportsE2EVideo"))
                object.supportsE2EVideo = message.supportsE2EVideo;
            if (message.supportsE2EAudio != null && message.hasOwnProperty("supportsE2EAudio"))
                object.supportsE2EAudio = message.supportsE2EAudio;
            if (message.supportsE2EDocument != null && message.hasOwnProperty("supportsE2EDocument"))
                object.supportsE2EDocument = message.supportsE2EDocument;
            if (message.documentTypes != null && message.hasOwnProperty("documentTypes"))
                object.documentTypes = message.documentTypes;
            if (message.features != null && message.hasOwnProperty("features"))
                object.features = options.bytes === String ? $util.base64.encode(message.features, 0, message.features.length) : options.bytes === Array ? Array.prototype.slice.call(message.features) : message.features;
            return object;
        };

        /**
         * Converts this WebdPayload to JSON.
         * @function toJSON
         * @memberof proto.WebdPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WebdPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return WebdPayload;
    })();

    proto.WebInfo = (function() {

        /**
         * Properties of a WebInfo.
         * @memberof proto
         * @interface IWebInfo
         * @property {string|null} [refToken] WebInfo refToken
         * @property {string|null} [version] WebInfo version
         * @property {proto.IWebdPayload|null} [webdPayload] WebInfo webdPayload
         * @property {proto.WebInfo.WebInfoWebSubPlatform|null} [webSubPlatform] WebInfo webSubPlatform
         */

        /**
         * Constructs a new WebInfo.
         * @memberof proto
         * @classdesc Represents a WebInfo.
         * @implements IWebInfo
         * @constructor
         * @param {proto.IWebInfo=} [properties] Properties to set
         */
        function WebInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * WebInfo refToken.
         * @member {string} refToken
         * @memberof proto.WebInfo
         * @instance
         */
        WebInfo.prototype.refToken = "";

        /**
         * WebInfo version.
         * @member {string} version
         * @memberof proto.WebInfo
         * @instance
         */
        WebInfo.prototype.version = "";

        /**
         * WebInfo webdPayload.
         * @member {proto.IWebdPayload|null|undefined} webdPayload
         * @memberof proto.WebInfo
         * @instance
         */
        WebInfo.prototype.webdPayload = null;

        /**
         * WebInfo webSubPlatform.
         * @member {proto.WebInfo.WebInfoWebSubPlatform} webSubPlatform
         * @memberof proto.WebInfo
         * @instance
         */
        WebInfo.prototype.webSubPlatform = 0;

        /**
         * Creates a new WebInfo instance using the specified properties.
         * @function create
         * @memberof proto.WebInfo
         * @static
         * @param {proto.IWebInfo=} [properties] Properties to set
         * @returns {proto.WebInfo} WebInfo instance
         */
        WebInfo.create = function create(properties) {
            return new WebInfo(properties);
        };

        /**
         * Encodes the specified WebInfo message. Does not implicitly {@link proto.WebInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.WebInfo
         * @static
         * @param {proto.IWebInfo} message WebInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WebInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.refToken != null && Object.hasOwnProperty.call(message, "refToken"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.refToken);
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.version);
            if (message.webdPayload != null && Object.hasOwnProperty.call(message, "webdPayload"))
                $root.proto.WebdPayload.encode(message.webdPayload, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.webSubPlatform != null && Object.hasOwnProperty.call(message, "webSubPlatform"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.webSubPlatform);
            return writer;
        };

        /**
         * Encodes the specified WebInfo message, length delimited. Does not implicitly {@link proto.WebInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.WebInfo
         * @static
         * @param {proto.IWebInfo} message WebInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WebInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WebInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.WebInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.WebInfo} WebInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WebInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.WebInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.refToken = reader.string();
                    break;
                case 2:
                    message.version = reader.string();
                    break;
                case 3:
                    message.webdPayload = $root.proto.WebdPayload.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.webSubPlatform = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a WebInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.WebInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.WebInfo} WebInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WebInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WebInfo message.
         * @function verify
         * @memberof proto.WebInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WebInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.refToken != null && message.hasOwnProperty("refToken"))
                if (!$util.isString(message.refToken))
                    return "refToken: string expected";
            if (message.version != null && message.hasOwnProperty("version"))
                if (!$util.isString(message.version))
                    return "version: string expected";
            if (message.webdPayload != null && message.hasOwnProperty("webdPayload")) {
                var error = $root.proto.WebdPayload.verify(message.webdPayload);
                if (error)
                    return "webdPayload." + error;
            }
            if (message.webSubPlatform != null && message.hasOwnProperty("webSubPlatform"))
                switch (message.webSubPlatform) {
                default:
                    return "webSubPlatform: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            return null;
        };

        /**
         * Creates a WebInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.WebInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.WebInfo} WebInfo
         */
        WebInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.WebInfo)
                return object;
            var message = new $root.proto.WebInfo();
            if (object.refToken != null)
                message.refToken = String(object.refToken);
            if (object.version != null)
                message.version = String(object.version);
            if (object.webdPayload != null) {
                if (typeof object.webdPayload !== "object")
                    throw TypeError(".proto.WebInfo.webdPayload: object expected");
                message.webdPayload = $root.proto.WebdPayload.fromObject(object.webdPayload);
            }
            switch (object.webSubPlatform) {
            case "WEB_BROWSER":
            case 0:
                message.webSubPlatform = 0;
                break;
            case "APP_STORE":
            case 1:
                message.webSubPlatform = 1;
                break;
            case "WIN_STORE":
            case 2:
                message.webSubPlatform = 2;
                break;
            case "DARWIN":
            case 3:
                message.webSubPlatform = 3;
                break;
            case "WIN32":
            case 4:
                message.webSubPlatform = 4;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a WebInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.WebInfo
         * @static
         * @param {proto.WebInfo} message WebInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WebInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.refToken = "";
                object.version = "";
                object.webdPayload = null;
                object.webSubPlatform = options.enums === String ? "WEB_BROWSER" : 0;
            }
            if (message.refToken != null && message.hasOwnProperty("refToken"))
                object.refToken = message.refToken;
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = message.version;
            if (message.webdPayload != null && message.hasOwnProperty("webdPayload"))
                object.webdPayload = $root.proto.WebdPayload.toObject(message.webdPayload, options);
            if (message.webSubPlatform != null && message.hasOwnProperty("webSubPlatform"))
                object.webSubPlatform = options.enums === String ? $root.proto.WebInfo.WebInfoWebSubPlatform[message.webSubPlatform] : message.webSubPlatform;
            return object;
        };

        /**
         * Converts this WebInfo to JSON.
         * @function toJSON
         * @memberof proto.WebInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WebInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * WebInfoWebSubPlatform enum.
         * @name proto.WebInfo.WebInfoWebSubPlatform
         * @enum {number}
         * @property {number} WEB_BROWSER=0 WEB_BROWSER value
         * @property {number} APP_STORE=1 APP_STORE value
         * @property {number} WIN_STORE=2 WIN_STORE value
         * @property {number} DARWIN=3 DARWIN value
         * @property {number} WIN32=4 WIN32 value
         */
        WebInfo.WebInfoWebSubPlatform = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WEB_BROWSER"] = 0;
            values[valuesById[1] = "APP_STORE"] = 1;
            values[valuesById[2] = "WIN_STORE"] = 2;
            values[valuesById[3] = "DARWIN"] = 3;
            values[valuesById[4] = "WIN32"] = 4;
            return values;
        })();

        return WebInfo;
    })();

    proto.DNSSource = (function() {

        /**
         * Properties of a DNSSource.
         * @memberof proto
         * @interface IDNSSource
         * @property {proto.DNSSource.DNSSourceDNSResolutionMethod|null} [dnsMethod] DNSSource dnsMethod
         * @property {boolean|null} [appCached] DNSSource appCached
         */

        /**
         * Constructs a new DNSSource.
         * @memberof proto
         * @classdesc Represents a DNSSource.
         * @implements IDNSSource
         * @constructor
         * @param {proto.IDNSSource=} [properties] Properties to set
         */
        function DNSSource(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DNSSource dnsMethod.
         * @member {proto.DNSSource.DNSSourceDNSResolutionMethod} dnsMethod
         * @memberof proto.DNSSource
         * @instance
         */
        DNSSource.prototype.dnsMethod = 0;

        /**
         * DNSSource appCached.
         * @member {boolean} appCached
         * @memberof proto.DNSSource
         * @instance
         */
        DNSSource.prototype.appCached = false;

        /**
         * Creates a new DNSSource instance using the specified properties.
         * @function create
         * @memberof proto.DNSSource
         * @static
         * @param {proto.IDNSSource=} [properties] Properties to set
         * @returns {proto.DNSSource} DNSSource instance
         */
        DNSSource.create = function create(properties) {
            return new DNSSource(properties);
        };

        /**
         * Encodes the specified DNSSource message. Does not implicitly {@link proto.DNSSource.verify|verify} messages.
         * @function encode
         * @memberof proto.DNSSource
         * @static
         * @param {proto.IDNSSource} message DNSSource message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DNSSource.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.dnsMethod != null && Object.hasOwnProperty.call(message, "dnsMethod"))
                writer.uint32(/* id 15, wireType 0 =*/120).int32(message.dnsMethod);
            if (message.appCached != null && Object.hasOwnProperty.call(message, "appCached"))
                writer.uint32(/* id 16, wireType 0 =*/128).bool(message.appCached);
            return writer;
        };

        /**
         * Encodes the specified DNSSource message, length delimited. Does not implicitly {@link proto.DNSSource.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DNSSource
         * @static
         * @param {proto.IDNSSource} message DNSSource message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DNSSource.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DNSSource message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DNSSource
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DNSSource} DNSSource
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DNSSource.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DNSSource();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 15:
                    message.dnsMethod = reader.int32();
                    break;
                case 16:
                    message.appCached = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DNSSource message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DNSSource
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DNSSource} DNSSource
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DNSSource.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DNSSource message.
         * @function verify
         * @memberof proto.DNSSource
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DNSSource.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.dnsMethod != null && message.hasOwnProperty("dnsMethod"))
                switch (message.dnsMethod) {
                default:
                    return "dnsMethod: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            if (message.appCached != null && message.hasOwnProperty("appCached"))
                if (typeof message.appCached !== "boolean")
                    return "appCached: boolean expected";
            return null;
        };

        /**
         * Creates a DNSSource message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DNSSource
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DNSSource} DNSSource
         */
        DNSSource.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DNSSource)
                return object;
            var message = new $root.proto.DNSSource();
            switch (object.dnsMethod) {
            case "SYSTEM":
            case 0:
                message.dnsMethod = 0;
                break;
            case "GOOGLE":
            case 1:
                message.dnsMethod = 1;
                break;
            case "HARDCODED":
            case 2:
                message.dnsMethod = 2;
                break;
            case "OVERRIDE":
            case 3:
                message.dnsMethod = 3;
                break;
            case "FALLBACK":
            case 4:
                message.dnsMethod = 4;
                break;
            }
            if (object.appCached != null)
                message.appCached = Boolean(object.appCached);
            return message;
        };

        /**
         * Creates a plain object from a DNSSource message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DNSSource
         * @static
         * @param {proto.DNSSource} message DNSSource
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DNSSource.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.dnsMethod = options.enums === String ? "SYSTEM" : 0;
                object.appCached = false;
            }
            if (message.dnsMethod != null && message.hasOwnProperty("dnsMethod"))
                object.dnsMethod = options.enums === String ? $root.proto.DNSSource.DNSSourceDNSResolutionMethod[message.dnsMethod] : message.dnsMethod;
            if (message.appCached != null && message.hasOwnProperty("appCached"))
                object.appCached = message.appCached;
            return object;
        };

        /**
         * Converts this DNSSource to JSON.
         * @function toJSON
         * @memberof proto.DNSSource
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DNSSource.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * DNSSourceDNSResolutionMethod enum.
         * @name proto.DNSSource.DNSSourceDNSResolutionMethod
         * @enum {number}
         * @property {number} SYSTEM=0 SYSTEM value
         * @property {number} GOOGLE=1 GOOGLE value
         * @property {number} HARDCODED=2 HARDCODED value
         * @property {number} OVERRIDE=3 OVERRIDE value
         * @property {number} FALLBACK=4 FALLBACK value
         */
        DNSSource.DNSSourceDNSResolutionMethod = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SYSTEM"] = 0;
            values[valuesById[1] = "GOOGLE"] = 1;
            values[valuesById[2] = "HARDCODED"] = 2;
            values[valuesById[3] = "OVERRIDE"] = 3;
            values[valuesById[4] = "FALLBACK"] = 4;
            return values;
        })();

        return DNSSource;
    })();

    proto.CompanionRegData = (function() {

        /**
         * Properties of a CompanionRegData.
         * @memberof proto
         * @interface ICompanionRegData
         * @property {Uint8Array|null} [eRegid] CompanionRegData eRegid
         * @property {Uint8Array|null} [eKeytype] CompanionRegData eKeytype
         * @property {Uint8Array|null} [eIdent] CompanionRegData eIdent
         * @property {Uint8Array|null} [eSkeyId] CompanionRegData eSkeyId
         * @property {Uint8Array|null} [eSkeyVal] CompanionRegData eSkeyVal
         * @property {Uint8Array|null} [eSkeySig] CompanionRegData eSkeySig
         * @property {Uint8Array|null} [buildHash] CompanionRegData buildHash
         * @property {Uint8Array|null} [companionProps] CompanionRegData companionProps
         */

        /**
         * Constructs a new CompanionRegData.
         * @memberof proto
         * @classdesc Represents a CompanionRegData.
         * @implements ICompanionRegData
         * @constructor
         * @param {proto.ICompanionRegData=} [properties] Properties to set
         */
        function CompanionRegData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CompanionRegData eRegid.
         * @member {Uint8Array} eRegid
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.eRegid = $util.newBuffer([]);

        /**
         * CompanionRegData eKeytype.
         * @member {Uint8Array} eKeytype
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.eKeytype = $util.newBuffer([]);

        /**
         * CompanionRegData eIdent.
         * @member {Uint8Array} eIdent
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.eIdent = $util.newBuffer([]);

        /**
         * CompanionRegData eSkeyId.
         * @member {Uint8Array} eSkeyId
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.eSkeyId = $util.newBuffer([]);

        /**
         * CompanionRegData eSkeyVal.
         * @member {Uint8Array} eSkeyVal
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.eSkeyVal = $util.newBuffer([]);

        /**
         * CompanionRegData eSkeySig.
         * @member {Uint8Array} eSkeySig
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.eSkeySig = $util.newBuffer([]);

        /**
         * CompanionRegData buildHash.
         * @member {Uint8Array} buildHash
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.buildHash = $util.newBuffer([]);

        /**
         * CompanionRegData companionProps.
         * @member {Uint8Array} companionProps
         * @memberof proto.CompanionRegData
         * @instance
         */
        CompanionRegData.prototype.companionProps = $util.newBuffer([]);

        /**
         * Creates a new CompanionRegData instance using the specified properties.
         * @function create
         * @memberof proto.CompanionRegData
         * @static
         * @param {proto.ICompanionRegData=} [properties] Properties to set
         * @returns {proto.CompanionRegData} CompanionRegData instance
         */
        CompanionRegData.create = function create(properties) {
            return new CompanionRegData(properties);
        };

        /**
         * Encodes the specified CompanionRegData message. Does not implicitly {@link proto.CompanionRegData.verify|verify} messages.
         * @function encode
         * @memberof proto.CompanionRegData
         * @static
         * @param {proto.ICompanionRegData} message CompanionRegData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CompanionRegData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.eRegid != null && Object.hasOwnProperty.call(message, "eRegid"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.eRegid);
            if (message.eKeytype != null && Object.hasOwnProperty.call(message, "eKeytype"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.eKeytype);
            if (message.eIdent != null && Object.hasOwnProperty.call(message, "eIdent"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.eIdent);
            if (message.eSkeyId != null && Object.hasOwnProperty.call(message, "eSkeyId"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.eSkeyId);
            if (message.eSkeyVal != null && Object.hasOwnProperty.call(message, "eSkeyVal"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.eSkeyVal);
            if (message.eSkeySig != null && Object.hasOwnProperty.call(message, "eSkeySig"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.eSkeySig);
            if (message.buildHash != null && Object.hasOwnProperty.call(message, "buildHash"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.buildHash);
            if (message.companionProps != null && Object.hasOwnProperty.call(message, "companionProps"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.companionProps);
            return writer;
        };

        /**
         * Encodes the specified CompanionRegData message, length delimited. Does not implicitly {@link proto.CompanionRegData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CompanionRegData
         * @static
         * @param {proto.ICompanionRegData} message CompanionRegData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CompanionRegData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CompanionRegData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CompanionRegData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CompanionRegData} CompanionRegData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CompanionRegData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CompanionRegData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.eRegid = reader.bytes();
                    break;
                case 2:
                    message.eKeytype = reader.bytes();
                    break;
                case 3:
                    message.eIdent = reader.bytes();
                    break;
                case 4:
                    message.eSkeyId = reader.bytes();
                    break;
                case 5:
                    message.eSkeyVal = reader.bytes();
                    break;
                case 6:
                    message.eSkeySig = reader.bytes();
                    break;
                case 7:
                    message.buildHash = reader.bytes();
                    break;
                case 8:
                    message.companionProps = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CompanionRegData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CompanionRegData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CompanionRegData} CompanionRegData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CompanionRegData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CompanionRegData message.
         * @function verify
         * @memberof proto.CompanionRegData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CompanionRegData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.eRegid != null && message.hasOwnProperty("eRegid"))
                if (!(message.eRegid && typeof message.eRegid.length === "number" || $util.isString(message.eRegid)))
                    return "eRegid: buffer expected";
            if (message.eKeytype != null && message.hasOwnProperty("eKeytype"))
                if (!(message.eKeytype && typeof message.eKeytype.length === "number" || $util.isString(message.eKeytype)))
                    return "eKeytype: buffer expected";
            if (message.eIdent != null && message.hasOwnProperty("eIdent"))
                if (!(message.eIdent && typeof message.eIdent.length === "number" || $util.isString(message.eIdent)))
                    return "eIdent: buffer expected";
            if (message.eSkeyId != null && message.hasOwnProperty("eSkeyId"))
                if (!(message.eSkeyId && typeof message.eSkeyId.length === "number" || $util.isString(message.eSkeyId)))
                    return "eSkeyId: buffer expected";
            if (message.eSkeyVal != null && message.hasOwnProperty("eSkeyVal"))
                if (!(message.eSkeyVal && typeof message.eSkeyVal.length === "number" || $util.isString(message.eSkeyVal)))
                    return "eSkeyVal: buffer expected";
            if (message.eSkeySig != null && message.hasOwnProperty("eSkeySig"))
                if (!(message.eSkeySig && typeof message.eSkeySig.length === "number" || $util.isString(message.eSkeySig)))
                    return "eSkeySig: buffer expected";
            if (message.buildHash != null && message.hasOwnProperty("buildHash"))
                if (!(message.buildHash && typeof message.buildHash.length === "number" || $util.isString(message.buildHash)))
                    return "buildHash: buffer expected";
            if (message.companionProps != null && message.hasOwnProperty("companionProps"))
                if (!(message.companionProps && typeof message.companionProps.length === "number" || $util.isString(message.companionProps)))
                    return "companionProps: buffer expected";
            return null;
        };

        /**
         * Creates a CompanionRegData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CompanionRegData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CompanionRegData} CompanionRegData
         */
        CompanionRegData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CompanionRegData)
                return object;
            var message = new $root.proto.CompanionRegData();
            if (object.eRegid != null)
                if (typeof object.eRegid === "string")
                    $util.base64.decode(object.eRegid, message.eRegid = $util.newBuffer($util.base64.length(object.eRegid)), 0);
                else if (object.eRegid.length)
                    message.eRegid = object.eRegid;
            if (object.eKeytype != null)
                if (typeof object.eKeytype === "string")
                    $util.base64.decode(object.eKeytype, message.eKeytype = $util.newBuffer($util.base64.length(object.eKeytype)), 0);
                else if (object.eKeytype.length)
                    message.eKeytype = object.eKeytype;
            if (object.eIdent != null)
                if (typeof object.eIdent === "string")
                    $util.base64.decode(object.eIdent, message.eIdent = $util.newBuffer($util.base64.length(object.eIdent)), 0);
                else if (object.eIdent.length)
                    message.eIdent = object.eIdent;
            if (object.eSkeyId != null)
                if (typeof object.eSkeyId === "string")
                    $util.base64.decode(object.eSkeyId, message.eSkeyId = $util.newBuffer($util.base64.length(object.eSkeyId)), 0);
                else if (object.eSkeyId.length)
                    message.eSkeyId = object.eSkeyId;
            if (object.eSkeyVal != null)
                if (typeof object.eSkeyVal === "string")
                    $util.base64.decode(object.eSkeyVal, message.eSkeyVal = $util.newBuffer($util.base64.length(object.eSkeyVal)), 0);
                else if (object.eSkeyVal.length)
                    message.eSkeyVal = object.eSkeyVal;
            if (object.eSkeySig != null)
                if (typeof object.eSkeySig === "string")
                    $util.base64.decode(object.eSkeySig, message.eSkeySig = $util.newBuffer($util.base64.length(object.eSkeySig)), 0);
                else if (object.eSkeySig.length)
                    message.eSkeySig = object.eSkeySig;
            if (object.buildHash != null)
                if (typeof object.buildHash === "string")
                    $util.base64.decode(object.buildHash, message.buildHash = $util.newBuffer($util.base64.length(object.buildHash)), 0);
                else if (object.buildHash.length)
                    message.buildHash = object.buildHash;
            if (object.companionProps != null)
                if (typeof object.companionProps === "string")
                    $util.base64.decode(object.companionProps, message.companionProps = $util.newBuffer($util.base64.length(object.companionProps)), 0);
                else if (object.companionProps.length)
                    message.companionProps = object.companionProps;
            return message;
        };

        /**
         * Creates a plain object from a CompanionRegData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CompanionRegData
         * @static
         * @param {proto.CompanionRegData} message CompanionRegData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CompanionRegData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.eRegid = "";
                else {
                    object.eRegid = [];
                    if (options.bytes !== Array)
                        object.eRegid = $util.newBuffer(object.eRegid);
                }
                if (options.bytes === String)
                    object.eKeytype = "";
                else {
                    object.eKeytype = [];
                    if (options.bytes !== Array)
                        object.eKeytype = $util.newBuffer(object.eKeytype);
                }
                if (options.bytes === String)
                    object.eIdent = "";
                else {
                    object.eIdent = [];
                    if (options.bytes !== Array)
                        object.eIdent = $util.newBuffer(object.eIdent);
                }
                if (options.bytes === String)
                    object.eSkeyId = "";
                else {
                    object.eSkeyId = [];
                    if (options.bytes !== Array)
                        object.eSkeyId = $util.newBuffer(object.eSkeyId);
                }
                if (options.bytes === String)
                    object.eSkeyVal = "";
                else {
                    object.eSkeyVal = [];
                    if (options.bytes !== Array)
                        object.eSkeyVal = $util.newBuffer(object.eSkeyVal);
                }
                if (options.bytes === String)
                    object.eSkeySig = "";
                else {
                    object.eSkeySig = [];
                    if (options.bytes !== Array)
                        object.eSkeySig = $util.newBuffer(object.eSkeySig);
                }
                if (options.bytes === String)
                    object.buildHash = "";
                else {
                    object.buildHash = [];
                    if (options.bytes !== Array)
                        object.buildHash = $util.newBuffer(object.buildHash);
                }
                if (options.bytes === String)
                    object.companionProps = "";
                else {
                    object.companionProps = [];
                    if (options.bytes !== Array)
                        object.companionProps = $util.newBuffer(object.companionProps);
                }
            }
            if (message.eRegid != null && message.hasOwnProperty("eRegid"))
                object.eRegid = options.bytes === String ? $util.base64.encode(message.eRegid, 0, message.eRegid.length) : options.bytes === Array ? Array.prototype.slice.call(message.eRegid) : message.eRegid;
            if (message.eKeytype != null && message.hasOwnProperty("eKeytype"))
                object.eKeytype = options.bytes === String ? $util.base64.encode(message.eKeytype, 0, message.eKeytype.length) : options.bytes === Array ? Array.prototype.slice.call(message.eKeytype) : message.eKeytype;
            if (message.eIdent != null && message.hasOwnProperty("eIdent"))
                object.eIdent = options.bytes === String ? $util.base64.encode(message.eIdent, 0, message.eIdent.length) : options.bytes === Array ? Array.prototype.slice.call(message.eIdent) : message.eIdent;
            if (message.eSkeyId != null && message.hasOwnProperty("eSkeyId"))
                object.eSkeyId = options.bytes === String ? $util.base64.encode(message.eSkeyId, 0, message.eSkeyId.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeyId) : message.eSkeyId;
            if (message.eSkeyVal != null && message.hasOwnProperty("eSkeyVal"))
                object.eSkeyVal = options.bytes === String ? $util.base64.encode(message.eSkeyVal, 0, message.eSkeyVal.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeyVal) : message.eSkeyVal;
            if (message.eSkeySig != null && message.hasOwnProperty("eSkeySig"))
                object.eSkeySig = options.bytes === String ? $util.base64.encode(message.eSkeySig, 0, message.eSkeySig.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeySig) : message.eSkeySig;
            if (message.buildHash != null && message.hasOwnProperty("buildHash"))
                object.buildHash = options.bytes === String ? $util.base64.encode(message.buildHash, 0, message.buildHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.buildHash) : message.buildHash;
            if (message.companionProps != null && message.hasOwnProperty("companionProps"))
                object.companionProps = options.bytes === String ? $util.base64.encode(message.companionProps, 0, message.companionProps.length) : options.bytes === Array ? Array.prototype.slice.call(message.companionProps) : message.companionProps;
            return object;
        };

        /**
         * Converts this CompanionRegData to JSON.
         * @function toJSON
         * @memberof proto.CompanionRegData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CompanionRegData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CompanionRegData;
    })();

    proto.ClientPayload = (function() {

        /**
         * Properties of a ClientPayload.
         * @memberof proto
         * @interface IClientPayload
         * @property {number|Long|null} [username] ClientPayload username
         * @property {boolean|null} [passive] ClientPayload passive
         * @property {proto.IUserAgent|null} [userAgent] ClientPayload userAgent
         * @property {proto.IWebInfo|null} [webInfo] ClientPayload webInfo
         * @property {string|null} [pushName] ClientPayload pushName
         * @property {number|null} [sessionId] ClientPayload sessionId
         * @property {boolean|null} [shortConnect] ClientPayload shortConnect
         * @property {proto.ClientPayload.ClientPayloadConnectType|null} [connectType] ClientPayload connectType
         * @property {proto.ClientPayload.ClientPayloadConnectReason|null} [connectReason] ClientPayload connectReason
         * @property {Array.<number>|null} [shards] ClientPayload shards
         * @property {proto.IDNSSource|null} [dnsSource] ClientPayload dnsSource
         * @property {number|null} [connectAttemptCount] ClientPayload connectAttemptCount
         * @property {number|null} [agent] ClientPayload agent
         * @property {number|null} [device] ClientPayload device
         * @property {proto.ICompanionRegData|null} [regData] ClientPayload regData
         * @property {proto.ClientPayload.ClientPayloadProduct|null} [product] ClientPayload product
         * @property {Uint8Array|null} [fbCat] ClientPayload fbCat
         * @property {Uint8Array|null} [fbUserAgent] ClientPayload fbUserAgent
         * @property {boolean|null} [oc] ClientPayload oc
         * @property {number|null} [lc] ClientPayload lc
         * @property {proto.ClientPayload.ClientPayloadIOSAppExtension|null} [iosAppExtension] ClientPayload iosAppExtension
         * @property {number|Long|null} [fbAppId] ClientPayload fbAppId
         * @property {Uint8Array|null} [fbDeviceId] ClientPayload fbDeviceId
         */

        /**
         * Constructs a new ClientPayload.
         * @memberof proto
         * @classdesc Represents a ClientPayload.
         * @implements IClientPayload
         * @constructor
         * @param {proto.IClientPayload=} [properties] Properties to set
         */
        function ClientPayload(properties) {
            this.shards = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientPayload username.
         * @member {number|Long} username
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.username = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ClientPayload passive.
         * @member {boolean} passive
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.passive = false;

        /**
         * ClientPayload userAgent.
         * @member {proto.IUserAgent|null|undefined} userAgent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.userAgent = null;

        /**
         * ClientPayload webInfo.
         * @member {proto.IWebInfo|null|undefined} webInfo
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.webInfo = null;

        /**
         * ClientPayload pushName.
         * @member {string} pushName
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.pushName = "";

        /**
         * ClientPayload sessionId.
         * @member {number} sessionId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.sessionId = 0;

        /**
         * ClientPayload shortConnect.
         * @member {boolean} shortConnect
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.shortConnect = false;

        /**
         * ClientPayload connectType.
         * @member {proto.ClientPayload.ClientPayloadConnectType} connectType
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectType = 0;

        /**
         * ClientPayload connectReason.
         * @member {proto.ClientPayload.ClientPayloadConnectReason} connectReason
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectReason = 0;

        /**
         * ClientPayload shards.
         * @member {Array.<number>} shards
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.shards = $util.emptyArray;

        /**
         * ClientPayload dnsSource.
         * @member {proto.IDNSSource|null|undefined} dnsSource
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.dnsSource = null;

        /**
         * ClientPayload connectAttemptCount.
         * @member {number} connectAttemptCount
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectAttemptCount = 0;

        /**
         * ClientPayload agent.
         * @member {number} agent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.agent = 0;

        /**
         * ClientPayload device.
         * @member {number} device
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.device = 0;

        /**
         * ClientPayload regData.
         * @member {proto.ICompanionRegData|null|undefined} regData
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.regData = null;

        /**
         * ClientPayload product.
         * @member {proto.ClientPayload.ClientPayloadProduct} product
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.product = 0;

        /**
         * ClientPayload fbCat.
         * @member {Uint8Array} fbCat
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbCat = $util.newBuffer([]);

        /**
         * ClientPayload fbUserAgent.
         * @member {Uint8Array} fbUserAgent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbUserAgent = $util.newBuffer([]);

        /**
         * ClientPayload oc.
         * @member {boolean} oc
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.oc = false;

        /**
         * ClientPayload lc.
         * @member {number} lc
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.lc = 0;

        /**
         * ClientPayload iosAppExtension.
         * @member {proto.ClientPayload.ClientPayloadIOSAppExtension} iosAppExtension
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.iosAppExtension = 0;

        /**
         * ClientPayload fbAppId.
         * @member {number|Long} fbAppId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbAppId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ClientPayload fbDeviceId.
         * @member {Uint8Array} fbDeviceId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbDeviceId = $util.newBuffer([]);

        /**
         * Creates a new ClientPayload instance using the specified properties.
         * @function create
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload=} [properties] Properties to set
         * @returns {proto.ClientPayload} ClientPayload instance
         */
        ClientPayload.create = function create(properties) {
            return new ClientPayload(properties);
        };

        /**
         * Encodes the specified ClientPayload message. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload} message ClientPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.username != null && Object.hasOwnProperty.call(message, "username"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.username);
            if (message.passive != null && Object.hasOwnProperty.call(message, "passive"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.passive);
            if (message.userAgent != null && Object.hasOwnProperty.call(message, "userAgent"))
                $root.proto.UserAgent.encode(message.userAgent, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.webInfo != null && Object.hasOwnProperty.call(message, "webInfo"))
                $root.proto.WebInfo.encode(message.webInfo, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.pushName != null && Object.hasOwnProperty.call(message, "pushName"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.pushName);
            if (message.sessionId != null && Object.hasOwnProperty.call(message, "sessionId"))
                writer.uint32(/* id 9, wireType 5 =*/77).sfixed32(message.sessionId);
            if (message.shortConnect != null && Object.hasOwnProperty.call(message, "shortConnect"))
                writer.uint32(/* id 10, wireType 0 =*/80).bool(message.shortConnect);
            if (message.connectType != null && Object.hasOwnProperty.call(message, "connectType"))
                writer.uint32(/* id 12, wireType 0 =*/96).int32(message.connectType);
            if (message.connectReason != null && Object.hasOwnProperty.call(message, "connectReason"))
                writer.uint32(/* id 13, wireType 0 =*/104).int32(message.connectReason);
            if (message.shards != null && message.shards.length)
                for (var i = 0; i < message.shards.length; ++i)
                    writer.uint32(/* id 14, wireType 0 =*/112).int32(message.shards[i]);
            if (message.dnsSource != null && Object.hasOwnProperty.call(message, "dnsSource"))
                $root.proto.DNSSource.encode(message.dnsSource, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            if (message.connectAttemptCount != null && Object.hasOwnProperty.call(message, "connectAttemptCount"))
                writer.uint32(/* id 16, wireType 0 =*/128).uint32(message.connectAttemptCount);
            if (message.agent != null && Object.hasOwnProperty.call(message, "agent"))
                writer.uint32(/* id 17, wireType 0 =*/136).uint32(message.agent);
            if (message.device != null && Object.hasOwnProperty.call(message, "device"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.device);
            if (message.regData != null && Object.hasOwnProperty.call(message, "regData"))
                $root.proto.CompanionRegData.encode(message.regData, writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
            if (message.product != null && Object.hasOwnProperty.call(message, "product"))
                writer.uint32(/* id 20, wireType 0 =*/160).int32(message.product);
            if (message.fbCat != null && Object.hasOwnProperty.call(message, "fbCat"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.fbCat);
            if (message.fbUserAgent != null && Object.hasOwnProperty.call(message, "fbUserAgent"))
                writer.uint32(/* id 22, wireType 2 =*/178).bytes(message.fbUserAgent);
            if (message.oc != null && Object.hasOwnProperty.call(message, "oc"))
                writer.uint32(/* id 23, wireType 0 =*/184).bool(message.oc);
            if (message.lc != null && Object.hasOwnProperty.call(message, "lc"))
                writer.uint32(/* id 24, wireType 0 =*/192).uint32(message.lc);
            if (message.iosAppExtension != null && Object.hasOwnProperty.call(message, "iosAppExtension"))
                writer.uint32(/* id 30, wireType 0 =*/240).int32(message.iosAppExtension);
            if (message.fbAppId != null && Object.hasOwnProperty.call(message, "fbAppId"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint64(message.fbAppId);
            if (message.fbDeviceId != null && Object.hasOwnProperty.call(message, "fbDeviceId"))
                writer.uint32(/* id 32, wireType 2 =*/258).bytes(message.fbDeviceId);
            return writer;
        };

        /**
         * Encodes the specified ClientPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload} message ClientPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientPayload} ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.username = reader.uint64();
                    break;
                case 3:
                    message.passive = reader.bool();
                    break;
                case 5:
                    message.userAgent = $root.proto.UserAgent.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.webInfo = $root.proto.WebInfo.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.pushName = reader.string();
                    break;
                case 9:
                    message.sessionId = reader.sfixed32();
                    break;
                case 10:
                    message.shortConnect = reader.bool();
                    break;
                case 12:
                    message.connectType = reader.int32();
                    break;
                case 13:
                    message.connectReason = reader.int32();
                    break;
                case 14:
                    if (!(message.shards && message.shards.length))
                        message.shards = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.shards.push(reader.int32());
                    } else
                        message.shards.push(reader.int32());
                    break;
                case 15:
                    message.dnsSource = $root.proto.DNSSource.decode(reader, reader.uint32());
                    break;
                case 16:
                    message.connectAttemptCount = reader.uint32();
                    break;
                case 17:
                    message.agent = reader.uint32();
                    break;
                case 18:
                    message.device = reader.uint32();
                    break;
                case 19:
                    message.regData = $root.proto.CompanionRegData.decode(reader, reader.uint32());
                    break;
                case 20:
                    message.product = reader.int32();
                    break;
                case 21:
                    message.fbCat = reader.bytes();
                    break;
                case 22:
                    message.fbUserAgent = reader.bytes();
                    break;
                case 23:
                    message.oc = reader.bool();
                    break;
                case 24:
                    message.lc = reader.uint32();
                    break;
                case 30:
                    message.iosAppExtension = reader.int32();
                    break;
                case 31:
                    message.fbAppId = reader.uint64();
                    break;
                case 32:
                    message.fbDeviceId = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientPayload} ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientPayload message.
         * @function verify
         * @memberof proto.ClientPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.username != null && message.hasOwnProperty("username"))
                if (!$util.isInteger(message.username) && !(message.username && $util.isInteger(message.username.low) && $util.isInteger(message.username.high)))
                    return "username: integer|Long expected";
            if (message.passive != null && message.hasOwnProperty("passive"))
                if (typeof message.passive !== "boolean")
                    return "passive: boolean expected";
            if (message.userAgent != null && message.hasOwnProperty("userAgent")) {
                var error = $root.proto.UserAgent.verify(message.userAgent);
                if (error)
                    return "userAgent." + error;
            }
            if (message.webInfo != null && message.hasOwnProperty("webInfo")) {
                var error = $root.proto.WebInfo.verify(message.webInfo);
                if (error)
                    return "webInfo." + error;
            }
            if (message.pushName != null && message.hasOwnProperty("pushName"))
                if (!$util.isString(message.pushName))
                    return "pushName: string expected";
            if (message.sessionId != null && message.hasOwnProperty("sessionId"))
                if (!$util.isInteger(message.sessionId))
                    return "sessionId: integer expected";
            if (message.shortConnect != null && message.hasOwnProperty("shortConnect"))
                if (typeof message.shortConnect !== "boolean")
                    return "shortConnect: boolean expected";
            if (message.connectType != null && message.hasOwnProperty("connectType"))
                switch (message.connectType) {
                default:
                    return "connectType: enum value expected";
                case 0:
                case 1:
                case 100:
                case 101:
                case 102:
                case 103:
                case 104:
                case 105:
                case 106:
                case 107:
                case 108:
                case 109:
                case 110:
                case 111:
                case 112:
                    break;
                }
            if (message.connectReason != null && message.hasOwnProperty("connectReason"))
                switch (message.connectReason) {
                default:
                    return "connectReason: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                    break;
                }
            if (message.shards != null && message.hasOwnProperty("shards")) {
                if (!Array.isArray(message.shards))
                    return "shards: array expected";
                for (var i = 0; i < message.shards.length; ++i)
                    if (!$util.isInteger(message.shards[i]))
                        return "shards: integer[] expected";
            }
            if (message.dnsSource != null && message.hasOwnProperty("dnsSource")) {
                var error = $root.proto.DNSSource.verify(message.dnsSource);
                if (error)
                    return "dnsSource." + error;
            }
            if (message.connectAttemptCount != null && message.hasOwnProperty("connectAttemptCount"))
                if (!$util.isInteger(message.connectAttemptCount))
                    return "connectAttemptCount: integer expected";
            if (message.agent != null && message.hasOwnProperty("agent"))
                if (!$util.isInteger(message.agent))
                    return "agent: integer expected";
            if (message.device != null && message.hasOwnProperty("device"))
                if (!$util.isInteger(message.device))
                    return "device: integer expected";
            if (message.regData != null && message.hasOwnProperty("regData")) {
                var error = $root.proto.CompanionRegData.verify(message.regData);
                if (error)
                    return "regData." + error;
            }
            if (message.product != null && message.hasOwnProperty("product"))
                switch (message.product) {
                default:
                    return "product: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.fbCat != null && message.hasOwnProperty("fbCat"))
                if (!(message.fbCat && typeof message.fbCat.length === "number" || $util.isString(message.fbCat)))
                    return "fbCat: buffer expected";
            if (message.fbUserAgent != null && message.hasOwnProperty("fbUserAgent"))
                if (!(message.fbUserAgent && typeof message.fbUserAgent.length === "number" || $util.isString(message.fbUserAgent)))
                    return "fbUserAgent: buffer expected";
            if (message.oc != null && message.hasOwnProperty("oc"))
                if (typeof message.oc !== "boolean")
                    return "oc: boolean expected";
            if (message.lc != null && message.hasOwnProperty("lc"))
                if (!$util.isInteger(message.lc))
                    return "lc: integer expected";
            if (message.iosAppExtension != null && message.hasOwnProperty("iosAppExtension"))
                switch (message.iosAppExtension) {
                default:
                    return "iosAppExtension: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.fbAppId != null && message.hasOwnProperty("fbAppId"))
                if (!$util.isInteger(message.fbAppId) && !(message.fbAppId && $util.isInteger(message.fbAppId.low) && $util.isInteger(message.fbAppId.high)))
                    return "fbAppId: integer|Long expected";
            if (message.fbDeviceId != null && message.hasOwnProperty("fbDeviceId"))
                if (!(message.fbDeviceId && typeof message.fbDeviceId.length === "number" || $util.isString(message.fbDeviceId)))
                    return "fbDeviceId: buffer expected";
            return null;
        };

        /**
         * Creates a ClientPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientPayload} ClientPayload
         */
        ClientPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientPayload)
                return object;
            var message = new $root.proto.ClientPayload();
            if (object.username != null)
                if ($util.Long)
                    (message.username = $util.Long.fromValue(object.username)).unsigned = true;
                else if (typeof object.username === "string")
                    message.username = parseInt(object.username, 10);
                else if (typeof object.username === "number")
                    message.username = object.username;
                else if (typeof object.username === "object")
                    message.username = new $util.LongBits(object.username.low >>> 0, object.username.high >>> 0).toNumber(true);
            if (object.passive != null)
                message.passive = Boolean(object.passive);
            if (object.userAgent != null) {
                if (typeof object.userAgent !== "object")
                    throw TypeError(".proto.ClientPayload.userAgent: object expected");
                message.userAgent = $root.proto.UserAgent.fromObject(object.userAgent);
            }
            if (object.webInfo != null) {
                if (typeof object.webInfo !== "object")
                    throw TypeError(".proto.ClientPayload.webInfo: object expected");
                message.webInfo = $root.proto.WebInfo.fromObject(object.webInfo);
            }
            if (object.pushName != null)
                message.pushName = String(object.pushName);
            if (object.sessionId != null)
                message.sessionId = object.sessionId | 0;
            if (object.shortConnect != null)
                message.shortConnect = Boolean(object.shortConnect);
            switch (object.connectType) {
            case "CELLULAR_UNKNOWN":
            case 0:
                message.connectType = 0;
                break;
            case "WIFI_UNKNOWN":
            case 1:
                message.connectType = 1;
                break;
            case "CELLULAR_EDGE":
            case 100:
                message.connectType = 100;
                break;
            case "CELLULAR_IDEN":
            case 101:
                message.connectType = 101;
                break;
            case "CELLULAR_UMTS":
            case 102:
                message.connectType = 102;
                break;
            case "CELLULAR_EVDO":
            case 103:
                message.connectType = 103;
                break;
            case "CELLULAR_GPRS":
            case 104:
                message.connectType = 104;
                break;
            case "CELLULAR_HSDPA":
            case 105:
                message.connectType = 105;
                break;
            case "CELLULAR_HSUPA":
            case 106:
                message.connectType = 106;
                break;
            case "CELLULAR_HSPA":
            case 107:
                message.connectType = 107;
                break;
            case "CELLULAR_CDMA":
            case 108:
                message.connectType = 108;
                break;
            case "CELLULAR_1XRTT":
            case 109:
                message.connectType = 109;
                break;
            case "CELLULAR_EHRPD":
            case 110:
                message.connectType = 110;
                break;
            case "CELLULAR_LTE":
            case 111:
                message.connectType = 111;
                break;
            case "CELLULAR_HSPAP":
            case 112:
                message.connectType = 112;
                break;
            }
            switch (object.connectReason) {
            case "PUSH":
            case 0:
                message.connectReason = 0;
                break;
            case "USER_ACTIVATED":
            case 1:
                message.connectReason = 1;
                break;
            case "SCHEDULED":
            case 2:
                message.connectReason = 2;
                break;
            case "ERROR_RECONNECT":
            case 3:
                message.connectReason = 3;
                break;
            case "NETWORK_SWITCH":
            case 4:
                message.connectReason = 4;
                break;
            case "PING_RECONNECT":
            case 5:
                message.connectReason = 5;
                break;
            }
            if (object.shards) {
                if (!Array.isArray(object.shards))
                    throw TypeError(".proto.ClientPayload.shards: array expected");
                message.shards = [];
                for (var i = 0; i < object.shards.length; ++i)
                    message.shards[i] = object.shards[i] | 0;
            }
            if (object.dnsSource != null) {
                if (typeof object.dnsSource !== "object")
                    throw TypeError(".proto.ClientPayload.dnsSource: object expected");
                message.dnsSource = $root.proto.DNSSource.fromObject(object.dnsSource);
            }
            if (object.connectAttemptCount != null)
                message.connectAttemptCount = object.connectAttemptCount >>> 0;
            if (object.agent != null)
                message.agent = object.agent >>> 0;
            if (object.device != null)
                message.device = object.device >>> 0;
            if (object.regData != null) {
                if (typeof object.regData !== "object")
                    throw TypeError(".proto.ClientPayload.regData: object expected");
                message.regData = $root.proto.CompanionRegData.fromObject(object.regData);
            }
            switch (object.product) {
            case "WHATSAPP":
            case 0:
                message.product = 0;
                break;
            case "MESSENGER":
            case 1:
                message.product = 1;
                break;
            }
            if (object.fbCat != null)
                if (typeof object.fbCat === "string")
                    $util.base64.decode(object.fbCat, message.fbCat = $util.newBuffer($util.base64.length(object.fbCat)), 0);
                else if (object.fbCat.length)
                    message.fbCat = object.fbCat;
            if (object.fbUserAgent != null)
                if (typeof object.fbUserAgent === "string")
                    $util.base64.decode(object.fbUserAgent, message.fbUserAgent = $util.newBuffer($util.base64.length(object.fbUserAgent)), 0);
                else if (object.fbUserAgent.length)
                    message.fbUserAgent = object.fbUserAgent;
            if (object.oc != null)
                message.oc = Boolean(object.oc);
            if (object.lc != null)
                message.lc = object.lc >>> 0;
            switch (object.iosAppExtension) {
            case "SHARE_EXTENSION":
            case 0:
                message.iosAppExtension = 0;
                break;
            case "SERVICE_EXTENSION":
            case 1:
                message.iosAppExtension = 1;
                break;
            case "INTENTS_EXTENSION":
            case 2:
                message.iosAppExtension = 2;
                break;
            }
            if (object.fbAppId != null)
                if ($util.Long)
                    (message.fbAppId = $util.Long.fromValue(object.fbAppId)).unsigned = true;
                else if (typeof object.fbAppId === "string")
                    message.fbAppId = parseInt(object.fbAppId, 10);
                else if (typeof object.fbAppId === "number")
                    message.fbAppId = object.fbAppId;
                else if (typeof object.fbAppId === "object")
                    message.fbAppId = new $util.LongBits(object.fbAppId.low >>> 0, object.fbAppId.high >>> 0).toNumber(true);
            if (object.fbDeviceId != null)
                if (typeof object.fbDeviceId === "string")
                    $util.base64.decode(object.fbDeviceId, message.fbDeviceId = $util.newBuffer($util.base64.length(object.fbDeviceId)), 0);
                else if (object.fbDeviceId.length)
                    message.fbDeviceId = object.fbDeviceId;
            return message;
        };

        /**
         * Creates a plain object from a ClientPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.ClientPayload} message ClientPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.shards = [];
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.username = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.username = options.longs === String ? "0" : 0;
                object.passive = false;
                object.userAgent = null;
                object.webInfo = null;
                object.pushName = "";
                object.sessionId = 0;
                object.shortConnect = false;
                object.connectType = options.enums === String ? "CELLULAR_UNKNOWN" : 0;
                object.connectReason = options.enums === String ? "PUSH" : 0;
                object.dnsSource = null;
                object.connectAttemptCount = 0;
                object.agent = 0;
                object.device = 0;
                object.regData = null;
                object.product = options.enums === String ? "WHATSAPP" : 0;
                if (options.bytes === String)
                    object.fbCat = "";
                else {
                    object.fbCat = [];
                    if (options.bytes !== Array)
                        object.fbCat = $util.newBuffer(object.fbCat);
                }
                if (options.bytes === String)
                    object.fbUserAgent = "";
                else {
                    object.fbUserAgent = [];
                    if (options.bytes !== Array)
                        object.fbUserAgent = $util.newBuffer(object.fbUserAgent);
                }
                object.oc = false;
                object.lc = 0;
                object.iosAppExtension = options.enums === String ? "SHARE_EXTENSION" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fbAppId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fbAppId = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.fbDeviceId = "";
                else {
                    object.fbDeviceId = [];
                    if (options.bytes !== Array)
                        object.fbDeviceId = $util.newBuffer(object.fbDeviceId);
                }
            }
            if (message.username != null && message.hasOwnProperty("username"))
                if (typeof message.username === "number")
                    object.username = options.longs === String ? String(message.username) : message.username;
                else
                    object.username = options.longs === String ? $util.Long.prototype.toString.call(message.username) : options.longs === Number ? new $util.LongBits(message.username.low >>> 0, message.username.high >>> 0).toNumber(true) : message.username;
            if (message.passive != null && message.hasOwnProperty("passive"))
                object.passive = message.passive;
            if (message.userAgent != null && message.hasOwnProperty("userAgent"))
                object.userAgent = $root.proto.UserAgent.toObject(message.userAgent, options);
            if (message.webInfo != null && message.hasOwnProperty("webInfo"))
                object.webInfo = $root.proto.WebInfo.toObject(message.webInfo, options);
            if (message.pushName != null && message.hasOwnProperty("pushName"))
                object.pushName = message.pushName;
            if (message.sessionId != null && message.hasOwnProperty("sessionId"))
                object.sessionId = message.sessionId;
            if (message.shortConnect != null && message.hasOwnProperty("shortConnect"))
                object.shortConnect = message.shortConnect;
            if (message.connectType != null && message.hasOwnProperty("connectType"))
                object.connectType = options.enums === String ? $root.proto.ClientPayload.ClientPayloadConnectType[message.connectType] : message.connectType;
            if (message.connectReason != null && message.hasOwnProperty("connectReason"))
                object.connectReason = options.enums === String ? $root.proto.ClientPayload.ClientPayloadConnectReason[message.connectReason] : message.connectReason;
            if (message.shards && message.shards.length) {
                object.shards = [];
                for (var j = 0; j < message.shards.length; ++j)
                    object.shards[j] = message.shards[j];
            }
            if (message.dnsSource != null && message.hasOwnProperty("dnsSource"))
                object.dnsSource = $root.proto.DNSSource.toObject(message.dnsSource, options);
            if (message.connectAttemptCount != null && message.hasOwnProperty("connectAttemptCount"))
                object.connectAttemptCount = message.connectAttemptCount;
            if (message.agent != null && message.hasOwnProperty("agent"))
                object.agent = message.agent;
            if (message.device != null && message.hasOwnProperty("device"))
                object.device = message.device;
            if (message.regData != null && message.hasOwnProperty("regData"))
                object.regData = $root.proto.CompanionRegData.toObject(message.regData, options);
            if (message.product != null && message.hasOwnProperty("product"))
                object.product = options.enums === String ? $root.proto.ClientPayload.ClientPayloadProduct[message.product] : message.product;
            if (message.fbCat != null && message.hasOwnProperty("fbCat"))
                object.fbCat = options.bytes === String ? $util.base64.encode(message.fbCat, 0, message.fbCat.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbCat) : message.fbCat;
            if (message.fbUserAgent != null && message.hasOwnProperty("fbUserAgent"))
                object.fbUserAgent = options.bytes === String ? $util.base64.encode(message.fbUserAgent, 0, message.fbUserAgent.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbUserAgent) : message.fbUserAgent;
            if (message.oc != null && message.hasOwnProperty("oc"))
                object.oc = message.oc;
            if (message.lc != null && message.hasOwnProperty("lc"))
                object.lc = message.lc;
            if (message.iosAppExtension != null && message.hasOwnProperty("iosAppExtension"))
                object.iosAppExtension = options.enums === String ? $root.proto.ClientPayload.ClientPayloadIOSAppExtension[message.iosAppExtension] : message.iosAppExtension;
            if (message.fbAppId != null && message.hasOwnProperty("fbAppId"))
                if (typeof message.fbAppId === "number")
                    object.fbAppId = options.longs === String ? String(message.fbAppId) : message.fbAppId;
                else
                    object.fbAppId = options.longs === String ? $util.Long.prototype.toString.call(message.fbAppId) : options.longs === Number ? new $util.LongBits(message.fbAppId.low >>> 0, message.fbAppId.high >>> 0).toNumber(true) : message.fbAppId;
            if (message.fbDeviceId != null && message.hasOwnProperty("fbDeviceId"))
                object.fbDeviceId = options.bytes === String ? $util.base64.encode(message.fbDeviceId, 0, message.fbDeviceId.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbDeviceId) : message.fbDeviceId;
            return object;
        };

        /**
         * Converts this ClientPayload to JSON.
         * @function toJSON
         * @memberof proto.ClientPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ClientPayloadConnectType enum.
         * @name proto.ClientPayload.ClientPayloadConnectType
         * @enum {number}
         * @property {number} CELLULAR_UNKNOWN=0 CELLULAR_UNKNOWN value
         * @property {number} WIFI_UNKNOWN=1 WIFI_UNKNOWN value
         * @property {number} CELLULAR_EDGE=100 CELLULAR_EDGE value
         * @property {number} CELLULAR_IDEN=101 CELLULAR_IDEN value
         * @property {number} CELLULAR_UMTS=102 CELLULAR_UMTS value
         * @property {number} CELLULAR_EVDO=103 CELLULAR_EVDO value
         * @property {number} CELLULAR_GPRS=104 CELLULAR_GPRS value
         * @property {number} CELLULAR_HSDPA=105 CELLULAR_HSDPA value
         * @property {number} CELLULAR_HSUPA=106 CELLULAR_HSUPA value
         * @property {number} CELLULAR_HSPA=107 CELLULAR_HSPA value
         * @property {number} CELLULAR_CDMA=108 CELLULAR_CDMA value
         * @property {number} CELLULAR_1XRTT=109 CELLULAR_1XRTT value
         * @property {number} CELLULAR_EHRPD=110 CELLULAR_EHRPD value
         * @property {number} CELLULAR_LTE=111 CELLULAR_LTE value
         * @property {number} CELLULAR_HSPAP=112 CELLULAR_HSPAP value
         */
        ClientPayload.ClientPayloadConnectType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CELLULAR_UNKNOWN"] = 0;
            values[valuesById[1] = "WIFI_UNKNOWN"] = 1;
            values[valuesById[100] = "CELLULAR_EDGE"] = 100;
            values[valuesById[101] = "CELLULAR_IDEN"] = 101;
            values[valuesById[102] = "CELLULAR_UMTS"] = 102;
            values[valuesById[103] = "CELLULAR_EVDO"] = 103;
            values[valuesById[104] = "CELLULAR_GPRS"] = 104;
            values[valuesById[105] = "CELLULAR_HSDPA"] = 105;
            values[valuesById[106] = "CELLULAR_HSUPA"] = 106;
            values[valuesById[107] = "CELLULAR_HSPA"] = 107;
            values[valuesById[108] = "CELLULAR_CDMA"] = 108;
            values[valuesById[109] = "CELLULAR_1XRTT"] = 109;
            values[valuesById[110] = "CELLULAR_EHRPD"] = 110;
            values[valuesById[111] = "CELLULAR_LTE"] = 111;
            values[valuesById[112] = "CELLULAR_HSPAP"] = 112;
            return values;
        })();

        /**
         * ClientPayloadConnectReason enum.
         * @name proto.ClientPayload.ClientPayloadConnectReason
         * @enum {number}
         * @property {number} PUSH=0 PUSH value
         * @property {number} USER_ACTIVATED=1 USER_ACTIVATED value
         * @property {number} SCHEDULED=2 SCHEDULED value
         * @property {number} ERROR_RECONNECT=3 ERROR_RECONNECT value
         * @property {number} NETWORK_SWITCH=4 NETWORK_SWITCH value
         * @property {number} PING_RECONNECT=5 PING_RECONNECT value
         */
        ClientPayload.ClientPayloadConnectReason = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "PUSH"] = 0;
            values[valuesById[1] = "USER_ACTIVATED"] = 1;
            values[valuesById[2] = "SCHEDULED"] = 2;
            values[valuesById[3] = "ERROR_RECONNECT"] = 3;
            values[valuesById[4] = "NETWORK_SWITCH"] = 4;
            values[valuesById[5] = "PING_RECONNECT"] = 5;
            return values;
        })();

        /**
         * ClientPayloadProduct enum.
         * @name proto.ClientPayload.ClientPayloadProduct
         * @enum {number}
         * @property {number} WHATSAPP=0 WHATSAPP value
         * @property {number} MESSENGER=1 MESSENGER value
         */
        ClientPayload.ClientPayloadProduct = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WHATSAPP"] = 0;
            values[valuesById[1] = "MESSENGER"] = 1;
            return values;
        })();

        /**
         * ClientPayloadIOSAppExtension enum.
         * @name proto.ClientPayload.ClientPayloadIOSAppExtension
         * @enum {number}
         * @property {number} SHARE_EXTENSION=0 SHARE_EXTENSION value
         * @property {number} SERVICE_EXTENSION=1 SERVICE_EXTENSION value
         * @property {number} INTENTS_EXTENSION=2 INTENTS_EXTENSION value
         */
        ClientPayload.ClientPayloadIOSAppExtension = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SHARE_EXTENSION"] = 0;
            values[valuesById[1] = "SERVICE_EXTENSION"] = 1;
            values[valuesById[2] = "INTENTS_EXTENSION"] = 2;
            return values;
        })();

        return ClientPayload;
    })();

    proto.Details = (function() {

        /**
         * Properties of a Details.
         * @memberof proto
         * @interface IDetails
         * @property {number|null} [serial] Details serial
         * @property {string|null} [issuer] Details issuer
         * @property {number|Long|null} [expires] Details expires
         * @property {string|null} [subject] Details subject
         * @property {Uint8Array|null} [key] Details key
         */

        /**
         * Constructs a new Details.
         * @memberof proto
         * @classdesc Represents a Details.
         * @implements IDetails
         * @constructor
         * @param {proto.IDetails=} [properties] Properties to set
         */
        function Details(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Details serial.
         * @member {number} serial
         * @memberof proto.Details
         * @instance
         */
        Details.prototype.serial = 0;

        /**
         * Details issuer.
         * @member {string} issuer
         * @memberof proto.Details
         * @instance
         */
        Details.prototype.issuer = "";

        /**
         * Details expires.
         * @member {number|Long} expires
         * @memberof proto.Details
         * @instance
         */
        Details.prototype.expires = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Details subject.
         * @member {string} subject
         * @memberof proto.Details
         * @instance
         */
        Details.prototype.subject = "";

        /**
         * Details key.
         * @member {Uint8Array} key
         * @memberof proto.Details
         * @instance
         */
        Details.prototype.key = $util.newBuffer([]);

        /**
         * Creates a new Details instance using the specified properties.
         * @function create
         * @memberof proto.Details
         * @static
         * @param {proto.IDetails=} [properties] Properties to set
         * @returns {proto.Details} Details instance
         */
        Details.create = function create(properties) {
            return new Details(properties);
        };

        /**
         * Encodes the specified Details message. Does not implicitly {@link proto.Details.verify|verify} messages.
         * @function encode
         * @memberof proto.Details
         * @static
         * @param {proto.IDetails} message Details message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Details.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.serial != null && Object.hasOwnProperty.call(message, "serial"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.serial);
            if (message.issuer != null && Object.hasOwnProperty.call(message, "issuer"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.issuer);
            if (message.expires != null && Object.hasOwnProperty.call(message, "expires"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.expires);
            if (message.subject != null && Object.hasOwnProperty.call(message, "subject"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.subject);
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.key);
            return writer;
        };

        /**
         * Encodes the specified Details message, length delimited. Does not implicitly {@link proto.Details.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Details
         * @static
         * @param {proto.IDetails} message Details message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Details.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Details message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Details
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Details} Details
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Details.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Details();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.serial = reader.uint32();
                    break;
                case 2:
                    message.issuer = reader.string();
                    break;
                case 3:
                    message.expires = reader.uint64();
                    break;
                case 4:
                    message.subject = reader.string();
                    break;
                case 5:
                    message.key = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Details message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Details
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Details} Details
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Details.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Details message.
         * @function verify
         * @memberof proto.Details
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Details.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.serial != null && message.hasOwnProperty("serial"))
                if (!$util.isInteger(message.serial))
                    return "serial: integer expected";
            if (message.issuer != null && message.hasOwnProperty("issuer"))
                if (!$util.isString(message.issuer))
                    return "issuer: string expected";
            if (message.expires != null && message.hasOwnProperty("expires"))
                if (!$util.isInteger(message.expires) && !(message.expires && $util.isInteger(message.expires.low) && $util.isInteger(message.expires.high)))
                    return "expires: integer|Long expected";
            if (message.subject != null && message.hasOwnProperty("subject"))
                if (!$util.isString(message.subject))
                    return "subject: string expected";
            if (message.key != null && message.hasOwnProperty("key"))
                if (!(message.key && typeof message.key.length === "number" || $util.isString(message.key)))
                    return "key: buffer expected";
            return null;
        };

        /**
         * Creates a Details message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Details
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Details} Details
         */
        Details.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Details)
                return object;
            var message = new $root.proto.Details();
            if (object.serial != null)
                message.serial = object.serial >>> 0;
            if (object.issuer != null)
                message.issuer = String(object.issuer);
            if (object.expires != null)
                if ($util.Long)
                    (message.expires = $util.Long.fromValue(object.expires)).unsigned = true;
                else if (typeof object.expires === "string")
                    message.expires = parseInt(object.expires, 10);
                else if (typeof object.expires === "number")
                    message.expires = object.expires;
                else if (typeof object.expires === "object")
                    message.expires = new $util.LongBits(object.expires.low >>> 0, object.expires.high >>> 0).toNumber(true);
            if (object.subject != null)
                message.subject = String(object.subject);
            if (object.key != null)
                if (typeof object.key === "string")
                    $util.base64.decode(object.key, message.key = $util.newBuffer($util.base64.length(object.key)), 0);
                else if (object.key.length)
                    message.key = object.key;
            return message;
        };

        /**
         * Creates a plain object from a Details message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Details
         * @static
         * @param {proto.Details} message Details
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Details.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.serial = 0;
                object.issuer = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.expires = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.expires = options.longs === String ? "0" : 0;
                object.subject = "";
                if (options.bytes === String)
                    object.key = "";
                else {
                    object.key = [];
                    if (options.bytes !== Array)
                        object.key = $util.newBuffer(object.key);
                }
            }
            if (message.serial != null && message.hasOwnProperty("serial"))
                object.serial = message.serial;
            if (message.issuer != null && message.hasOwnProperty("issuer"))
                object.issuer = message.issuer;
            if (message.expires != null && message.hasOwnProperty("expires"))
                if (typeof message.expires === "number")
                    object.expires = options.longs === String ? String(message.expires) : message.expires;
                else
                    object.expires = options.longs === String ? $util.Long.prototype.toString.call(message.expires) : options.longs === Number ? new $util.LongBits(message.expires.low >>> 0, message.expires.high >>> 0).toNumber(true) : message.expires;
            if (message.subject != null && message.hasOwnProperty("subject"))
                object.subject = message.subject;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = options.bytes === String ? $util.base64.encode(message.key, 0, message.key.length) : options.bytes === Array ? Array.prototype.slice.call(message.key) : message.key;
            return object;
        };

        /**
         * Converts this Details to JSON.
         * @function toJSON
         * @memberof proto.Details
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Details.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Details;
    })();

    proto.NoiseCertificate = (function() {

        /**
         * Properties of a NoiseCertificate.
         * @memberof proto
         * @interface INoiseCertificate
         * @property {Uint8Array|null} [details] NoiseCertificate details
         * @property {Uint8Array|null} [signature] NoiseCertificate signature
         */

        /**
         * Constructs a new NoiseCertificate.
         * @memberof proto
         * @classdesc Represents a NoiseCertificate.
         * @implements INoiseCertificate
         * @constructor
         * @param {proto.INoiseCertificate=} [properties] Properties to set
         */
        function NoiseCertificate(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * NoiseCertificate details.
         * @member {Uint8Array} details
         * @memberof proto.NoiseCertificate
         * @instance
         */
        NoiseCertificate.prototype.details = $util.newBuffer([]);

        /**
         * NoiseCertificate signature.
         * @member {Uint8Array} signature
         * @memberof proto.NoiseCertificate
         * @instance
         */
        NoiseCertificate.prototype.signature = $util.newBuffer([]);

        /**
         * Creates a new NoiseCertificate instance using the specified properties.
         * @function create
         * @memberof proto.NoiseCertificate
         * @static
         * @param {proto.INoiseCertificate=} [properties] Properties to set
         * @returns {proto.NoiseCertificate} NoiseCertificate instance
         */
        NoiseCertificate.create = function create(properties) {
            return new NoiseCertificate(properties);
        };

        /**
         * Encodes the specified NoiseCertificate message. Does not implicitly {@link proto.NoiseCertificate.verify|verify} messages.
         * @function encode
         * @memberof proto.NoiseCertificate
         * @static
         * @param {proto.INoiseCertificate} message NoiseCertificate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        NoiseCertificate.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.signature != null && Object.hasOwnProperty.call(message, "signature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.signature);
            return writer;
        };

        /**
         * Encodes the specified NoiseCertificate message, length delimited. Does not implicitly {@link proto.NoiseCertificate.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.NoiseCertificate
         * @static
         * @param {proto.INoiseCertificate} message NoiseCertificate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        NoiseCertificate.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a NoiseCertificate message from the specified reader or buffer.
         * @function decode
         * @memberof proto.NoiseCertificate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.NoiseCertificate} NoiseCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        NoiseCertificate.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.NoiseCertificate();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.signature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a NoiseCertificate message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.NoiseCertificate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.NoiseCertificate} NoiseCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        NoiseCertificate.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a NoiseCertificate message.
         * @function verify
         * @memberof proto.NoiseCertificate
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        NoiseCertificate.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.signature != null && message.hasOwnProperty("signature"))
                if (!(message.signature && typeof message.signature.length === "number" || $util.isString(message.signature)))
                    return "signature: buffer expected";
            return null;
        };

        /**
         * Creates a NoiseCertificate message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.NoiseCertificate
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.NoiseCertificate} NoiseCertificate
         */
        NoiseCertificate.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.NoiseCertificate)
                return object;
            var message = new $root.proto.NoiseCertificate();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.signature != null)
                if (typeof object.signature === "string")
                    $util.base64.decode(object.signature, message.signature = $util.newBuffer($util.base64.length(object.signature)), 0);
                else if (object.signature.length)
                    message.signature = object.signature;
            return message;
        };

        /**
         * Creates a plain object from a NoiseCertificate message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.NoiseCertificate
         * @static
         * @param {proto.NoiseCertificate} message NoiseCertificate
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        NoiseCertificate.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.signature = "";
                else {
                    object.signature = [];
                    if (options.bytes !== Array)
                        object.signature = $util.newBuffer(object.signature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.signature != null && message.hasOwnProperty("signature"))
                object.signature = options.bytes === String ? $util.base64.encode(message.signature, 0, message.signature.length) : options.bytes === Array ? Array.prototype.slice.call(message.signature) : message.signature;
            return object;
        };

        /**
         * Converts this NoiseCertificate to JSON.
         * @function toJSON
         * @memberof proto.NoiseCertificate
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        NoiseCertificate.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return NoiseCertificate;
    })();

    proto.ClientHello = (function() {

        /**
         * Properties of a ClientHello.
         * @memberof proto
         * @interface IClientHello
         * @property {Uint8Array|null} [ephemeral] ClientHello ephemeral
         * @property {Uint8Array|null} ["static"] ClientHello static
         * @property {Uint8Array|null} [payload] ClientHello payload
         */

        /**
         * Constructs a new ClientHello.
         * @memberof proto
         * @classdesc Represents a ClientHello.
         * @implements IClientHello
         * @constructor
         * @param {proto.IClientHello=} [properties] Properties to set
         */
        function ClientHello(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientHello ephemeral.
         * @member {Uint8Array} ephemeral
         * @memberof proto.ClientHello
         * @instance
         */
        ClientHello.prototype.ephemeral = $util.newBuffer([]);

        /**
         * ClientHello static.
         * @member {Uint8Array} static
         * @memberof proto.ClientHello
         * @instance
         */
        ClientHello.prototype["static"] = $util.newBuffer([]);

        /**
         * ClientHello payload.
         * @member {Uint8Array} payload
         * @memberof proto.ClientHello
         * @instance
         */
        ClientHello.prototype.payload = $util.newBuffer([]);

        /**
         * Creates a new ClientHello instance using the specified properties.
         * @function create
         * @memberof proto.ClientHello
         * @static
         * @param {proto.IClientHello=} [properties] Properties to set
         * @returns {proto.ClientHello} ClientHello instance
         */
        ClientHello.create = function create(properties) {
            return new ClientHello(properties);
        };

        /**
         * Encodes the specified ClientHello message. Does not implicitly {@link proto.ClientHello.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientHello
         * @static
         * @param {proto.IClientHello} message ClientHello message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientHello.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.ephemeral != null && Object.hasOwnProperty.call(message, "ephemeral"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.ephemeral);
            if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message["static"]);
            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.payload);
            return writer;
        };

        /**
         * Encodes the specified ClientHello message, length delimited. Does not implicitly {@link proto.ClientHello.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientHello
         * @static
         * @param {proto.IClientHello} message ClientHello message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientHello.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientHello message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientHello
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientHello} ClientHello
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientHello.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientHello();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.ephemeral = reader.bytes();
                    break;
                case 2:
                    message["static"] = reader.bytes();
                    break;
                case 3:
                    message.payload = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientHello message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientHello
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientHello} ClientHello
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientHello.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientHello message.
         * @function verify
         * @memberof proto.ClientHello
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientHello.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                if (!(message.ephemeral && typeof message.ephemeral.length === "number" || $util.isString(message.ephemeral)))
                    return "ephemeral: buffer expected";
            if (message["static"] != null && message.hasOwnProperty("static"))
                if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                    return "static: buffer expected";
            if (message.payload != null && message.hasOwnProperty("payload"))
                if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                    return "payload: buffer expected";
            return null;
        };

        /**
         * Creates a ClientHello message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientHello
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientHello} ClientHello
         */
        ClientHello.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientHello)
                return object;
            var message = new $root.proto.ClientHello();
            if (object.ephemeral != null)
                if (typeof object.ephemeral === "string")
                    $util.base64.decode(object.ephemeral, message.ephemeral = $util.newBuffer($util.base64.length(object.ephemeral)), 0);
                else if (object.ephemeral.length)
                    message.ephemeral = object.ephemeral;
            if (object["static"] != null)
                if (typeof object["static"] === "string")
                    $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                else if (object["static"].length)
                    message["static"] = object["static"];
            if (object.payload != null)
                if (typeof object.payload === "string")
                    $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                else if (object.payload.length)
                    message.payload = object.payload;
            return message;
        };

        /**
         * Creates a plain object from a ClientHello message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientHello
         * @static
         * @param {proto.ClientHello} message ClientHello
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientHello.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.ephemeral = "";
                else {
                    object.ephemeral = [];
                    if (options.bytes !== Array)
                        object.ephemeral = $util.newBuffer(object.ephemeral);
                }
                if (options.bytes === String)
                    object["static"] = "";
                else {
                    object["static"] = [];
                    if (options.bytes !== Array)
                        object["static"] = $util.newBuffer(object["static"]);
                }
                if (options.bytes === String)
                    object.payload = "";
                else {
                    object.payload = [];
                    if (options.bytes !== Array)
                        object.payload = $util.newBuffer(object.payload);
                }
            }
            if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                object.ephemeral = options.bytes === String ? $util.base64.encode(message.ephemeral, 0, message.ephemeral.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeral) : message.ephemeral;
            if (message["static"] != null && message.hasOwnProperty("static"))
                object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
            if (message.payload != null && message.hasOwnProperty("payload"))
                object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
            return object;
        };

        /**
         * Converts this ClientHello to JSON.
         * @function toJSON
         * @memberof proto.ClientHello
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientHello.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ClientHello;
    })();

    proto.ServerHello = (function() {

        /**
         * Properties of a ServerHello.
         * @memberof proto
         * @interface IServerHello
         * @property {Uint8Array|null} [ephemeral] ServerHello ephemeral
         * @property {Uint8Array|null} ["static"] ServerHello static
         * @property {Uint8Array|null} [payload] ServerHello payload
         */

        /**
         * Constructs a new ServerHello.
         * @memberof proto
         * @classdesc Represents a ServerHello.
         * @implements IServerHello
         * @constructor
         * @param {proto.IServerHello=} [properties] Properties to set
         */
        function ServerHello(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ServerHello ephemeral.
         * @member {Uint8Array} ephemeral
         * @memberof proto.ServerHello
         * @instance
         */
        ServerHello.prototype.ephemeral = $util.newBuffer([]);

        /**
         * ServerHello static.
         * @member {Uint8Array} static
         * @memberof proto.ServerHello
         * @instance
         */
        ServerHello.prototype["static"] = $util.newBuffer([]);

        /**
         * ServerHello payload.
         * @member {Uint8Array} payload
         * @memberof proto.ServerHello
         * @instance
         */
        ServerHello.prototype.payload = $util.newBuffer([]);

        /**
         * Creates a new ServerHello instance using the specified properties.
         * @function create
         * @memberof proto.ServerHello
         * @static
         * @param {proto.IServerHello=} [properties] Properties to set
         * @returns {proto.ServerHello} ServerHello instance
         */
        ServerHello.create = function create(properties) {
            return new ServerHello(properties);
        };

        /**
         * Encodes the specified ServerHello message. Does not implicitly {@link proto.ServerHello.verify|verify} messages.
         * @function encode
         * @memberof proto.ServerHello
         * @static
         * @param {proto.IServerHello} message ServerHello message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServerHello.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.ephemeral != null && Object.hasOwnProperty.call(message, "ephemeral"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.ephemeral);
            if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message["static"]);
            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.payload);
            return writer;
        };

        /**
         * Encodes the specified ServerHello message, length delimited. Does not implicitly {@link proto.ServerHello.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ServerHello
         * @static
         * @param {proto.IServerHello} message ServerHello message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServerHello.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ServerHello message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ServerHello
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ServerHello} ServerHello
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServerHello.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ServerHello();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.ephemeral = reader.bytes();
                    break;
                case 2:
                    message["static"] = reader.bytes();
                    break;
                case 3:
                    message.payload = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ServerHello message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ServerHello
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ServerHello} ServerHello
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServerHello.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ServerHello message.
         * @function verify
         * @memberof proto.ServerHello
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ServerHello.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                if (!(message.ephemeral && typeof message.ephemeral.length === "number" || $util.isString(message.ephemeral)))
                    return "ephemeral: buffer expected";
            if (message["static"] != null && message.hasOwnProperty("static"))
                if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                    return "static: buffer expected";
            if (message.payload != null && message.hasOwnProperty("payload"))
                if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                    return "payload: buffer expected";
            return null;
        };

        /**
         * Creates a ServerHello message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ServerHello
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ServerHello} ServerHello
         */
        ServerHello.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ServerHello)
                return object;
            var message = new $root.proto.ServerHello();
            if (object.ephemeral != null)
                if (typeof object.ephemeral === "string")
                    $util.base64.decode(object.ephemeral, message.ephemeral = $util.newBuffer($util.base64.length(object.ephemeral)), 0);
                else if (object.ephemeral.length)
                    message.ephemeral = object.ephemeral;
            if (object["static"] != null)
                if (typeof object["static"] === "string")
                    $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                else if (object["static"].length)
                    message["static"] = object["static"];
            if (object.payload != null)
                if (typeof object.payload === "string")
                    $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                else if (object.payload.length)
                    message.payload = object.payload;
            return message;
        };

        /**
         * Creates a plain object from a ServerHello message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ServerHello
         * @static
         * @param {proto.ServerHello} message ServerHello
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ServerHello.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.ephemeral = "";
                else {
                    object.ephemeral = [];
                    if (options.bytes !== Array)
                        object.ephemeral = $util.newBuffer(object.ephemeral);
                }
                if (options.bytes === String)
                    object["static"] = "";
                else {
                    object["static"] = [];
                    if (options.bytes !== Array)
                        object["static"] = $util.newBuffer(object["static"]);
                }
                if (options.bytes === String)
                    object.payload = "";
                else {
                    object.payload = [];
                    if (options.bytes !== Array)
                        object.payload = $util.newBuffer(object.payload);
                }
            }
            if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                object.ephemeral = options.bytes === String ? $util.base64.encode(message.ephemeral, 0, message.ephemeral.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeral) : message.ephemeral;
            if (message["static"] != null && message.hasOwnProperty("static"))
                object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
            if (message.payload != null && message.hasOwnProperty("payload"))
                object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
            return object;
        };

        /**
         * Converts this ServerHello to JSON.
         * @function toJSON
         * @memberof proto.ServerHello
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ServerHello.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ServerHello;
    })();

    proto.ClientFinish = (function() {

        /**
         * Properties of a ClientFinish.
         * @memberof proto
         * @interface IClientFinish
         * @property {Uint8Array|null} ["static"] ClientFinish static
         * @property {Uint8Array|null} [payload] ClientFinish payload
         */

        /**
         * Constructs a new ClientFinish.
         * @memberof proto
         * @classdesc Represents a ClientFinish.
         * @implements IClientFinish
         * @constructor
         * @param {proto.IClientFinish=} [properties] Properties to set
         */
        function ClientFinish(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientFinish static.
         * @member {Uint8Array} static
         * @memberof proto.ClientFinish
         * @instance
         */
        ClientFinish.prototype["static"] = $util.newBuffer([]);

        /**
         * ClientFinish payload.
         * @member {Uint8Array} payload
         * @memberof proto.ClientFinish
         * @instance
         */
        ClientFinish.prototype.payload = $util.newBuffer([]);

        /**
         * Creates a new ClientFinish instance using the specified properties.
         * @function create
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.IClientFinish=} [properties] Properties to set
         * @returns {proto.ClientFinish} ClientFinish instance
         */
        ClientFinish.create = function create(properties) {
            return new ClientFinish(properties);
        };

        /**
         * Encodes the specified ClientFinish message. Does not implicitly {@link proto.ClientFinish.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.IClientFinish} message ClientFinish message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientFinish.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message["static"]);
            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.payload);
            return writer;
        };

        /**
         * Encodes the specified ClientFinish message, length delimited. Does not implicitly {@link proto.ClientFinish.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.IClientFinish} message ClientFinish message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientFinish.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientFinish message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientFinish
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientFinish} ClientFinish
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientFinish.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientFinish();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message["static"] = reader.bytes();
                    break;
                case 2:
                    message.payload = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientFinish message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientFinish
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientFinish} ClientFinish
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientFinish.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientFinish message.
         * @function verify
         * @memberof proto.ClientFinish
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientFinish.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message["static"] != null && message.hasOwnProperty("static"))
                if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                    return "static: buffer expected";
            if (message.payload != null && message.hasOwnProperty("payload"))
                if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                    return "payload: buffer expected";
            return null;
        };

        /**
         * Creates a ClientFinish message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientFinish
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientFinish} ClientFinish
         */
        ClientFinish.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientFinish)
                return object;
            var message = new $root.proto.ClientFinish();
            if (object["static"] != null)
                if (typeof object["static"] === "string")
                    $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                else if (object["static"].length)
                    message["static"] = object["static"];
            if (object.payload != null)
                if (typeof object.payload === "string")
                    $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                else if (object.payload.length)
                    message.payload = object.payload;
            return message;
        };

        /**
         * Creates a plain object from a ClientFinish message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.ClientFinish} message ClientFinish
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientFinish.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object["static"] = "";
                else {
                    object["static"] = [];
                    if (options.bytes !== Array)
                        object["static"] = $util.newBuffer(object["static"]);
                }
                if (options.bytes === String)
                    object.payload = "";
                else {
                    object.payload = [];
                    if (options.bytes !== Array)
                        object.payload = $util.newBuffer(object.payload);
                }
            }
            if (message["static"] != null && message.hasOwnProperty("static"))
                object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
            if (message.payload != null && message.hasOwnProperty("payload"))
                object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
            return object;
        };

        /**
         * Converts this ClientFinish to JSON.
         * @function toJSON
         * @memberof proto.ClientFinish
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientFinish.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ClientFinish;
    })();

    proto.HandshakeMessage = (function() {

        /**
         * Properties of a HandshakeMessage.
         * @memberof proto
         * @interface IHandshakeMessage
         * @property {proto.IClientHello|null} [clientHello] HandshakeMessage clientHello
         * @property {proto.IServerHello|null} [serverHello] HandshakeMessage serverHello
         * @property {proto.IClientFinish|null} [clientFinish] HandshakeMessage clientFinish
         */

        /**
         * Constructs a new HandshakeMessage.
         * @memberof proto
         * @classdesc Represents a HandshakeMessage.
         * @implements IHandshakeMessage
         * @constructor
         * @param {proto.IHandshakeMessage=} [properties] Properties to set
         */
        function HandshakeMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HandshakeMessage clientHello.
         * @member {proto.IClientHello|null|undefined} clientHello
         * @memberof proto.HandshakeMessage
         * @instance
         */
        HandshakeMessage.prototype.clientHello = null;

        /**
         * HandshakeMessage serverHello.
         * @member {proto.IServerHello|null|undefined} serverHello
         * @memberof proto.HandshakeMessage
         * @instance
         */
        HandshakeMessage.prototype.serverHello = null;

        /**
         * HandshakeMessage clientFinish.
         * @member {proto.IClientFinish|null|undefined} clientFinish
         * @memberof proto.HandshakeMessage
         * @instance
         */
        HandshakeMessage.prototype.clientFinish = null;

        /**
         * Creates a new HandshakeMessage instance using the specified properties.
         * @function create
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.IHandshakeMessage=} [properties] Properties to set
         * @returns {proto.HandshakeMessage} HandshakeMessage instance
         */
        HandshakeMessage.create = function create(properties) {
            return new HandshakeMessage(properties);
        };

        /**
         * Encodes the specified HandshakeMessage message. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.IHandshakeMessage} message HandshakeMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HandshakeMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.clientHello != null && Object.hasOwnProperty.call(message, "clientHello"))
                $root.proto.ClientHello.encode(message.clientHello, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.serverHello != null && Object.hasOwnProperty.call(message, "serverHello"))
                $root.proto.ServerHello.encode(message.serverHello, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.clientFinish != null && Object.hasOwnProperty.call(message, "clientFinish"))
                $root.proto.ClientFinish.encode(message.clientFinish, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified HandshakeMessage message, length delimited. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.IHandshakeMessage} message HandshakeMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HandshakeMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HandshakeMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HandshakeMessage} HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HandshakeMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HandshakeMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 2:
                    message.clientHello = $root.proto.ClientHello.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.serverHello = $root.proto.ServerHello.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.clientFinish = $root.proto.ClientFinish.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HandshakeMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HandshakeMessage} HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HandshakeMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HandshakeMessage message.
         * @function verify
         * @memberof proto.HandshakeMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HandshakeMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.clientHello != null && message.hasOwnProperty("clientHello")) {
                var error = $root.proto.ClientHello.verify(message.clientHello);
                if (error)
                    return "clientHello." + error;
            }
            if (message.serverHello != null && message.hasOwnProperty("serverHello")) {
                var error = $root.proto.ServerHello.verify(message.serverHello);
                if (error)
                    return "serverHello." + error;
            }
            if (message.clientFinish != null && message.hasOwnProperty("clientFinish")) {
                var error = $root.proto.ClientFinish.verify(message.clientFinish);
                if (error)
                    return "clientFinish." + error;
            }
            return null;
        };

        /**
         * Creates a HandshakeMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HandshakeMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HandshakeMessage} HandshakeMessage
         */
        HandshakeMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HandshakeMessage)
                return object;
            var message = new $root.proto.HandshakeMessage();
            if (object.clientHello != null) {
                if (typeof object.clientHello !== "object")
                    throw TypeError(".proto.HandshakeMessage.clientHello: object expected");
                message.clientHello = $root.proto.ClientHello.fromObject(object.clientHello);
            }
            if (object.serverHello != null) {
                if (typeof object.serverHello !== "object")
                    throw TypeError(".proto.HandshakeMessage.serverHello: object expected");
                message.serverHello = $root.proto.ServerHello.fromObject(object.serverHello);
            }
            if (object.clientFinish != null) {
                if (typeof object.clientFinish !== "object")
                    throw TypeError(".proto.HandshakeMessage.clientFinish: object expected");
                message.clientFinish = $root.proto.ClientFinish.fromObject(object.clientFinish);
            }
            return message;
        };

        /**
         * Creates a plain object from a HandshakeMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.HandshakeMessage} message HandshakeMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HandshakeMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.clientHello = null;
                object.serverHello = null;
                object.clientFinish = null;
            }
            if (message.clientHello != null && message.hasOwnProperty("clientHello"))
                object.clientHello = $root.proto.ClientHello.toObject(message.clientHello, options);
            if (message.serverHello != null && message.hasOwnProperty("serverHello"))
                object.serverHello = $root.proto.ServerHello.toObject(message.serverHello, options);
            if (message.clientFinish != null && message.hasOwnProperty("clientFinish"))
                object.clientFinish = $root.proto.ClientFinish.toObject(message.clientFinish, options);
            return object;
        };

        /**
         * Converts this HandshakeMessage to JSON.
         * @function toJSON
         * @memberof proto.HandshakeMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HandshakeMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HandshakeMessage;
    })();

    proto.BizIdentityInfo = (function() {

        /**
         * Properties of a BizIdentityInfo.
         * @memberof proto
         * @interface IBizIdentityInfo
         * @property {proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue|null} [vlevel] BizIdentityInfo vlevel
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizIdentityInfo vnameCert
         * @property {boolean|null} [signed] BizIdentityInfo signed
         * @property {boolean|null} [revoked] BizIdentityInfo revoked
         * @property {proto.BizIdentityInfo.BizIdentityInfoHostStorageType|null} [hostStorage] BizIdentityInfo hostStorage
         * @property {proto.BizIdentityInfo.BizIdentityInfoActualActorsType|null} [actualActors] BizIdentityInfo actualActors
         * @property {number|Long|null} [privacyModeTs] BizIdentityInfo privacyModeTs
         * @property {number|Long|null} [featureControls] BizIdentityInfo featureControls
         */

        /**
         * Constructs a new BizIdentityInfo.
         * @memberof proto
         * @classdesc Represents a BizIdentityInfo.
         * @implements IBizIdentityInfo
         * @constructor
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         */
        function BizIdentityInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizIdentityInfo vlevel.
         * @member {proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue} vlevel
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vlevel = 0;

        /**
         * BizIdentityInfo vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vnameCert = null;

        /**
         * BizIdentityInfo signed.
         * @member {boolean} signed
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.signed = false;

        /**
         * BizIdentityInfo revoked.
         * @member {boolean} revoked
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.revoked = false;

        /**
         * BizIdentityInfo hostStorage.
         * @member {proto.BizIdentityInfo.BizIdentityInfoHostStorageType} hostStorage
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.hostStorage = 0;

        /**
         * BizIdentityInfo actualActors.
         * @member {proto.BizIdentityInfo.BizIdentityInfoActualActorsType} actualActors
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.actualActors = 0;

        /**
         * BizIdentityInfo privacyModeTs.
         * @member {number|Long} privacyModeTs
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.privacyModeTs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizIdentityInfo featureControls.
         * @member {number|Long} featureControls
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.featureControls = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new BizIdentityInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         * @returns {proto.BizIdentityInfo} BizIdentityInfo instance
         */
        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        /**
         * Encodes the specified BizIdentityInfo message. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vlevel != null && Object.hasOwnProperty.call(message, "vlevel"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.vlevel);
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.signed != null && Object.hasOwnProperty.call(message, "signed"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.signed);
            if (message.revoked != null && Object.hasOwnProperty.call(message, "revoked"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.revoked);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.hostStorage);
            if (message.actualActors != null && Object.hasOwnProperty.call(message, "actualActors"))
                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.actualActors);
            if (message.privacyModeTs != null && Object.hasOwnProperty.call(message, "privacyModeTs"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint64(message.privacyModeTs);
            if (message.featureControls != null && Object.hasOwnProperty.call(message, "featureControls"))
                writer.uint32(/* id 8, wireType 0 =*/64).uint64(message.featureControls);
            return writer;
        };

        /**
         * Encodes the specified BizIdentityInfo message, length delimited. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizIdentityInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vlevel = reader.int32();
                    break;
                case 2:
                    message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.signed = reader.bool();
                    break;
                case 4:
                    message.revoked = reader.bool();
                    break;
                case 5:
                    message.hostStorage = reader.int32();
                    break;
                case 6:
                    message.actualActors = reader.int32();
                    break;
                case 7:
                    message.privacyModeTs = reader.uint64();
                    break;
                case 8:
                    message.featureControls = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizIdentityInfo message.
         * @function verify
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizIdentityInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vlevel != null && message.hasOwnProperty("vlevel"))
                switch (message.vlevel) {
                default:
                    return "vlevel: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                var error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                if (error)
                    return "vnameCert." + error;
            }
            if (message.signed != null && message.hasOwnProperty("signed"))
                if (typeof message.signed !== "boolean")
                    return "signed: boolean expected";
            if (message.revoked != null && message.hasOwnProperty("revoked"))
                if (typeof message.revoked !== "boolean")
                    return "revoked: boolean expected";
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.actualActors != null && message.hasOwnProperty("actualActors"))
                switch (message.actualActors) {
                default:
                    return "actualActors: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs"))
                if (!$util.isInteger(message.privacyModeTs) && !(message.privacyModeTs && $util.isInteger(message.privacyModeTs.low) && $util.isInteger(message.privacyModeTs.high)))
                    return "privacyModeTs: integer|Long expected";
            if (message.featureControls != null && message.hasOwnProperty("featureControls"))
                if (!$util.isInteger(message.featureControls) && !(message.featureControls && $util.isInteger(message.featureControls.low) && $util.isInteger(message.featureControls.high)))
                    return "featureControls: integer|Long expected";
            return null;
        };

        /**
         * Creates a BizIdentityInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         */
        BizIdentityInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizIdentityInfo)
                return object;
            var message = new $root.proto.BizIdentityInfo();
            switch (object.vlevel) {
            case "UNKNOWN":
            case 0:
                message.vlevel = 0;
                break;
            case "LOW":
            case 1:
                message.vlevel = 1;
                break;
            case "HIGH":
            case 2:
                message.vlevel = 2;
                break;
            }
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizIdentityInfo.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.signed != null)
                message.signed = Boolean(object.signed);
            if (object.revoked != null)
                message.revoked = Boolean(object.revoked);
            switch (object.hostStorage) {
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.actualActors) {
            case "SELF":
            case 0:
                message.actualActors = 0;
                break;
            case "BSP":
            case 1:
                message.actualActors = 1;
                break;
            }
            if (object.privacyModeTs != null)
                if ($util.Long)
                    (message.privacyModeTs = $util.Long.fromValue(object.privacyModeTs)).unsigned = true;
                else if (typeof object.privacyModeTs === "string")
                    message.privacyModeTs = parseInt(object.privacyModeTs, 10);
                else if (typeof object.privacyModeTs === "number")
                    message.privacyModeTs = object.privacyModeTs;
                else if (typeof object.privacyModeTs === "object")
                    message.privacyModeTs = new $util.LongBits(object.privacyModeTs.low >>> 0, object.privacyModeTs.high >>> 0).toNumber(true);
            if (object.featureControls != null)
                if ($util.Long)
                    (message.featureControls = $util.Long.fromValue(object.featureControls)).unsigned = true;
                else if (typeof object.featureControls === "string")
                    message.featureControls = parseInt(object.featureControls, 10);
                else if (typeof object.featureControls === "number")
                    message.featureControls = object.featureControls;
                else if (typeof object.featureControls === "object")
                    message.featureControls = new $util.LongBits(object.featureControls.low >>> 0, object.featureControls.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a BizIdentityInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.BizIdentityInfo} message BizIdentityInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizIdentityInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.vlevel = options.enums === String ? "UNKNOWN" : 0;
                object.vnameCert = null;
                object.signed = false;
                object.revoked = false;
                object.hostStorage = options.enums === String ? "ON_PREMISE" : 0;
                object.actualActors = options.enums === String ? "SELF" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.privacyModeTs = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.privacyModeTs = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.featureControls = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.featureControls = options.longs === String ? "0" : 0;
            }
            if (message.vlevel != null && message.hasOwnProperty("vlevel"))
                object.vlevel = options.enums === String ? $root.proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue[message.vlevel] : message.vlevel;
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert"))
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
            if (message.signed != null && message.hasOwnProperty("signed"))
                object.signed = message.signed;
            if (message.revoked != null && message.hasOwnProperty("revoked"))
                object.revoked = message.revoked;
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                object.hostStorage = options.enums === String ? $root.proto.BizIdentityInfo.BizIdentityInfoHostStorageType[message.hostStorage] : message.hostStorage;
            if (message.actualActors != null && message.hasOwnProperty("actualActors"))
                object.actualActors = options.enums === String ? $root.proto.BizIdentityInfo.BizIdentityInfoActualActorsType[message.actualActors] : message.actualActors;
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs"))
                if (typeof message.privacyModeTs === "number")
                    object.privacyModeTs = options.longs === String ? String(message.privacyModeTs) : message.privacyModeTs;
                else
                    object.privacyModeTs = options.longs === String ? $util.Long.prototype.toString.call(message.privacyModeTs) : options.longs === Number ? new $util.LongBits(message.privacyModeTs.low >>> 0, message.privacyModeTs.high >>> 0).toNumber(true) : message.privacyModeTs;
            if (message.featureControls != null && message.hasOwnProperty("featureControls"))
                if (typeof message.featureControls === "number")
                    object.featureControls = options.longs === String ? String(message.featureControls) : message.featureControls;
                else
                    object.featureControls = options.longs === String ? $util.Long.prototype.toString.call(message.featureControls) : options.longs === Number ? new $util.LongBits(message.featureControls.low >>> 0, message.featureControls.high >>> 0).toNumber(true) : message.featureControls;
            return object;
        };

        /**
         * Converts this BizIdentityInfo to JSON.
         * @function toJSON
         * @memberof proto.BizIdentityInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizIdentityInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * BizIdentityInfoVerifiedLevelValue enum.
         * @name proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} LOW=1 LOW value
         * @property {number} HIGH=2 HIGH value
         */
        BizIdentityInfo.BizIdentityInfoVerifiedLevelValue = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        /**
         * BizIdentityInfoHostStorageType enum.
         * @name proto.BizIdentityInfo.BizIdentityInfoHostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizIdentityInfo.BizIdentityInfoHostStorageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        /**
         * BizIdentityInfoActualActorsType enum.
         * @name proto.BizIdentityInfo.BizIdentityInfoActualActorsType
         * @enum {number}
         * @property {number} SELF=0 SELF value
         * @property {number} BSP=1 BSP value
         */
        BizIdentityInfo.BizIdentityInfoActualActorsType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.BizAccountLinkInfo = (function() {

        /**
         * Properties of a BizAccountLinkInfo.
         * @memberof proto
         * @interface IBizAccountLinkInfo
         * @property {number|Long|null} [whatsappBizAcctFbid] BizAccountLinkInfo whatsappBizAcctFbid
         * @property {string|null} [whatsappAcctNumber] BizAccountLinkInfo whatsappAcctNumber
         * @property {number|Long|null} [issueTime] BizAccountLinkInfo issueTime
         * @property {proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType|null} [hostStorage] BizAccountLinkInfo hostStorage
         * @property {proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType|null} [accountType] BizAccountLinkInfo accountType
         */

        /**
         * Constructs a new BizAccountLinkInfo.
         * @memberof proto
         * @classdesc Represents a BizAccountLinkInfo.
         * @implements IBizAccountLinkInfo
         * @constructor
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         */
        function BizAccountLinkInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountLinkInfo whatsappBizAcctFbid.
         * @member {number|Long} whatsappBizAcctFbid
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizAccountLinkInfo whatsappAcctNumber.
         * @member {string} whatsappAcctNumber
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappAcctNumber = "";

        /**
         * BizAccountLinkInfo issueTime.
         * @member {number|Long} issueTime
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.issueTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizAccountLinkInfo hostStorage.
         * @member {proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType} hostStorage
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.hostStorage = 0;

        /**
         * BizAccountLinkInfo accountType.
         * @member {proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType} accountType
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.accountType = 0;

        /**
         * Creates a new BizAccountLinkInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo instance
         */
        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        /**
         * Encodes the specified BizAccountLinkInfo message. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(message, "whatsappBizAcctFbid"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.whatsappBizAcctFbid);
            if (message.whatsappAcctNumber != null && Object.hasOwnProperty.call(message, "whatsappAcctNumber"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.whatsappAcctNumber);
            if (message.issueTime != null && Object.hasOwnProperty.call(message, "issueTime"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.issueTime);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.hostStorage);
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.accountType);
            return writer;
        };

        /**
         * Encodes the specified BizAccountLinkInfo message, length delimited. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountLinkInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.whatsappBizAcctFbid = reader.uint64();
                    break;
                case 2:
                    message.whatsappAcctNumber = reader.string();
                    break;
                case 3:
                    message.issueTime = reader.uint64();
                    break;
                case 4:
                    message.hostStorage = reader.int32();
                    break;
                case 5:
                    message.accountType = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountLinkInfo message.
         * @function verify
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountLinkInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid"))
                if (!$util.isInteger(message.whatsappBizAcctFbid) && !(message.whatsappBizAcctFbid && $util.isInteger(message.whatsappBizAcctFbid.low) && $util.isInteger(message.whatsappBizAcctFbid.high)))
                    return "whatsappBizAcctFbid: integer|Long expected";
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber"))
                if (!$util.isString(message.whatsappAcctNumber))
                    return "whatsappAcctNumber: string expected";
            if (message.issueTime != null && message.hasOwnProperty("issueTime"))
                if (!$util.isInteger(message.issueTime) && !(message.issueTime && $util.isInteger(message.issueTime.low) && $util.isInteger(message.issueTime.high)))
                    return "issueTime: integer|Long expected";
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.accountType != null && message.hasOwnProperty("accountType"))
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                    break;
                }
            return null;
        };

        /**
         * Creates a BizAccountLinkInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         */
        BizAccountLinkInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountLinkInfo)
                return object;
            var message = new $root.proto.BizAccountLinkInfo();
            if (object.whatsappBizAcctFbid != null)
                if ($util.Long)
                    (message.whatsappBizAcctFbid = $util.Long.fromValue(object.whatsappBizAcctFbid)).unsigned = true;
                else if (typeof object.whatsappBizAcctFbid === "string")
                    message.whatsappBizAcctFbid = parseInt(object.whatsappBizAcctFbid, 10);
                else if (typeof object.whatsappBizAcctFbid === "number")
                    message.whatsappBizAcctFbid = object.whatsappBizAcctFbid;
                else if (typeof object.whatsappBizAcctFbid === "object")
                    message.whatsappBizAcctFbid = new $util.LongBits(object.whatsappBizAcctFbid.low >>> 0, object.whatsappBizAcctFbid.high >>> 0).toNumber(true);
            if (object.whatsappAcctNumber != null)
                message.whatsappAcctNumber = String(object.whatsappAcctNumber);
            if (object.issueTime != null)
                if ($util.Long)
                    (message.issueTime = $util.Long.fromValue(object.issueTime)).unsigned = true;
                else if (typeof object.issueTime === "string")
                    message.issueTime = parseInt(object.issueTime, 10);
                else if (typeof object.issueTime === "number")
                    message.issueTime = object.issueTime;
                else if (typeof object.issueTime === "object")
                    message.issueTime = new $util.LongBits(object.issueTime.low >>> 0, object.issueTime.high >>> 0).toNumber(true);
            switch (object.hostStorage) {
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.accountType) {
            case "ENTERPRISE":
            case 0:
                message.accountType = 0;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BizAccountLinkInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.BizAccountLinkInfo} message BizAccountLinkInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountLinkInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.whatsappBizAcctFbid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.whatsappBizAcctFbid = options.longs === String ? "0" : 0;
                object.whatsappAcctNumber = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.issueTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.issueTime = options.longs === String ? "0" : 0;
                object.hostStorage = options.enums === String ? "ON_PREMISE" : 0;
                object.accountType = options.enums === String ? "ENTERPRISE" : 0;
            }
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid"))
                if (typeof message.whatsappBizAcctFbid === "number")
                    object.whatsappBizAcctFbid = options.longs === String ? String(message.whatsappBizAcctFbid) : message.whatsappBizAcctFbid;
                else
                    object.whatsappBizAcctFbid = options.longs === String ? $util.Long.prototype.toString.call(message.whatsappBizAcctFbid) : options.longs === Number ? new $util.LongBits(message.whatsappBizAcctFbid.low >>> 0, message.whatsappBizAcctFbid.high >>> 0).toNumber(true) : message.whatsappBizAcctFbid;
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber"))
                object.whatsappAcctNumber = message.whatsappAcctNumber;
            if (message.issueTime != null && message.hasOwnProperty("issueTime"))
                if (typeof message.issueTime === "number")
                    object.issueTime = options.longs === String ? String(message.issueTime) : message.issueTime;
                else
                    object.issueTime = options.longs === String ? $util.Long.prototype.toString.call(message.issueTime) : options.longs === Number ? new $util.LongBits(message.issueTime.low >>> 0, message.issueTime.high >>> 0).toNumber(true) : message.issueTime;
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                object.hostStorage = options.enums === String ? $root.proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType[message.hostStorage] : message.hostStorage;
            if (message.accountType != null && message.hasOwnProperty("accountType"))
                object.accountType = options.enums === String ? $root.proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType[message.accountType] : message.accountType;
            return object;
        };

        /**
         * Converts this BizAccountLinkInfo to JSON.
         * @function toJSON
         * @memberof proto.BizAccountLinkInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountLinkInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * BizAccountLinkInfoHostStorageType enum.
         * @name proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizAccountLinkInfo.BizAccountLinkInfoHostStorageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        /**
         * BizAccountLinkInfoAccountType enum.
         * @name proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType
         * @enum {number}
         * @property {number} ENTERPRISE=0 ENTERPRISE value
         */
        BizAccountLinkInfo.BizAccountLinkInfoAccountType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        /**
         * Properties of a BizAccountPayload.
         * @memberof proto
         * @interface IBizAccountPayload
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizAccountPayload vnameCert
         * @property {Uint8Array|null} [bizAcctLinkInfo] BizAccountPayload bizAcctLinkInfo
         */

        /**
         * Constructs a new BizAccountPayload.
         * @memberof proto
         * @classdesc Represents a BizAccountPayload.
         * @implements IBizAccountPayload
         * @constructor
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         */
        function BizAccountPayload(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountPayload vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.vnameCert = null;

        /**
         * BizAccountPayload bizAcctLinkInfo.
         * @member {Uint8Array} bizAcctLinkInfo
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.bizAcctLinkInfo = $util.newBuffer([]);

        /**
         * Creates a new BizAccountPayload instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         * @returns {proto.BizAccountPayload} BizAccountPayload instance
         */
        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        /**
         * Encodes the specified BizAccountPayload message. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.bizAcctLinkInfo != null && Object.hasOwnProperty.call(message, "bizAcctLinkInfo"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.bizAcctLinkInfo);
            return writer;
        };

        /**
         * Encodes the specified BizAccountPayload message, length delimited. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.bizAcctLinkInfo = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountPayload message.
         * @function verify
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                var error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                if (error)
                    return "vnameCert." + error;
            }
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo"))
                if (!(message.bizAcctLinkInfo && typeof message.bizAcctLinkInfo.length === "number" || $util.isString(message.bizAcctLinkInfo)))
                    return "bizAcctLinkInfo: buffer expected";
            return null;
        };

        /**
         * Creates a BizAccountPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountPayload} BizAccountPayload
         */
        BizAccountPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountPayload)
                return object;
            var message = new $root.proto.BizAccountPayload();
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizAccountPayload.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.bizAcctLinkInfo != null)
                if (typeof object.bizAcctLinkInfo === "string")
                    $util.base64.decode(object.bizAcctLinkInfo, message.bizAcctLinkInfo = $util.newBuffer($util.base64.length(object.bizAcctLinkInfo)), 0);
                else if (object.bizAcctLinkInfo.length)
                    message.bizAcctLinkInfo = object.bizAcctLinkInfo;
            return message;
        };

        /**
         * Creates a plain object from a BizAccountPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.BizAccountPayload} message BizAccountPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.vnameCert = null;
                if (options.bytes === String)
                    object.bizAcctLinkInfo = "";
                else {
                    object.bizAcctLinkInfo = [];
                    if (options.bytes !== Array)
                        object.bizAcctLinkInfo = $util.newBuffer(object.bizAcctLinkInfo);
                }
            }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert"))
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo"))
                object.bizAcctLinkInfo = options.bytes === String ? $util.base64.encode(message.bizAcctLinkInfo, 0, message.bizAcctLinkInfo.length) : options.bytes === Array ? Array.prototype.slice.call(message.bizAcctLinkInfo) : message.bizAcctLinkInfo;
            return object;
        };

        /**
         * Converts this BizAccountPayload to JSON.
         * @function toJSON
         * @memberof proto.BizAccountPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BizAccountPayload;
    })();

    proto.VerifiedNameCertificate = (function() {

        /**
         * Properties of a VerifiedNameCertificate.
         * @memberof proto
         * @interface IVerifiedNameCertificate
         * @property {Uint8Array|null} [details] VerifiedNameCertificate details
         * @property {Uint8Array|null} [signature] VerifiedNameCertificate signature
         * @property {Uint8Array|null} [serverSignature] VerifiedNameCertificate serverSignature
         */

        /**
         * Constructs a new VerifiedNameCertificate.
         * @memberof proto
         * @classdesc Represents a VerifiedNameCertificate.
         * @implements IVerifiedNameCertificate
         * @constructor
         * @param {proto.IVerifiedNameCertificate=} [properties] Properties to set
         */
        function VerifiedNameCertificate(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * VerifiedNameCertificate details.
         * @member {Uint8Array} details
         * @memberof proto.VerifiedNameCertificate
         * @instance
         */
        VerifiedNameCertificate.prototype.details = $util.newBuffer([]);

        /**
         * VerifiedNameCertificate signature.
         * @member {Uint8Array} signature
         * @memberof proto.VerifiedNameCertificate
         * @instance
         */
        VerifiedNameCertificate.prototype.signature = $util.newBuffer([]);

        /**
         * VerifiedNameCertificate serverSignature.
         * @member {Uint8Array} serverSignature
         * @memberof proto.VerifiedNameCertificate
         * @instance
         */
        VerifiedNameCertificate.prototype.serverSignature = $util.newBuffer([]);

        /**
         * Creates a new VerifiedNameCertificate instance using the specified properties.
         * @function create
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {proto.IVerifiedNameCertificate=} [properties] Properties to set
         * @returns {proto.VerifiedNameCertificate} VerifiedNameCertificate instance
         */
        VerifiedNameCertificate.create = function create(properties) {
            return new VerifiedNameCertificate(properties);
        };

        /**
         * Encodes the specified VerifiedNameCertificate message. Does not implicitly {@link proto.VerifiedNameCertificate.verify|verify} messages.
         * @function encode
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {proto.IVerifiedNameCertificate} message VerifiedNameCertificate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        VerifiedNameCertificate.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.signature != null && Object.hasOwnProperty.call(message, "signature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.signature);
            if (message.serverSignature != null && Object.hasOwnProperty.call(message, "serverSignature"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.serverSignature);
            return writer;
        };

        /**
         * Encodes the specified VerifiedNameCertificate message, length delimited. Does not implicitly {@link proto.VerifiedNameCertificate.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {proto.IVerifiedNameCertificate} message VerifiedNameCertificate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        VerifiedNameCertificate.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a VerifiedNameCertificate message from the specified reader or buffer.
         * @function decode
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.VerifiedNameCertificate} VerifiedNameCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        VerifiedNameCertificate.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.VerifiedNameCertificate();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.signature = reader.bytes();
                    break;
                case 3:
                    message.serverSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a VerifiedNameCertificate message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.VerifiedNameCertificate} VerifiedNameCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        VerifiedNameCertificate.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a VerifiedNameCertificate message.
         * @function verify
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        VerifiedNameCertificate.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.signature != null && message.hasOwnProperty("signature"))
                if (!(message.signature && typeof message.signature.length === "number" || $util.isString(message.signature)))
                    return "signature: buffer expected";
            if (message.serverSignature != null && message.hasOwnProperty("serverSignature"))
                if (!(message.serverSignature && typeof message.serverSignature.length === "number" || $util.isString(message.serverSignature)))
                    return "serverSignature: buffer expected";
            return null;
        };

        /**
         * Creates a VerifiedNameCertificate message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.VerifiedNameCertificate} VerifiedNameCertificate
         */
        VerifiedNameCertificate.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.VerifiedNameCertificate)
                return object;
            var message = new $root.proto.VerifiedNameCertificate();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.signature != null)
                if (typeof object.signature === "string")
                    $util.base64.decode(object.signature, message.signature = $util.newBuffer($util.base64.length(object.signature)), 0);
                else if (object.signature.length)
                    message.signature = object.signature;
            if (object.serverSignature != null)
                if (typeof object.serverSignature === "string")
                    $util.base64.decode(object.serverSignature, message.serverSignature = $util.newBuffer($util.base64.length(object.serverSignature)), 0);
                else if (object.serverSignature.length)
                    message.serverSignature = object.serverSignature;
            return message;
        };

        /**
         * Creates a plain object from a VerifiedNameCertificate message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.VerifiedNameCertificate
         * @static
         * @param {proto.VerifiedNameCertificate} message VerifiedNameCertificate
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        VerifiedNameCertificate.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.signature = "";
                else {
                    object.signature = [];
                    if (options.bytes !== Array)
                        object.signature = $util.newBuffer(object.signature);
                }
                if (options.bytes === String)
                    object.serverSignature = "";
                else {
                    object.serverSignature = [];
                    if (options.bytes !== Array)
                        object.serverSignature = $util.newBuffer(object.serverSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.signature != null && message.hasOwnProperty("signature"))
                object.signature = options.bytes === String ? $util.base64.encode(message.signature, 0, message.signature.length) : options.bytes === Array ? Array.prototype.slice.call(message.signature) : message.signature;
            if (message.serverSignature != null && message.hasOwnProperty("serverSignature"))
                object.serverSignature = options.bytes === String ? $util.base64.encode(message.serverSignature, 0, message.serverSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.serverSignature) : message.serverSignature;
            return object;
        };

        /**
         * Converts this VerifiedNameCertificate to JSON.
         * @function toJSON
         * @memberof proto.VerifiedNameCertificate
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        VerifiedNameCertificate.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return VerifiedNameCertificate;
    })();

    proto.LocalizedName = (function() {

        /**
         * Properties of a LocalizedName.
         * @memberof proto
         * @interface ILocalizedName
         * @property {string|null} [lg] LocalizedName lg
         * @property {string|null} [lc] LocalizedName lc
         * @property {string|null} [verifiedName] LocalizedName verifiedName
         */

        /**
         * Constructs a new LocalizedName.
         * @memberof proto
         * @classdesc Represents a LocalizedName.
         * @implements ILocalizedName
         * @constructor
         * @param {proto.ILocalizedName=} [properties] Properties to set
         */
        function LocalizedName(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LocalizedName lg.
         * @member {string} lg
         * @memberof proto.LocalizedName
         * @instance
         */
        LocalizedName.prototype.lg = "";

        /**
         * LocalizedName lc.
         * @member {string} lc
         * @memberof proto.LocalizedName
         * @instance
         */
        LocalizedName.prototype.lc = "";

        /**
         * LocalizedName verifiedName.
         * @member {string} verifiedName
         * @memberof proto.LocalizedName
         * @instance
         */
        LocalizedName.prototype.verifiedName = "";

        /**
         * Creates a new LocalizedName instance using the specified properties.
         * @function create
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.ILocalizedName=} [properties] Properties to set
         * @returns {proto.LocalizedName} LocalizedName instance
         */
        LocalizedName.create = function create(properties) {
            return new LocalizedName(properties);
        };

        /**
         * Encodes the specified LocalizedName message. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @function encode
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.ILocalizedName} message LocalizedName message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocalizedName.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lg != null && Object.hasOwnProperty.call(message, "lg"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.lg);
            if (message.lc != null && Object.hasOwnProperty.call(message, "lc"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.lc);
            if (message.verifiedName != null && Object.hasOwnProperty.call(message, "verifiedName"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.verifiedName);
            return writer;
        };

        /**
         * Encodes the specified LocalizedName message, length delimited. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.ILocalizedName} message LocalizedName message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocalizedName.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LocalizedName message from the specified reader or buffer.
         * @function decode
         * @memberof proto.LocalizedName
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.LocalizedName} LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LocalizedName.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.LocalizedName();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.lg = reader.string();
                    break;
                case 2:
                    message.lc = reader.string();
                    break;
                case 3:
                    message.verifiedName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LocalizedName message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.LocalizedName
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.LocalizedName} LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LocalizedName.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LocalizedName message.
         * @function verify
         * @memberof proto.LocalizedName
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LocalizedName.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.lg != null && message.hasOwnProperty("lg"))
                if (!$util.isString(message.lg))
                    return "lg: string expected";
            if (message.lc != null && message.hasOwnProperty("lc"))
                if (!$util.isString(message.lc))
                    return "lc: string expected";
            if (message.verifiedName != null && message.hasOwnProperty("verifiedName"))
                if (!$util.isString(message.verifiedName))
                    return "verifiedName: string expected";
            return null;
        };

        /**
         * Creates a LocalizedName message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.LocalizedName
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.LocalizedName} LocalizedName
         */
        LocalizedName.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.LocalizedName)
                return object;
            var message = new $root.proto.LocalizedName();
            if (object.lg != null)
                message.lg = String(object.lg);
            if (object.lc != null)
                message.lc = String(object.lc);
            if (object.verifiedName != null)
                message.verifiedName = String(object.verifiedName);
            return message;
        };

        /**
         * Creates a plain object from a LocalizedName message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.LocalizedName} message LocalizedName
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LocalizedName.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.lg = "";
                object.lc = "";
                object.verifiedName = "";
            }
            if (message.lg != null && message.hasOwnProperty("lg"))
                object.lg = message.lg;
            if (message.lc != null && message.hasOwnProperty("lc"))
                object.lc = message.lc;
            if (message.verifiedName != null && message.hasOwnProperty("verifiedName"))
                object.verifiedName = message.verifiedName;
            return object;
        };

        /**
         * Converts this LocalizedName to JSON.
         * @function toJSON
         * @memberof proto.LocalizedName
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LocalizedName.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LocalizedName;
    })();

    proto.SyncActionData = (function() {

        /**
         * Properties of a SyncActionData.
         * @memberof proto
         * @interface ISyncActionData
         * @property {Uint8Array|null} [index] SyncActionData index
         * @property {proto.ISyncActionValue|null} [value] SyncActionData value
         * @property {Uint8Array|null} [padding] SyncActionData padding
         * @property {number|null} [version] SyncActionData version
         */

        /**
         * Constructs a new SyncActionData.
         * @memberof proto
         * @classdesc Represents a SyncActionData.
         * @implements ISyncActionData
         * @constructor
         * @param {proto.ISyncActionData=} [properties] Properties to set
         */
        function SyncActionData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncActionData index.
         * @member {Uint8Array} index
         * @memberof proto.SyncActionData
         * @instance
         */
        SyncActionData.prototype.index = $util.newBuffer([]);

        /**
         * SyncActionData value.
         * @member {proto.ISyncActionValue|null|undefined} value
         * @memberof proto.SyncActionData
         * @instance
         */
        SyncActionData.prototype.value = null;

        /**
         * SyncActionData padding.
         * @member {Uint8Array} padding
         * @memberof proto.SyncActionData
         * @instance
         */
        SyncActionData.prototype.padding = $util.newBuffer([]);

        /**
         * SyncActionData version.
         * @member {number} version
         * @memberof proto.SyncActionData
         * @instance
         */
        SyncActionData.prototype.version = 0;

        /**
         * Creates a new SyncActionData instance using the specified properties.
         * @function create
         * @memberof proto.SyncActionData
         * @static
         * @param {proto.ISyncActionData=} [properties] Properties to set
         * @returns {proto.SyncActionData} SyncActionData instance
         */
        SyncActionData.create = function create(properties) {
            return new SyncActionData(properties);
        };

        /**
         * Encodes the specified SyncActionData message. Does not implicitly {@link proto.SyncActionData.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncActionData
         * @static
         * @param {proto.ISyncActionData} message SyncActionData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.index);
            if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                $root.proto.SyncActionValue.encode(message.value, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.padding != null && Object.hasOwnProperty.call(message, "padding"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.padding);
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.version);
            return writer;
        };

        /**
         * Encodes the specified SyncActionData message, length delimited. Does not implicitly {@link proto.SyncActionData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncActionData
         * @static
         * @param {proto.ISyncActionData} message SyncActionData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncActionData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncActionData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncActionData} SyncActionData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncActionData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.bytes();
                    break;
                case 2:
                    message.value = $root.proto.SyncActionValue.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.padding = reader.bytes();
                    break;
                case 4:
                    message.version = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncActionData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncActionData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncActionData} SyncActionData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncActionData message.
         * @function verify
         * @memberof proto.SyncActionData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncActionData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!(message.index && typeof message.index.length === "number" || $util.isString(message.index)))
                    return "index: buffer expected";
            if (message.value != null && message.hasOwnProperty("value")) {
                var error = $root.proto.SyncActionValue.verify(message.value);
                if (error)
                    return "value." + error;
            }
            if (message.padding != null && message.hasOwnProperty("padding"))
                if (!(message.padding && typeof message.padding.length === "number" || $util.isString(message.padding)))
                    return "padding: buffer expected";
            if (message.version != null && message.hasOwnProperty("version"))
                if (!$util.isInteger(message.version))
                    return "version: integer expected";
            return null;
        };

        /**
         * Creates a SyncActionData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncActionData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncActionData} SyncActionData
         */
        SyncActionData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncActionData)
                return object;
            var message = new $root.proto.SyncActionData();
            if (object.index != null)
                if (typeof object.index === "string")
                    $util.base64.decode(object.index, message.index = $util.newBuffer($util.base64.length(object.index)), 0);
                else if (object.index.length)
                    message.index = object.index;
            if (object.value != null) {
                if (typeof object.value !== "object")
                    throw TypeError(".proto.SyncActionData.value: object expected");
                message.value = $root.proto.SyncActionValue.fromObject(object.value);
            }
            if (object.padding != null)
                if (typeof object.padding === "string")
                    $util.base64.decode(object.padding, message.padding = $util.newBuffer($util.base64.length(object.padding)), 0);
                else if (object.padding.length)
                    message.padding = object.padding;
            if (object.version != null)
                message.version = object.version | 0;
            return message;
        };

        /**
         * Creates a plain object from a SyncActionData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncActionData
         * @static
         * @param {proto.SyncActionData} message SyncActionData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncActionData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.index = "";
                else {
                    object.index = [];
                    if (options.bytes !== Array)
                        object.index = $util.newBuffer(object.index);
                }
                object.value = null;
                if (options.bytes === String)
                    object.padding = "";
                else {
                    object.padding = [];
                    if (options.bytes !== Array)
                        object.padding = $util.newBuffer(object.padding);
                }
                object.version = 0;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = options.bytes === String ? $util.base64.encode(message.index, 0, message.index.length) : options.bytes === Array ? Array.prototype.slice.call(message.index) : message.index;
            if (message.value != null && message.hasOwnProperty("value"))
                object.value = $root.proto.SyncActionValue.toObject(message.value, options);
            if (message.padding != null && message.hasOwnProperty("padding"))
                object.padding = options.bytes === String ? $util.base64.encode(message.padding, 0, message.padding.length) : options.bytes === Array ? Array.prototype.slice.call(message.padding) : message.padding;
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = message.version;
            return object;
        };

        /**
         * Converts this SyncActionData to JSON.
         * @function toJSON
         * @memberof proto.SyncActionData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncActionData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncActionData;
    })();

    proto.StarAction = (function() {

        /**
         * Properties of a StarAction.
         * @memberof proto
         * @interface IStarAction
         * @property {boolean|null} [starred] StarAction starred
         */

        /**
         * Constructs a new StarAction.
         * @memberof proto
         * @classdesc Represents a StarAction.
         * @implements IStarAction
         * @constructor
         * @param {proto.IStarAction=} [properties] Properties to set
         */
        function StarAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * StarAction starred.
         * @member {boolean} starred
         * @memberof proto.StarAction
         * @instance
         */
        StarAction.prototype.starred = false;

        /**
         * Creates a new StarAction instance using the specified properties.
         * @function create
         * @memberof proto.StarAction
         * @static
         * @param {proto.IStarAction=} [properties] Properties to set
         * @returns {proto.StarAction} StarAction instance
         */
        StarAction.create = function create(properties) {
            return new StarAction(properties);
        };

        /**
         * Encodes the specified StarAction message. Does not implicitly {@link proto.StarAction.verify|verify} messages.
         * @function encode
         * @memberof proto.StarAction
         * @static
         * @param {proto.IStarAction} message StarAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        StarAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.starred != null && Object.hasOwnProperty.call(message, "starred"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.starred);
            return writer;
        };

        /**
         * Encodes the specified StarAction message, length delimited. Does not implicitly {@link proto.StarAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.StarAction
         * @static
         * @param {proto.IStarAction} message StarAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        StarAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a StarAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.StarAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.StarAction} StarAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        StarAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.StarAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.starred = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a StarAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.StarAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.StarAction} StarAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        StarAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a StarAction message.
         * @function verify
         * @memberof proto.StarAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        StarAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.starred != null && message.hasOwnProperty("starred"))
                if (typeof message.starred !== "boolean")
                    return "starred: boolean expected";
            return null;
        };

        /**
         * Creates a StarAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.StarAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.StarAction} StarAction
         */
        StarAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.StarAction)
                return object;
            var message = new $root.proto.StarAction();
            if (object.starred != null)
                message.starred = Boolean(object.starred);
            return message;
        };

        /**
         * Creates a plain object from a StarAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.StarAction
         * @static
         * @param {proto.StarAction} message StarAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        StarAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.starred = false;
            if (message.starred != null && message.hasOwnProperty("starred"))
                object.starred = message.starred;
            return object;
        };

        /**
         * Converts this StarAction to JSON.
         * @function toJSON
         * @memberof proto.StarAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        StarAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return StarAction;
    })();

    proto.ContactAction = (function() {

        /**
         * Properties of a ContactAction.
         * @memberof proto
         * @interface IContactAction
         * @property {string|null} [fullName] ContactAction fullName
         * @property {string|null} [firstName] ContactAction firstName
         */

        /**
         * Constructs a new ContactAction.
         * @memberof proto
         * @classdesc Represents a ContactAction.
         * @implements IContactAction
         * @constructor
         * @param {proto.IContactAction=} [properties] Properties to set
         */
        function ContactAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContactAction fullName.
         * @member {string} fullName
         * @memberof proto.ContactAction
         * @instance
         */
        ContactAction.prototype.fullName = "";

        /**
         * ContactAction firstName.
         * @member {string} firstName
         * @memberof proto.ContactAction
         * @instance
         */
        ContactAction.prototype.firstName = "";

        /**
         * Creates a new ContactAction instance using the specified properties.
         * @function create
         * @memberof proto.ContactAction
         * @static
         * @param {proto.IContactAction=} [properties] Properties to set
         * @returns {proto.ContactAction} ContactAction instance
         */
        ContactAction.create = function create(properties) {
            return new ContactAction(properties);
        };

        /**
         * Encodes the specified ContactAction message. Does not implicitly {@link proto.ContactAction.verify|verify} messages.
         * @function encode
         * @memberof proto.ContactAction
         * @static
         * @param {proto.IContactAction} message ContactAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fullName != null && Object.hasOwnProperty.call(message, "fullName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.fullName);
            if (message.firstName != null && Object.hasOwnProperty.call(message, "firstName"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.firstName);
            return writer;
        };

        /**
         * Encodes the specified ContactAction message, length delimited. Does not implicitly {@link proto.ContactAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContactAction
         * @static
         * @param {proto.IContactAction} message ContactAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContactAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContactAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContactAction} ContactAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContactAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.fullName = reader.string();
                    break;
                case 2:
                    message.firstName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContactAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContactAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContactAction} ContactAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContactAction message.
         * @function verify
         * @memberof proto.ContactAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContactAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.fullName != null && message.hasOwnProperty("fullName"))
                if (!$util.isString(message.fullName))
                    return "fullName: string expected";
            if (message.firstName != null && message.hasOwnProperty("firstName"))
                if (!$util.isString(message.firstName))
                    return "firstName: string expected";
            return null;
        };

        /**
         * Creates a ContactAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContactAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContactAction} ContactAction
         */
        ContactAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContactAction)
                return object;
            var message = new $root.proto.ContactAction();
            if (object.fullName != null)
                message.fullName = String(object.fullName);
            if (object.firstName != null)
                message.firstName = String(object.firstName);
            return message;
        };

        /**
         * Creates a plain object from a ContactAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContactAction
         * @static
         * @param {proto.ContactAction} message ContactAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContactAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.fullName = "";
                object.firstName = "";
            }
            if (message.fullName != null && message.hasOwnProperty("fullName"))
                object.fullName = message.fullName;
            if (message.firstName != null && message.hasOwnProperty("firstName"))
                object.firstName = message.firstName;
            return object;
        };

        /**
         * Converts this ContactAction to JSON.
         * @function toJSON
         * @memberof proto.ContactAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContactAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContactAction;
    })();

    proto.MuteAction = (function() {

        /**
         * Properties of a MuteAction.
         * @memberof proto
         * @interface IMuteAction
         * @property {boolean|null} [muted] MuteAction muted
         * @property {number|Long|null} [muteEndTimestamp] MuteAction muteEndTimestamp
         */

        /**
         * Constructs a new MuteAction.
         * @memberof proto
         * @classdesc Represents a MuteAction.
         * @implements IMuteAction
         * @constructor
         * @param {proto.IMuteAction=} [properties] Properties to set
         */
        function MuteAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MuteAction muted.
         * @member {boolean} muted
         * @memberof proto.MuteAction
         * @instance
         */
        MuteAction.prototype.muted = false;

        /**
         * MuteAction muteEndTimestamp.
         * @member {number|Long} muteEndTimestamp
         * @memberof proto.MuteAction
         * @instance
         */
        MuteAction.prototype.muteEndTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new MuteAction instance using the specified properties.
         * @function create
         * @memberof proto.MuteAction
         * @static
         * @param {proto.IMuteAction=} [properties] Properties to set
         * @returns {proto.MuteAction} MuteAction instance
         */
        MuteAction.create = function create(properties) {
            return new MuteAction(properties);
        };

        /**
         * Encodes the specified MuteAction message. Does not implicitly {@link proto.MuteAction.verify|verify} messages.
         * @function encode
         * @memberof proto.MuteAction
         * @static
         * @param {proto.IMuteAction} message MuteAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MuteAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.muted != null && Object.hasOwnProperty.call(message, "muted"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.muted);
            if (message.muteEndTimestamp != null && Object.hasOwnProperty.call(message, "muteEndTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.muteEndTimestamp);
            return writer;
        };

        /**
         * Encodes the specified MuteAction message, length delimited. Does not implicitly {@link proto.MuteAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MuteAction
         * @static
         * @param {proto.IMuteAction} message MuteAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MuteAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MuteAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MuteAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MuteAction} MuteAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MuteAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MuteAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.muted = reader.bool();
                    break;
                case 2:
                    message.muteEndTimestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MuteAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MuteAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MuteAction} MuteAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MuteAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MuteAction message.
         * @function verify
         * @memberof proto.MuteAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MuteAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.muted != null && message.hasOwnProperty("muted"))
                if (typeof message.muted !== "boolean")
                    return "muted: boolean expected";
            if (message.muteEndTimestamp != null && message.hasOwnProperty("muteEndTimestamp"))
                if (!$util.isInteger(message.muteEndTimestamp) && !(message.muteEndTimestamp && $util.isInteger(message.muteEndTimestamp.low) && $util.isInteger(message.muteEndTimestamp.high)))
                    return "muteEndTimestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates a MuteAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MuteAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MuteAction} MuteAction
         */
        MuteAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MuteAction)
                return object;
            var message = new $root.proto.MuteAction();
            if (object.muted != null)
                message.muted = Boolean(object.muted);
            if (object.muteEndTimestamp != null)
                if ($util.Long)
                    (message.muteEndTimestamp = $util.Long.fromValue(object.muteEndTimestamp)).unsigned = false;
                else if (typeof object.muteEndTimestamp === "string")
                    message.muteEndTimestamp = parseInt(object.muteEndTimestamp, 10);
                else if (typeof object.muteEndTimestamp === "number")
                    message.muteEndTimestamp = object.muteEndTimestamp;
                else if (typeof object.muteEndTimestamp === "object")
                    message.muteEndTimestamp = new $util.LongBits(object.muteEndTimestamp.low >>> 0, object.muteEndTimestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a MuteAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MuteAction
         * @static
         * @param {proto.MuteAction} message MuteAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MuteAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.muted = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.muteEndTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.muteEndTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.muted != null && message.hasOwnProperty("muted"))
                object.muted = message.muted;
            if (message.muteEndTimestamp != null && message.hasOwnProperty("muteEndTimestamp"))
                if (typeof message.muteEndTimestamp === "number")
                    object.muteEndTimestamp = options.longs === String ? String(message.muteEndTimestamp) : message.muteEndTimestamp;
                else
                    object.muteEndTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.muteEndTimestamp) : options.longs === Number ? new $util.LongBits(message.muteEndTimestamp.low >>> 0, message.muteEndTimestamp.high >>> 0).toNumber() : message.muteEndTimestamp;
            return object;
        };

        /**
         * Converts this MuteAction to JSON.
         * @function toJSON
         * @memberof proto.MuteAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MuteAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MuteAction;
    })();

    proto.PinAction = (function() {

        /**
         * Properties of a PinAction.
         * @memberof proto
         * @interface IPinAction
         * @property {boolean|null} [pinned] PinAction pinned
         */

        /**
         * Constructs a new PinAction.
         * @memberof proto
         * @classdesc Represents a PinAction.
         * @implements IPinAction
         * @constructor
         * @param {proto.IPinAction=} [properties] Properties to set
         */
        function PinAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PinAction pinned.
         * @member {boolean} pinned
         * @memberof proto.PinAction
         * @instance
         */
        PinAction.prototype.pinned = false;

        /**
         * Creates a new PinAction instance using the specified properties.
         * @function create
         * @memberof proto.PinAction
         * @static
         * @param {proto.IPinAction=} [properties] Properties to set
         * @returns {proto.PinAction} PinAction instance
         */
        PinAction.create = function create(properties) {
            return new PinAction(properties);
        };

        /**
         * Encodes the specified PinAction message. Does not implicitly {@link proto.PinAction.verify|verify} messages.
         * @function encode
         * @memberof proto.PinAction
         * @static
         * @param {proto.IPinAction} message PinAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PinAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pinned != null && Object.hasOwnProperty.call(message, "pinned"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.pinned);
            return writer;
        };

        /**
         * Encodes the specified PinAction message, length delimited. Does not implicitly {@link proto.PinAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.PinAction
         * @static
         * @param {proto.IPinAction} message PinAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PinAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PinAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.PinAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.PinAction} PinAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PinAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.PinAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pinned = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PinAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.PinAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.PinAction} PinAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PinAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PinAction message.
         * @function verify
         * @memberof proto.PinAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PinAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                if (typeof message.pinned !== "boolean")
                    return "pinned: boolean expected";
            return null;
        };

        /**
         * Creates a PinAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.PinAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.PinAction} PinAction
         */
        PinAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.PinAction)
                return object;
            var message = new $root.proto.PinAction();
            if (object.pinned != null)
                message.pinned = Boolean(object.pinned);
            return message;
        };

        /**
         * Creates a plain object from a PinAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.PinAction
         * @static
         * @param {proto.PinAction} message PinAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PinAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.pinned = false;
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                object.pinned = message.pinned;
            return object;
        };

        /**
         * Converts this PinAction to JSON.
         * @function toJSON
         * @memberof proto.PinAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PinAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PinAction;
    })();

    proto.SecurityNotificationSetting = (function() {

        /**
         * Properties of a SecurityNotificationSetting.
         * @memberof proto
         * @interface ISecurityNotificationSetting
         * @property {boolean|null} [showNotification] SecurityNotificationSetting showNotification
         */

        /**
         * Constructs a new SecurityNotificationSetting.
         * @memberof proto
         * @classdesc Represents a SecurityNotificationSetting.
         * @implements ISecurityNotificationSetting
         * @constructor
         * @param {proto.ISecurityNotificationSetting=} [properties] Properties to set
         */
        function SecurityNotificationSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SecurityNotificationSetting showNotification.
         * @member {boolean} showNotification
         * @memberof proto.SecurityNotificationSetting
         * @instance
         */
        SecurityNotificationSetting.prototype.showNotification = false;

        /**
         * Creates a new SecurityNotificationSetting instance using the specified properties.
         * @function create
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {proto.ISecurityNotificationSetting=} [properties] Properties to set
         * @returns {proto.SecurityNotificationSetting} SecurityNotificationSetting instance
         */
        SecurityNotificationSetting.create = function create(properties) {
            return new SecurityNotificationSetting(properties);
        };

        /**
         * Encodes the specified SecurityNotificationSetting message. Does not implicitly {@link proto.SecurityNotificationSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {proto.ISecurityNotificationSetting} message SecurityNotificationSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SecurityNotificationSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.showNotification != null && Object.hasOwnProperty.call(message, "showNotification"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.showNotification);
            return writer;
        };

        /**
         * Encodes the specified SecurityNotificationSetting message, length delimited. Does not implicitly {@link proto.SecurityNotificationSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {proto.ISecurityNotificationSetting} message SecurityNotificationSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SecurityNotificationSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SecurityNotificationSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SecurityNotificationSetting} SecurityNotificationSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SecurityNotificationSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SecurityNotificationSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.showNotification = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SecurityNotificationSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SecurityNotificationSetting} SecurityNotificationSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SecurityNotificationSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SecurityNotificationSetting message.
         * @function verify
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SecurityNotificationSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.showNotification != null && message.hasOwnProperty("showNotification"))
                if (typeof message.showNotification !== "boolean")
                    return "showNotification: boolean expected";
            return null;
        };

        /**
         * Creates a SecurityNotificationSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SecurityNotificationSetting} SecurityNotificationSetting
         */
        SecurityNotificationSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SecurityNotificationSetting)
                return object;
            var message = new $root.proto.SecurityNotificationSetting();
            if (object.showNotification != null)
                message.showNotification = Boolean(object.showNotification);
            return message;
        };

        /**
         * Creates a plain object from a SecurityNotificationSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SecurityNotificationSetting
         * @static
         * @param {proto.SecurityNotificationSetting} message SecurityNotificationSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SecurityNotificationSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.showNotification = false;
            if (message.showNotification != null && message.hasOwnProperty("showNotification"))
                object.showNotification = message.showNotification;
            return object;
        };

        /**
         * Converts this SecurityNotificationSetting to JSON.
         * @function toJSON
         * @memberof proto.SecurityNotificationSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SecurityNotificationSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SecurityNotificationSetting;
    })();

    proto.PushNameSetting = (function() {

        /**
         * Properties of a PushNameSetting.
         * @memberof proto
         * @interface IPushNameSetting
         * @property {string|null} [name] PushNameSetting name
         */

        /**
         * Constructs a new PushNameSetting.
         * @memberof proto
         * @classdesc Represents a PushNameSetting.
         * @implements IPushNameSetting
         * @constructor
         * @param {proto.IPushNameSetting=} [properties] Properties to set
         */
        function PushNameSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PushNameSetting name.
         * @member {string} name
         * @memberof proto.PushNameSetting
         * @instance
         */
        PushNameSetting.prototype.name = "";

        /**
         * Creates a new PushNameSetting instance using the specified properties.
         * @function create
         * @memberof proto.PushNameSetting
         * @static
         * @param {proto.IPushNameSetting=} [properties] Properties to set
         * @returns {proto.PushNameSetting} PushNameSetting instance
         */
        PushNameSetting.create = function create(properties) {
            return new PushNameSetting(properties);
        };

        /**
         * Encodes the specified PushNameSetting message. Does not implicitly {@link proto.PushNameSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.PushNameSetting
         * @static
         * @param {proto.IPushNameSetting} message PushNameSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PushNameSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
            return writer;
        };

        /**
         * Encodes the specified PushNameSetting message, length delimited. Does not implicitly {@link proto.PushNameSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.PushNameSetting
         * @static
         * @param {proto.IPushNameSetting} message PushNameSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PushNameSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PushNameSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.PushNameSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.PushNameSetting} PushNameSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PushNameSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.PushNameSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PushNameSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.PushNameSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.PushNameSetting} PushNameSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PushNameSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PushNameSetting message.
         * @function verify
         * @memberof proto.PushNameSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PushNameSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            return null;
        };

        /**
         * Creates a PushNameSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.PushNameSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.PushNameSetting} PushNameSetting
         */
        PushNameSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.PushNameSetting)
                return object;
            var message = new $root.proto.PushNameSetting();
            if (object.name != null)
                message.name = String(object.name);
            return message;
        };

        /**
         * Creates a plain object from a PushNameSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.PushNameSetting
         * @static
         * @param {proto.PushNameSetting} message PushNameSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PushNameSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.name = "";
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            return object;
        };

        /**
         * Converts this PushNameSetting to JSON.
         * @function toJSON
         * @memberof proto.PushNameSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PushNameSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PushNameSetting;
    })();

    proto.LocaleSetting = (function() {

        /**
         * Properties of a LocaleSetting.
         * @memberof proto
         * @interface ILocaleSetting
         * @property {string|null} [locale] LocaleSetting locale
         */

        /**
         * Constructs a new LocaleSetting.
         * @memberof proto
         * @classdesc Represents a LocaleSetting.
         * @implements ILocaleSetting
         * @constructor
         * @param {proto.ILocaleSetting=} [properties] Properties to set
         */
        function LocaleSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LocaleSetting locale.
         * @member {string} locale
         * @memberof proto.LocaleSetting
         * @instance
         */
        LocaleSetting.prototype.locale = "";

        /**
         * Creates a new LocaleSetting instance using the specified properties.
         * @function create
         * @memberof proto.LocaleSetting
         * @static
         * @param {proto.ILocaleSetting=} [properties] Properties to set
         * @returns {proto.LocaleSetting} LocaleSetting instance
         */
        LocaleSetting.create = function create(properties) {
            return new LocaleSetting(properties);
        };

        /**
         * Encodes the specified LocaleSetting message. Does not implicitly {@link proto.LocaleSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.LocaleSetting
         * @static
         * @param {proto.ILocaleSetting} message LocaleSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocaleSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.locale != null && Object.hasOwnProperty.call(message, "locale"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.locale);
            return writer;
        };

        /**
         * Encodes the specified LocaleSetting message, length delimited. Does not implicitly {@link proto.LocaleSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LocaleSetting
         * @static
         * @param {proto.ILocaleSetting} message LocaleSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocaleSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LocaleSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.LocaleSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.LocaleSetting} LocaleSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LocaleSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.LocaleSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.locale = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LocaleSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.LocaleSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.LocaleSetting} LocaleSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LocaleSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LocaleSetting message.
         * @function verify
         * @memberof proto.LocaleSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LocaleSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.locale != null && message.hasOwnProperty("locale"))
                if (!$util.isString(message.locale))
                    return "locale: string expected";
            return null;
        };

        /**
         * Creates a LocaleSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.LocaleSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.LocaleSetting} LocaleSetting
         */
        LocaleSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.LocaleSetting)
                return object;
            var message = new $root.proto.LocaleSetting();
            if (object.locale != null)
                message.locale = String(object.locale);
            return message;
        };

        /**
         * Creates a plain object from a LocaleSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.LocaleSetting
         * @static
         * @param {proto.LocaleSetting} message LocaleSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LocaleSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.locale = "";
            if (message.locale != null && message.hasOwnProperty("locale"))
                object.locale = message.locale;
            return object;
        };

        /**
         * Converts this LocaleSetting to JSON.
         * @function toJSON
         * @memberof proto.LocaleSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LocaleSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LocaleSetting;
    })();

    proto.QuickReplyAction = (function() {

        /**
         * Properties of a QuickReplyAction.
         * @memberof proto
         * @interface IQuickReplyAction
         * @property {string|null} [shortcut] QuickReplyAction shortcut
         * @property {string|null} [message] QuickReplyAction message
         * @property {Array.<string>|null} [keywords] QuickReplyAction keywords
         * @property {number|null} [count] QuickReplyAction count
         * @property {boolean|null} [deleted] QuickReplyAction deleted
         */

        /**
         * Constructs a new QuickReplyAction.
         * @memberof proto
         * @classdesc Represents a QuickReplyAction.
         * @implements IQuickReplyAction
         * @constructor
         * @param {proto.IQuickReplyAction=} [properties] Properties to set
         */
        function QuickReplyAction(properties) {
            this.keywords = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QuickReplyAction shortcut.
         * @member {string} shortcut
         * @memberof proto.QuickReplyAction
         * @instance
         */
        QuickReplyAction.prototype.shortcut = "";

        /**
         * QuickReplyAction message.
         * @member {string} message
         * @memberof proto.QuickReplyAction
         * @instance
         */
        QuickReplyAction.prototype.message = "";

        /**
         * QuickReplyAction keywords.
         * @member {Array.<string>} keywords
         * @memberof proto.QuickReplyAction
         * @instance
         */
        QuickReplyAction.prototype.keywords = $util.emptyArray;

        /**
         * QuickReplyAction count.
         * @member {number} count
         * @memberof proto.QuickReplyAction
         * @instance
         */
        QuickReplyAction.prototype.count = 0;

        /**
         * QuickReplyAction deleted.
         * @member {boolean} deleted
         * @memberof proto.QuickReplyAction
         * @instance
         */
        QuickReplyAction.prototype.deleted = false;

        /**
         * Creates a new QuickReplyAction instance using the specified properties.
         * @function create
         * @memberof proto.QuickReplyAction
         * @static
         * @param {proto.IQuickReplyAction=} [properties] Properties to set
         * @returns {proto.QuickReplyAction} QuickReplyAction instance
         */
        QuickReplyAction.create = function create(properties) {
            return new QuickReplyAction(properties);
        };

        /**
         * Encodes the specified QuickReplyAction message. Does not implicitly {@link proto.QuickReplyAction.verify|verify} messages.
         * @function encode
         * @memberof proto.QuickReplyAction
         * @static
         * @param {proto.IQuickReplyAction} message QuickReplyAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QuickReplyAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.shortcut != null && Object.hasOwnProperty.call(message, "shortcut"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.shortcut);
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.message);
            if (message.keywords != null && message.keywords.length)
                for (var i = 0; i < message.keywords.length; ++i)
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.keywords[i]);
            if (message.count != null && Object.hasOwnProperty.call(message, "count"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.count);
            if (message.deleted != null && Object.hasOwnProperty.call(message, "deleted"))
                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.deleted);
            return writer;
        };

        /**
         * Encodes the specified QuickReplyAction message, length delimited. Does not implicitly {@link proto.QuickReplyAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.QuickReplyAction
         * @static
         * @param {proto.IQuickReplyAction} message QuickReplyAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QuickReplyAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QuickReplyAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.QuickReplyAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.QuickReplyAction} QuickReplyAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QuickReplyAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.QuickReplyAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.shortcut = reader.string();
                    break;
                case 2:
                    message.message = reader.string();
                    break;
                case 3:
                    if (!(message.keywords && message.keywords.length))
                        message.keywords = [];
                    message.keywords.push(reader.string());
                    break;
                case 4:
                    message.count = reader.int32();
                    break;
                case 5:
                    message.deleted = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QuickReplyAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.QuickReplyAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.QuickReplyAction} QuickReplyAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QuickReplyAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QuickReplyAction message.
         * @function verify
         * @memberof proto.QuickReplyAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QuickReplyAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.shortcut != null && message.hasOwnProperty("shortcut"))
                if (!$util.isString(message.shortcut))
                    return "shortcut: string expected";
            if (message.message != null && message.hasOwnProperty("message"))
                if (!$util.isString(message.message))
                    return "message: string expected";
            if (message.keywords != null && message.hasOwnProperty("keywords")) {
                if (!Array.isArray(message.keywords))
                    return "keywords: array expected";
                for (var i = 0; i < message.keywords.length; ++i)
                    if (!$util.isString(message.keywords[i]))
                        return "keywords: string[] expected";
            }
            if (message.count != null && message.hasOwnProperty("count"))
                if (!$util.isInteger(message.count))
                    return "count: integer expected";
            if (message.deleted != null && message.hasOwnProperty("deleted"))
                if (typeof message.deleted !== "boolean")
                    return "deleted: boolean expected";
            return null;
        };

        /**
         * Creates a QuickReplyAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.QuickReplyAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.QuickReplyAction} QuickReplyAction
         */
        QuickReplyAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.QuickReplyAction)
                return object;
            var message = new $root.proto.QuickReplyAction();
            if (object.shortcut != null)
                message.shortcut = String(object.shortcut);
            if (object.message != null)
                message.message = String(object.message);
            if (object.keywords) {
                if (!Array.isArray(object.keywords))
                    throw TypeError(".proto.QuickReplyAction.keywords: array expected");
                message.keywords = [];
                for (var i = 0; i < object.keywords.length; ++i)
                    message.keywords[i] = String(object.keywords[i]);
            }
            if (object.count != null)
                message.count = object.count | 0;
            if (object.deleted != null)
                message.deleted = Boolean(object.deleted);
            return message;
        };

        /**
         * Creates a plain object from a QuickReplyAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.QuickReplyAction
         * @static
         * @param {proto.QuickReplyAction} message QuickReplyAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QuickReplyAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.keywords = [];
            if (options.defaults) {
                object.shortcut = "";
                object.message = "";
                object.count = 0;
                object.deleted = false;
            }
            if (message.shortcut != null && message.hasOwnProperty("shortcut"))
                object.shortcut = message.shortcut;
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = message.message;
            if (message.keywords && message.keywords.length) {
                object.keywords = [];
                for (var j = 0; j < message.keywords.length; ++j)
                    object.keywords[j] = message.keywords[j];
            }
            if (message.count != null && message.hasOwnProperty("count"))
                object.count = message.count;
            if (message.deleted != null && message.hasOwnProperty("deleted"))
                object.deleted = message.deleted;
            return object;
        };

        /**
         * Converts this QuickReplyAction to JSON.
         * @function toJSON
         * @memberof proto.QuickReplyAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QuickReplyAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QuickReplyAction;
    })();

    proto.LabelAssociationAction = (function() {

        /**
         * Properties of a LabelAssociationAction.
         * @memberof proto
         * @interface ILabelAssociationAction
         * @property {boolean|null} [labeled] LabelAssociationAction labeled
         */

        /**
         * Constructs a new LabelAssociationAction.
         * @memberof proto
         * @classdesc Represents a LabelAssociationAction.
         * @implements ILabelAssociationAction
         * @constructor
         * @param {proto.ILabelAssociationAction=} [properties] Properties to set
         */
        function LabelAssociationAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LabelAssociationAction labeled.
         * @member {boolean} labeled
         * @memberof proto.LabelAssociationAction
         * @instance
         */
        LabelAssociationAction.prototype.labeled = false;

        /**
         * Creates a new LabelAssociationAction instance using the specified properties.
         * @function create
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {proto.ILabelAssociationAction=} [properties] Properties to set
         * @returns {proto.LabelAssociationAction} LabelAssociationAction instance
         */
        LabelAssociationAction.create = function create(properties) {
            return new LabelAssociationAction(properties);
        };

        /**
         * Encodes the specified LabelAssociationAction message. Does not implicitly {@link proto.LabelAssociationAction.verify|verify} messages.
         * @function encode
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {proto.ILabelAssociationAction} message LabelAssociationAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LabelAssociationAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.labeled != null && Object.hasOwnProperty.call(message, "labeled"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.labeled);
            return writer;
        };

        /**
         * Encodes the specified LabelAssociationAction message, length delimited. Does not implicitly {@link proto.LabelAssociationAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {proto.ILabelAssociationAction} message LabelAssociationAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LabelAssociationAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LabelAssociationAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.LabelAssociationAction} LabelAssociationAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LabelAssociationAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.LabelAssociationAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.labeled = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LabelAssociationAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.LabelAssociationAction} LabelAssociationAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LabelAssociationAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LabelAssociationAction message.
         * @function verify
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LabelAssociationAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.labeled != null && message.hasOwnProperty("labeled"))
                if (typeof message.labeled !== "boolean")
                    return "labeled: boolean expected";
            return null;
        };

        /**
         * Creates a LabelAssociationAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.LabelAssociationAction} LabelAssociationAction
         */
        LabelAssociationAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.LabelAssociationAction)
                return object;
            var message = new $root.proto.LabelAssociationAction();
            if (object.labeled != null)
                message.labeled = Boolean(object.labeled);
            return message;
        };

        /**
         * Creates a plain object from a LabelAssociationAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.LabelAssociationAction
         * @static
         * @param {proto.LabelAssociationAction} message LabelAssociationAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LabelAssociationAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.labeled = false;
            if (message.labeled != null && message.hasOwnProperty("labeled"))
                object.labeled = message.labeled;
            return object;
        };

        /**
         * Converts this LabelAssociationAction to JSON.
         * @function toJSON
         * @memberof proto.LabelAssociationAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LabelAssociationAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LabelAssociationAction;
    })();

    proto.LabelEditAction = (function() {

        /**
         * Properties of a LabelEditAction.
         * @memberof proto
         * @interface ILabelEditAction
         * @property {string|null} [name] LabelEditAction name
         * @property {number|null} [color] LabelEditAction color
         * @property {number|null} [predefinedId] LabelEditAction predefinedId
         * @property {boolean|null} [deleted] LabelEditAction deleted
         */

        /**
         * Constructs a new LabelEditAction.
         * @memberof proto
         * @classdesc Represents a LabelEditAction.
         * @implements ILabelEditAction
         * @constructor
         * @param {proto.ILabelEditAction=} [properties] Properties to set
         */
        function LabelEditAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LabelEditAction name.
         * @member {string} name
         * @memberof proto.LabelEditAction
         * @instance
         */
        LabelEditAction.prototype.name = "";

        /**
         * LabelEditAction color.
         * @member {number} color
         * @memberof proto.LabelEditAction
         * @instance
         */
        LabelEditAction.prototype.color = 0;

        /**
         * LabelEditAction predefinedId.
         * @member {number} predefinedId
         * @memberof proto.LabelEditAction
         * @instance
         */
        LabelEditAction.prototype.predefinedId = 0;

        /**
         * LabelEditAction deleted.
         * @member {boolean} deleted
         * @memberof proto.LabelEditAction
         * @instance
         */
        LabelEditAction.prototype.deleted = false;

        /**
         * Creates a new LabelEditAction instance using the specified properties.
         * @function create
         * @memberof proto.LabelEditAction
         * @static
         * @param {proto.ILabelEditAction=} [properties] Properties to set
         * @returns {proto.LabelEditAction} LabelEditAction instance
         */
        LabelEditAction.create = function create(properties) {
            return new LabelEditAction(properties);
        };

        /**
         * Encodes the specified LabelEditAction message. Does not implicitly {@link proto.LabelEditAction.verify|verify} messages.
         * @function encode
         * @memberof proto.LabelEditAction
         * @static
         * @param {proto.ILabelEditAction} message LabelEditAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LabelEditAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
            if (message.color != null && Object.hasOwnProperty.call(message, "color"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.color);
            if (message.predefinedId != null && Object.hasOwnProperty.call(message, "predefinedId"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.predefinedId);
            if (message.deleted != null && Object.hasOwnProperty.call(message, "deleted"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.deleted);
            return writer;
        };

        /**
         * Encodes the specified LabelEditAction message, length delimited. Does not implicitly {@link proto.LabelEditAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LabelEditAction
         * @static
         * @param {proto.ILabelEditAction} message LabelEditAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LabelEditAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LabelEditAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.LabelEditAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.LabelEditAction} LabelEditAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LabelEditAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.LabelEditAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.name = reader.string();
                    break;
                case 2:
                    message.color = reader.int32();
                    break;
                case 3:
                    message.predefinedId = reader.int32();
                    break;
                case 4:
                    message.deleted = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LabelEditAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.LabelEditAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.LabelEditAction} LabelEditAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LabelEditAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LabelEditAction message.
         * @function verify
         * @memberof proto.LabelEditAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LabelEditAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.color != null && message.hasOwnProperty("color"))
                if (!$util.isInteger(message.color))
                    return "color: integer expected";
            if (message.predefinedId != null && message.hasOwnProperty("predefinedId"))
                if (!$util.isInteger(message.predefinedId))
                    return "predefinedId: integer expected";
            if (message.deleted != null && message.hasOwnProperty("deleted"))
                if (typeof message.deleted !== "boolean")
                    return "deleted: boolean expected";
            return null;
        };

        /**
         * Creates a LabelEditAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.LabelEditAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.LabelEditAction} LabelEditAction
         */
        LabelEditAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.LabelEditAction)
                return object;
            var message = new $root.proto.LabelEditAction();
            if (object.name != null)
                message.name = String(object.name);
            if (object.color != null)
                message.color = object.color | 0;
            if (object.predefinedId != null)
                message.predefinedId = object.predefinedId | 0;
            if (object.deleted != null)
                message.deleted = Boolean(object.deleted);
            return message;
        };

        /**
         * Creates a plain object from a LabelEditAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.LabelEditAction
         * @static
         * @param {proto.LabelEditAction} message LabelEditAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LabelEditAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.name = "";
                object.color = 0;
                object.predefinedId = 0;
                object.deleted = false;
            }
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.color != null && message.hasOwnProperty("color"))
                object.color = message.color;
            if (message.predefinedId != null && message.hasOwnProperty("predefinedId"))
                object.predefinedId = message.predefinedId;
            if (message.deleted != null && message.hasOwnProperty("deleted"))
                object.deleted = message.deleted;
            return object;
        };

        /**
         * Converts this LabelEditAction to JSON.
         * @function toJSON
         * @memberof proto.LabelEditAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LabelEditAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LabelEditAction;
    })();

    proto.RecentStickerWeightsAction = (function() {

        /**
         * Properties of a RecentStickerWeightsAction.
         * @memberof proto
         * @interface IRecentStickerWeightsAction
         * @property {Array.<proto.IRecentStickerWeight>|null} [weights] RecentStickerWeightsAction weights
         */

        /**
         * Constructs a new RecentStickerWeightsAction.
         * @memberof proto
         * @classdesc Represents a RecentStickerWeightsAction.
         * @implements IRecentStickerWeightsAction
         * @constructor
         * @param {proto.IRecentStickerWeightsAction=} [properties] Properties to set
         */
        function RecentStickerWeightsAction(properties) {
            this.weights = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * RecentStickerWeightsAction weights.
         * @member {Array.<proto.IRecentStickerWeight>} weights
         * @memberof proto.RecentStickerWeightsAction
         * @instance
         */
        RecentStickerWeightsAction.prototype.weights = $util.emptyArray;

        /**
         * Creates a new RecentStickerWeightsAction instance using the specified properties.
         * @function create
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {proto.IRecentStickerWeightsAction=} [properties] Properties to set
         * @returns {proto.RecentStickerWeightsAction} RecentStickerWeightsAction instance
         */
        RecentStickerWeightsAction.create = function create(properties) {
            return new RecentStickerWeightsAction(properties);
        };

        /**
         * Encodes the specified RecentStickerWeightsAction message. Does not implicitly {@link proto.RecentStickerWeightsAction.verify|verify} messages.
         * @function encode
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {proto.IRecentStickerWeightsAction} message RecentStickerWeightsAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentStickerWeightsAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.weights != null && message.weights.length)
                for (var i = 0; i < message.weights.length; ++i)
                    $root.proto.RecentStickerWeight.encode(message.weights[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified RecentStickerWeightsAction message, length delimited. Does not implicitly {@link proto.RecentStickerWeightsAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {proto.IRecentStickerWeightsAction} message RecentStickerWeightsAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentStickerWeightsAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RecentStickerWeightsAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.RecentStickerWeightsAction} RecentStickerWeightsAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentStickerWeightsAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.RecentStickerWeightsAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.weights && message.weights.length))
                        message.weights = [];
                    message.weights.push($root.proto.RecentStickerWeight.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RecentStickerWeightsAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.RecentStickerWeightsAction} RecentStickerWeightsAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentStickerWeightsAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RecentStickerWeightsAction message.
         * @function verify
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RecentStickerWeightsAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.weights != null && message.hasOwnProperty("weights")) {
                if (!Array.isArray(message.weights))
                    return "weights: array expected";
                for (var i = 0; i < message.weights.length; ++i) {
                    var error = $root.proto.RecentStickerWeight.verify(message.weights[i]);
                    if (error)
                        return "weights." + error;
                }
            }
            return null;
        };

        /**
         * Creates a RecentStickerWeightsAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.RecentStickerWeightsAction} RecentStickerWeightsAction
         */
        RecentStickerWeightsAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.RecentStickerWeightsAction)
                return object;
            var message = new $root.proto.RecentStickerWeightsAction();
            if (object.weights) {
                if (!Array.isArray(object.weights))
                    throw TypeError(".proto.RecentStickerWeightsAction.weights: array expected");
                message.weights = [];
                for (var i = 0; i < object.weights.length; ++i) {
                    if (typeof object.weights[i] !== "object")
                        throw TypeError(".proto.RecentStickerWeightsAction.weights: object expected");
                    message.weights[i] = $root.proto.RecentStickerWeight.fromObject(object.weights[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a RecentStickerWeightsAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.RecentStickerWeightsAction
         * @static
         * @param {proto.RecentStickerWeightsAction} message RecentStickerWeightsAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RecentStickerWeightsAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.weights = [];
            if (message.weights && message.weights.length) {
                object.weights = [];
                for (var j = 0; j < message.weights.length; ++j)
                    object.weights[j] = $root.proto.RecentStickerWeight.toObject(message.weights[j], options);
            }
            return object;
        };

        /**
         * Converts this RecentStickerWeightsAction to JSON.
         * @function toJSON
         * @memberof proto.RecentStickerWeightsAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RecentStickerWeightsAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RecentStickerWeightsAction;
    })();

    proto.RecentStickerMetadata = (function() {

        /**
         * Properties of a RecentStickerMetadata.
         * @memberof proto
         * @interface IRecentStickerMetadata
         * @property {string|null} [directPath] RecentStickerMetadata directPath
         * @property {string|null} [encFilehash] RecentStickerMetadata encFilehash
         * @property {string|null} [mediaKey] RecentStickerMetadata mediaKey
         * @property {string|null} [stanzaId] RecentStickerMetadata stanzaId
         * @property {string|null} [chatJid] RecentStickerMetadata chatJid
         * @property {string|null} [participant] RecentStickerMetadata participant
         * @property {boolean|null} [isSentByMe] RecentStickerMetadata isSentByMe
         */

        /**
         * Constructs a new RecentStickerMetadata.
         * @memberof proto
         * @classdesc Represents a RecentStickerMetadata.
         * @implements IRecentStickerMetadata
         * @constructor
         * @param {proto.IRecentStickerMetadata=} [properties] Properties to set
         */
        function RecentStickerMetadata(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * RecentStickerMetadata directPath.
         * @member {string} directPath
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.directPath = "";

        /**
         * RecentStickerMetadata encFilehash.
         * @member {string} encFilehash
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.encFilehash = "";

        /**
         * RecentStickerMetadata mediaKey.
         * @member {string} mediaKey
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.mediaKey = "";

        /**
         * RecentStickerMetadata stanzaId.
         * @member {string} stanzaId
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.stanzaId = "";

        /**
         * RecentStickerMetadata chatJid.
         * @member {string} chatJid
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.chatJid = "";

        /**
         * RecentStickerMetadata participant.
         * @member {string} participant
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.participant = "";

        /**
         * RecentStickerMetadata isSentByMe.
         * @member {boolean} isSentByMe
         * @memberof proto.RecentStickerMetadata
         * @instance
         */
        RecentStickerMetadata.prototype.isSentByMe = false;

        /**
         * Creates a new RecentStickerMetadata instance using the specified properties.
         * @function create
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {proto.IRecentStickerMetadata=} [properties] Properties to set
         * @returns {proto.RecentStickerMetadata} RecentStickerMetadata instance
         */
        RecentStickerMetadata.create = function create(properties) {
            return new RecentStickerMetadata(properties);
        };

        /**
         * Encodes the specified RecentStickerMetadata message. Does not implicitly {@link proto.RecentStickerMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {proto.IRecentStickerMetadata} message RecentStickerMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentStickerMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.directPath);
            if (message.encFilehash != null && Object.hasOwnProperty.call(message, "encFilehash"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.encFilehash);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.mediaKey);
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.stanzaId);
            if (message.chatJid != null && Object.hasOwnProperty.call(message, "chatJid"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.chatJid);
            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.participant);
            if (message.isSentByMe != null && Object.hasOwnProperty.call(message, "isSentByMe"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.isSentByMe);
            return writer;
        };

        /**
         * Encodes the specified RecentStickerMetadata message, length delimited. Does not implicitly {@link proto.RecentStickerMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {proto.IRecentStickerMetadata} message RecentStickerMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentStickerMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RecentStickerMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.RecentStickerMetadata} RecentStickerMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentStickerMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.RecentStickerMetadata();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.directPath = reader.string();
                    break;
                case 2:
                    message.encFilehash = reader.string();
                    break;
                case 3:
                    message.mediaKey = reader.string();
                    break;
                case 4:
                    message.stanzaId = reader.string();
                    break;
                case 5:
                    message.chatJid = reader.string();
                    break;
                case 6:
                    message.participant = reader.string();
                    break;
                case 7:
                    message.isSentByMe = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RecentStickerMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.RecentStickerMetadata} RecentStickerMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentStickerMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RecentStickerMetadata message.
         * @function verify
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RecentStickerMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.encFilehash != null && message.hasOwnProperty("encFilehash"))
                if (!$util.isString(message.encFilehash))
                    return "encFilehash: string expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!$util.isString(message.mediaKey))
                    return "mediaKey: string expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            if (message.chatJid != null && message.hasOwnProperty("chatJid"))
                if (!$util.isString(message.chatJid))
                    return "chatJid: string expected";
            if (message.participant != null && message.hasOwnProperty("participant"))
                if (!$util.isString(message.participant))
                    return "participant: string expected";
            if (message.isSentByMe != null && message.hasOwnProperty("isSentByMe"))
                if (typeof message.isSentByMe !== "boolean")
                    return "isSentByMe: boolean expected";
            return null;
        };

        /**
         * Creates a RecentStickerMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.RecentStickerMetadata} RecentStickerMetadata
         */
        RecentStickerMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.RecentStickerMetadata)
                return object;
            var message = new $root.proto.RecentStickerMetadata();
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.encFilehash != null)
                message.encFilehash = String(object.encFilehash);
            if (object.mediaKey != null)
                message.mediaKey = String(object.mediaKey);
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            if (object.chatJid != null)
                message.chatJid = String(object.chatJid);
            if (object.participant != null)
                message.participant = String(object.participant);
            if (object.isSentByMe != null)
                message.isSentByMe = Boolean(object.isSentByMe);
            return message;
        };

        /**
         * Creates a plain object from a RecentStickerMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.RecentStickerMetadata
         * @static
         * @param {proto.RecentStickerMetadata} message RecentStickerMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RecentStickerMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.directPath = "";
                object.encFilehash = "";
                object.mediaKey = "";
                object.stanzaId = "";
                object.chatJid = "";
                object.participant = "";
                object.isSentByMe = false;
            }
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.encFilehash != null && message.hasOwnProperty("encFilehash"))
                object.encFilehash = message.encFilehash;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = message.mediaKey;
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            if (message.chatJid != null && message.hasOwnProperty("chatJid"))
                object.chatJid = message.chatJid;
            if (message.participant != null && message.hasOwnProperty("participant"))
                object.participant = message.participant;
            if (message.isSentByMe != null && message.hasOwnProperty("isSentByMe"))
                object.isSentByMe = message.isSentByMe;
            return object;
        };

        /**
         * Converts this RecentStickerMetadata to JSON.
         * @function toJSON
         * @memberof proto.RecentStickerMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RecentStickerMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RecentStickerMetadata;
    })();

    proto.RecentEmojiWeightsAction = (function() {

        /**
         * Properties of a RecentEmojiWeightsAction.
         * @memberof proto
         * @interface IRecentEmojiWeightsAction
         * @property {Array.<proto.IRecentEmojiWeight>|null} [weights] RecentEmojiWeightsAction weights
         */

        /**
         * Constructs a new RecentEmojiWeightsAction.
         * @memberof proto
         * @classdesc Represents a RecentEmojiWeightsAction.
         * @implements IRecentEmojiWeightsAction
         * @constructor
         * @param {proto.IRecentEmojiWeightsAction=} [properties] Properties to set
         */
        function RecentEmojiWeightsAction(properties) {
            this.weights = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * RecentEmojiWeightsAction weights.
         * @member {Array.<proto.IRecentEmojiWeight>} weights
         * @memberof proto.RecentEmojiWeightsAction
         * @instance
         */
        RecentEmojiWeightsAction.prototype.weights = $util.emptyArray;

        /**
         * Creates a new RecentEmojiWeightsAction instance using the specified properties.
         * @function create
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {proto.IRecentEmojiWeightsAction=} [properties] Properties to set
         * @returns {proto.RecentEmojiWeightsAction} RecentEmojiWeightsAction instance
         */
        RecentEmojiWeightsAction.create = function create(properties) {
            return new RecentEmojiWeightsAction(properties);
        };

        /**
         * Encodes the specified RecentEmojiWeightsAction message. Does not implicitly {@link proto.RecentEmojiWeightsAction.verify|verify} messages.
         * @function encode
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {proto.IRecentEmojiWeightsAction} message RecentEmojiWeightsAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentEmojiWeightsAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.weights != null && message.weights.length)
                for (var i = 0; i < message.weights.length; ++i)
                    $root.proto.RecentEmojiWeight.encode(message.weights[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified RecentEmojiWeightsAction message, length delimited. Does not implicitly {@link proto.RecentEmojiWeightsAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {proto.IRecentEmojiWeightsAction} message RecentEmojiWeightsAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentEmojiWeightsAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RecentEmojiWeightsAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.RecentEmojiWeightsAction} RecentEmojiWeightsAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentEmojiWeightsAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.RecentEmojiWeightsAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.weights && message.weights.length))
                        message.weights = [];
                    message.weights.push($root.proto.RecentEmojiWeight.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RecentEmojiWeightsAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.RecentEmojiWeightsAction} RecentEmojiWeightsAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentEmojiWeightsAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RecentEmojiWeightsAction message.
         * @function verify
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RecentEmojiWeightsAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.weights != null && message.hasOwnProperty("weights")) {
                if (!Array.isArray(message.weights))
                    return "weights: array expected";
                for (var i = 0; i < message.weights.length; ++i) {
                    var error = $root.proto.RecentEmojiWeight.verify(message.weights[i]);
                    if (error)
                        return "weights." + error;
                }
            }
            return null;
        };

        /**
         * Creates a RecentEmojiWeightsAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.RecentEmojiWeightsAction} RecentEmojiWeightsAction
         */
        RecentEmojiWeightsAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.RecentEmojiWeightsAction)
                return object;
            var message = new $root.proto.RecentEmojiWeightsAction();
            if (object.weights) {
                if (!Array.isArray(object.weights))
                    throw TypeError(".proto.RecentEmojiWeightsAction.weights: array expected");
                message.weights = [];
                for (var i = 0; i < object.weights.length; ++i) {
                    if (typeof object.weights[i] !== "object")
                        throw TypeError(".proto.RecentEmojiWeightsAction.weights: object expected");
                    message.weights[i] = $root.proto.RecentEmojiWeight.fromObject(object.weights[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a RecentEmojiWeightsAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.RecentEmojiWeightsAction
         * @static
         * @param {proto.RecentEmojiWeightsAction} message RecentEmojiWeightsAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RecentEmojiWeightsAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.weights = [];
            if (message.weights && message.weights.length) {
                object.weights = [];
                for (var j = 0; j < message.weights.length; ++j)
                    object.weights[j] = $root.proto.RecentEmojiWeight.toObject(message.weights[j], options);
            }
            return object;
        };

        /**
         * Converts this RecentEmojiWeightsAction to JSON.
         * @function toJSON
         * @memberof proto.RecentEmojiWeightsAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RecentEmojiWeightsAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RecentEmojiWeightsAction;
    })();

    proto.FavoriteStickerAction = (function() {

        /**
         * Properties of a FavoriteStickerAction.
         * @memberof proto
         * @interface IFavoriteStickerAction
         * @property {string|null} [directPath] FavoriteStickerAction directPath
         * @property {string|null} [lastUploadTimestamp] FavoriteStickerAction lastUploadTimestamp
         * @property {string|null} [handle] FavoriteStickerAction handle
         * @property {string|null} [encFilehash] FavoriteStickerAction encFilehash
         * @property {string|null} [stickerHashWithoutMeta] FavoriteStickerAction stickerHashWithoutMeta
         * @property {string|null} [mediaKey] FavoriteStickerAction mediaKey
         * @property {number|Long|null} [mediaKeyTimestamp] FavoriteStickerAction mediaKeyTimestamp
         * @property {boolean|null} [isFavorite] FavoriteStickerAction isFavorite
         */

        /**
         * Constructs a new FavoriteStickerAction.
         * @memberof proto
         * @classdesc Represents a FavoriteStickerAction.
         * @implements IFavoriteStickerAction
         * @constructor
         * @param {proto.IFavoriteStickerAction=} [properties] Properties to set
         */
        function FavoriteStickerAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FavoriteStickerAction directPath.
         * @member {string} directPath
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.directPath = "";

        /**
         * FavoriteStickerAction lastUploadTimestamp.
         * @member {string} lastUploadTimestamp
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.lastUploadTimestamp = "";

        /**
         * FavoriteStickerAction handle.
         * @member {string} handle
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.handle = "";

        /**
         * FavoriteStickerAction encFilehash.
         * @member {string} encFilehash
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.encFilehash = "";

        /**
         * FavoriteStickerAction stickerHashWithoutMeta.
         * @member {string} stickerHashWithoutMeta
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.stickerHashWithoutMeta = "";

        /**
         * FavoriteStickerAction mediaKey.
         * @member {string} mediaKey
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.mediaKey = "";

        /**
         * FavoriteStickerAction mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * FavoriteStickerAction isFavorite.
         * @member {boolean} isFavorite
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.isFavorite = false;

        /**
         * Creates a new FavoriteStickerAction instance using the specified properties.
         * @function create
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.IFavoriteStickerAction=} [properties] Properties to set
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction instance
         */
        FavoriteStickerAction.create = function create(properties) {
            return new FavoriteStickerAction(properties);
        };

        /**
         * Encodes the specified FavoriteStickerAction message. Does not implicitly {@link proto.FavoriteStickerAction.verify|verify} messages.
         * @function encode
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.IFavoriteStickerAction} message FavoriteStickerAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FavoriteStickerAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.directPath);
            if (message.lastUploadTimestamp != null && Object.hasOwnProperty.call(message, "lastUploadTimestamp"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.lastUploadTimestamp);
            if (message.handle != null && Object.hasOwnProperty.call(message, "handle"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.handle);
            if (message.encFilehash != null && Object.hasOwnProperty.call(message, "encFilehash"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.encFilehash);
            if (message.stickerHashWithoutMeta != null && Object.hasOwnProperty.call(message, "stickerHashWithoutMeta"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.stickerHashWithoutMeta);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.mediaKey);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 7, wireType 0 =*/56).int64(message.mediaKeyTimestamp);
            if (message.isFavorite != null && Object.hasOwnProperty.call(message, "isFavorite"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.isFavorite);
            return writer;
        };

        /**
         * Encodes the specified FavoriteStickerAction message, length delimited. Does not implicitly {@link proto.FavoriteStickerAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.IFavoriteStickerAction} message FavoriteStickerAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FavoriteStickerAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FavoriteStickerAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FavoriteStickerAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.FavoriteStickerAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.directPath = reader.string();
                    break;
                case 2:
                    message.lastUploadTimestamp = reader.string();
                    break;
                case 3:
                    message.handle = reader.string();
                    break;
                case 4:
                    message.encFilehash = reader.string();
                    break;
                case 5:
                    message.stickerHashWithoutMeta = reader.string();
                    break;
                case 6:
                    message.mediaKey = reader.string();
                    break;
                case 7:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 8:
                    message.isFavorite = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FavoriteStickerAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FavoriteStickerAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FavoriteStickerAction message.
         * @function verify
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FavoriteStickerAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.lastUploadTimestamp != null && message.hasOwnProperty("lastUploadTimestamp"))
                if (!$util.isString(message.lastUploadTimestamp))
                    return "lastUploadTimestamp: string expected";
            if (message.handle != null && message.hasOwnProperty("handle"))
                if (!$util.isString(message.handle))
                    return "handle: string expected";
            if (message.encFilehash != null && message.hasOwnProperty("encFilehash"))
                if (!$util.isString(message.encFilehash))
                    return "encFilehash: string expected";
            if (message.stickerHashWithoutMeta != null && message.hasOwnProperty("stickerHashWithoutMeta"))
                if (!$util.isString(message.stickerHashWithoutMeta))
                    return "stickerHashWithoutMeta: string expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!$util.isString(message.mediaKey))
                    return "mediaKey: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.isFavorite != null && message.hasOwnProperty("isFavorite"))
                if (typeof message.isFavorite !== "boolean")
                    return "isFavorite: boolean expected";
            return null;
        };

        /**
         * Creates a FavoriteStickerAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction
         */
        FavoriteStickerAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.FavoriteStickerAction)
                return object;
            var message = new $root.proto.FavoriteStickerAction();
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.lastUploadTimestamp != null)
                message.lastUploadTimestamp = String(object.lastUploadTimestamp);
            if (object.handle != null)
                message.handle = String(object.handle);
            if (object.encFilehash != null)
                message.encFilehash = String(object.encFilehash);
            if (object.stickerHashWithoutMeta != null)
                message.stickerHashWithoutMeta = String(object.stickerHashWithoutMeta);
            if (object.mediaKey != null)
                message.mediaKey = String(object.mediaKey);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.isFavorite != null)
                message.isFavorite = Boolean(object.isFavorite);
            return message;
        };

        /**
         * Creates a plain object from a FavoriteStickerAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.FavoriteStickerAction} message FavoriteStickerAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FavoriteStickerAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.directPath = "";
                object.lastUploadTimestamp = "";
                object.handle = "";
                object.encFilehash = "";
                object.stickerHashWithoutMeta = "";
                object.mediaKey = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.isFavorite = false;
            }
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.lastUploadTimestamp != null && message.hasOwnProperty("lastUploadTimestamp"))
                object.lastUploadTimestamp = message.lastUploadTimestamp;
            if (message.handle != null && message.hasOwnProperty("handle"))
                object.handle = message.handle;
            if (message.encFilehash != null && message.hasOwnProperty("encFilehash"))
                object.encFilehash = message.encFilehash;
            if (message.stickerHashWithoutMeta != null && message.hasOwnProperty("stickerHashWithoutMeta"))
                object.stickerHashWithoutMeta = message.stickerHashWithoutMeta;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = message.mediaKey;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.isFavorite != null && message.hasOwnProperty("isFavorite"))
                object.isFavorite = message.isFavorite;
            return object;
        };

        /**
         * Converts this FavoriteStickerAction to JSON.
         * @function toJSON
         * @memberof proto.FavoriteStickerAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FavoriteStickerAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FavoriteStickerAction;
    })();

    proto.ArchiveChatAction = (function() {

        /**
         * Properties of an ArchiveChatAction.
         * @memberof proto
         * @interface IArchiveChatAction
         * @property {boolean|null} [archived] ArchiveChatAction archived
         * @property {proto.ISyncActionMessageRange|null} [messageRange] ArchiveChatAction messageRange
         */

        /**
         * Constructs a new ArchiveChatAction.
         * @memberof proto
         * @classdesc Represents an ArchiveChatAction.
         * @implements IArchiveChatAction
         * @constructor
         * @param {proto.IArchiveChatAction=} [properties] Properties to set
         */
        function ArchiveChatAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ArchiveChatAction archived.
         * @member {boolean} archived
         * @memberof proto.ArchiveChatAction
         * @instance
         */
        ArchiveChatAction.prototype.archived = false;

        /**
         * ArchiveChatAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.ArchiveChatAction
         * @instance
         */
        ArchiveChatAction.prototype.messageRange = null;

        /**
         * Creates a new ArchiveChatAction instance using the specified properties.
         * @function create
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.IArchiveChatAction=} [properties] Properties to set
         * @returns {proto.ArchiveChatAction} ArchiveChatAction instance
         */
        ArchiveChatAction.create = function create(properties) {
            return new ArchiveChatAction(properties);
        };

        /**
         * Encodes the specified ArchiveChatAction message. Does not implicitly {@link proto.ArchiveChatAction.verify|verify} messages.
         * @function encode
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.IArchiveChatAction} message ArchiveChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ArchiveChatAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.archived != null && Object.hasOwnProperty.call(message, "archived"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.archived);
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ArchiveChatAction message, length delimited. Does not implicitly {@link proto.ArchiveChatAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.IArchiveChatAction} message ArchiveChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ArchiveChatAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ArchiveChatAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ArchiveChatAction} ArchiveChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ArchiveChatAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ArchiveChatAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.archived = reader.bool();
                    break;
                case 2:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ArchiveChatAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ArchiveChatAction} ArchiveChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ArchiveChatAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ArchiveChatAction message.
         * @function verify
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ArchiveChatAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.archived != null && message.hasOwnProperty("archived"))
                if (typeof message.archived !== "boolean")
                    return "archived: boolean expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates an ArchiveChatAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ArchiveChatAction} ArchiveChatAction
         */
        ArchiveChatAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ArchiveChatAction)
                return object;
            var message = new $root.proto.ArchiveChatAction();
            if (object.archived != null)
                message.archived = Boolean(object.archived);
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.ArchiveChatAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from an ArchiveChatAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.ArchiveChatAction} message ArchiveChatAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ArchiveChatAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.archived = false;
                object.messageRange = null;
            }
            if (message.archived != null && message.hasOwnProperty("archived"))
                object.archived = message.archived;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this ArchiveChatAction to JSON.
         * @function toJSON
         * @memberof proto.ArchiveChatAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ArchiveChatAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ArchiveChatAction;
    })();

    proto.DeleteMessageForMeAction = (function() {

        /**
         * Properties of a DeleteMessageForMeAction.
         * @memberof proto
         * @interface IDeleteMessageForMeAction
         * @property {boolean|null} [deleteMedia] DeleteMessageForMeAction deleteMedia
         * @property {number|Long|null} [messageTimestamp] DeleteMessageForMeAction messageTimestamp
         */

        /**
         * Constructs a new DeleteMessageForMeAction.
         * @memberof proto
         * @classdesc Represents a DeleteMessageForMeAction.
         * @implements IDeleteMessageForMeAction
         * @constructor
         * @param {proto.IDeleteMessageForMeAction=} [properties] Properties to set
         */
        function DeleteMessageForMeAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeleteMessageForMeAction deleteMedia.
         * @member {boolean} deleteMedia
         * @memberof proto.DeleteMessageForMeAction
         * @instance
         */
        DeleteMessageForMeAction.prototype.deleteMedia = false;

        /**
         * DeleteMessageForMeAction messageTimestamp.
         * @member {number|Long} messageTimestamp
         * @memberof proto.DeleteMessageForMeAction
         * @instance
         */
        DeleteMessageForMeAction.prototype.messageTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new DeleteMessageForMeAction instance using the specified properties.
         * @function create
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.IDeleteMessageForMeAction=} [properties] Properties to set
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction instance
         */
        DeleteMessageForMeAction.create = function create(properties) {
            return new DeleteMessageForMeAction(properties);
        };

        /**
         * Encodes the specified DeleteMessageForMeAction message. Does not implicitly {@link proto.DeleteMessageForMeAction.verify|verify} messages.
         * @function encode
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.IDeleteMessageForMeAction} message DeleteMessageForMeAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteMessageForMeAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.deleteMedia != null && Object.hasOwnProperty.call(message, "deleteMedia"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.deleteMedia);
            if (message.messageTimestamp != null && Object.hasOwnProperty.call(message, "messageTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.messageTimestamp);
            return writer;
        };

        /**
         * Encodes the specified DeleteMessageForMeAction message, length delimited. Does not implicitly {@link proto.DeleteMessageForMeAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.IDeleteMessageForMeAction} message DeleteMessageForMeAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteMessageForMeAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeleteMessageForMeAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteMessageForMeAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeleteMessageForMeAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.deleteMedia = reader.bool();
                    break;
                case 2:
                    message.messageTimestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeleteMessageForMeAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteMessageForMeAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeleteMessageForMeAction message.
         * @function verify
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeleteMessageForMeAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.deleteMedia != null && message.hasOwnProperty("deleteMedia"))
                if (typeof message.deleteMedia !== "boolean")
                    return "deleteMedia: boolean expected";
            if (message.messageTimestamp != null && message.hasOwnProperty("messageTimestamp"))
                if (!$util.isInteger(message.messageTimestamp) && !(message.messageTimestamp && $util.isInteger(message.messageTimestamp.low) && $util.isInteger(message.messageTimestamp.high)))
                    return "messageTimestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates a DeleteMessageForMeAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction
         */
        DeleteMessageForMeAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeleteMessageForMeAction)
                return object;
            var message = new $root.proto.DeleteMessageForMeAction();
            if (object.deleteMedia != null)
                message.deleteMedia = Boolean(object.deleteMedia);
            if (object.messageTimestamp != null)
                if ($util.Long)
                    (message.messageTimestamp = $util.Long.fromValue(object.messageTimestamp)).unsigned = false;
                else if (typeof object.messageTimestamp === "string")
                    message.messageTimestamp = parseInt(object.messageTimestamp, 10);
                else if (typeof object.messageTimestamp === "number")
                    message.messageTimestamp = object.messageTimestamp;
                else if (typeof object.messageTimestamp === "object")
                    message.messageTimestamp = new $util.LongBits(object.messageTimestamp.low >>> 0, object.messageTimestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a DeleteMessageForMeAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.DeleteMessageForMeAction} message DeleteMessageForMeAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeleteMessageForMeAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.deleteMedia = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.messageTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.messageTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.deleteMedia != null && message.hasOwnProperty("deleteMedia"))
                object.deleteMedia = message.deleteMedia;
            if (message.messageTimestamp != null && message.hasOwnProperty("messageTimestamp"))
                if (typeof message.messageTimestamp === "number")
                    object.messageTimestamp = options.longs === String ? String(message.messageTimestamp) : message.messageTimestamp;
                else
                    object.messageTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.messageTimestamp) : options.longs === Number ? new $util.LongBits(message.messageTimestamp.low >>> 0, message.messageTimestamp.high >>> 0).toNumber() : message.messageTimestamp;
            return object;
        };

        /**
         * Converts this DeleteMessageForMeAction to JSON.
         * @function toJSON
         * @memberof proto.DeleteMessageForMeAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeleteMessageForMeAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeleteMessageForMeAction;
    })();

    proto.MarkChatAsReadAction = (function() {

        /**
         * Properties of a MarkChatAsReadAction.
         * @memberof proto
         * @interface IMarkChatAsReadAction
         * @property {boolean|null} [read] MarkChatAsReadAction read
         * @property {proto.ISyncActionMessageRange|null} [messageRange] MarkChatAsReadAction messageRange
         */

        /**
         * Constructs a new MarkChatAsReadAction.
         * @memberof proto
         * @classdesc Represents a MarkChatAsReadAction.
         * @implements IMarkChatAsReadAction
         * @constructor
         * @param {proto.IMarkChatAsReadAction=} [properties] Properties to set
         */
        function MarkChatAsReadAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MarkChatAsReadAction read.
         * @member {boolean} read
         * @memberof proto.MarkChatAsReadAction
         * @instance
         */
        MarkChatAsReadAction.prototype.read = false;

        /**
         * MarkChatAsReadAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.MarkChatAsReadAction
         * @instance
         */
        MarkChatAsReadAction.prototype.messageRange = null;

        /**
         * Creates a new MarkChatAsReadAction instance using the specified properties.
         * @function create
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {proto.IMarkChatAsReadAction=} [properties] Properties to set
         * @returns {proto.MarkChatAsReadAction} MarkChatAsReadAction instance
         */
        MarkChatAsReadAction.create = function create(properties) {
            return new MarkChatAsReadAction(properties);
        };

        /**
         * Encodes the specified MarkChatAsReadAction message. Does not implicitly {@link proto.MarkChatAsReadAction.verify|verify} messages.
         * @function encode
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {proto.IMarkChatAsReadAction} message MarkChatAsReadAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MarkChatAsReadAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.read != null && Object.hasOwnProperty.call(message, "read"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.read);
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified MarkChatAsReadAction message, length delimited. Does not implicitly {@link proto.MarkChatAsReadAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {proto.IMarkChatAsReadAction} message MarkChatAsReadAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MarkChatAsReadAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MarkChatAsReadAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MarkChatAsReadAction} MarkChatAsReadAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MarkChatAsReadAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MarkChatAsReadAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.read = reader.bool();
                    break;
                case 2:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MarkChatAsReadAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MarkChatAsReadAction} MarkChatAsReadAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MarkChatAsReadAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MarkChatAsReadAction message.
         * @function verify
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MarkChatAsReadAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.read != null && message.hasOwnProperty("read"))
                if (typeof message.read !== "boolean")
                    return "read: boolean expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates a MarkChatAsReadAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MarkChatAsReadAction} MarkChatAsReadAction
         */
        MarkChatAsReadAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MarkChatAsReadAction)
                return object;
            var message = new $root.proto.MarkChatAsReadAction();
            if (object.read != null)
                message.read = Boolean(object.read);
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.MarkChatAsReadAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from a MarkChatAsReadAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MarkChatAsReadAction
         * @static
         * @param {proto.MarkChatAsReadAction} message MarkChatAsReadAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MarkChatAsReadAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.read = false;
                object.messageRange = null;
            }
            if (message.read != null && message.hasOwnProperty("read"))
                object.read = message.read;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this MarkChatAsReadAction to JSON.
         * @function toJSON
         * @memberof proto.MarkChatAsReadAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MarkChatAsReadAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MarkChatAsReadAction;
    })();

    proto.ClearChatAction = (function() {

        /**
         * Properties of a ClearChatAction.
         * @memberof proto
         * @interface IClearChatAction
         * @property {proto.ISyncActionMessageRange|null} [messageRange] ClearChatAction messageRange
         */

        /**
         * Constructs a new ClearChatAction.
         * @memberof proto
         * @classdesc Represents a ClearChatAction.
         * @implements IClearChatAction
         * @constructor
         * @param {proto.IClearChatAction=} [properties] Properties to set
         */
        function ClearChatAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClearChatAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.ClearChatAction
         * @instance
         */
        ClearChatAction.prototype.messageRange = null;

        /**
         * Creates a new ClearChatAction instance using the specified properties.
         * @function create
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.IClearChatAction=} [properties] Properties to set
         * @returns {proto.ClearChatAction} ClearChatAction instance
         */
        ClearChatAction.create = function create(properties) {
            return new ClearChatAction(properties);
        };

        /**
         * Encodes the specified ClearChatAction message. Does not implicitly {@link proto.ClearChatAction.verify|verify} messages.
         * @function encode
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.IClearChatAction} message ClearChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClearChatAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ClearChatAction message, length delimited. Does not implicitly {@link proto.ClearChatAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.IClearChatAction} message ClearChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClearChatAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClearChatAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClearChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClearChatAction} ClearChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClearChatAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClearChatAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClearChatAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClearChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClearChatAction} ClearChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClearChatAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClearChatAction message.
         * @function verify
         * @memberof proto.ClearChatAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClearChatAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates a ClearChatAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClearChatAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClearChatAction} ClearChatAction
         */
        ClearChatAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClearChatAction)
                return object;
            var message = new $root.proto.ClearChatAction();
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.ClearChatAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from a ClearChatAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.ClearChatAction} message ClearChatAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClearChatAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.messageRange = null;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this ClearChatAction to JSON.
         * @function toJSON
         * @memberof proto.ClearChatAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClearChatAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ClearChatAction;
    })();

    proto.DeleteChatAction = (function() {

        /**
         * Properties of a DeleteChatAction.
         * @memberof proto
         * @interface IDeleteChatAction
         * @property {proto.ISyncActionMessageRange|null} [messageRange] DeleteChatAction messageRange
         */

        /**
         * Constructs a new DeleteChatAction.
         * @memberof proto
         * @classdesc Represents a DeleteChatAction.
         * @implements IDeleteChatAction
         * @constructor
         * @param {proto.IDeleteChatAction=} [properties] Properties to set
         */
        function DeleteChatAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeleteChatAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.DeleteChatAction
         * @instance
         */
        DeleteChatAction.prototype.messageRange = null;

        /**
         * Creates a new DeleteChatAction instance using the specified properties.
         * @function create
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.IDeleteChatAction=} [properties] Properties to set
         * @returns {proto.DeleteChatAction} DeleteChatAction instance
         */
        DeleteChatAction.create = function create(properties) {
            return new DeleteChatAction(properties);
        };

        /**
         * Encodes the specified DeleteChatAction message. Does not implicitly {@link proto.DeleteChatAction.verify|verify} messages.
         * @function encode
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.IDeleteChatAction} message DeleteChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteChatAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DeleteChatAction message, length delimited. Does not implicitly {@link proto.DeleteChatAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.IDeleteChatAction} message DeleteChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteChatAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeleteChatAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeleteChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeleteChatAction} DeleteChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteChatAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeleteChatAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeleteChatAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeleteChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeleteChatAction} DeleteChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteChatAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeleteChatAction message.
         * @function verify
         * @memberof proto.DeleteChatAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeleteChatAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates a DeleteChatAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeleteChatAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeleteChatAction} DeleteChatAction
         */
        DeleteChatAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeleteChatAction)
                return object;
            var message = new $root.proto.DeleteChatAction();
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.DeleteChatAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from a DeleteChatAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.DeleteChatAction} message DeleteChatAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeleteChatAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.messageRange = null;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this DeleteChatAction to JSON.
         * @function toJSON
         * @memberof proto.DeleteChatAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeleteChatAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeleteChatAction;
    })();

    proto.UnarchiveChatsSetting = (function() {

        /**
         * Properties of an UnarchiveChatsSetting.
         * @memberof proto
         * @interface IUnarchiveChatsSetting
         * @property {boolean|null} [unarchiveChats] UnarchiveChatsSetting unarchiveChats
         */

        /**
         * Constructs a new UnarchiveChatsSetting.
         * @memberof proto
         * @classdesc Represents an UnarchiveChatsSetting.
         * @implements IUnarchiveChatsSetting
         * @constructor
         * @param {proto.IUnarchiveChatsSetting=} [properties] Properties to set
         */
        function UnarchiveChatsSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UnarchiveChatsSetting unarchiveChats.
         * @member {boolean} unarchiveChats
         * @memberof proto.UnarchiveChatsSetting
         * @instance
         */
        UnarchiveChatsSetting.prototype.unarchiveChats = false;

        /**
         * Creates a new UnarchiveChatsSetting instance using the specified properties.
         * @function create
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {proto.IUnarchiveChatsSetting=} [properties] Properties to set
         * @returns {proto.UnarchiveChatsSetting} UnarchiveChatsSetting instance
         */
        UnarchiveChatsSetting.create = function create(properties) {
            return new UnarchiveChatsSetting(properties);
        };

        /**
         * Encodes the specified UnarchiveChatsSetting message. Does not implicitly {@link proto.UnarchiveChatsSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {proto.IUnarchiveChatsSetting} message UnarchiveChatsSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UnarchiveChatsSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.unarchiveChats != null && Object.hasOwnProperty.call(message, "unarchiveChats"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.unarchiveChats);
            return writer;
        };

        /**
         * Encodes the specified UnarchiveChatsSetting message, length delimited. Does not implicitly {@link proto.UnarchiveChatsSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {proto.IUnarchiveChatsSetting} message UnarchiveChatsSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UnarchiveChatsSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an UnarchiveChatsSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.UnarchiveChatsSetting} UnarchiveChatsSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UnarchiveChatsSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.UnarchiveChatsSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.unarchiveChats = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an UnarchiveChatsSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.UnarchiveChatsSetting} UnarchiveChatsSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UnarchiveChatsSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an UnarchiveChatsSetting message.
         * @function verify
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UnarchiveChatsSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.unarchiveChats != null && message.hasOwnProperty("unarchiveChats"))
                if (typeof message.unarchiveChats !== "boolean")
                    return "unarchiveChats: boolean expected";
            return null;
        };

        /**
         * Creates an UnarchiveChatsSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.UnarchiveChatsSetting} UnarchiveChatsSetting
         */
        UnarchiveChatsSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.UnarchiveChatsSetting)
                return object;
            var message = new $root.proto.UnarchiveChatsSetting();
            if (object.unarchiveChats != null)
                message.unarchiveChats = Boolean(object.unarchiveChats);
            return message;
        };

        /**
         * Creates a plain object from an UnarchiveChatsSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.UnarchiveChatsSetting
         * @static
         * @param {proto.UnarchiveChatsSetting} message UnarchiveChatsSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UnarchiveChatsSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.unarchiveChats = false;
            if (message.unarchiveChats != null && message.hasOwnProperty("unarchiveChats"))
                object.unarchiveChats = message.unarchiveChats;
            return object;
        };

        /**
         * Converts this UnarchiveChatsSetting to JSON.
         * @function toJSON
         * @memberof proto.UnarchiveChatsSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UnarchiveChatsSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UnarchiveChatsSetting;
    })();

    proto.SyncActionMessageRange = (function() {

        /**
         * Properties of a SyncActionMessageRange.
         * @memberof proto
         * @interface ISyncActionMessageRange
         * @property {number|Long|null} [lastMessageTimestamp] SyncActionMessageRange lastMessageTimestamp
         * @property {number|Long|null} [lastSystemMessageTimestamp] SyncActionMessageRange lastSystemMessageTimestamp
         * @property {Array.<proto.ISyncActionMessage>|null} [messages] SyncActionMessageRange messages
         */

        /**
         * Constructs a new SyncActionMessageRange.
         * @memberof proto
         * @classdesc Represents a SyncActionMessageRange.
         * @implements ISyncActionMessageRange
         * @constructor
         * @param {proto.ISyncActionMessageRange=} [properties] Properties to set
         */
        function SyncActionMessageRange(properties) {
            this.messages = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncActionMessageRange lastMessageTimestamp.
         * @member {number|Long} lastMessageTimestamp
         * @memberof proto.SyncActionMessageRange
         * @instance
         */
        SyncActionMessageRange.prototype.lastMessageTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * SyncActionMessageRange lastSystemMessageTimestamp.
         * @member {number|Long} lastSystemMessageTimestamp
         * @memberof proto.SyncActionMessageRange
         * @instance
         */
        SyncActionMessageRange.prototype.lastSystemMessageTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * SyncActionMessageRange messages.
         * @member {Array.<proto.ISyncActionMessage>} messages
         * @memberof proto.SyncActionMessageRange
         * @instance
         */
        SyncActionMessageRange.prototype.messages = $util.emptyArray;

        /**
         * Creates a new SyncActionMessageRange instance using the specified properties.
         * @function create
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {proto.ISyncActionMessageRange=} [properties] Properties to set
         * @returns {proto.SyncActionMessageRange} SyncActionMessageRange instance
         */
        SyncActionMessageRange.create = function create(properties) {
            return new SyncActionMessageRange(properties);
        };

        /**
         * Encodes the specified SyncActionMessageRange message. Does not implicitly {@link proto.SyncActionMessageRange.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {proto.ISyncActionMessageRange} message SyncActionMessageRange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionMessageRange.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lastMessageTimestamp != null && Object.hasOwnProperty.call(message, "lastMessageTimestamp"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.lastMessageTimestamp);
            if (message.lastSystemMessageTimestamp != null && Object.hasOwnProperty.call(message, "lastSystemMessageTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.lastSystemMessageTimestamp);
            if (message.messages != null && message.messages.length)
                for (var i = 0; i < message.messages.length; ++i)
                    $root.proto.SyncActionMessage.encode(message.messages[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified SyncActionMessageRange message, length delimited. Does not implicitly {@link proto.SyncActionMessageRange.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {proto.ISyncActionMessageRange} message SyncActionMessageRange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionMessageRange.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncActionMessageRange message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncActionMessageRange} SyncActionMessageRange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionMessageRange.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncActionMessageRange();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.lastMessageTimestamp = reader.int64();
                    break;
                case 2:
                    message.lastSystemMessageTimestamp = reader.int64();
                    break;
                case 3:
                    if (!(message.messages && message.messages.length))
                        message.messages = [];
                    message.messages.push($root.proto.SyncActionMessage.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncActionMessageRange message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncActionMessageRange} SyncActionMessageRange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionMessageRange.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncActionMessageRange message.
         * @function verify
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncActionMessageRange.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.lastMessageTimestamp != null && message.hasOwnProperty("lastMessageTimestamp"))
                if (!$util.isInteger(message.lastMessageTimestamp) && !(message.lastMessageTimestamp && $util.isInteger(message.lastMessageTimestamp.low) && $util.isInteger(message.lastMessageTimestamp.high)))
                    return "lastMessageTimestamp: integer|Long expected";
            if (message.lastSystemMessageTimestamp != null && message.hasOwnProperty("lastSystemMessageTimestamp"))
                if (!$util.isInteger(message.lastSystemMessageTimestamp) && !(message.lastSystemMessageTimestamp && $util.isInteger(message.lastSystemMessageTimestamp.low) && $util.isInteger(message.lastSystemMessageTimestamp.high)))
                    return "lastSystemMessageTimestamp: integer|Long expected";
            if (message.messages != null && message.hasOwnProperty("messages")) {
                if (!Array.isArray(message.messages))
                    return "messages: array expected";
                for (var i = 0; i < message.messages.length; ++i) {
                    var error = $root.proto.SyncActionMessage.verify(message.messages[i]);
                    if (error)
                        return "messages." + error;
                }
            }
            return null;
        };

        /**
         * Creates a SyncActionMessageRange message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncActionMessageRange} SyncActionMessageRange
         */
        SyncActionMessageRange.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncActionMessageRange)
                return object;
            var message = new $root.proto.SyncActionMessageRange();
            if (object.lastMessageTimestamp != null)
                if ($util.Long)
                    (message.lastMessageTimestamp = $util.Long.fromValue(object.lastMessageTimestamp)).unsigned = false;
                else if (typeof object.lastMessageTimestamp === "string")
                    message.lastMessageTimestamp = parseInt(object.lastMessageTimestamp, 10);
                else if (typeof object.lastMessageTimestamp === "number")
                    message.lastMessageTimestamp = object.lastMessageTimestamp;
                else if (typeof object.lastMessageTimestamp === "object")
                    message.lastMessageTimestamp = new $util.LongBits(object.lastMessageTimestamp.low >>> 0, object.lastMessageTimestamp.high >>> 0).toNumber();
            if (object.lastSystemMessageTimestamp != null)
                if ($util.Long)
                    (message.lastSystemMessageTimestamp = $util.Long.fromValue(object.lastSystemMessageTimestamp)).unsigned = false;
                else if (typeof object.lastSystemMessageTimestamp === "string")
                    message.lastSystemMessageTimestamp = parseInt(object.lastSystemMessageTimestamp, 10);
                else if (typeof object.lastSystemMessageTimestamp === "number")
                    message.lastSystemMessageTimestamp = object.lastSystemMessageTimestamp;
                else if (typeof object.lastSystemMessageTimestamp === "object")
                    message.lastSystemMessageTimestamp = new $util.LongBits(object.lastSystemMessageTimestamp.low >>> 0, object.lastSystemMessageTimestamp.high >>> 0).toNumber();
            if (object.messages) {
                if (!Array.isArray(object.messages))
                    throw TypeError(".proto.SyncActionMessageRange.messages: array expected");
                message.messages = [];
                for (var i = 0; i < object.messages.length; ++i) {
                    if (typeof object.messages[i] !== "object")
                        throw TypeError(".proto.SyncActionMessageRange.messages: object expected");
                    message.messages[i] = $root.proto.SyncActionMessage.fromObject(object.messages[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a SyncActionMessageRange message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncActionMessageRange
         * @static
         * @param {proto.SyncActionMessageRange} message SyncActionMessageRange
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncActionMessageRange.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.messages = [];
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.lastMessageTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.lastMessageTimestamp = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.lastSystemMessageTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.lastSystemMessageTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.lastMessageTimestamp != null && message.hasOwnProperty("lastMessageTimestamp"))
                if (typeof message.lastMessageTimestamp === "number")
                    object.lastMessageTimestamp = options.longs === String ? String(message.lastMessageTimestamp) : message.lastMessageTimestamp;
                else
                    object.lastMessageTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.lastMessageTimestamp) : options.longs === Number ? new $util.LongBits(message.lastMessageTimestamp.low >>> 0, message.lastMessageTimestamp.high >>> 0).toNumber() : message.lastMessageTimestamp;
            if (message.lastSystemMessageTimestamp != null && message.hasOwnProperty("lastSystemMessageTimestamp"))
                if (typeof message.lastSystemMessageTimestamp === "number")
                    object.lastSystemMessageTimestamp = options.longs === String ? String(message.lastSystemMessageTimestamp) : message.lastSystemMessageTimestamp;
                else
                    object.lastSystemMessageTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.lastSystemMessageTimestamp) : options.longs === Number ? new $util.LongBits(message.lastSystemMessageTimestamp.low >>> 0, message.lastSystemMessageTimestamp.high >>> 0).toNumber() : message.lastSystemMessageTimestamp;
            if (message.messages && message.messages.length) {
                object.messages = [];
                for (var j = 0; j < message.messages.length; ++j)
                    object.messages[j] = $root.proto.SyncActionMessage.toObject(message.messages[j], options);
            }
            return object;
        };

        /**
         * Converts this SyncActionMessageRange to JSON.
         * @function toJSON
         * @memberof proto.SyncActionMessageRange
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncActionMessageRange.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncActionMessageRange;
    })();

    proto.SyncActionMessage = (function() {

        /**
         * Properties of a SyncActionMessage.
         * @memberof proto
         * @interface ISyncActionMessage
         * @property {proto.IMessageKey|null} [key] SyncActionMessage key
         * @property {number|Long|null} [timestamp] SyncActionMessage timestamp
         */

        /**
         * Constructs a new SyncActionMessage.
         * @memberof proto
         * @classdesc Represents a SyncActionMessage.
         * @implements ISyncActionMessage
         * @constructor
         * @param {proto.ISyncActionMessage=} [properties] Properties to set
         */
        function SyncActionMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncActionMessage key.
         * @member {proto.IMessageKey|null|undefined} key
         * @memberof proto.SyncActionMessage
         * @instance
         */
        SyncActionMessage.prototype.key = null;

        /**
         * SyncActionMessage timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.SyncActionMessage
         * @instance
         */
        SyncActionMessage.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new SyncActionMessage instance using the specified properties.
         * @function create
         * @memberof proto.SyncActionMessage
         * @static
         * @param {proto.ISyncActionMessage=} [properties] Properties to set
         * @returns {proto.SyncActionMessage} SyncActionMessage instance
         */
        SyncActionMessage.create = function create(properties) {
            return new SyncActionMessage(properties);
        };

        /**
         * Encodes the specified SyncActionMessage message. Does not implicitly {@link proto.SyncActionMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncActionMessage
         * @static
         * @param {proto.ISyncActionMessage} message SyncActionMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                $root.proto.MessageKey.encode(message.key, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified SyncActionMessage message, length delimited. Does not implicitly {@link proto.SyncActionMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncActionMessage
         * @static
         * @param {proto.ISyncActionMessage} message SyncActionMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncActionMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncActionMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncActionMessage} SyncActionMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncActionMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.key = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.timestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncActionMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncActionMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncActionMessage} SyncActionMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncActionMessage message.
         * @function verify
         * @memberof proto.SyncActionMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncActionMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                var error = $root.proto.MessageKey.verify(message.key);
                if (error)
                    return "key." + error;
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates a SyncActionMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncActionMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncActionMessage} SyncActionMessage
         */
        SyncActionMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncActionMessage)
                return object;
            var message = new $root.proto.SyncActionMessage();
            if (object.key != null) {
                if (typeof object.key !== "object")
                    throw TypeError(".proto.SyncActionMessage.key: object expected");
                message.key = $root.proto.MessageKey.fromObject(object.key);
            }
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a SyncActionMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncActionMessage
         * @static
         * @param {proto.SyncActionMessage} message SyncActionMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncActionMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.key = null;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            }
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = $root.proto.MessageKey.toObject(message.key, options);
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this SyncActionMessage to JSON.
         * @function toJSON
         * @memberof proto.SyncActionMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncActionMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncActionMessage;
    })();

    proto.KeyExpiration = (function() {

        /**
         * Properties of a KeyExpiration.
         * @memberof proto
         * @interface IKeyExpiration
         * @property {number|null} [expiredKeyEpoch] KeyExpiration expiredKeyEpoch
         */

        /**
         * Constructs a new KeyExpiration.
         * @memberof proto
         * @classdesc Represents a KeyExpiration.
         * @implements IKeyExpiration
         * @constructor
         * @param {proto.IKeyExpiration=} [properties] Properties to set
         */
        function KeyExpiration(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * KeyExpiration expiredKeyEpoch.
         * @member {number} expiredKeyEpoch
         * @memberof proto.KeyExpiration
         * @instance
         */
        KeyExpiration.prototype.expiredKeyEpoch = 0;

        /**
         * Creates a new KeyExpiration instance using the specified properties.
         * @function create
         * @memberof proto.KeyExpiration
         * @static
         * @param {proto.IKeyExpiration=} [properties] Properties to set
         * @returns {proto.KeyExpiration} KeyExpiration instance
         */
        KeyExpiration.create = function create(properties) {
            return new KeyExpiration(properties);
        };

        /**
         * Encodes the specified KeyExpiration message. Does not implicitly {@link proto.KeyExpiration.verify|verify} messages.
         * @function encode
         * @memberof proto.KeyExpiration
         * @static
         * @param {proto.IKeyExpiration} message KeyExpiration message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeyExpiration.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.expiredKeyEpoch != null && Object.hasOwnProperty.call(message, "expiredKeyEpoch"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.expiredKeyEpoch);
            return writer;
        };

        /**
         * Encodes the specified KeyExpiration message, length delimited. Does not implicitly {@link proto.KeyExpiration.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.KeyExpiration
         * @static
         * @param {proto.IKeyExpiration} message KeyExpiration message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeyExpiration.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a KeyExpiration message from the specified reader or buffer.
         * @function decode
         * @memberof proto.KeyExpiration
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.KeyExpiration} KeyExpiration
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeyExpiration.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.KeyExpiration();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.expiredKeyEpoch = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a KeyExpiration message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.KeyExpiration
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.KeyExpiration} KeyExpiration
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeyExpiration.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a KeyExpiration message.
         * @function verify
         * @memberof proto.KeyExpiration
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        KeyExpiration.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.expiredKeyEpoch != null && message.hasOwnProperty("expiredKeyEpoch"))
                if (!$util.isInteger(message.expiredKeyEpoch))
                    return "expiredKeyEpoch: integer expected";
            return null;
        };

        /**
         * Creates a KeyExpiration message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.KeyExpiration
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.KeyExpiration} KeyExpiration
         */
        KeyExpiration.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.KeyExpiration)
                return object;
            var message = new $root.proto.KeyExpiration();
            if (object.expiredKeyEpoch != null)
                message.expiredKeyEpoch = object.expiredKeyEpoch | 0;
            return message;
        };

        /**
         * Creates a plain object from a KeyExpiration message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.KeyExpiration
         * @static
         * @param {proto.KeyExpiration} message KeyExpiration
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        KeyExpiration.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.expiredKeyEpoch = 0;
            if (message.expiredKeyEpoch != null && message.hasOwnProperty("expiredKeyEpoch"))
                object.expiredKeyEpoch = message.expiredKeyEpoch;
            return object;
        };

        /**
         * Converts this KeyExpiration to JSON.
         * @function toJSON
         * @memberof proto.KeyExpiration
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        KeyExpiration.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return KeyExpiration;
    })();

    proto.PrimaryFeature = (function() {

        /**
         * Properties of a PrimaryFeature.
         * @memberof proto
         * @interface IPrimaryFeature
         * @property {Array.<string>|null} [flags] PrimaryFeature flags
         */

        /**
         * Constructs a new PrimaryFeature.
         * @memberof proto
         * @classdesc Represents a PrimaryFeature.
         * @implements IPrimaryFeature
         * @constructor
         * @param {proto.IPrimaryFeature=} [properties] Properties to set
         */
        function PrimaryFeature(properties) {
            this.flags = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PrimaryFeature flags.
         * @member {Array.<string>} flags
         * @memberof proto.PrimaryFeature
         * @instance
         */
        PrimaryFeature.prototype.flags = $util.emptyArray;

        /**
         * Creates a new PrimaryFeature instance using the specified properties.
         * @function create
         * @memberof proto.PrimaryFeature
         * @static
         * @param {proto.IPrimaryFeature=} [properties] Properties to set
         * @returns {proto.PrimaryFeature} PrimaryFeature instance
         */
        PrimaryFeature.create = function create(properties) {
            return new PrimaryFeature(properties);
        };

        /**
         * Encodes the specified PrimaryFeature message. Does not implicitly {@link proto.PrimaryFeature.verify|verify} messages.
         * @function encode
         * @memberof proto.PrimaryFeature
         * @static
         * @param {proto.IPrimaryFeature} message PrimaryFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PrimaryFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.flags != null && message.flags.length)
                for (var i = 0; i < message.flags.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.flags[i]);
            return writer;
        };

        /**
         * Encodes the specified PrimaryFeature message, length delimited. Does not implicitly {@link proto.PrimaryFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.PrimaryFeature
         * @static
         * @param {proto.IPrimaryFeature} message PrimaryFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PrimaryFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PrimaryFeature message from the specified reader or buffer.
         * @function decode
         * @memberof proto.PrimaryFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.PrimaryFeature} PrimaryFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PrimaryFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.PrimaryFeature();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.flags && message.flags.length))
                        message.flags = [];
                    message.flags.push(reader.string());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PrimaryFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.PrimaryFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.PrimaryFeature} PrimaryFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PrimaryFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PrimaryFeature message.
         * @function verify
         * @memberof proto.PrimaryFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PrimaryFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.flags != null && message.hasOwnProperty("flags")) {
                if (!Array.isArray(message.flags))
                    return "flags: array expected";
                for (var i = 0; i < message.flags.length; ++i)
                    if (!$util.isString(message.flags[i]))
                        return "flags: string[] expected";
            }
            return null;
        };

        /**
         * Creates a PrimaryFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.PrimaryFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.PrimaryFeature} PrimaryFeature
         */
        PrimaryFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.PrimaryFeature)
                return object;
            var message = new $root.proto.PrimaryFeature();
            if (object.flags) {
                if (!Array.isArray(object.flags))
                    throw TypeError(".proto.PrimaryFeature.flags: array expected");
                message.flags = [];
                for (var i = 0; i < object.flags.length; ++i)
                    message.flags[i] = String(object.flags[i]);
            }
            return message;
        };

        /**
         * Creates a plain object from a PrimaryFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.PrimaryFeature
         * @static
         * @param {proto.PrimaryFeature} message PrimaryFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PrimaryFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.flags = [];
            if (message.flags && message.flags.length) {
                object.flags = [];
                for (var j = 0; j < message.flags.length; ++j)
                    object.flags[j] = message.flags[j];
            }
            return object;
        };

        /**
         * Converts this PrimaryFeature to JSON.
         * @function toJSON
         * @memberof proto.PrimaryFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PrimaryFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PrimaryFeature;
    })();

    proto.AndroidUnsupportedActions = (function() {

        /**
         * Properties of an AndroidUnsupportedActions.
         * @memberof proto
         * @interface IAndroidUnsupportedActions
         * @property {boolean|null} [allowed] AndroidUnsupportedActions allowed
         */

        /**
         * Constructs a new AndroidUnsupportedActions.
         * @memberof proto
         * @classdesc Represents an AndroidUnsupportedActions.
         * @implements IAndroidUnsupportedActions
         * @constructor
         * @param {proto.IAndroidUnsupportedActions=} [properties] Properties to set
         */
        function AndroidUnsupportedActions(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AndroidUnsupportedActions allowed.
         * @member {boolean} allowed
         * @memberof proto.AndroidUnsupportedActions
         * @instance
         */
        AndroidUnsupportedActions.prototype.allowed = false;

        /**
         * Creates a new AndroidUnsupportedActions instance using the specified properties.
         * @function create
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.IAndroidUnsupportedActions=} [properties] Properties to set
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions instance
         */
        AndroidUnsupportedActions.create = function create(properties) {
            return new AndroidUnsupportedActions(properties);
        };

        /**
         * Encodes the specified AndroidUnsupportedActions message. Does not implicitly {@link proto.AndroidUnsupportedActions.verify|verify} messages.
         * @function encode
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.IAndroidUnsupportedActions} message AndroidUnsupportedActions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AndroidUnsupportedActions.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allowed != null && Object.hasOwnProperty.call(message, "allowed"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.allowed);
            return writer;
        };

        /**
         * Encodes the specified AndroidUnsupportedActions message, length delimited. Does not implicitly {@link proto.AndroidUnsupportedActions.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.IAndroidUnsupportedActions} message AndroidUnsupportedActions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AndroidUnsupportedActions.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AndroidUnsupportedActions message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AndroidUnsupportedActions.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AndroidUnsupportedActions();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.allowed = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AndroidUnsupportedActions message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AndroidUnsupportedActions.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AndroidUnsupportedActions message.
         * @function verify
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AndroidUnsupportedActions.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allowed != null && message.hasOwnProperty("allowed"))
                if (typeof message.allowed !== "boolean")
                    return "allowed: boolean expected";
            return null;
        };

        /**
         * Creates an AndroidUnsupportedActions message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions
         */
        AndroidUnsupportedActions.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AndroidUnsupportedActions)
                return object;
            var message = new $root.proto.AndroidUnsupportedActions();
            if (object.allowed != null)
                message.allowed = Boolean(object.allowed);
            return message;
        };

        /**
         * Creates a plain object from an AndroidUnsupportedActions message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.AndroidUnsupportedActions} message AndroidUnsupportedActions
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AndroidUnsupportedActions.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.allowed = false;
            if (message.allowed != null && message.hasOwnProperty("allowed"))
                object.allowed = message.allowed;
            return object;
        };

        /**
         * Converts this AndroidUnsupportedActions to JSON.
         * @function toJSON
         * @memberof proto.AndroidUnsupportedActions
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AndroidUnsupportedActions.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AndroidUnsupportedActions;
    })();

    proto.SyncActionValue = (function() {

        /**
         * Properties of a SyncActionValue.
         * @memberof proto
         * @interface ISyncActionValue
         * @property {number|Long|null} [timestamp] SyncActionValue timestamp
         * @property {proto.IStarAction|null} [starAction] SyncActionValue starAction
         * @property {proto.IContactAction|null} [contactAction] SyncActionValue contactAction
         * @property {proto.IMuteAction|null} [muteAction] SyncActionValue muteAction
         * @property {proto.IPinAction|null} [pinAction] SyncActionValue pinAction
         * @property {proto.ISecurityNotificationSetting|null} [securityNotificationSetting] SyncActionValue securityNotificationSetting
         * @property {proto.IPushNameSetting|null} [pushNameSetting] SyncActionValue pushNameSetting
         * @property {proto.IQuickReplyAction|null} [quickReplyAction] SyncActionValue quickReplyAction
         * @property {proto.IRecentStickerWeightsAction|null} [recentStickerWeightsAction] SyncActionValue recentStickerWeightsAction
         * @property {proto.IRecentStickerMetadata|null} [recentStickerMetadata] SyncActionValue recentStickerMetadata
         * @property {proto.IRecentEmojiWeightsAction|null} [recentEmojiWeightsAction] SyncActionValue recentEmojiWeightsAction
         * @property {proto.ILabelEditAction|null} [labelEditAction] SyncActionValue labelEditAction
         * @property {proto.ILabelAssociationAction|null} [labelAssociationAction] SyncActionValue labelAssociationAction
         * @property {proto.ILocaleSetting|null} [localeSetting] SyncActionValue localeSetting
         * @property {proto.IArchiveChatAction|null} [archiveChatAction] SyncActionValue archiveChatAction
         * @property {proto.IDeleteMessageForMeAction|null} [deleteMessageForMeAction] SyncActionValue deleteMessageForMeAction
         * @property {proto.IKeyExpiration|null} [keyExpiration] SyncActionValue keyExpiration
         * @property {proto.IMarkChatAsReadAction|null} [markChatAsReadAction] SyncActionValue markChatAsReadAction
         * @property {proto.IClearChatAction|null} [clearChatAction] SyncActionValue clearChatAction
         * @property {proto.IDeleteChatAction|null} [deleteChatAction] SyncActionValue deleteChatAction
         * @property {proto.IUnarchiveChatsSetting|null} [unarchiveChatsSetting] SyncActionValue unarchiveChatsSetting
         * @property {proto.IPrimaryFeature|null} [primaryFeature] SyncActionValue primaryFeature
         * @property {proto.IFavoriteStickerAction|null} [favoriteStickerAction] SyncActionValue favoriteStickerAction
         * @property {proto.IAndroidUnsupportedActions|null} [androidUnsupportedActions] SyncActionValue androidUnsupportedActions
         */

        /**
         * Constructs a new SyncActionValue.
         * @memberof proto
         * @classdesc Represents a SyncActionValue.
         * @implements ISyncActionValue
         * @constructor
         * @param {proto.ISyncActionValue=} [properties] Properties to set
         */
        function SyncActionValue(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncActionValue timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * SyncActionValue starAction.
         * @member {proto.IStarAction|null|undefined} starAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.starAction = null;

        /**
         * SyncActionValue contactAction.
         * @member {proto.IContactAction|null|undefined} contactAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.contactAction = null;

        /**
         * SyncActionValue muteAction.
         * @member {proto.IMuteAction|null|undefined} muteAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.muteAction = null;

        /**
         * SyncActionValue pinAction.
         * @member {proto.IPinAction|null|undefined} pinAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.pinAction = null;

        /**
         * SyncActionValue securityNotificationSetting.
         * @member {proto.ISecurityNotificationSetting|null|undefined} securityNotificationSetting
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.securityNotificationSetting = null;

        /**
         * SyncActionValue pushNameSetting.
         * @member {proto.IPushNameSetting|null|undefined} pushNameSetting
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.pushNameSetting = null;

        /**
         * SyncActionValue quickReplyAction.
         * @member {proto.IQuickReplyAction|null|undefined} quickReplyAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.quickReplyAction = null;

        /**
         * SyncActionValue recentStickerWeightsAction.
         * @member {proto.IRecentStickerWeightsAction|null|undefined} recentStickerWeightsAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.recentStickerWeightsAction = null;

        /**
         * SyncActionValue recentStickerMetadata.
         * @member {proto.IRecentStickerMetadata|null|undefined} recentStickerMetadata
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.recentStickerMetadata = null;

        /**
         * SyncActionValue recentEmojiWeightsAction.
         * @member {proto.IRecentEmojiWeightsAction|null|undefined} recentEmojiWeightsAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.recentEmojiWeightsAction = null;

        /**
         * SyncActionValue labelEditAction.
         * @member {proto.ILabelEditAction|null|undefined} labelEditAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.labelEditAction = null;

        /**
         * SyncActionValue labelAssociationAction.
         * @member {proto.ILabelAssociationAction|null|undefined} labelAssociationAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.labelAssociationAction = null;

        /**
         * SyncActionValue localeSetting.
         * @member {proto.ILocaleSetting|null|undefined} localeSetting
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.localeSetting = null;

        /**
         * SyncActionValue archiveChatAction.
         * @member {proto.IArchiveChatAction|null|undefined} archiveChatAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.archiveChatAction = null;

        /**
         * SyncActionValue deleteMessageForMeAction.
         * @member {proto.IDeleteMessageForMeAction|null|undefined} deleteMessageForMeAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.deleteMessageForMeAction = null;

        /**
         * SyncActionValue keyExpiration.
         * @member {proto.IKeyExpiration|null|undefined} keyExpiration
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.keyExpiration = null;

        /**
         * SyncActionValue markChatAsReadAction.
         * @member {proto.IMarkChatAsReadAction|null|undefined} markChatAsReadAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.markChatAsReadAction = null;

        /**
         * SyncActionValue clearChatAction.
         * @member {proto.IClearChatAction|null|undefined} clearChatAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.clearChatAction = null;

        /**
         * SyncActionValue deleteChatAction.
         * @member {proto.IDeleteChatAction|null|undefined} deleteChatAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.deleteChatAction = null;

        /**
         * SyncActionValue unarchiveChatsSetting.
         * @member {proto.IUnarchiveChatsSetting|null|undefined} unarchiveChatsSetting
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.unarchiveChatsSetting = null;

        /**
         * SyncActionValue primaryFeature.
         * @member {proto.IPrimaryFeature|null|undefined} primaryFeature
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.primaryFeature = null;

        /**
         * SyncActionValue favoriteStickerAction.
         * @member {proto.IFavoriteStickerAction|null|undefined} favoriteStickerAction
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.favoriteStickerAction = null;

        /**
         * SyncActionValue androidUnsupportedActions.
         * @member {proto.IAndroidUnsupportedActions|null|undefined} androidUnsupportedActions
         * @memberof proto.SyncActionValue
         * @instance
         */
        SyncActionValue.prototype.androidUnsupportedActions = null;

        /**
         * Creates a new SyncActionValue instance using the specified properties.
         * @function create
         * @memberof proto.SyncActionValue
         * @static
         * @param {proto.ISyncActionValue=} [properties] Properties to set
         * @returns {proto.SyncActionValue} SyncActionValue instance
         */
        SyncActionValue.create = function create(properties) {
            return new SyncActionValue(properties);
        };

        /**
         * Encodes the specified SyncActionValue message. Does not implicitly {@link proto.SyncActionValue.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncActionValue
         * @static
         * @param {proto.ISyncActionValue} message SyncActionValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionValue.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.timestamp);
            if (message.starAction != null && Object.hasOwnProperty.call(message, "starAction"))
                $root.proto.StarAction.encode(message.starAction, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.contactAction != null && Object.hasOwnProperty.call(message, "contactAction"))
                $root.proto.ContactAction.encode(message.contactAction, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.muteAction != null && Object.hasOwnProperty.call(message, "muteAction"))
                $root.proto.MuteAction.encode(message.muteAction, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.pinAction != null && Object.hasOwnProperty.call(message, "pinAction"))
                $root.proto.PinAction.encode(message.pinAction, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.securityNotificationSetting != null && Object.hasOwnProperty.call(message, "securityNotificationSetting"))
                $root.proto.SecurityNotificationSetting.encode(message.securityNotificationSetting, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.pushNameSetting != null && Object.hasOwnProperty.call(message, "pushNameSetting"))
                $root.proto.PushNameSetting.encode(message.pushNameSetting, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.quickReplyAction != null && Object.hasOwnProperty.call(message, "quickReplyAction"))
                $root.proto.QuickReplyAction.encode(message.quickReplyAction, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.recentStickerWeightsAction != null && Object.hasOwnProperty.call(message, "recentStickerWeightsAction"))
                $root.proto.RecentStickerWeightsAction.encode(message.recentStickerWeightsAction, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.recentStickerMetadata != null && Object.hasOwnProperty.call(message, "recentStickerMetadata"))
                $root.proto.RecentStickerMetadata.encode(message.recentStickerMetadata, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
            if (message.recentEmojiWeightsAction != null && Object.hasOwnProperty.call(message, "recentEmojiWeightsAction"))
                $root.proto.RecentEmojiWeightsAction.encode(message.recentEmojiWeightsAction, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
            if (message.labelEditAction != null && Object.hasOwnProperty.call(message, "labelEditAction"))
                $root.proto.LabelEditAction.encode(message.labelEditAction, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
            if (message.labelAssociationAction != null && Object.hasOwnProperty.call(message, "labelAssociationAction"))
                $root.proto.LabelAssociationAction.encode(message.labelAssociationAction, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            if (message.localeSetting != null && Object.hasOwnProperty.call(message, "localeSetting"))
                $root.proto.LocaleSetting.encode(message.localeSetting, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
            if (message.archiveChatAction != null && Object.hasOwnProperty.call(message, "archiveChatAction"))
                $root.proto.ArchiveChatAction.encode(message.archiveChatAction, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.deleteMessageForMeAction != null && Object.hasOwnProperty.call(message, "deleteMessageForMeAction"))
                $root.proto.DeleteMessageForMeAction.encode(message.deleteMessageForMeAction, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
            if (message.keyExpiration != null && Object.hasOwnProperty.call(message, "keyExpiration"))
                $root.proto.KeyExpiration.encode(message.keyExpiration, writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
            if (message.markChatAsReadAction != null && Object.hasOwnProperty.call(message, "markChatAsReadAction"))
                $root.proto.MarkChatAsReadAction.encode(message.markChatAsReadAction, writer.uint32(/* id 20, wireType 2 =*/162).fork()).ldelim();
            if (message.clearChatAction != null && Object.hasOwnProperty.call(message, "clearChatAction"))
                $root.proto.ClearChatAction.encode(message.clearChatAction, writer.uint32(/* id 21, wireType 2 =*/170).fork()).ldelim();
            if (message.deleteChatAction != null && Object.hasOwnProperty.call(message, "deleteChatAction"))
                $root.proto.DeleteChatAction.encode(message.deleteChatAction, writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
            if (message.unarchiveChatsSetting != null && Object.hasOwnProperty.call(message, "unarchiveChatsSetting"))
                $root.proto.UnarchiveChatsSetting.encode(message.unarchiveChatsSetting, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
            if (message.primaryFeature != null && Object.hasOwnProperty.call(message, "primaryFeature"))
                $root.proto.PrimaryFeature.encode(message.primaryFeature, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
            if (message.favoriteStickerAction != null && Object.hasOwnProperty.call(message, "favoriteStickerAction"))
                $root.proto.FavoriteStickerAction.encode(message.favoriteStickerAction, writer.uint32(/* id 25, wireType 2 =*/202).fork()).ldelim();
            if (message.androidUnsupportedActions != null && Object.hasOwnProperty.call(message, "androidUnsupportedActions"))
                $root.proto.AndroidUnsupportedActions.encode(message.androidUnsupportedActions, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified SyncActionValue message, length delimited. Does not implicitly {@link proto.SyncActionValue.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncActionValue
         * @static
         * @param {proto.ISyncActionValue} message SyncActionValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncActionValue.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncActionValue message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncActionValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncActionValue} SyncActionValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionValue.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncActionValue();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.timestamp = reader.int64();
                    break;
                case 2:
                    message.starAction = $root.proto.StarAction.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.contactAction = $root.proto.ContactAction.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.muteAction = $root.proto.MuteAction.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.pinAction = $root.proto.PinAction.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.securityNotificationSetting = $root.proto.SecurityNotificationSetting.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.pushNameSetting = $root.proto.PushNameSetting.decode(reader, reader.uint32());
                    break;
                case 8:
                    message.quickReplyAction = $root.proto.QuickReplyAction.decode(reader, reader.uint32());
                    break;
                case 9:
                    message.recentStickerWeightsAction = $root.proto.RecentStickerWeightsAction.decode(reader, reader.uint32());
                    break;
                case 10:
                    message.recentStickerMetadata = $root.proto.RecentStickerMetadata.decode(reader, reader.uint32());
                    break;
                case 11:
                    message.recentEmojiWeightsAction = $root.proto.RecentEmojiWeightsAction.decode(reader, reader.uint32());
                    break;
                case 14:
                    message.labelEditAction = $root.proto.LabelEditAction.decode(reader, reader.uint32());
                    break;
                case 15:
                    message.labelAssociationAction = $root.proto.LabelAssociationAction.decode(reader, reader.uint32());
                    break;
                case 16:
                    message.localeSetting = $root.proto.LocaleSetting.decode(reader, reader.uint32());
                    break;
                case 17:
                    message.archiveChatAction = $root.proto.ArchiveChatAction.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.deleteMessageForMeAction = $root.proto.DeleteMessageForMeAction.decode(reader, reader.uint32());
                    break;
                case 19:
                    message.keyExpiration = $root.proto.KeyExpiration.decode(reader, reader.uint32());
                    break;
                case 20:
                    message.markChatAsReadAction = $root.proto.MarkChatAsReadAction.decode(reader, reader.uint32());
                    break;
                case 21:
                    message.clearChatAction = $root.proto.ClearChatAction.decode(reader, reader.uint32());
                    break;
                case 22:
                    message.deleteChatAction = $root.proto.DeleteChatAction.decode(reader, reader.uint32());
                    break;
                case 23:
                    message.unarchiveChatsSetting = $root.proto.UnarchiveChatsSetting.decode(reader, reader.uint32());
                    break;
                case 24:
                    message.primaryFeature = $root.proto.PrimaryFeature.decode(reader, reader.uint32());
                    break;
                case 25:
                    message.favoriteStickerAction = $root.proto.FavoriteStickerAction.decode(reader, reader.uint32());
                    break;
                case 26:
                    message.androidUnsupportedActions = $root.proto.AndroidUnsupportedActions.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncActionValue message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncActionValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncActionValue} SyncActionValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncActionValue.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncActionValue message.
         * @function verify
         * @memberof proto.SyncActionValue
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncActionValue.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.starAction != null && message.hasOwnProperty("starAction")) {
                var error = $root.proto.StarAction.verify(message.starAction);
                if (error)
                    return "starAction." + error;
            }
            if (message.contactAction != null && message.hasOwnProperty("contactAction")) {
                var error = $root.proto.ContactAction.verify(message.contactAction);
                if (error)
                    return "contactAction." + error;
            }
            if (message.muteAction != null && message.hasOwnProperty("muteAction")) {
                var error = $root.proto.MuteAction.verify(message.muteAction);
                if (error)
                    return "muteAction." + error;
            }
            if (message.pinAction != null && message.hasOwnProperty("pinAction")) {
                var error = $root.proto.PinAction.verify(message.pinAction);
                if (error)
                    return "pinAction." + error;
            }
            if (message.securityNotificationSetting != null && message.hasOwnProperty("securityNotificationSetting")) {
                var error = $root.proto.SecurityNotificationSetting.verify(message.securityNotificationSetting);
                if (error)
                    return "securityNotificationSetting." + error;
            }
            if (message.pushNameSetting != null && message.hasOwnProperty("pushNameSetting")) {
                var error = $root.proto.PushNameSetting.verify(message.pushNameSetting);
                if (error)
                    return "pushNameSetting." + error;
            }
            if (message.quickReplyAction != null && message.hasOwnProperty("quickReplyAction")) {
                var error = $root.proto.QuickReplyAction.verify(message.quickReplyAction);
                if (error)
                    return "quickReplyAction." + error;
            }
            if (message.recentStickerWeightsAction != null && message.hasOwnProperty("recentStickerWeightsAction")) {
                var error = $root.proto.RecentStickerWeightsAction.verify(message.recentStickerWeightsAction);
                if (error)
                    return "recentStickerWeightsAction." + error;
            }
            if (message.recentStickerMetadata != null && message.hasOwnProperty("recentStickerMetadata")) {
                var error = $root.proto.RecentStickerMetadata.verify(message.recentStickerMetadata);
                if (error)
                    return "recentStickerMetadata." + error;
            }
            if (message.recentEmojiWeightsAction != null && message.hasOwnProperty("recentEmojiWeightsAction")) {
                var error = $root.proto.RecentEmojiWeightsAction.verify(message.recentEmojiWeightsAction);
                if (error)
                    return "recentEmojiWeightsAction." + error;
            }
            if (message.labelEditAction != null && message.hasOwnProperty("labelEditAction")) {
                var error = $root.proto.LabelEditAction.verify(message.labelEditAction);
                if (error)
                    return "labelEditAction." + error;
            }
            if (message.labelAssociationAction != null && message.hasOwnProperty("labelAssociationAction")) {
                var error = $root.proto.LabelAssociationAction.verify(message.labelAssociationAction);
                if (error)
                    return "labelAssociationAction." + error;
            }
            if (message.localeSetting != null && message.hasOwnProperty("localeSetting")) {
                var error = $root.proto.LocaleSetting.verify(message.localeSetting);
                if (error)
                    return "localeSetting." + error;
            }
            if (message.archiveChatAction != null && message.hasOwnProperty("archiveChatAction")) {
                var error = $root.proto.ArchiveChatAction.verify(message.archiveChatAction);
                if (error)
                    return "archiveChatAction." + error;
            }
            if (message.deleteMessageForMeAction != null && message.hasOwnProperty("deleteMessageForMeAction")) {
                var error = $root.proto.DeleteMessageForMeAction.verify(message.deleteMessageForMeAction);
                if (error)
                    return "deleteMessageForMeAction." + error;
            }
            if (message.keyExpiration != null && message.hasOwnProperty("keyExpiration")) {
                var error = $root.proto.KeyExpiration.verify(message.keyExpiration);
                if (error)
                    return "keyExpiration." + error;
            }
            if (message.markChatAsReadAction != null && message.hasOwnProperty("markChatAsReadAction")) {
                var error = $root.proto.MarkChatAsReadAction.verify(message.markChatAsReadAction);
                if (error)
                    return "markChatAsReadAction." + error;
            }
            if (message.clearChatAction != null && message.hasOwnProperty("clearChatAction")) {
                var error = $root.proto.ClearChatAction.verify(message.clearChatAction);
                if (error)
                    return "clearChatAction." + error;
            }
            if (message.deleteChatAction != null && message.hasOwnProperty("deleteChatAction")) {
                var error = $root.proto.DeleteChatAction.verify(message.deleteChatAction);
                if (error)
                    return "deleteChatAction." + error;
            }
            if (message.unarchiveChatsSetting != null && message.hasOwnProperty("unarchiveChatsSetting")) {
                var error = $root.proto.UnarchiveChatsSetting.verify(message.unarchiveChatsSetting);
                if (error)
                    return "unarchiveChatsSetting." + error;
            }
            if (message.primaryFeature != null && message.hasOwnProperty("primaryFeature")) {
                var error = $root.proto.PrimaryFeature.verify(message.primaryFeature);
                if (error)
                    return "primaryFeature." + error;
            }
            if (message.favoriteStickerAction != null && message.hasOwnProperty("favoriteStickerAction")) {
                var error = $root.proto.FavoriteStickerAction.verify(message.favoriteStickerAction);
                if (error)
                    return "favoriteStickerAction." + error;
            }
            if (message.androidUnsupportedActions != null && message.hasOwnProperty("androidUnsupportedActions")) {
                var error = $root.proto.AndroidUnsupportedActions.verify(message.androidUnsupportedActions);
                if (error)
                    return "androidUnsupportedActions." + error;
            }
            return null;
        };

        /**
         * Creates a SyncActionValue message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncActionValue
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncActionValue} SyncActionValue
         */
        SyncActionValue.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncActionValue)
                return object;
            var message = new $root.proto.SyncActionValue();
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            if (object.starAction != null) {
                if (typeof object.starAction !== "object")
                    throw TypeError(".proto.SyncActionValue.starAction: object expected");
                message.starAction = $root.proto.StarAction.fromObject(object.starAction);
            }
            if (object.contactAction != null) {
                if (typeof object.contactAction !== "object")
                    throw TypeError(".proto.SyncActionValue.contactAction: object expected");
                message.contactAction = $root.proto.ContactAction.fromObject(object.contactAction);
            }
            if (object.muteAction != null) {
                if (typeof object.muteAction !== "object")
                    throw TypeError(".proto.SyncActionValue.muteAction: object expected");
                message.muteAction = $root.proto.MuteAction.fromObject(object.muteAction);
            }
            if (object.pinAction != null) {
                if (typeof object.pinAction !== "object")
                    throw TypeError(".proto.SyncActionValue.pinAction: object expected");
                message.pinAction = $root.proto.PinAction.fromObject(object.pinAction);
            }
            if (object.securityNotificationSetting != null) {
                if (typeof object.securityNotificationSetting !== "object")
                    throw TypeError(".proto.SyncActionValue.securityNotificationSetting: object expected");
                message.securityNotificationSetting = $root.proto.SecurityNotificationSetting.fromObject(object.securityNotificationSetting);
            }
            if (object.pushNameSetting != null) {
                if (typeof object.pushNameSetting !== "object")
                    throw TypeError(".proto.SyncActionValue.pushNameSetting: object expected");
                message.pushNameSetting = $root.proto.PushNameSetting.fromObject(object.pushNameSetting);
            }
            if (object.quickReplyAction != null) {
                if (typeof object.quickReplyAction !== "object")
                    throw TypeError(".proto.SyncActionValue.quickReplyAction: object expected");
                message.quickReplyAction = $root.proto.QuickReplyAction.fromObject(object.quickReplyAction);
            }
            if (object.recentStickerWeightsAction != null) {
                if (typeof object.recentStickerWeightsAction !== "object")
                    throw TypeError(".proto.SyncActionValue.recentStickerWeightsAction: object expected");
                message.recentStickerWeightsAction = $root.proto.RecentStickerWeightsAction.fromObject(object.recentStickerWeightsAction);
            }
            if (object.recentStickerMetadata != null) {
                if (typeof object.recentStickerMetadata !== "object")
                    throw TypeError(".proto.SyncActionValue.recentStickerMetadata: object expected");
                message.recentStickerMetadata = $root.proto.RecentStickerMetadata.fromObject(object.recentStickerMetadata);
            }
            if (object.recentEmojiWeightsAction != null) {
                if (typeof object.recentEmojiWeightsAction !== "object")
                    throw TypeError(".proto.SyncActionValue.recentEmojiWeightsAction: object expected");
                message.recentEmojiWeightsAction = $root.proto.RecentEmojiWeightsAction.fromObject(object.recentEmojiWeightsAction);
            }
            if (object.labelEditAction != null) {
                if (typeof object.labelEditAction !== "object")
                    throw TypeError(".proto.SyncActionValue.labelEditAction: object expected");
                message.labelEditAction = $root.proto.LabelEditAction.fromObject(object.labelEditAction);
            }
            if (object.labelAssociationAction != null) {
                if (typeof object.labelAssociationAction !== "object")
                    throw TypeError(".proto.SyncActionValue.labelAssociationAction: object expected");
                message.labelAssociationAction = $root.proto.LabelAssociationAction.fromObject(object.labelAssociationAction);
            }
            if (object.localeSetting != null) {
                if (typeof object.localeSetting !== "object")
                    throw TypeError(".proto.SyncActionValue.localeSetting: object expected");
                message.localeSetting = $root.proto.LocaleSetting.fromObject(object.localeSetting);
            }
            if (object.archiveChatAction != null) {
                if (typeof object.archiveChatAction !== "object")
                    throw TypeError(".proto.SyncActionValue.archiveChatAction: object expected");
                message.archiveChatAction = $root.proto.ArchiveChatAction.fromObject(object.archiveChatAction);
            }
            if (object.deleteMessageForMeAction != null) {
                if (typeof object.deleteMessageForMeAction !== "object")
                    throw TypeError(".proto.SyncActionValue.deleteMessageForMeAction: object expected");
                message.deleteMessageForMeAction = $root.proto.DeleteMessageForMeAction.fromObject(object.deleteMessageForMeAction);
            }
            if (object.keyExpiration != null) {
                if (typeof object.keyExpiration !== "object")
                    throw TypeError(".proto.SyncActionValue.keyExpiration: object expected");
                message.keyExpiration = $root.proto.KeyExpiration.fromObject(object.keyExpiration);
            }
            if (object.markChatAsReadAction != null) {
                if (typeof object.markChatAsReadAction !== "object")
                    throw TypeError(".proto.SyncActionValue.markChatAsReadAction: object expected");
                message.markChatAsReadAction = $root.proto.MarkChatAsReadAction.fromObject(object.markChatAsReadAction);
            }
            if (object.clearChatAction != null) {
                if (typeof object.clearChatAction !== "object")
                    throw TypeError(".proto.SyncActionValue.clearChatAction: object expected");
                message.clearChatAction = $root.proto.ClearChatAction.fromObject(object.clearChatAction);
            }
            if (object.deleteChatAction != null) {
                if (typeof object.deleteChatAction !== "object")
                    throw TypeError(".proto.SyncActionValue.deleteChatAction: object expected");
                message.deleteChatAction = $root.proto.DeleteChatAction.fromObject(object.deleteChatAction);
            }
            if (object.unarchiveChatsSetting != null) {
                if (typeof object.unarchiveChatsSetting !== "object")
                    throw TypeError(".proto.SyncActionValue.unarchiveChatsSetting: object expected");
                message.unarchiveChatsSetting = $root.proto.UnarchiveChatsSetting.fromObject(object.unarchiveChatsSetting);
            }
            if (object.primaryFeature != null) {
                if (typeof object.primaryFeature !== "object")
                    throw TypeError(".proto.SyncActionValue.primaryFeature: object expected");
                message.primaryFeature = $root.proto.PrimaryFeature.fromObject(object.primaryFeature);
            }
            if (object.favoriteStickerAction != null) {
                if (typeof object.favoriteStickerAction !== "object")
                    throw TypeError(".proto.SyncActionValue.favoriteStickerAction: object expected");
                message.favoriteStickerAction = $root.proto.FavoriteStickerAction.fromObject(object.favoriteStickerAction);
            }
            if (object.androidUnsupportedActions != null) {
                if (typeof object.androidUnsupportedActions !== "object")
                    throw TypeError(".proto.SyncActionValue.androidUnsupportedActions: object expected");
                message.androidUnsupportedActions = $root.proto.AndroidUnsupportedActions.fromObject(object.androidUnsupportedActions);
            }
            return message;
        };

        /**
         * Creates a plain object from a SyncActionValue message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncActionValue
         * @static
         * @param {proto.SyncActionValue} message SyncActionValue
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncActionValue.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.starAction = null;
                object.contactAction = null;
                object.muteAction = null;
                object.pinAction = null;
                object.securityNotificationSetting = null;
                object.pushNameSetting = null;
                object.quickReplyAction = null;
                object.recentStickerWeightsAction = null;
                object.recentStickerMetadata = null;
                object.recentEmojiWeightsAction = null;
                object.labelEditAction = null;
                object.labelAssociationAction = null;
                object.localeSetting = null;
                object.archiveChatAction = null;
                object.deleteMessageForMeAction = null;
                object.keyExpiration = null;
                object.markChatAsReadAction = null;
                object.clearChatAction = null;
                object.deleteChatAction = null;
                object.unarchiveChatsSetting = null;
                object.primaryFeature = null;
                object.favoriteStickerAction = null;
                object.androidUnsupportedActions = null;
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            if (message.starAction != null && message.hasOwnProperty("starAction"))
                object.starAction = $root.proto.StarAction.toObject(message.starAction, options);
            if (message.contactAction != null && message.hasOwnProperty("contactAction"))
                object.contactAction = $root.proto.ContactAction.toObject(message.contactAction, options);
            if (message.muteAction != null && message.hasOwnProperty("muteAction"))
                object.muteAction = $root.proto.MuteAction.toObject(message.muteAction, options);
            if (message.pinAction != null && message.hasOwnProperty("pinAction"))
                object.pinAction = $root.proto.PinAction.toObject(message.pinAction, options);
            if (message.securityNotificationSetting != null && message.hasOwnProperty("securityNotificationSetting"))
                object.securityNotificationSetting = $root.proto.SecurityNotificationSetting.toObject(message.securityNotificationSetting, options);
            if (message.pushNameSetting != null && message.hasOwnProperty("pushNameSetting"))
                object.pushNameSetting = $root.proto.PushNameSetting.toObject(message.pushNameSetting, options);
            if (message.quickReplyAction != null && message.hasOwnProperty("quickReplyAction"))
                object.quickReplyAction = $root.proto.QuickReplyAction.toObject(message.quickReplyAction, options);
            if (message.recentStickerWeightsAction != null && message.hasOwnProperty("recentStickerWeightsAction"))
                object.recentStickerWeightsAction = $root.proto.RecentStickerWeightsAction.toObject(message.recentStickerWeightsAction, options);
            if (message.recentStickerMetadata != null && message.hasOwnProperty("recentStickerMetadata"))
                object.recentStickerMetadata = $root.proto.RecentStickerMetadata.toObject(message.recentStickerMetadata, options);
            if (message.recentEmojiWeightsAction != null && message.hasOwnProperty("recentEmojiWeightsAction"))
                object.recentEmojiWeightsAction = $root.proto.RecentEmojiWeightsAction.toObject(message.recentEmojiWeightsAction, options);
            if (message.labelEditAction != null && message.hasOwnProperty("labelEditAction"))
                object.labelEditAction = $root.proto.LabelEditAction.toObject(message.labelEditAction, options);
            if (message.labelAssociationAction != null && message.hasOwnProperty("labelAssociationAction"))
                object.labelAssociationAction = $root.proto.LabelAssociationAction.toObject(message.labelAssociationAction, options);
            if (message.localeSetting != null && message.hasOwnProperty("localeSetting"))
                object.localeSetting = $root.proto.LocaleSetting.toObject(message.localeSetting, options);
            if (message.archiveChatAction != null && message.hasOwnProperty("archiveChatAction"))
                object.archiveChatAction = $root.proto.ArchiveChatAction.toObject(message.archiveChatAction, options);
            if (message.deleteMessageForMeAction != null && message.hasOwnProperty("deleteMessageForMeAction"))
                object.deleteMessageForMeAction = $root.proto.DeleteMessageForMeAction.toObject(message.deleteMessageForMeAction, options);
            if (message.keyExpiration != null && message.hasOwnProperty("keyExpiration"))
                object.keyExpiration = $root.proto.KeyExpiration.toObject(message.keyExpiration, options);
            if (message.markChatAsReadAction != null && message.hasOwnProperty("markChatAsReadAction"))
                object.markChatAsReadAction = $root.proto.MarkChatAsReadAction.toObject(message.markChatAsReadAction, options);
            if (message.clearChatAction != null && message.hasOwnProperty("clearChatAction"))
                object.clearChatAction = $root.proto.ClearChatAction.toObject(message.clearChatAction, options);
            if (message.deleteChatAction != null && message.hasOwnProperty("deleteChatAction"))
                object.deleteChatAction = $root.proto.DeleteChatAction.toObject(message.deleteChatAction, options);
            if (message.unarchiveChatsSetting != null && message.hasOwnProperty("unarchiveChatsSetting"))
                object.unarchiveChatsSetting = $root.proto.UnarchiveChatsSetting.toObject(message.unarchiveChatsSetting, options);
            if (message.primaryFeature != null && message.hasOwnProperty("primaryFeature"))
                object.primaryFeature = $root.proto.PrimaryFeature.toObject(message.primaryFeature, options);
            if (message.favoriteStickerAction != null && message.hasOwnProperty("favoriteStickerAction"))
                object.favoriteStickerAction = $root.proto.FavoriteStickerAction.toObject(message.favoriteStickerAction, options);
            if (message.androidUnsupportedActions != null && message.hasOwnProperty("androidUnsupportedActions"))
                object.androidUnsupportedActions = $root.proto.AndroidUnsupportedActions.toObject(message.androidUnsupportedActions, options);
            return object;
        };

        /**
         * Converts this SyncActionValue to JSON.
         * @function toJSON
         * @memberof proto.SyncActionValue
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncActionValue.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncActionValue;
    })();

    proto.RecentEmojiWeight = (function() {

        /**
         * Properties of a RecentEmojiWeight.
         * @memberof proto
         * @interface IRecentEmojiWeight
         * @property {string|null} [emoji] RecentEmojiWeight emoji
         * @property {number|null} [weight] RecentEmojiWeight weight
         */

        /**
         * Constructs a new RecentEmojiWeight.
         * @memberof proto
         * @classdesc Represents a RecentEmojiWeight.
         * @implements IRecentEmojiWeight
         * @constructor
         * @param {proto.IRecentEmojiWeight=} [properties] Properties to set
         */
        function RecentEmojiWeight(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * RecentEmojiWeight emoji.
         * @member {string} emoji
         * @memberof proto.RecentEmojiWeight
         * @instance
         */
        RecentEmojiWeight.prototype.emoji = "";

        /**
         * RecentEmojiWeight weight.
         * @member {number} weight
         * @memberof proto.RecentEmojiWeight
         * @instance
         */
        RecentEmojiWeight.prototype.weight = 0;

        /**
         * Creates a new RecentEmojiWeight instance using the specified properties.
         * @function create
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {proto.IRecentEmojiWeight=} [properties] Properties to set
         * @returns {proto.RecentEmojiWeight} RecentEmojiWeight instance
         */
        RecentEmojiWeight.create = function create(properties) {
            return new RecentEmojiWeight(properties);
        };

        /**
         * Encodes the specified RecentEmojiWeight message. Does not implicitly {@link proto.RecentEmojiWeight.verify|verify} messages.
         * @function encode
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {proto.IRecentEmojiWeight} message RecentEmojiWeight message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentEmojiWeight.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.emoji != null && Object.hasOwnProperty.call(message, "emoji"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.emoji);
            if (message.weight != null && Object.hasOwnProperty.call(message, "weight"))
                writer.uint32(/* id 2, wireType 5 =*/21).float(message.weight);
            return writer;
        };

        /**
         * Encodes the specified RecentEmojiWeight message, length delimited. Does not implicitly {@link proto.RecentEmojiWeight.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {proto.IRecentEmojiWeight} message RecentEmojiWeight message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentEmojiWeight.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RecentEmojiWeight message from the specified reader or buffer.
         * @function decode
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.RecentEmojiWeight} RecentEmojiWeight
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentEmojiWeight.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.RecentEmojiWeight();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.emoji = reader.string();
                    break;
                case 2:
                    message.weight = reader.float();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RecentEmojiWeight message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.RecentEmojiWeight} RecentEmojiWeight
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentEmojiWeight.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RecentEmojiWeight message.
         * @function verify
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RecentEmojiWeight.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.emoji != null && message.hasOwnProperty("emoji"))
                if (!$util.isString(message.emoji))
                    return "emoji: string expected";
            if (message.weight != null && message.hasOwnProperty("weight"))
                if (typeof message.weight !== "number")
                    return "weight: number expected";
            return null;
        };

        /**
         * Creates a RecentEmojiWeight message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.RecentEmojiWeight} RecentEmojiWeight
         */
        RecentEmojiWeight.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.RecentEmojiWeight)
                return object;
            var message = new $root.proto.RecentEmojiWeight();
            if (object.emoji != null)
                message.emoji = String(object.emoji);
            if (object.weight != null)
                message.weight = Number(object.weight);
            return message;
        };

        /**
         * Creates a plain object from a RecentEmojiWeight message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.RecentEmojiWeight
         * @static
         * @param {proto.RecentEmojiWeight} message RecentEmojiWeight
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RecentEmojiWeight.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.emoji = "";
                object.weight = 0;
            }
            if (message.emoji != null && message.hasOwnProperty("emoji"))
                object.emoji = message.emoji;
            if (message.weight != null && message.hasOwnProperty("weight"))
                object.weight = options.json && !isFinite(message.weight) ? String(message.weight) : message.weight;
            return object;
        };

        /**
         * Converts this RecentEmojiWeight to JSON.
         * @function toJSON
         * @memberof proto.RecentEmojiWeight
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RecentEmojiWeight.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RecentEmojiWeight;
    })();

    proto.RecentStickerWeight = (function() {

        /**
         * Properties of a RecentStickerWeight.
         * @memberof proto
         * @interface IRecentStickerWeight
         * @property {string|null} [filehash] RecentStickerWeight filehash
         * @property {number|null} [weight] RecentStickerWeight weight
         */

        /**
         * Constructs a new RecentStickerWeight.
         * @memberof proto
         * @classdesc Represents a RecentStickerWeight.
         * @implements IRecentStickerWeight
         * @constructor
         * @param {proto.IRecentStickerWeight=} [properties] Properties to set
         */
        function RecentStickerWeight(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * RecentStickerWeight filehash.
         * @member {string} filehash
         * @memberof proto.RecentStickerWeight
         * @instance
         */
        RecentStickerWeight.prototype.filehash = "";

        /**
         * RecentStickerWeight weight.
         * @member {number} weight
         * @memberof proto.RecentStickerWeight
         * @instance
         */
        RecentStickerWeight.prototype.weight = 0;

        /**
         * Creates a new RecentStickerWeight instance using the specified properties.
         * @function create
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {proto.IRecentStickerWeight=} [properties] Properties to set
         * @returns {proto.RecentStickerWeight} RecentStickerWeight instance
         */
        RecentStickerWeight.create = function create(properties) {
            return new RecentStickerWeight(properties);
        };

        /**
         * Encodes the specified RecentStickerWeight message. Does not implicitly {@link proto.RecentStickerWeight.verify|verify} messages.
         * @function encode
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {proto.IRecentStickerWeight} message RecentStickerWeight message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentStickerWeight.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.filehash != null && Object.hasOwnProperty.call(message, "filehash"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.filehash);
            if (message.weight != null && Object.hasOwnProperty.call(message, "weight"))
                writer.uint32(/* id 2, wireType 5 =*/21).float(message.weight);
            return writer;
        };

        /**
         * Encodes the specified RecentStickerWeight message, length delimited. Does not implicitly {@link proto.RecentStickerWeight.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {proto.IRecentStickerWeight} message RecentStickerWeight message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RecentStickerWeight.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RecentStickerWeight message from the specified reader or buffer.
         * @function decode
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.RecentStickerWeight} RecentStickerWeight
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentStickerWeight.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.RecentStickerWeight();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.filehash = reader.string();
                    break;
                case 2:
                    message.weight = reader.float();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RecentStickerWeight message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.RecentStickerWeight} RecentStickerWeight
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RecentStickerWeight.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RecentStickerWeight message.
         * @function verify
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RecentStickerWeight.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.filehash != null && message.hasOwnProperty("filehash"))
                if (!$util.isString(message.filehash))
                    return "filehash: string expected";
            if (message.weight != null && message.hasOwnProperty("weight"))
                if (typeof message.weight !== "number")
                    return "weight: number expected";
            return null;
        };

        /**
         * Creates a RecentStickerWeight message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.RecentStickerWeight} RecentStickerWeight
         */
        RecentStickerWeight.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.RecentStickerWeight)
                return object;
            var message = new $root.proto.RecentStickerWeight();
            if (object.filehash != null)
                message.filehash = String(object.filehash);
            if (object.weight != null)
                message.weight = Number(object.weight);
            return message;
        };

        /**
         * Creates a plain object from a RecentStickerWeight message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.RecentStickerWeight
         * @static
         * @param {proto.RecentStickerWeight} message RecentStickerWeight
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RecentStickerWeight.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.filehash = "";
                object.weight = 0;
            }
            if (message.filehash != null && message.hasOwnProperty("filehash"))
                object.filehash = message.filehash;
            if (message.weight != null && message.hasOwnProperty("weight"))
                object.weight = options.json && !isFinite(message.weight) ? String(message.weight) : message.weight;
            return object;
        };

        /**
         * Converts this RecentStickerWeight to JSON.
         * @function toJSON
         * @memberof proto.RecentStickerWeight
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RecentStickerWeight.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RecentStickerWeight;
    })();

    proto.SyncdPatch = (function() {

        /**
         * Properties of a SyncdPatch.
         * @memberof proto
         * @interface ISyncdPatch
         * @property {proto.ISyncdVersion|null} [version] SyncdPatch version
         * @property {Array.<proto.ISyncdMutation>|null} [mutations] SyncdPatch mutations
         * @property {proto.IExternalBlobReference|null} [externalMutations] SyncdPatch externalMutations
         * @property {Uint8Array|null} [snapshotMac] SyncdPatch snapshotMac
         * @property {Uint8Array|null} [patchMac] SyncdPatch patchMac
         * @property {proto.IKeyId|null} [keyId] SyncdPatch keyId
         * @property {proto.IExitCode|null} [exitCode] SyncdPatch exitCode
         * @property {number|null} [deviceIndex] SyncdPatch deviceIndex
         */

        /**
         * Constructs a new SyncdPatch.
         * @memberof proto
         * @classdesc Represents a SyncdPatch.
         * @implements ISyncdPatch
         * @constructor
         * @param {proto.ISyncdPatch=} [properties] Properties to set
         */
        function SyncdPatch(properties) {
            this.mutations = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdPatch version.
         * @member {proto.ISyncdVersion|null|undefined} version
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.version = null;

        /**
         * SyncdPatch mutations.
         * @member {Array.<proto.ISyncdMutation>} mutations
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.mutations = $util.emptyArray;

        /**
         * SyncdPatch externalMutations.
         * @member {proto.IExternalBlobReference|null|undefined} externalMutations
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.externalMutations = null;

        /**
         * SyncdPatch snapshotMac.
         * @member {Uint8Array} snapshotMac
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.snapshotMac = $util.newBuffer([]);

        /**
         * SyncdPatch patchMac.
         * @member {Uint8Array} patchMac
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.patchMac = $util.newBuffer([]);

        /**
         * SyncdPatch keyId.
         * @member {proto.IKeyId|null|undefined} keyId
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.keyId = null;

        /**
         * SyncdPatch exitCode.
         * @member {proto.IExitCode|null|undefined} exitCode
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.exitCode = null;

        /**
         * SyncdPatch deviceIndex.
         * @member {number} deviceIndex
         * @memberof proto.SyncdPatch
         * @instance
         */
        SyncdPatch.prototype.deviceIndex = 0;

        /**
         * Creates a new SyncdPatch instance using the specified properties.
         * @function create
         * @memberof proto.SyncdPatch
         * @static
         * @param {proto.ISyncdPatch=} [properties] Properties to set
         * @returns {proto.SyncdPatch} SyncdPatch instance
         */
        SyncdPatch.create = function create(properties) {
            return new SyncdPatch(properties);
        };

        /**
         * Encodes the specified SyncdPatch message. Does not implicitly {@link proto.SyncdPatch.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdPatch
         * @static
         * @param {proto.ISyncdPatch} message SyncdPatch message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdPatch.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                $root.proto.SyncdVersion.encode(message.version, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.mutations != null && message.mutations.length)
                for (var i = 0; i < message.mutations.length; ++i)
                    $root.proto.SyncdMutation.encode(message.mutations[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.externalMutations != null && Object.hasOwnProperty.call(message, "externalMutations"))
                $root.proto.ExternalBlobReference.encode(message.externalMutations, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.snapshotMac != null && Object.hasOwnProperty.call(message, "snapshotMac"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.snapshotMac);
            if (message.patchMac != null && Object.hasOwnProperty.call(message, "patchMac"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.patchMac);
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                $root.proto.KeyId.encode(message.keyId, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.exitCode != null && Object.hasOwnProperty.call(message, "exitCode"))
                $root.proto.ExitCode.encode(message.exitCode, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.deviceIndex != null && Object.hasOwnProperty.call(message, "deviceIndex"))
                writer.uint32(/* id 8, wireType 0 =*/64).uint32(message.deviceIndex);
            return writer;
        };

        /**
         * Encodes the specified SyncdPatch message, length delimited. Does not implicitly {@link proto.SyncdPatch.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdPatch
         * @static
         * @param {proto.ISyncdPatch} message SyncdPatch message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdPatch.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdPatch message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdPatch
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdPatch} SyncdPatch
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdPatch.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdPatch();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.version = $root.proto.SyncdVersion.decode(reader, reader.uint32());
                    break;
                case 2:
                    if (!(message.mutations && message.mutations.length))
                        message.mutations = [];
                    message.mutations.push($root.proto.SyncdMutation.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.externalMutations = $root.proto.ExternalBlobReference.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.snapshotMac = reader.bytes();
                    break;
                case 5:
                    message.patchMac = reader.bytes();
                    break;
                case 6:
                    message.keyId = $root.proto.KeyId.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.exitCode = $root.proto.ExitCode.decode(reader, reader.uint32());
                    break;
                case 8:
                    message.deviceIndex = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdPatch message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdPatch
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdPatch} SyncdPatch
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdPatch.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdPatch message.
         * @function verify
         * @memberof proto.SyncdPatch
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdPatch.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.version != null && message.hasOwnProperty("version")) {
                var error = $root.proto.SyncdVersion.verify(message.version);
                if (error)
                    return "version." + error;
            }
            if (message.mutations != null && message.hasOwnProperty("mutations")) {
                if (!Array.isArray(message.mutations))
                    return "mutations: array expected";
                for (var i = 0; i < message.mutations.length; ++i) {
                    var error = $root.proto.SyncdMutation.verify(message.mutations[i]);
                    if (error)
                        return "mutations." + error;
                }
            }
            if (message.externalMutations != null && message.hasOwnProperty("externalMutations")) {
                var error = $root.proto.ExternalBlobReference.verify(message.externalMutations);
                if (error)
                    return "externalMutations." + error;
            }
            if (message.snapshotMac != null && message.hasOwnProperty("snapshotMac"))
                if (!(message.snapshotMac && typeof message.snapshotMac.length === "number" || $util.isString(message.snapshotMac)))
                    return "snapshotMac: buffer expected";
            if (message.patchMac != null && message.hasOwnProperty("patchMac"))
                if (!(message.patchMac && typeof message.patchMac.length === "number" || $util.isString(message.patchMac)))
                    return "patchMac: buffer expected";
            if (message.keyId != null && message.hasOwnProperty("keyId")) {
                var error = $root.proto.KeyId.verify(message.keyId);
                if (error)
                    return "keyId." + error;
            }
            if (message.exitCode != null && message.hasOwnProperty("exitCode")) {
                var error = $root.proto.ExitCode.verify(message.exitCode);
                if (error)
                    return "exitCode." + error;
            }
            if (message.deviceIndex != null && message.hasOwnProperty("deviceIndex"))
                if (!$util.isInteger(message.deviceIndex))
                    return "deviceIndex: integer expected";
            return null;
        };

        /**
         * Creates a SyncdPatch message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdPatch
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdPatch} SyncdPatch
         */
        SyncdPatch.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdPatch)
                return object;
            var message = new $root.proto.SyncdPatch();
            if (object.version != null) {
                if (typeof object.version !== "object")
                    throw TypeError(".proto.SyncdPatch.version: object expected");
                message.version = $root.proto.SyncdVersion.fromObject(object.version);
            }
            if (object.mutations) {
                if (!Array.isArray(object.mutations))
                    throw TypeError(".proto.SyncdPatch.mutations: array expected");
                message.mutations = [];
                for (var i = 0; i < object.mutations.length; ++i) {
                    if (typeof object.mutations[i] !== "object")
                        throw TypeError(".proto.SyncdPatch.mutations: object expected");
                    message.mutations[i] = $root.proto.SyncdMutation.fromObject(object.mutations[i]);
                }
            }
            if (object.externalMutations != null) {
                if (typeof object.externalMutations !== "object")
                    throw TypeError(".proto.SyncdPatch.externalMutations: object expected");
                message.externalMutations = $root.proto.ExternalBlobReference.fromObject(object.externalMutations);
            }
            if (object.snapshotMac != null)
                if (typeof object.snapshotMac === "string")
                    $util.base64.decode(object.snapshotMac, message.snapshotMac = $util.newBuffer($util.base64.length(object.snapshotMac)), 0);
                else if (object.snapshotMac.length)
                    message.snapshotMac = object.snapshotMac;
            if (object.patchMac != null)
                if (typeof object.patchMac === "string")
                    $util.base64.decode(object.patchMac, message.patchMac = $util.newBuffer($util.base64.length(object.patchMac)), 0);
                else if (object.patchMac.length)
                    message.patchMac = object.patchMac;
            if (object.keyId != null) {
                if (typeof object.keyId !== "object")
                    throw TypeError(".proto.SyncdPatch.keyId: object expected");
                message.keyId = $root.proto.KeyId.fromObject(object.keyId);
            }
            if (object.exitCode != null) {
                if (typeof object.exitCode !== "object")
                    throw TypeError(".proto.SyncdPatch.exitCode: object expected");
                message.exitCode = $root.proto.ExitCode.fromObject(object.exitCode);
            }
            if (object.deviceIndex != null)
                message.deviceIndex = object.deviceIndex >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a SyncdPatch message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdPatch
         * @static
         * @param {proto.SyncdPatch} message SyncdPatch
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdPatch.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.mutations = [];
            if (options.defaults) {
                object.version = null;
                object.externalMutations = null;
                if (options.bytes === String)
                    object.snapshotMac = "";
                else {
                    object.snapshotMac = [];
                    if (options.bytes !== Array)
                        object.snapshotMac = $util.newBuffer(object.snapshotMac);
                }
                if (options.bytes === String)
                    object.patchMac = "";
                else {
                    object.patchMac = [];
                    if (options.bytes !== Array)
                        object.patchMac = $util.newBuffer(object.patchMac);
                }
                object.keyId = null;
                object.exitCode = null;
                object.deviceIndex = 0;
            }
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = $root.proto.SyncdVersion.toObject(message.version, options);
            if (message.mutations && message.mutations.length) {
                object.mutations = [];
                for (var j = 0; j < message.mutations.length; ++j)
                    object.mutations[j] = $root.proto.SyncdMutation.toObject(message.mutations[j], options);
            }
            if (message.externalMutations != null && message.hasOwnProperty("externalMutations"))
                object.externalMutations = $root.proto.ExternalBlobReference.toObject(message.externalMutations, options);
            if (message.snapshotMac != null && message.hasOwnProperty("snapshotMac"))
                object.snapshotMac = options.bytes === String ? $util.base64.encode(message.snapshotMac, 0, message.snapshotMac.length) : options.bytes === Array ? Array.prototype.slice.call(message.snapshotMac) : message.snapshotMac;
            if (message.patchMac != null && message.hasOwnProperty("patchMac"))
                object.patchMac = options.bytes === String ? $util.base64.encode(message.patchMac, 0, message.patchMac.length) : options.bytes === Array ? Array.prototype.slice.call(message.patchMac) : message.patchMac;
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = $root.proto.KeyId.toObject(message.keyId, options);
            if (message.exitCode != null && message.hasOwnProperty("exitCode"))
                object.exitCode = $root.proto.ExitCode.toObject(message.exitCode, options);
            if (message.deviceIndex != null && message.hasOwnProperty("deviceIndex"))
                object.deviceIndex = message.deviceIndex;
            return object;
        };

        /**
         * Converts this SyncdPatch to JSON.
         * @function toJSON
         * @memberof proto.SyncdPatch
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdPatch.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdPatch;
    })();

    proto.SyncdMutation = (function() {

        /**
         * Properties of a SyncdMutation.
         * @memberof proto
         * @interface ISyncdMutation
         * @property {proto.SyncdMutation.SyncdMutationSyncdOperation|null} [operation] SyncdMutation operation
         * @property {proto.ISyncdRecord|null} [record] SyncdMutation record
         */

        /**
         * Constructs a new SyncdMutation.
         * @memberof proto
         * @classdesc Represents a SyncdMutation.
         * @implements ISyncdMutation
         * @constructor
         * @param {proto.ISyncdMutation=} [properties] Properties to set
         */
        function SyncdMutation(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdMutation operation.
         * @member {proto.SyncdMutation.SyncdMutationSyncdOperation} operation
         * @memberof proto.SyncdMutation
         * @instance
         */
        SyncdMutation.prototype.operation = 0;

        /**
         * SyncdMutation record.
         * @member {proto.ISyncdRecord|null|undefined} record
         * @memberof proto.SyncdMutation
         * @instance
         */
        SyncdMutation.prototype.record = null;

        /**
         * Creates a new SyncdMutation instance using the specified properties.
         * @function create
         * @memberof proto.SyncdMutation
         * @static
         * @param {proto.ISyncdMutation=} [properties] Properties to set
         * @returns {proto.SyncdMutation} SyncdMutation instance
         */
        SyncdMutation.create = function create(properties) {
            return new SyncdMutation(properties);
        };

        /**
         * Encodes the specified SyncdMutation message. Does not implicitly {@link proto.SyncdMutation.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdMutation
         * @static
         * @param {proto.ISyncdMutation} message SyncdMutation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdMutation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.operation);
            if (message.record != null && Object.hasOwnProperty.call(message, "record"))
                $root.proto.SyncdRecord.encode(message.record, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified SyncdMutation message, length delimited. Does not implicitly {@link proto.SyncdMutation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdMutation
         * @static
         * @param {proto.ISyncdMutation} message SyncdMutation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdMutation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdMutation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdMutation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdMutation} SyncdMutation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdMutation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdMutation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.operation = reader.int32();
                    break;
                case 2:
                    message.record = $root.proto.SyncdRecord.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdMutation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdMutation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdMutation} SyncdMutation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdMutation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdMutation message.
         * @function verify
         * @memberof proto.SyncdMutation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdMutation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.operation != null && message.hasOwnProperty("operation"))
                switch (message.operation) {
                default:
                    return "operation: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.record != null && message.hasOwnProperty("record")) {
                var error = $root.proto.SyncdRecord.verify(message.record);
                if (error)
                    return "record." + error;
            }
            return null;
        };

        /**
         * Creates a SyncdMutation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdMutation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdMutation} SyncdMutation
         */
        SyncdMutation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdMutation)
                return object;
            var message = new $root.proto.SyncdMutation();
            switch (object.operation) {
            case "SET":
            case 0:
                message.operation = 0;
                break;
            case "REMOVE":
            case 1:
                message.operation = 1;
                break;
            }
            if (object.record != null) {
                if (typeof object.record !== "object")
                    throw TypeError(".proto.SyncdMutation.record: object expected");
                message.record = $root.proto.SyncdRecord.fromObject(object.record);
            }
            return message;
        };

        /**
         * Creates a plain object from a SyncdMutation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdMutation
         * @static
         * @param {proto.SyncdMutation} message SyncdMutation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdMutation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.operation = options.enums === String ? "SET" : 0;
                object.record = null;
            }
            if (message.operation != null && message.hasOwnProperty("operation"))
                object.operation = options.enums === String ? $root.proto.SyncdMutation.SyncdMutationSyncdOperation[message.operation] : message.operation;
            if (message.record != null && message.hasOwnProperty("record"))
                object.record = $root.proto.SyncdRecord.toObject(message.record, options);
            return object;
        };

        /**
         * Converts this SyncdMutation to JSON.
         * @function toJSON
         * @memberof proto.SyncdMutation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdMutation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * SyncdMutationSyncdOperation enum.
         * @name proto.SyncdMutation.SyncdMutationSyncdOperation
         * @enum {number}
         * @property {number} SET=0 SET value
         * @property {number} REMOVE=1 REMOVE value
         */
        SyncdMutation.SyncdMutationSyncdOperation = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SET"] = 0;
            values[valuesById[1] = "REMOVE"] = 1;
            return values;
        })();

        return SyncdMutation;
    })();

    proto.SyncdMutations = (function() {

        /**
         * Properties of a SyncdMutations.
         * @memberof proto
         * @interface ISyncdMutations
         * @property {Array.<proto.ISyncdMutation>|null} [mutations] SyncdMutations mutations
         */

        /**
         * Constructs a new SyncdMutations.
         * @memberof proto
         * @classdesc Represents a SyncdMutations.
         * @implements ISyncdMutations
         * @constructor
         * @param {proto.ISyncdMutations=} [properties] Properties to set
         */
        function SyncdMutations(properties) {
            this.mutations = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdMutations mutations.
         * @member {Array.<proto.ISyncdMutation>} mutations
         * @memberof proto.SyncdMutations
         * @instance
         */
        SyncdMutations.prototype.mutations = $util.emptyArray;

        /**
         * Creates a new SyncdMutations instance using the specified properties.
         * @function create
         * @memberof proto.SyncdMutations
         * @static
         * @param {proto.ISyncdMutations=} [properties] Properties to set
         * @returns {proto.SyncdMutations} SyncdMutations instance
         */
        SyncdMutations.create = function create(properties) {
            return new SyncdMutations(properties);
        };

        /**
         * Encodes the specified SyncdMutations message. Does not implicitly {@link proto.SyncdMutations.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdMutations
         * @static
         * @param {proto.ISyncdMutations} message SyncdMutations message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdMutations.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.mutations != null && message.mutations.length)
                for (var i = 0; i < message.mutations.length; ++i)
                    $root.proto.SyncdMutation.encode(message.mutations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified SyncdMutations message, length delimited. Does not implicitly {@link proto.SyncdMutations.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdMutations
         * @static
         * @param {proto.ISyncdMutations} message SyncdMutations message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdMutations.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdMutations message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdMutations
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdMutations} SyncdMutations
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdMutations.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdMutations();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.mutations && message.mutations.length))
                        message.mutations = [];
                    message.mutations.push($root.proto.SyncdMutation.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdMutations message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdMutations
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdMutations} SyncdMutations
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdMutations.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdMutations message.
         * @function verify
         * @memberof proto.SyncdMutations
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdMutations.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.mutations != null && message.hasOwnProperty("mutations")) {
                if (!Array.isArray(message.mutations))
                    return "mutations: array expected";
                for (var i = 0; i < message.mutations.length; ++i) {
                    var error = $root.proto.SyncdMutation.verify(message.mutations[i]);
                    if (error)
                        return "mutations." + error;
                }
            }
            return null;
        };

        /**
         * Creates a SyncdMutations message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdMutations
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdMutations} SyncdMutations
         */
        SyncdMutations.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdMutations)
                return object;
            var message = new $root.proto.SyncdMutations();
            if (object.mutations) {
                if (!Array.isArray(object.mutations))
                    throw TypeError(".proto.SyncdMutations.mutations: array expected");
                message.mutations = [];
                for (var i = 0; i < object.mutations.length; ++i) {
                    if (typeof object.mutations[i] !== "object")
                        throw TypeError(".proto.SyncdMutations.mutations: object expected");
                    message.mutations[i] = $root.proto.SyncdMutation.fromObject(object.mutations[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a SyncdMutations message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdMutations
         * @static
         * @param {proto.SyncdMutations} message SyncdMutations
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdMutations.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.mutations = [];
            if (message.mutations && message.mutations.length) {
                object.mutations = [];
                for (var j = 0; j < message.mutations.length; ++j)
                    object.mutations[j] = $root.proto.SyncdMutation.toObject(message.mutations[j], options);
            }
            return object;
        };

        /**
         * Converts this SyncdMutations to JSON.
         * @function toJSON
         * @memberof proto.SyncdMutations
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdMutations.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdMutations;
    })();

    proto.SyncdSnapshot = (function() {

        /**
         * Properties of a SyncdSnapshot.
         * @memberof proto
         * @interface ISyncdSnapshot
         * @property {proto.ISyncdVersion|null} [version] SyncdSnapshot version
         * @property {Array.<proto.ISyncdRecord>|null} [records] SyncdSnapshot records
         * @property {Uint8Array|null} [mac] SyncdSnapshot mac
         * @property {proto.IKeyId|null} [keyId] SyncdSnapshot keyId
         */

        /**
         * Constructs a new SyncdSnapshot.
         * @memberof proto
         * @classdesc Represents a SyncdSnapshot.
         * @implements ISyncdSnapshot
         * @constructor
         * @param {proto.ISyncdSnapshot=} [properties] Properties to set
         */
        function SyncdSnapshot(properties) {
            this.records = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdSnapshot version.
         * @member {proto.ISyncdVersion|null|undefined} version
         * @memberof proto.SyncdSnapshot
         * @instance
         */
        SyncdSnapshot.prototype.version = null;

        /**
         * SyncdSnapshot records.
         * @member {Array.<proto.ISyncdRecord>} records
         * @memberof proto.SyncdSnapshot
         * @instance
         */
        SyncdSnapshot.prototype.records = $util.emptyArray;

        /**
         * SyncdSnapshot mac.
         * @member {Uint8Array} mac
         * @memberof proto.SyncdSnapshot
         * @instance
         */
        SyncdSnapshot.prototype.mac = $util.newBuffer([]);

        /**
         * SyncdSnapshot keyId.
         * @member {proto.IKeyId|null|undefined} keyId
         * @memberof proto.SyncdSnapshot
         * @instance
         */
        SyncdSnapshot.prototype.keyId = null;

        /**
         * Creates a new SyncdSnapshot instance using the specified properties.
         * @function create
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {proto.ISyncdSnapshot=} [properties] Properties to set
         * @returns {proto.SyncdSnapshot} SyncdSnapshot instance
         */
        SyncdSnapshot.create = function create(properties) {
            return new SyncdSnapshot(properties);
        };

        /**
         * Encodes the specified SyncdSnapshot message. Does not implicitly {@link proto.SyncdSnapshot.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {proto.ISyncdSnapshot} message SyncdSnapshot message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdSnapshot.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                $root.proto.SyncdVersion.encode(message.version, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.records != null && message.records.length)
                for (var i = 0; i < message.records.length; ++i)
                    $root.proto.SyncdRecord.encode(message.records[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.mac != null && Object.hasOwnProperty.call(message, "mac"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.mac);
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                $root.proto.KeyId.encode(message.keyId, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified SyncdSnapshot message, length delimited. Does not implicitly {@link proto.SyncdSnapshot.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {proto.ISyncdSnapshot} message SyncdSnapshot message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdSnapshot.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdSnapshot message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdSnapshot} SyncdSnapshot
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdSnapshot.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdSnapshot();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.version = $root.proto.SyncdVersion.decode(reader, reader.uint32());
                    break;
                case 2:
                    if (!(message.records && message.records.length))
                        message.records = [];
                    message.records.push($root.proto.SyncdRecord.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.mac = reader.bytes();
                    break;
                case 4:
                    message.keyId = $root.proto.KeyId.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdSnapshot message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdSnapshot} SyncdSnapshot
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdSnapshot.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdSnapshot message.
         * @function verify
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdSnapshot.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.version != null && message.hasOwnProperty("version")) {
                var error = $root.proto.SyncdVersion.verify(message.version);
                if (error)
                    return "version." + error;
            }
            if (message.records != null && message.hasOwnProperty("records")) {
                if (!Array.isArray(message.records))
                    return "records: array expected";
                for (var i = 0; i < message.records.length; ++i) {
                    var error = $root.proto.SyncdRecord.verify(message.records[i]);
                    if (error)
                        return "records." + error;
                }
            }
            if (message.mac != null && message.hasOwnProperty("mac"))
                if (!(message.mac && typeof message.mac.length === "number" || $util.isString(message.mac)))
                    return "mac: buffer expected";
            if (message.keyId != null && message.hasOwnProperty("keyId")) {
                var error = $root.proto.KeyId.verify(message.keyId);
                if (error)
                    return "keyId." + error;
            }
            return null;
        };

        /**
         * Creates a SyncdSnapshot message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdSnapshot} SyncdSnapshot
         */
        SyncdSnapshot.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdSnapshot)
                return object;
            var message = new $root.proto.SyncdSnapshot();
            if (object.version != null) {
                if (typeof object.version !== "object")
                    throw TypeError(".proto.SyncdSnapshot.version: object expected");
                message.version = $root.proto.SyncdVersion.fromObject(object.version);
            }
            if (object.records) {
                if (!Array.isArray(object.records))
                    throw TypeError(".proto.SyncdSnapshot.records: array expected");
                message.records = [];
                for (var i = 0; i < object.records.length; ++i) {
                    if (typeof object.records[i] !== "object")
                        throw TypeError(".proto.SyncdSnapshot.records: object expected");
                    message.records[i] = $root.proto.SyncdRecord.fromObject(object.records[i]);
                }
            }
            if (object.mac != null)
                if (typeof object.mac === "string")
                    $util.base64.decode(object.mac, message.mac = $util.newBuffer($util.base64.length(object.mac)), 0);
                else if (object.mac.length)
                    message.mac = object.mac;
            if (object.keyId != null) {
                if (typeof object.keyId !== "object")
                    throw TypeError(".proto.SyncdSnapshot.keyId: object expected");
                message.keyId = $root.proto.KeyId.fromObject(object.keyId);
            }
            return message;
        };

        /**
         * Creates a plain object from a SyncdSnapshot message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdSnapshot
         * @static
         * @param {proto.SyncdSnapshot} message SyncdSnapshot
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdSnapshot.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.records = [];
            if (options.defaults) {
                object.version = null;
                if (options.bytes === String)
                    object.mac = "";
                else {
                    object.mac = [];
                    if (options.bytes !== Array)
                        object.mac = $util.newBuffer(object.mac);
                }
                object.keyId = null;
            }
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = $root.proto.SyncdVersion.toObject(message.version, options);
            if (message.records && message.records.length) {
                object.records = [];
                for (var j = 0; j < message.records.length; ++j)
                    object.records[j] = $root.proto.SyncdRecord.toObject(message.records[j], options);
            }
            if (message.mac != null && message.hasOwnProperty("mac"))
                object.mac = options.bytes === String ? $util.base64.encode(message.mac, 0, message.mac.length) : options.bytes === Array ? Array.prototype.slice.call(message.mac) : message.mac;
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = $root.proto.KeyId.toObject(message.keyId, options);
            return object;
        };

        /**
         * Converts this SyncdSnapshot to JSON.
         * @function toJSON
         * @memberof proto.SyncdSnapshot
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdSnapshot.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdSnapshot;
    })();

    proto.ExternalBlobReference = (function() {

        /**
         * Properties of an ExternalBlobReference.
         * @memberof proto
         * @interface IExternalBlobReference
         * @property {Uint8Array|null} [mediaKey] ExternalBlobReference mediaKey
         * @property {string|null} [directPath] ExternalBlobReference directPath
         * @property {string|null} [handle] ExternalBlobReference handle
         * @property {number|Long|null} [fileSizeBytes] ExternalBlobReference fileSizeBytes
         * @property {Uint8Array|null} [fileSha256] ExternalBlobReference fileSha256
         * @property {Uint8Array|null} [fileEncSha256] ExternalBlobReference fileEncSha256
         */

        /**
         * Constructs a new ExternalBlobReference.
         * @memberof proto
         * @classdesc Represents an ExternalBlobReference.
         * @implements IExternalBlobReference
         * @constructor
         * @param {proto.IExternalBlobReference=} [properties] Properties to set
         */
        function ExternalBlobReference(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExternalBlobReference mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.mediaKey = $util.newBuffer([]);

        /**
         * ExternalBlobReference directPath.
         * @member {string} directPath
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.directPath = "";

        /**
         * ExternalBlobReference handle.
         * @member {string} handle
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.handle = "";

        /**
         * ExternalBlobReference fileSizeBytes.
         * @member {number|Long} fileSizeBytes
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileSizeBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ExternalBlobReference fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * ExternalBlobReference fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * Creates a new ExternalBlobReference instance using the specified properties.
         * @function create
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference=} [properties] Properties to set
         * @returns {proto.ExternalBlobReference} ExternalBlobReference instance
         */
        ExternalBlobReference.create = function create(properties) {
            return new ExternalBlobReference(properties);
        };

        /**
         * Encodes the specified ExternalBlobReference message. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @function encode
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference} message ExternalBlobReference message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalBlobReference.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.mediaKey);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.directPath);
            if (message.handle != null && Object.hasOwnProperty.call(message, "handle"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.handle);
            if (message.fileSizeBytes != null && Object.hasOwnProperty.call(message, "fileSizeBytes"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.fileSizeBytes);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.fileSha256);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.fileEncSha256);
            return writer;
        };

        /**
         * Encodes the specified ExternalBlobReference message, length delimited. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference} message ExternalBlobReference message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalBlobReference.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalBlobReference.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExternalBlobReference();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.mediaKey = reader.bytes();
                    break;
                case 2:
                    message.directPath = reader.string();
                    break;
                case 3:
                    message.handle = reader.string();
                    break;
                case 4:
                    message.fileSizeBytes = reader.uint64();
                    break;
                case 5:
                    message.fileSha256 = reader.bytes();
                    break;
                case 6:
                    message.fileEncSha256 = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalBlobReference.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExternalBlobReference message.
         * @function verify
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExternalBlobReference.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.handle != null && message.hasOwnProperty("handle"))
                if (!$util.isString(message.handle))
                    return "handle: string expected";
            if (message.fileSizeBytes != null && message.hasOwnProperty("fileSizeBytes"))
                if (!$util.isInteger(message.fileSizeBytes) && !(message.fileSizeBytes && $util.isInteger(message.fileSizeBytes.low) && $util.isInteger(message.fileSizeBytes.high)))
                    return "fileSizeBytes: integer|Long expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            return null;
        };

        /**
         * Creates an ExternalBlobReference message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         */
        ExternalBlobReference.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExternalBlobReference)
                return object;
            var message = new $root.proto.ExternalBlobReference();
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.handle != null)
                message.handle = String(object.handle);
            if (object.fileSizeBytes != null)
                if ($util.Long)
                    (message.fileSizeBytes = $util.Long.fromValue(object.fileSizeBytes)).unsigned = true;
                else if (typeof object.fileSizeBytes === "string")
                    message.fileSizeBytes = parseInt(object.fileSizeBytes, 10);
                else if (typeof object.fileSizeBytes === "number")
                    message.fileSizeBytes = object.fileSizeBytes;
                else if (typeof object.fileSizeBytes === "object")
                    message.fileSizeBytes = new $util.LongBits(object.fileSizeBytes.low >>> 0, object.fileSizeBytes.high >>> 0).toNumber(true);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            return message;
        };

        /**
         * Creates a plain object from an ExternalBlobReference message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.ExternalBlobReference} message ExternalBlobReference
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExternalBlobReference.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                object.directPath = "";
                object.handle = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileSizeBytes = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileSizeBytes = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
            }
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.handle != null && message.hasOwnProperty("handle"))
                object.handle = message.handle;
            if (message.fileSizeBytes != null && message.hasOwnProperty("fileSizeBytes"))
                if (typeof message.fileSizeBytes === "number")
                    object.fileSizeBytes = options.longs === String ? String(message.fileSizeBytes) : message.fileSizeBytes;
                else
                    object.fileSizeBytes = options.longs === String ? $util.Long.prototype.toString.call(message.fileSizeBytes) : options.longs === Number ? new $util.LongBits(message.fileSizeBytes.low >>> 0, message.fileSizeBytes.high >>> 0).toNumber(true) : message.fileSizeBytes;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            return object;
        };

        /**
         * Converts this ExternalBlobReference to JSON.
         * @function toJSON
         * @memberof proto.ExternalBlobReference
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExternalBlobReference.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExternalBlobReference;
    })();

    proto.SyncdRecord = (function() {

        /**
         * Properties of a SyncdRecord.
         * @memberof proto
         * @interface ISyncdRecord
         * @property {proto.ISyncdIndex|null} [index] SyncdRecord index
         * @property {proto.ISyncdValue|null} [value] SyncdRecord value
         * @property {proto.IKeyId|null} [keyId] SyncdRecord keyId
         */

        /**
         * Constructs a new SyncdRecord.
         * @memberof proto
         * @classdesc Represents a SyncdRecord.
         * @implements ISyncdRecord
         * @constructor
         * @param {proto.ISyncdRecord=} [properties] Properties to set
         */
        function SyncdRecord(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdRecord index.
         * @member {proto.ISyncdIndex|null|undefined} index
         * @memberof proto.SyncdRecord
         * @instance
         */
        SyncdRecord.prototype.index = null;

        /**
         * SyncdRecord value.
         * @member {proto.ISyncdValue|null|undefined} value
         * @memberof proto.SyncdRecord
         * @instance
         */
        SyncdRecord.prototype.value = null;

        /**
         * SyncdRecord keyId.
         * @member {proto.IKeyId|null|undefined} keyId
         * @memberof proto.SyncdRecord
         * @instance
         */
        SyncdRecord.prototype.keyId = null;

        /**
         * Creates a new SyncdRecord instance using the specified properties.
         * @function create
         * @memberof proto.SyncdRecord
         * @static
         * @param {proto.ISyncdRecord=} [properties] Properties to set
         * @returns {proto.SyncdRecord} SyncdRecord instance
         */
        SyncdRecord.create = function create(properties) {
            return new SyncdRecord(properties);
        };

        /**
         * Encodes the specified SyncdRecord message. Does not implicitly {@link proto.SyncdRecord.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdRecord
         * @static
         * @param {proto.ISyncdRecord} message SyncdRecord message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdRecord.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                $root.proto.SyncdIndex.encode(message.index, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                $root.proto.SyncdValue.encode(message.value, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                $root.proto.KeyId.encode(message.keyId, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified SyncdRecord message, length delimited. Does not implicitly {@link proto.SyncdRecord.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdRecord
         * @static
         * @param {proto.ISyncdRecord} message SyncdRecord message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdRecord.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdRecord message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdRecord
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdRecord} SyncdRecord
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdRecord.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdRecord();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = $root.proto.SyncdIndex.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.value = $root.proto.SyncdValue.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.keyId = $root.proto.KeyId.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdRecord message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdRecord
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdRecord} SyncdRecord
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdRecord.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdRecord message.
         * @function verify
         * @memberof proto.SyncdRecord
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdRecord.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index")) {
                var error = $root.proto.SyncdIndex.verify(message.index);
                if (error)
                    return "index." + error;
            }
            if (message.value != null && message.hasOwnProperty("value")) {
                var error = $root.proto.SyncdValue.verify(message.value);
                if (error)
                    return "value." + error;
            }
            if (message.keyId != null && message.hasOwnProperty("keyId")) {
                var error = $root.proto.KeyId.verify(message.keyId);
                if (error)
                    return "keyId." + error;
            }
            return null;
        };

        /**
         * Creates a SyncdRecord message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdRecord
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdRecord} SyncdRecord
         */
        SyncdRecord.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdRecord)
                return object;
            var message = new $root.proto.SyncdRecord();
            if (object.index != null) {
                if (typeof object.index !== "object")
                    throw TypeError(".proto.SyncdRecord.index: object expected");
                message.index = $root.proto.SyncdIndex.fromObject(object.index);
            }
            if (object.value != null) {
                if (typeof object.value !== "object")
                    throw TypeError(".proto.SyncdRecord.value: object expected");
                message.value = $root.proto.SyncdValue.fromObject(object.value);
            }
            if (object.keyId != null) {
                if (typeof object.keyId !== "object")
                    throw TypeError(".proto.SyncdRecord.keyId: object expected");
                message.keyId = $root.proto.KeyId.fromObject(object.keyId);
            }
            return message;
        };

        /**
         * Creates a plain object from a SyncdRecord message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdRecord
         * @static
         * @param {proto.SyncdRecord} message SyncdRecord
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdRecord.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = null;
                object.value = null;
                object.keyId = null;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = $root.proto.SyncdIndex.toObject(message.index, options);
            if (message.value != null && message.hasOwnProperty("value"))
                object.value = $root.proto.SyncdValue.toObject(message.value, options);
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = $root.proto.KeyId.toObject(message.keyId, options);
            return object;
        };

        /**
         * Converts this SyncdRecord to JSON.
         * @function toJSON
         * @memberof proto.SyncdRecord
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdRecord.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdRecord;
    })();

    proto.KeyId = (function() {

        /**
         * Properties of a KeyId.
         * @memberof proto
         * @interface IKeyId
         * @property {Uint8Array|null} [id] KeyId id
         */

        /**
         * Constructs a new KeyId.
         * @memberof proto
         * @classdesc Represents a KeyId.
         * @implements IKeyId
         * @constructor
         * @param {proto.IKeyId=} [properties] Properties to set
         */
        function KeyId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * KeyId id.
         * @member {Uint8Array} id
         * @memberof proto.KeyId
         * @instance
         */
        KeyId.prototype.id = $util.newBuffer([]);

        /**
         * Creates a new KeyId instance using the specified properties.
         * @function create
         * @memberof proto.KeyId
         * @static
         * @param {proto.IKeyId=} [properties] Properties to set
         * @returns {proto.KeyId} KeyId instance
         */
        KeyId.create = function create(properties) {
            return new KeyId(properties);
        };

        /**
         * Encodes the specified KeyId message. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @function encode
         * @memberof proto.KeyId
         * @static
         * @param {proto.IKeyId} message KeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeyId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.id);
            return writer;
        };

        /**
         * Encodes the specified KeyId message, length delimited. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.KeyId
         * @static
         * @param {proto.IKeyId} message KeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeyId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a KeyId message from the specified reader or buffer.
         * @function decode
         * @memberof proto.KeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.KeyId} KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeyId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.KeyId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a KeyId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.KeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.KeyId} KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeyId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a KeyId message.
         * @function verify
         * @memberof proto.KeyId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        KeyId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!(message.id && typeof message.id.length === "number" || $util.isString(message.id)))
                    return "id: buffer expected";
            return null;
        };

        /**
         * Creates a KeyId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.KeyId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.KeyId} KeyId
         */
        KeyId.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.KeyId)
                return object;
            var message = new $root.proto.KeyId();
            if (object.id != null)
                if (typeof object.id === "string")
                    $util.base64.decode(object.id, message.id = $util.newBuffer($util.base64.length(object.id)), 0);
                else if (object.id.length)
                    message.id = object.id;
            return message;
        };

        /**
         * Creates a plain object from a KeyId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.KeyId
         * @static
         * @param {proto.KeyId} message KeyId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        KeyId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.id = "";
                else {
                    object.id = [];
                    if (options.bytes !== Array)
                        object.id = $util.newBuffer(object.id);
                }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = options.bytes === String ? $util.base64.encode(message.id, 0, message.id.length) : options.bytes === Array ? Array.prototype.slice.call(message.id) : message.id;
            return object;
        };

        /**
         * Converts this KeyId to JSON.
         * @function toJSON
         * @memberof proto.KeyId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        KeyId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return KeyId;
    })();

    proto.SyncdValue = (function() {

        /**
         * Properties of a SyncdValue.
         * @memberof proto
         * @interface ISyncdValue
         * @property {Uint8Array|null} [blob] SyncdValue blob
         */

        /**
         * Constructs a new SyncdValue.
         * @memberof proto
         * @classdesc Represents a SyncdValue.
         * @implements ISyncdValue
         * @constructor
         * @param {proto.ISyncdValue=} [properties] Properties to set
         */
        function SyncdValue(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdValue blob.
         * @member {Uint8Array} blob
         * @memberof proto.SyncdValue
         * @instance
         */
        SyncdValue.prototype.blob = $util.newBuffer([]);

        /**
         * Creates a new SyncdValue instance using the specified properties.
         * @function create
         * @memberof proto.SyncdValue
         * @static
         * @param {proto.ISyncdValue=} [properties] Properties to set
         * @returns {proto.SyncdValue} SyncdValue instance
         */
        SyncdValue.create = function create(properties) {
            return new SyncdValue(properties);
        };

        /**
         * Encodes the specified SyncdValue message. Does not implicitly {@link proto.SyncdValue.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdValue
         * @static
         * @param {proto.ISyncdValue} message SyncdValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdValue.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.blob != null && Object.hasOwnProperty.call(message, "blob"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.blob);
            return writer;
        };

        /**
         * Encodes the specified SyncdValue message, length delimited. Does not implicitly {@link proto.SyncdValue.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdValue
         * @static
         * @param {proto.ISyncdValue} message SyncdValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdValue.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdValue message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdValue} SyncdValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdValue.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdValue();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.blob = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdValue message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdValue} SyncdValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdValue.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdValue message.
         * @function verify
         * @memberof proto.SyncdValue
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdValue.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.blob != null && message.hasOwnProperty("blob"))
                if (!(message.blob && typeof message.blob.length === "number" || $util.isString(message.blob)))
                    return "blob: buffer expected";
            return null;
        };

        /**
         * Creates a SyncdValue message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdValue
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdValue} SyncdValue
         */
        SyncdValue.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdValue)
                return object;
            var message = new $root.proto.SyncdValue();
            if (object.blob != null)
                if (typeof object.blob === "string")
                    $util.base64.decode(object.blob, message.blob = $util.newBuffer($util.base64.length(object.blob)), 0);
                else if (object.blob.length)
                    message.blob = object.blob;
            return message;
        };

        /**
         * Creates a plain object from a SyncdValue message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdValue
         * @static
         * @param {proto.SyncdValue} message SyncdValue
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdValue.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.blob = "";
                else {
                    object.blob = [];
                    if (options.bytes !== Array)
                        object.blob = $util.newBuffer(object.blob);
                }
            if (message.blob != null && message.hasOwnProperty("blob"))
                object.blob = options.bytes === String ? $util.base64.encode(message.blob, 0, message.blob.length) : options.bytes === Array ? Array.prototype.slice.call(message.blob) : message.blob;
            return object;
        };

        /**
         * Converts this SyncdValue to JSON.
         * @function toJSON
         * @memberof proto.SyncdValue
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdValue.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdValue;
    })();

    proto.SyncdIndex = (function() {

        /**
         * Properties of a SyncdIndex.
         * @memberof proto
         * @interface ISyncdIndex
         * @property {Uint8Array|null} [blob] SyncdIndex blob
         */

        /**
         * Constructs a new SyncdIndex.
         * @memberof proto
         * @classdesc Represents a SyncdIndex.
         * @implements ISyncdIndex
         * @constructor
         * @param {proto.ISyncdIndex=} [properties] Properties to set
         */
        function SyncdIndex(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdIndex blob.
         * @member {Uint8Array} blob
         * @memberof proto.SyncdIndex
         * @instance
         */
        SyncdIndex.prototype.blob = $util.newBuffer([]);

        /**
         * Creates a new SyncdIndex instance using the specified properties.
         * @function create
         * @memberof proto.SyncdIndex
         * @static
         * @param {proto.ISyncdIndex=} [properties] Properties to set
         * @returns {proto.SyncdIndex} SyncdIndex instance
         */
        SyncdIndex.create = function create(properties) {
            return new SyncdIndex(properties);
        };

        /**
         * Encodes the specified SyncdIndex message. Does not implicitly {@link proto.SyncdIndex.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdIndex
         * @static
         * @param {proto.ISyncdIndex} message SyncdIndex message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdIndex.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.blob != null && Object.hasOwnProperty.call(message, "blob"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.blob);
            return writer;
        };

        /**
         * Encodes the specified SyncdIndex message, length delimited. Does not implicitly {@link proto.SyncdIndex.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdIndex
         * @static
         * @param {proto.ISyncdIndex} message SyncdIndex message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdIndex.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdIndex message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdIndex
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdIndex} SyncdIndex
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdIndex.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdIndex();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.blob = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdIndex message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdIndex
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdIndex} SyncdIndex
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdIndex.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdIndex message.
         * @function verify
         * @memberof proto.SyncdIndex
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdIndex.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.blob != null && message.hasOwnProperty("blob"))
                if (!(message.blob && typeof message.blob.length === "number" || $util.isString(message.blob)))
                    return "blob: buffer expected";
            return null;
        };

        /**
         * Creates a SyncdIndex message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdIndex
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdIndex} SyncdIndex
         */
        SyncdIndex.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdIndex)
                return object;
            var message = new $root.proto.SyncdIndex();
            if (object.blob != null)
                if (typeof object.blob === "string")
                    $util.base64.decode(object.blob, message.blob = $util.newBuffer($util.base64.length(object.blob)), 0);
                else if (object.blob.length)
                    message.blob = object.blob;
            return message;
        };

        /**
         * Creates a plain object from a SyncdIndex message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdIndex
         * @static
         * @param {proto.SyncdIndex} message SyncdIndex
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdIndex.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.blob = "";
                else {
                    object.blob = [];
                    if (options.bytes !== Array)
                        object.blob = $util.newBuffer(object.blob);
                }
            if (message.blob != null && message.hasOwnProperty("blob"))
                object.blob = options.bytes === String ? $util.base64.encode(message.blob, 0, message.blob.length) : options.bytes === Array ? Array.prototype.slice.call(message.blob) : message.blob;
            return object;
        };

        /**
         * Converts this SyncdIndex to JSON.
         * @function toJSON
         * @memberof proto.SyncdIndex
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdIndex.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdIndex;
    })();

    proto.ExitCode = (function() {

        /**
         * Properties of an ExitCode.
         * @memberof proto
         * @interface IExitCode
         * @property {number|Long|null} [code] ExitCode code
         * @property {string|null} [text] ExitCode text
         */

        /**
         * Constructs a new ExitCode.
         * @memberof proto
         * @classdesc Represents an ExitCode.
         * @implements IExitCode
         * @constructor
         * @param {proto.IExitCode=} [properties] Properties to set
         */
        function ExitCode(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExitCode code.
         * @member {number|Long} code
         * @memberof proto.ExitCode
         * @instance
         */
        ExitCode.prototype.code = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ExitCode text.
         * @member {string} text
         * @memberof proto.ExitCode
         * @instance
         */
        ExitCode.prototype.text = "";

        /**
         * Creates a new ExitCode instance using the specified properties.
         * @function create
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode=} [properties] Properties to set
         * @returns {proto.ExitCode} ExitCode instance
         */
        ExitCode.create = function create(properties) {
            return new ExitCode(properties);
        };

        /**
         * Encodes the specified ExitCode message. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @function encode
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode} message ExitCode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExitCode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.code);
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified ExitCode message, length delimited. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode} message ExitCode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExitCode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExitCode message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExitCode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExitCode} ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExitCode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExitCode();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.code = reader.uint64();
                    break;
                case 2:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExitCode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExitCode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExitCode} ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExitCode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExitCode message.
         * @function verify
         * @memberof proto.ExitCode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExitCode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.code != null && message.hasOwnProperty("code"))
                if (!$util.isInteger(message.code) && !(message.code && $util.isInteger(message.code.low) && $util.isInteger(message.code.high)))
                    return "code: integer|Long expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates an ExitCode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExitCode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExitCode} ExitCode
         */
        ExitCode.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExitCode)
                return object;
            var message = new $root.proto.ExitCode();
            if (object.code != null)
                if ($util.Long)
                    (message.code = $util.Long.fromValue(object.code)).unsigned = true;
                else if (typeof object.code === "string")
                    message.code = parseInt(object.code, 10);
                else if (typeof object.code === "number")
                    message.code = object.code;
                else if (typeof object.code === "object")
                    message.code = new $util.LongBits(object.code.low >>> 0, object.code.high >>> 0).toNumber(true);
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from an ExitCode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExitCode
         * @static
         * @param {proto.ExitCode} message ExitCode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExitCode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.code = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.code = options.longs === String ? "0" : 0;
                object.text = "";
            }
            if (message.code != null && message.hasOwnProperty("code"))
                if (typeof message.code === "number")
                    object.code = options.longs === String ? String(message.code) : message.code;
                else
                    object.code = options.longs === String ? $util.Long.prototype.toString.call(message.code) : options.longs === Number ? new $util.LongBits(message.code.low >>> 0, message.code.high >>> 0).toNumber(true) : message.code;
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this ExitCode to JSON.
         * @function toJSON
         * @memberof proto.ExitCode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExitCode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExitCode;
    })();

    proto.SyncdVersion = (function() {

        /**
         * Properties of a SyncdVersion.
         * @memberof proto
         * @interface ISyncdVersion
         * @property {number|Long|null} [version] SyncdVersion version
         */

        /**
         * Constructs a new SyncdVersion.
         * @memberof proto
         * @classdesc Represents a SyncdVersion.
         * @implements ISyncdVersion
         * @constructor
         * @param {proto.ISyncdVersion=} [properties] Properties to set
         */
        function SyncdVersion(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SyncdVersion version.
         * @member {number|Long} version
         * @memberof proto.SyncdVersion
         * @instance
         */
        SyncdVersion.prototype.version = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new SyncdVersion instance using the specified properties.
         * @function create
         * @memberof proto.SyncdVersion
         * @static
         * @param {proto.ISyncdVersion=} [properties] Properties to set
         * @returns {proto.SyncdVersion} SyncdVersion instance
         */
        SyncdVersion.create = function create(properties) {
            return new SyncdVersion(properties);
        };

        /**
         * Encodes the specified SyncdVersion message. Does not implicitly {@link proto.SyncdVersion.verify|verify} messages.
         * @function encode
         * @memberof proto.SyncdVersion
         * @static
         * @param {proto.ISyncdVersion} message SyncdVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdVersion.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.version);
            return writer;
        };

        /**
         * Encodes the specified SyncdVersion message, length delimited. Does not implicitly {@link proto.SyncdVersion.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.SyncdVersion
         * @static
         * @param {proto.ISyncdVersion} message SyncdVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SyncdVersion.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SyncdVersion message from the specified reader or buffer.
         * @function decode
         * @memberof proto.SyncdVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.SyncdVersion} SyncdVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdVersion.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.SyncdVersion();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.version = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SyncdVersion message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.SyncdVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.SyncdVersion} SyncdVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SyncdVersion.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SyncdVersion message.
         * @function verify
         * @memberof proto.SyncdVersion
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SyncdVersion.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.version != null && message.hasOwnProperty("version"))
                if (!$util.isInteger(message.version) && !(message.version && $util.isInteger(message.version.low) && $util.isInteger(message.version.high)))
                    return "version: integer|Long expected";
            return null;
        };

        /**
         * Creates a SyncdVersion message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.SyncdVersion
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.SyncdVersion} SyncdVersion
         */
        SyncdVersion.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.SyncdVersion)
                return object;
            var message = new $root.proto.SyncdVersion();
            if (object.version != null)
                if ($util.Long)
                    (message.version = $util.Long.fromValue(object.version)).unsigned = true;
                else if (typeof object.version === "string")
                    message.version = parseInt(object.version, 10);
                else if (typeof object.version === "number")
                    message.version = object.version;
                else if (typeof object.version === "object")
                    message.version = new $util.LongBits(object.version.low >>> 0, object.version.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a SyncdVersion message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.SyncdVersion
         * @static
         * @param {proto.SyncdVersion} message SyncdVersion
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SyncdVersion.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.version = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.version = options.longs === String ? "0" : 0;
            if (message.version != null && message.hasOwnProperty("version"))
                if (typeof message.version === "number")
                    object.version = options.longs === String ? String(message.version) : message.version;
                else
                    object.version = options.longs === String ? $util.Long.prototype.toString.call(message.version) : options.longs === Number ? new $util.LongBits(message.version.low >>> 0, message.version.high >>> 0).toNumber(true) : message.version;
            return object;
        };

        /**
         * Converts this SyncdVersion to JSON.
         * @function toJSON
         * @memberof proto.SyncdVersion
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SyncdVersion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SyncdVersion;
    })();

    proto.ServerErrorReceipt = (function() {

        /**
         * Properties of a ServerErrorReceipt.
         * @memberof proto
         * @interface IServerErrorReceipt
         * @property {string|null} [stanzaId] ServerErrorReceipt stanzaId
         */

        /**
         * Constructs a new ServerErrorReceipt.
         * @memberof proto
         * @classdesc Represents a ServerErrorReceipt.
         * @implements IServerErrorReceipt
         * @constructor
         * @param {proto.IServerErrorReceipt=} [properties] Properties to set
         */
        function ServerErrorReceipt(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ServerErrorReceipt stanzaId.
         * @member {string} stanzaId
         * @memberof proto.ServerErrorReceipt
         * @instance
         */
        ServerErrorReceipt.prototype.stanzaId = "";

        /**
         * Creates a new ServerErrorReceipt instance using the specified properties.
         * @function create
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {proto.IServerErrorReceipt=} [properties] Properties to set
         * @returns {proto.ServerErrorReceipt} ServerErrorReceipt instance
         */
        ServerErrorReceipt.create = function create(properties) {
            return new ServerErrorReceipt(properties);
        };

        /**
         * Encodes the specified ServerErrorReceipt message. Does not implicitly {@link proto.ServerErrorReceipt.verify|verify} messages.
         * @function encode
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {proto.IServerErrorReceipt} message ServerErrorReceipt message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServerErrorReceipt.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.stanzaId);
            return writer;
        };

        /**
         * Encodes the specified ServerErrorReceipt message, length delimited. Does not implicitly {@link proto.ServerErrorReceipt.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {proto.IServerErrorReceipt} message ServerErrorReceipt message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServerErrorReceipt.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ServerErrorReceipt message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ServerErrorReceipt} ServerErrorReceipt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServerErrorReceipt.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ServerErrorReceipt();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.stanzaId = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ServerErrorReceipt message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ServerErrorReceipt} ServerErrorReceipt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServerErrorReceipt.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ServerErrorReceipt message.
         * @function verify
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ServerErrorReceipt.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            return null;
        };

        /**
         * Creates a ServerErrorReceipt message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ServerErrorReceipt} ServerErrorReceipt
         */
        ServerErrorReceipt.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ServerErrorReceipt)
                return object;
            var message = new $root.proto.ServerErrorReceipt();
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            return message;
        };

        /**
         * Creates a plain object from a ServerErrorReceipt message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ServerErrorReceipt
         * @static
         * @param {proto.ServerErrorReceipt} message ServerErrorReceipt
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ServerErrorReceipt.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.stanzaId = "";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            return object;
        };

        /**
         * Converts this ServerErrorReceipt to JSON.
         * @function toJSON
         * @memberof proto.ServerErrorReceipt
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ServerErrorReceipt.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ServerErrorReceipt;
    })();

    proto.MediaRetryNotification = (function() {

        /**
         * Properties of a MediaRetryNotification.
         * @memberof proto
         * @interface IMediaRetryNotification
         * @property {string|null} [stanzaId] MediaRetryNotification stanzaId
         * @property {string|null} [directPath] MediaRetryNotification directPath
         * @property {proto.MediaRetryNotification.MediaRetryNotificationResultType|null} [result] MediaRetryNotification result
         */

        /**
         * Constructs a new MediaRetryNotification.
         * @memberof proto
         * @classdesc Represents a MediaRetryNotification.
         * @implements IMediaRetryNotification
         * @constructor
         * @param {proto.IMediaRetryNotification=} [properties] Properties to set
         */
        function MediaRetryNotification(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MediaRetryNotification stanzaId.
         * @member {string} stanzaId
         * @memberof proto.MediaRetryNotification
         * @instance
         */
        MediaRetryNotification.prototype.stanzaId = "";

        /**
         * MediaRetryNotification directPath.
         * @member {string} directPath
         * @memberof proto.MediaRetryNotification
         * @instance
         */
        MediaRetryNotification.prototype.directPath = "";

        /**
         * MediaRetryNotification result.
         * @member {proto.MediaRetryNotification.MediaRetryNotificationResultType} result
         * @memberof proto.MediaRetryNotification
         * @instance
         */
        MediaRetryNotification.prototype.result = 0;

        /**
         * Creates a new MediaRetryNotification instance using the specified properties.
         * @function create
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.IMediaRetryNotification=} [properties] Properties to set
         * @returns {proto.MediaRetryNotification} MediaRetryNotification instance
         */
        MediaRetryNotification.create = function create(properties) {
            return new MediaRetryNotification(properties);
        };

        /**
         * Encodes the specified MediaRetryNotification message. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @function encode
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.IMediaRetryNotification} message MediaRetryNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MediaRetryNotification.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.stanzaId);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.directPath);
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.result);
            return writer;
        };

        /**
         * Encodes the specified MediaRetryNotification message, length delimited. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.IMediaRetryNotification} message MediaRetryNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MediaRetryNotification.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MediaRetryNotification} MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MediaRetryNotification.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MediaRetryNotification();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.stanzaId = reader.string();
                    break;
                case 2:
                    message.directPath = reader.string();
                    break;
                case 3:
                    message.result = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MediaRetryNotification} MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MediaRetryNotification.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MediaRetryNotification message.
         * @function verify
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MediaRetryNotification.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.result != null && message.hasOwnProperty("result"))
                switch (message.result) {
                default:
                    return "result: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                }
            return null;
        };

        /**
         * Creates a MediaRetryNotification message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MediaRetryNotification} MediaRetryNotification
         */
        MediaRetryNotification.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MediaRetryNotification)
                return object;
            var message = new $root.proto.MediaRetryNotification();
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            switch (object.result) {
            case "GENERAL_ERROR":
            case 0:
                message.result = 0;
                break;
            case "SUCCESS":
            case 1:
                message.result = 1;
                break;
            case "NOT_FOUND":
            case 2:
                message.result = 2;
                break;
            case "DECRYPTION_ERROR":
            case 3:
                message.result = 3;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a MediaRetryNotification message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.MediaRetryNotification} message MediaRetryNotification
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MediaRetryNotification.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.stanzaId = "";
                object.directPath = "";
                object.result = options.enums === String ? "GENERAL_ERROR" : 0;
            }
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = options.enums === String ? $root.proto.MediaRetryNotification.MediaRetryNotificationResultType[message.result] : message.result;
            return object;
        };

        /**
         * Converts this MediaRetryNotification to JSON.
         * @function toJSON
         * @memberof proto.MediaRetryNotification
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MediaRetryNotification.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * MediaRetryNotificationResultType enum.
         * @name proto.MediaRetryNotification.MediaRetryNotificationResultType
         * @enum {number}
         * @property {number} GENERAL_ERROR=0 GENERAL_ERROR value
         * @property {number} SUCCESS=1 SUCCESS value
         * @property {number} NOT_FOUND=2 NOT_FOUND value
         * @property {number} DECRYPTION_ERROR=3 DECRYPTION_ERROR value
         */
        MediaRetryNotification.MediaRetryNotificationResultType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "GENERAL_ERROR"] = 0;
            values[valuesById[1] = "SUCCESS"] = 1;
            values[valuesById[2] = "NOT_FOUND"] = 2;
            values[valuesById[3] = "DECRYPTION_ERROR"] = 3;
            return values;
        })();

        return MediaRetryNotification;
    })();

    proto.MsgOpaqueData = (function() {

        /**
         * Properties of a MsgOpaqueData.
         * @memberof proto
         * @interface IMsgOpaqueData
         * @property {string|null} [body] MsgOpaqueData body
         * @property {string|null} [caption] MsgOpaqueData caption
         * @property {number|null} [lng] MsgOpaqueData lng
         * @property {number|null} [lat] MsgOpaqueData lat
         * @property {number|null} [paymentAmount1000] MsgOpaqueData paymentAmount1000
         * @property {string|null} [paymentNoteMsgBody] MsgOpaqueData paymentNoteMsgBody
         * @property {string|null} [canonicalUrl] MsgOpaqueData canonicalUrl
         * @property {string|null} [matchedText] MsgOpaqueData matchedText
         * @property {string|null} [title] MsgOpaqueData title
         * @property {string|null} [description] MsgOpaqueData description
         * @property {Uint8Array|null} [futureproofBuffer] MsgOpaqueData futureproofBuffer
         * @property {string|null} [clientUrl] MsgOpaqueData clientUrl
         * @property {string|null} [loc] MsgOpaqueData loc
         */

        /**
         * Constructs a new MsgOpaqueData.
         * @memberof proto
         * @classdesc Represents a MsgOpaqueData.
         * @implements IMsgOpaqueData
         * @constructor
         * @param {proto.IMsgOpaqueData=} [properties] Properties to set
         */
        function MsgOpaqueData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MsgOpaqueData body.
         * @member {string} body
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.body = "";

        /**
         * MsgOpaqueData caption.
         * @member {string} caption
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.caption = "";

        /**
         * MsgOpaqueData lng.
         * @member {number} lng
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.lng = 0;

        /**
         * MsgOpaqueData lat.
         * @member {number} lat
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.lat = 0;

        /**
         * MsgOpaqueData paymentAmount1000.
         * @member {number} paymentAmount1000
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.paymentAmount1000 = 0;

        /**
         * MsgOpaqueData paymentNoteMsgBody.
         * @member {string} paymentNoteMsgBody
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.paymentNoteMsgBody = "";

        /**
         * MsgOpaqueData canonicalUrl.
         * @member {string} canonicalUrl
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.canonicalUrl = "";

        /**
         * MsgOpaqueData matchedText.
         * @member {string} matchedText
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.matchedText = "";

        /**
         * MsgOpaqueData title.
         * @member {string} title
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.title = "";

        /**
         * MsgOpaqueData description.
         * @member {string} description
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.description = "";

        /**
         * MsgOpaqueData futureproofBuffer.
         * @member {Uint8Array} futureproofBuffer
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.futureproofBuffer = $util.newBuffer([]);

        /**
         * MsgOpaqueData clientUrl.
         * @member {string} clientUrl
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.clientUrl = "";

        /**
         * MsgOpaqueData loc.
         * @member {string} loc
         * @memberof proto.MsgOpaqueData
         * @instance
         */
        MsgOpaqueData.prototype.loc = "";

        /**
         * Creates a new MsgOpaqueData instance using the specified properties.
         * @function create
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {proto.IMsgOpaqueData=} [properties] Properties to set
         * @returns {proto.MsgOpaqueData} MsgOpaqueData instance
         */
        MsgOpaqueData.create = function create(properties) {
            return new MsgOpaqueData(properties);
        };

        /**
         * Encodes the specified MsgOpaqueData message. Does not implicitly {@link proto.MsgOpaqueData.verify|verify} messages.
         * @function encode
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {proto.IMsgOpaqueData} message MsgOpaqueData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MsgOpaqueData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.body);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.caption);
            if (message.lng != null && Object.hasOwnProperty.call(message, "lng"))
                writer.uint32(/* id 5, wireType 1 =*/41).double(message.lng);
            if (message.lat != null && Object.hasOwnProperty.call(message, "lat"))
                writer.uint32(/* id 7, wireType 1 =*/57).double(message.lat);
            if (message.paymentAmount1000 != null && Object.hasOwnProperty.call(message, "paymentAmount1000"))
                writer.uint32(/* id 8, wireType 0 =*/64).int32(message.paymentAmount1000);
            if (message.paymentNoteMsgBody != null && Object.hasOwnProperty.call(message, "paymentNoteMsgBody"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.paymentNoteMsgBody);
            if (message.canonicalUrl != null && Object.hasOwnProperty.call(message, "canonicalUrl"))
                writer.uint32(/* id 10, wireType 2 =*/82).string(message.canonicalUrl);
            if (message.matchedText != null && Object.hasOwnProperty.call(message, "matchedText"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.matchedText);
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 12, wireType 2 =*/98).string(message.title);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.description);
            if (message.futureproofBuffer != null && Object.hasOwnProperty.call(message, "futureproofBuffer"))
                writer.uint32(/* id 14, wireType 2 =*/114).bytes(message.futureproofBuffer);
            if (message.clientUrl != null && Object.hasOwnProperty.call(message, "clientUrl"))
                writer.uint32(/* id 15, wireType 2 =*/122).string(message.clientUrl);
            if (message.loc != null && Object.hasOwnProperty.call(message, "loc"))
                writer.uint32(/* id 16, wireType 2 =*/130).string(message.loc);
            return writer;
        };

        /**
         * Encodes the specified MsgOpaqueData message, length delimited. Does not implicitly {@link proto.MsgOpaqueData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {proto.IMsgOpaqueData} message MsgOpaqueData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MsgOpaqueData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MsgOpaqueData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MsgOpaqueData} MsgOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MsgOpaqueData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MsgOpaqueData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.body = reader.string();
                    break;
                case 3:
                    message.caption = reader.string();
                    break;
                case 5:
                    message.lng = reader.double();
                    break;
                case 7:
                    message.lat = reader.double();
                    break;
                case 8:
                    message.paymentAmount1000 = reader.int32();
                    break;
                case 9:
                    message.paymentNoteMsgBody = reader.string();
                    break;
                case 10:
                    message.canonicalUrl = reader.string();
                    break;
                case 11:
                    message.matchedText = reader.string();
                    break;
                case 12:
                    message.title = reader.string();
                    break;
                case 13:
                    message.description = reader.string();
                    break;
                case 14:
                    message.futureproofBuffer = reader.bytes();
                    break;
                case 15:
                    message.clientUrl = reader.string();
                    break;
                case 16:
                    message.loc = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MsgOpaqueData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MsgOpaqueData} MsgOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MsgOpaqueData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MsgOpaqueData message.
         * @function verify
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MsgOpaqueData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.body != null && message.hasOwnProperty("body"))
                if (!$util.isString(message.body))
                    return "body: string expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            if (message.lng != null && message.hasOwnProperty("lng"))
                if (typeof message.lng !== "number")
                    return "lng: number expected";
            if (message.lat != null && message.hasOwnProperty("lat"))
                if (typeof message.lat !== "number")
                    return "lat: number expected";
            if (message.paymentAmount1000 != null && message.hasOwnProperty("paymentAmount1000"))
                if (!$util.isInteger(message.paymentAmount1000))
                    return "paymentAmount1000: integer expected";
            if (message.paymentNoteMsgBody != null && message.hasOwnProperty("paymentNoteMsgBody"))
                if (!$util.isString(message.paymentNoteMsgBody))
                    return "paymentNoteMsgBody: string expected";
            if (message.canonicalUrl != null && message.hasOwnProperty("canonicalUrl"))
                if (!$util.isString(message.canonicalUrl))
                    return "canonicalUrl: string expected";
            if (message.matchedText != null && message.hasOwnProperty("matchedText"))
                if (!$util.isString(message.matchedText))
                    return "matchedText: string expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            if (message.futureproofBuffer != null && message.hasOwnProperty("futureproofBuffer"))
                if (!(message.futureproofBuffer && typeof message.futureproofBuffer.length === "number" || $util.isString(message.futureproofBuffer)))
                    return "futureproofBuffer: buffer expected";
            if (message.clientUrl != null && message.hasOwnProperty("clientUrl"))
                if (!$util.isString(message.clientUrl))
                    return "clientUrl: string expected";
            if (message.loc != null && message.hasOwnProperty("loc"))
                if (!$util.isString(message.loc))
                    return "loc: string expected";
            return null;
        };

        /**
         * Creates a MsgOpaqueData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MsgOpaqueData} MsgOpaqueData
         */
        MsgOpaqueData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MsgOpaqueData)
                return object;
            var message = new $root.proto.MsgOpaqueData();
            if (object.body != null)
                message.body = String(object.body);
            if (object.caption != null)
                message.caption = String(object.caption);
            if (object.lng != null)
                message.lng = Number(object.lng);
            if (object.lat != null)
                message.lat = Number(object.lat);
            if (object.paymentAmount1000 != null)
                message.paymentAmount1000 = object.paymentAmount1000 | 0;
            if (object.paymentNoteMsgBody != null)
                message.paymentNoteMsgBody = String(object.paymentNoteMsgBody);
            if (object.canonicalUrl != null)
                message.canonicalUrl = String(object.canonicalUrl);
            if (object.matchedText != null)
                message.matchedText = String(object.matchedText);
            if (object.title != null)
                message.title = String(object.title);
            if (object.description != null)
                message.description = String(object.description);
            if (object.futureproofBuffer != null)
                if (typeof object.futureproofBuffer === "string")
                    $util.base64.decode(object.futureproofBuffer, message.futureproofBuffer = $util.newBuffer($util.base64.length(object.futureproofBuffer)), 0);
                else if (object.futureproofBuffer.length)
                    message.futureproofBuffer = object.futureproofBuffer;
            if (object.clientUrl != null)
                message.clientUrl = String(object.clientUrl);
            if (object.loc != null)
                message.loc = String(object.loc);
            return message;
        };

        /**
         * Creates a plain object from a MsgOpaqueData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MsgOpaqueData
         * @static
         * @param {proto.MsgOpaqueData} message MsgOpaqueData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MsgOpaqueData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.body = "";
                object.caption = "";
                object.lng = 0;
                object.lat = 0;
                object.paymentAmount1000 = 0;
                object.paymentNoteMsgBody = "";
                object.canonicalUrl = "";
                object.matchedText = "";
                object.title = "";
                object.description = "";
                if (options.bytes === String)
                    object.futureproofBuffer = "";
                else {
                    object.futureproofBuffer = [];
                    if (options.bytes !== Array)
                        object.futureproofBuffer = $util.newBuffer(object.futureproofBuffer);
                }
                object.clientUrl = "";
                object.loc = "";
            }
            if (message.body != null && message.hasOwnProperty("body"))
                object.body = message.body;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            if (message.lng != null && message.hasOwnProperty("lng"))
                object.lng = options.json && !isFinite(message.lng) ? String(message.lng) : message.lng;
            if (message.lat != null && message.hasOwnProperty("lat"))
                object.lat = options.json && !isFinite(message.lat) ? String(message.lat) : message.lat;
            if (message.paymentAmount1000 != null && message.hasOwnProperty("paymentAmount1000"))
                object.paymentAmount1000 = message.paymentAmount1000;
            if (message.paymentNoteMsgBody != null && message.hasOwnProperty("paymentNoteMsgBody"))
                object.paymentNoteMsgBody = message.paymentNoteMsgBody;
            if (message.canonicalUrl != null && message.hasOwnProperty("canonicalUrl"))
                object.canonicalUrl = message.canonicalUrl;
            if (message.matchedText != null && message.hasOwnProperty("matchedText"))
                object.matchedText = message.matchedText;
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            if (message.futureproofBuffer != null && message.hasOwnProperty("futureproofBuffer"))
                object.futureproofBuffer = options.bytes === String ? $util.base64.encode(message.futureproofBuffer, 0, message.futureproofBuffer.length) : options.bytes === Array ? Array.prototype.slice.call(message.futureproofBuffer) : message.futureproofBuffer;
            if (message.clientUrl != null && message.hasOwnProperty("clientUrl"))
                object.clientUrl = message.clientUrl;
            if (message.loc != null && message.hasOwnProperty("loc"))
                object.loc = message.loc;
            return object;
        };

        /**
         * Converts this MsgOpaqueData to JSON.
         * @function toJSON
         * @memberof proto.MsgOpaqueData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MsgOpaqueData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MsgOpaqueData;
    })();

    proto.MsgRowOpaqueData = (function() {

        /**
         * Properties of a MsgRowOpaqueData.
         * @memberof proto
         * @interface IMsgRowOpaqueData
         * @property {proto.IMsgOpaqueData|null} [currentMsg] MsgRowOpaqueData currentMsg
         * @property {proto.IMsgOpaqueData|null} [quotedMsg] MsgRowOpaqueData quotedMsg
         */

        /**
         * Constructs a new MsgRowOpaqueData.
         * @memberof proto
         * @classdesc Represents a MsgRowOpaqueData.
         * @implements IMsgRowOpaqueData
         * @constructor
         * @param {proto.IMsgRowOpaqueData=} [properties] Properties to set
         */
        function MsgRowOpaqueData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MsgRowOpaqueData currentMsg.
         * @member {proto.IMsgOpaqueData|null|undefined} currentMsg
         * @memberof proto.MsgRowOpaqueData
         * @instance
         */
        MsgRowOpaqueData.prototype.currentMsg = null;

        /**
         * MsgRowOpaqueData quotedMsg.
         * @member {proto.IMsgOpaqueData|null|undefined} quotedMsg
         * @memberof proto.MsgRowOpaqueData
         * @instance
         */
        MsgRowOpaqueData.prototype.quotedMsg = null;

        /**
         * Creates a new MsgRowOpaqueData instance using the specified properties.
         * @function create
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {proto.IMsgRowOpaqueData=} [properties] Properties to set
         * @returns {proto.MsgRowOpaqueData} MsgRowOpaqueData instance
         */
        MsgRowOpaqueData.create = function create(properties) {
            return new MsgRowOpaqueData(properties);
        };

        /**
         * Encodes the specified MsgRowOpaqueData message. Does not implicitly {@link proto.MsgRowOpaqueData.verify|verify} messages.
         * @function encode
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {proto.IMsgRowOpaqueData} message MsgRowOpaqueData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MsgRowOpaqueData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.currentMsg != null && Object.hasOwnProperty.call(message, "currentMsg"))
                $root.proto.MsgOpaqueData.encode(message.currentMsg, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.quotedMsg != null && Object.hasOwnProperty.call(message, "quotedMsg"))
                $root.proto.MsgOpaqueData.encode(message.quotedMsg, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified MsgRowOpaqueData message, length delimited. Does not implicitly {@link proto.MsgRowOpaqueData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {proto.IMsgRowOpaqueData} message MsgRowOpaqueData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MsgRowOpaqueData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MsgRowOpaqueData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MsgRowOpaqueData} MsgRowOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MsgRowOpaqueData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MsgRowOpaqueData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.currentMsg = $root.proto.MsgOpaqueData.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.quotedMsg = $root.proto.MsgOpaqueData.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MsgRowOpaqueData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MsgRowOpaqueData} MsgRowOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MsgRowOpaqueData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MsgRowOpaqueData message.
         * @function verify
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MsgRowOpaqueData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.currentMsg != null && message.hasOwnProperty("currentMsg")) {
                var error = $root.proto.MsgOpaqueData.verify(message.currentMsg);
                if (error)
                    return "currentMsg." + error;
            }
            if (message.quotedMsg != null && message.hasOwnProperty("quotedMsg")) {
                var error = $root.proto.MsgOpaqueData.verify(message.quotedMsg);
                if (error)
                    return "quotedMsg." + error;
            }
            return null;
        };

        /**
         * Creates a MsgRowOpaqueData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MsgRowOpaqueData} MsgRowOpaqueData
         */
        MsgRowOpaqueData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MsgRowOpaqueData)
                return object;
            var message = new $root.proto.MsgRowOpaqueData();
            if (object.currentMsg != null) {
                if (typeof object.currentMsg !== "object")
                    throw TypeError(".proto.MsgRowOpaqueData.currentMsg: object expected");
                message.currentMsg = $root.proto.MsgOpaqueData.fromObject(object.currentMsg);
            }
            if (object.quotedMsg != null) {
                if (typeof object.quotedMsg !== "object")
                    throw TypeError(".proto.MsgRowOpaqueData.quotedMsg: object expected");
                message.quotedMsg = $root.proto.MsgOpaqueData.fromObject(object.quotedMsg);
            }
            return message;
        };

        /**
         * Creates a plain object from a MsgRowOpaqueData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MsgRowOpaqueData
         * @static
         * @param {proto.MsgRowOpaqueData} message MsgRowOpaqueData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MsgRowOpaqueData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.currentMsg = null;
                object.quotedMsg = null;
            }
            if (message.currentMsg != null && message.hasOwnProperty("currentMsg"))
                object.currentMsg = $root.proto.MsgOpaqueData.toObject(message.currentMsg, options);
            if (message.quotedMsg != null && message.hasOwnProperty("quotedMsg"))
                object.quotedMsg = $root.proto.MsgOpaqueData.toObject(message.quotedMsg, options);
            return object;
        };

        /**
         * Converts this MsgRowOpaqueData to JSON.
         * @function toJSON
         * @memberof proto.MsgRowOpaqueData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MsgRowOpaqueData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MsgRowOpaqueData;
    })();

    proto.GlobalSettings = (function() {

        /**
         * Properties of a GlobalSettings.
         * @memberof proto
         * @interface IGlobalSettings
         * @property {proto.IWallpaperSettings|null} [lightThemeWallpaper] GlobalSettings lightThemeWallpaper
         * @property {proto.MediaVisibility|null} [mediaVisibility] GlobalSettings mediaVisibility
         * @property {proto.IWallpaperSettings|null} [darkThemeWallpaper] GlobalSettings darkThemeWallpaper
         */

        /**
         * Constructs a new GlobalSettings.
         * @memberof proto
         * @classdesc Represents a GlobalSettings.
         * @implements IGlobalSettings
         * @constructor
         * @param {proto.IGlobalSettings=} [properties] Properties to set
         */
        function GlobalSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GlobalSettings lightThemeWallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} lightThemeWallpaper
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.lightThemeWallpaper = null;

        /**
         * GlobalSettings mediaVisibility.
         * @member {proto.MediaVisibility} mediaVisibility
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.mediaVisibility = 0;

        /**
         * GlobalSettings darkThemeWallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} darkThemeWallpaper
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.darkThemeWallpaper = null;

        /**
         * Creates a new GlobalSettings instance using the specified properties.
         * @function create
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings=} [properties] Properties to set
         * @returns {proto.GlobalSettings} GlobalSettings instance
         */
        GlobalSettings.create = function create(properties) {
            return new GlobalSettings(properties);
        };

        /**
         * Encodes the specified GlobalSettings message. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings} message GlobalSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GlobalSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lightThemeWallpaper != null && Object.hasOwnProperty.call(message, "lightThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(message.lightThemeWallpaper, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.mediaVisibility != null && Object.hasOwnProperty.call(message, "mediaVisibility"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaVisibility);
            if (message.darkThemeWallpaper != null && Object.hasOwnProperty.call(message, "darkThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(message.darkThemeWallpaper, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified GlobalSettings message, length delimited. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings} message GlobalSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GlobalSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.GlobalSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.GlobalSettings} GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GlobalSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.GlobalSettings();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.lightThemeWallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.mediaVisibility = reader.int32();
                    break;
                case 3:
                    message.darkThemeWallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.GlobalSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.GlobalSettings} GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GlobalSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GlobalSettings message.
         * @function verify
         * @memberof proto.GlobalSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GlobalSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.lightThemeWallpaper != null && message.hasOwnProperty("lightThemeWallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.lightThemeWallpaper);
                if (error)
                    return "lightThemeWallpaper." + error;
            }
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                switch (message.mediaVisibility) {
                default:
                    return "mediaVisibility: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.darkThemeWallpaper != null && message.hasOwnProperty("darkThemeWallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.darkThemeWallpaper);
                if (error)
                    return "darkThemeWallpaper." + error;
            }
            return null;
        };

        /**
         * Creates a GlobalSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.GlobalSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.GlobalSettings} GlobalSettings
         */
        GlobalSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.GlobalSettings)
                return object;
            var message = new $root.proto.GlobalSettings();
            if (object.lightThemeWallpaper != null) {
                if (typeof object.lightThemeWallpaper !== "object")
                    throw TypeError(".proto.GlobalSettings.lightThemeWallpaper: object expected");
                message.lightThemeWallpaper = $root.proto.WallpaperSettings.fromObject(object.lightThemeWallpaper);
            }
            switch (object.mediaVisibility) {
            case "DEFAULT":
            case 0:
                message.mediaVisibility = 0;
                break;
            case "OFF":
            case 1:
                message.mediaVisibility = 1;
                break;
            case "ON":
            case 2:
                message.mediaVisibility = 2;
                break;
            }
            if (object.darkThemeWallpaper != null) {
                if (typeof object.darkThemeWallpaper !== "object")
                    throw TypeError(".proto.GlobalSettings.darkThemeWallpaper: object expected");
                message.darkThemeWallpaper = $root.proto.WallpaperSettings.fromObject(object.darkThemeWallpaper);
            }
            return message;
        };

        /**
         * Creates a plain object from a GlobalSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.GlobalSettings} message GlobalSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GlobalSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.lightThemeWallpaper = null;
                object.mediaVisibility = options.enums === String ? "DEFAULT" : 0;
                object.darkThemeWallpaper = null;
            }
            if (message.lightThemeWallpaper != null && message.hasOwnProperty("lightThemeWallpaper"))
                object.lightThemeWallpaper = $root.proto.WallpaperSettings.toObject(message.lightThemeWallpaper, options);
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                object.mediaVisibility = options.enums === String ? $root.proto.MediaVisibility[message.mediaVisibility] : message.mediaVisibility;
            if (message.darkThemeWallpaper != null && message.hasOwnProperty("darkThemeWallpaper"))
                object.darkThemeWallpaper = $root.proto.WallpaperSettings.toObject(message.darkThemeWallpaper, options);
            return object;
        };

        /**
         * Converts this GlobalSettings to JSON.
         * @function toJSON
         * @memberof proto.GlobalSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GlobalSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GlobalSettings;
    })();

    proto.WallpaperSettings = (function() {

        /**
         * Properties of a WallpaperSettings.
         * @memberof proto
         * @interface IWallpaperSettings
         * @property {string|null} [filename] WallpaperSettings filename
         * @property {number|null} [opacity] WallpaperSettings opacity
         */

        /**
         * Constructs a new WallpaperSettings.
         * @memberof proto
         * @classdesc Represents a WallpaperSettings.
         * @implements IWallpaperSettings
         * @constructor
         * @param {proto.IWallpaperSettings=} [properties] Properties to set
         */
        function WallpaperSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * WallpaperSettings filename.
         * @member {string} filename
         * @memberof proto.WallpaperSettings
         * @instance
         */
        WallpaperSettings.prototype.filename = "";

        /**
         * WallpaperSettings opacity.
         * @member {number} opacity
         * @memberof proto.WallpaperSettings
         * @instance
         */
        WallpaperSettings.prototype.opacity = 0;

        /**
         * Creates a new WallpaperSettings instance using the specified properties.
         * @function create
         * @memberof proto.WallpaperSettings
         * @static
         * @param {proto.IWallpaperSettings=} [properties] Properties to set
         * @returns {proto.WallpaperSettings} WallpaperSettings instance
         */
        WallpaperSettings.create = function create(properties) {
            return new WallpaperSettings(properties);
        };

        /**
         * Encodes the specified WallpaperSettings message. Does not implicitly {@link proto.WallpaperSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.WallpaperSettings
         * @static
         * @param {proto.IWallpaperSettings} message WallpaperSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WallpaperSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.filename != null && Object.hasOwnProperty.call(message, "filename"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.filename);
            if (message.opacity != null && Object.hasOwnProperty.call(message, "opacity"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.opacity);
            return writer;
        };

        /**
         * Encodes the specified WallpaperSettings message, length delimited. Does not implicitly {@link proto.WallpaperSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.WallpaperSettings
         * @static
         * @param {proto.IWallpaperSettings} message WallpaperSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WallpaperSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WallpaperSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.WallpaperSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.WallpaperSettings} WallpaperSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WallpaperSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.WallpaperSettings();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.filename = reader.string();
                    break;
                case 2:
                    message.opacity = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a WallpaperSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.WallpaperSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.WallpaperSettings} WallpaperSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WallpaperSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WallpaperSettings message.
         * @function verify
         * @memberof proto.WallpaperSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WallpaperSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.filename != null && message.hasOwnProperty("filename"))
                if (!$util.isString(message.filename))
                    return "filename: string expected";
            if (message.opacity != null && message.hasOwnProperty("opacity"))
                if (!$util.isInteger(message.opacity))
                    return "opacity: integer expected";
            return null;
        };

        /**
         * Creates a WallpaperSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.WallpaperSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.WallpaperSettings} WallpaperSettings
         */
        WallpaperSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.WallpaperSettings)
                return object;
            var message = new $root.proto.WallpaperSettings();
            if (object.filename != null)
                message.filename = String(object.filename);
            if (object.opacity != null)
                message.opacity = object.opacity >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a WallpaperSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.WallpaperSettings
         * @static
         * @param {proto.WallpaperSettings} message WallpaperSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WallpaperSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.filename = "";
                object.opacity = 0;
            }
            if (message.filename != null && message.hasOwnProperty("filename"))
                object.filename = message.filename;
            if (message.opacity != null && message.hasOwnProperty("opacity"))
                object.opacity = message.opacity;
            return object;
        };

        /**
         * Converts this WallpaperSettings to JSON.
         * @function toJSON
         * @memberof proto.WallpaperSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WallpaperSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return WallpaperSettings;
    })();

    proto.GroupParticipant = (function() {

        /**
         * Properties of a GroupParticipant.
         * @memberof proto
         * @interface IGroupParticipant
         * @property {string} userJid GroupParticipant userJid
         * @property {proto.GroupParticipant.GroupParticipantRank|null} [rank] GroupParticipant rank
         */

        /**
         * Constructs a new GroupParticipant.
         * @memberof proto
         * @classdesc Represents a GroupParticipant.
         * @implements IGroupParticipant
         * @constructor
         * @param {proto.IGroupParticipant=} [properties] Properties to set
         */
        function GroupParticipant(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GroupParticipant userJid.
         * @member {string} userJid
         * @memberof proto.GroupParticipant
         * @instance
         */
        GroupParticipant.prototype.userJid = "";

        /**
         * GroupParticipant rank.
         * @member {proto.GroupParticipant.GroupParticipantRank} rank
         * @memberof proto.GroupParticipant
         * @instance
         */
        GroupParticipant.prototype.rank = 0;

        /**
         * Creates a new GroupParticipant instance using the specified properties.
         * @function create
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.IGroupParticipant=} [properties] Properties to set
         * @returns {proto.GroupParticipant} GroupParticipant instance
         */
        GroupParticipant.create = function create(properties) {
            return new GroupParticipant(properties);
        };

        /**
         * Encodes the specified GroupParticipant message. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @function encode
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.IGroupParticipant} message GroupParticipant message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GroupParticipant.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.userJid);
            if (message.rank != null && Object.hasOwnProperty.call(message, "rank"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.rank);
            return writer;
        };

        /**
         * Encodes the specified GroupParticipant message, length delimited. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.IGroupParticipant} message GroupParticipant message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GroupParticipant.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer.
         * @function decode
         * @memberof proto.GroupParticipant
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.GroupParticipant} GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GroupParticipant.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.GroupParticipant();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.userJid = reader.string();
                    break;
                case 2:
                    message.rank = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("userJid"))
                throw $util.ProtocolError("missing required 'userJid'", { instance: message });
            return message;
        };

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.GroupParticipant
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.GroupParticipant} GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GroupParticipant.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GroupParticipant message.
         * @function verify
         * @memberof proto.GroupParticipant
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GroupParticipant.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.userJid))
                return "userJid: string expected";
            if (message.rank != null && message.hasOwnProperty("rank"))
                switch (message.rank) {
                default:
                    return "rank: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            return null;
        };

        /**
         * Creates a GroupParticipant message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.GroupParticipant
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.GroupParticipant} GroupParticipant
         */
        GroupParticipant.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.GroupParticipant)
                return object;
            var message = new $root.proto.GroupParticipant();
            if (object.userJid != null)
                message.userJid = String(object.userJid);
            switch (object.rank) {
            case "REGULAR":
            case 0:
                message.rank = 0;
                break;
            case "ADMIN":
            case 1:
                message.rank = 1;
                break;
            case "SUPERADMIN":
            case 2:
                message.rank = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a GroupParticipant message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.GroupParticipant} message GroupParticipant
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GroupParticipant.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.userJid = "";
                object.rank = options.enums === String ? "REGULAR" : 0;
            }
            if (message.userJid != null && message.hasOwnProperty("userJid"))
                object.userJid = message.userJid;
            if (message.rank != null && message.hasOwnProperty("rank"))
                object.rank = options.enums === String ? $root.proto.GroupParticipant.GroupParticipantRank[message.rank] : message.rank;
            return object;
        };

        /**
         * Converts this GroupParticipant to JSON.
         * @function toJSON
         * @memberof proto.GroupParticipant
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GroupParticipant.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * GroupParticipantRank enum.
         * @name proto.GroupParticipant.GroupParticipantRank
         * @enum {number}
         * @property {number} REGULAR=0 REGULAR value
         * @property {number} ADMIN=1 ADMIN value
         * @property {number} SUPERADMIN=2 SUPERADMIN value
         */
        GroupParticipant.GroupParticipantRank = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "REGULAR"] = 0;
            values[valuesById[1] = "ADMIN"] = 1;
            values[valuesById[2] = "SUPERADMIN"] = 2;
            return values;
        })();

        return GroupParticipant;
    })();

    proto.Pushname = (function() {

        /**
         * Properties of a Pushname.
         * @memberof proto
         * @interface IPushname
         * @property {string|null} [id] Pushname id
         * @property {string|null} [pushname] Pushname pushname
         */

        /**
         * Constructs a new Pushname.
         * @memberof proto
         * @classdesc Represents a Pushname.
         * @implements IPushname
         * @constructor
         * @param {proto.IPushname=} [properties] Properties to set
         */
        function Pushname(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Pushname id.
         * @member {string} id
         * @memberof proto.Pushname
         * @instance
         */
        Pushname.prototype.id = "";

        /**
         * Pushname pushname.
         * @member {string} pushname
         * @memberof proto.Pushname
         * @instance
         */
        Pushname.prototype.pushname = "";

        /**
         * Creates a new Pushname instance using the specified properties.
         * @function create
         * @memberof proto.Pushname
         * @static
         * @param {proto.IPushname=} [properties] Properties to set
         * @returns {proto.Pushname} Pushname instance
         */
        Pushname.create = function create(properties) {
            return new Pushname(properties);
        };

        /**
         * Encodes the specified Pushname message. Does not implicitly {@link proto.Pushname.verify|verify} messages.
         * @function encode
         * @memberof proto.Pushname
         * @static
         * @param {proto.IPushname} message Pushname message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Pushname.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            if (message.pushname != null && Object.hasOwnProperty.call(message, "pushname"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.pushname);
            return writer;
        };

        /**
         * Encodes the specified Pushname message, length delimited. Does not implicitly {@link proto.Pushname.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Pushname
         * @static
         * @param {proto.IPushname} message Pushname message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Pushname.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Pushname message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Pushname
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Pushname} Pushname
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Pushname.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Pushname();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                case 2:
                    message.pushname = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Pushname message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Pushname
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Pushname} Pushname
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Pushname.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Pushname message.
         * @function verify
         * @memberof proto.Pushname
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Pushname.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            if (message.pushname != null && message.hasOwnProperty("pushname"))
                if (!$util.isString(message.pushname))
                    return "pushname: string expected";
            return null;
        };

        /**
         * Creates a Pushname message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Pushname
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Pushname} Pushname
         */
        Pushname.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Pushname)
                return object;
            var message = new $root.proto.Pushname();
            if (object.id != null)
                message.id = String(object.id);
            if (object.pushname != null)
                message.pushname = String(object.pushname);
            return message;
        };

        /**
         * Creates a plain object from a Pushname message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Pushname
         * @static
         * @param {proto.Pushname} message Pushname
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Pushname.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = "";
                object.pushname = "";
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.pushname != null && message.hasOwnProperty("pushname"))
                object.pushname = message.pushname;
            return object;
        };

        /**
         * Converts this Pushname to JSON.
         * @function toJSON
         * @memberof proto.Pushname
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Pushname.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Pushname;
    })();

    proto.HistorySyncMsg = (function() {

        /**
         * Properties of a HistorySyncMsg.
         * @memberof proto
         * @interface IHistorySyncMsg
         * @property {proto.IWebMessageInfo|null} [message] HistorySyncMsg message
         * @property {number|Long|null} [msgOrderId] HistorySyncMsg msgOrderId
         */

        /**
         * Constructs a new HistorySyncMsg.
         * @memberof proto
         * @classdesc Represents a HistorySyncMsg.
         * @implements IHistorySyncMsg
         * @constructor
         * @param {proto.IHistorySyncMsg=} [properties] Properties to set
         */
        function HistorySyncMsg(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HistorySyncMsg message.
         * @member {proto.IWebMessageInfo|null|undefined} message
         * @memberof proto.HistorySyncMsg
         * @instance
         */
        HistorySyncMsg.prototype.message = null;

        /**
         * HistorySyncMsg msgOrderId.
         * @member {number|Long} msgOrderId
         * @memberof proto.HistorySyncMsg
         * @instance
         */
        HistorySyncMsg.prototype.msgOrderId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new HistorySyncMsg instance using the specified properties.
         * @function create
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.IHistorySyncMsg=} [properties] Properties to set
         * @returns {proto.HistorySyncMsg} HistorySyncMsg instance
         */
        HistorySyncMsg.create = function create(properties) {
            return new HistorySyncMsg(properties);
        };

        /**
         * Encodes the specified HistorySyncMsg message. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @function encode
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.IHistorySyncMsg} message HistorySyncMsg message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySyncMsg.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.WebMessageInfo.encode(message.message, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.msgOrderId != null && Object.hasOwnProperty.call(message, "msgOrderId"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.msgOrderId);
            return writer;
        };

        /**
         * Encodes the specified HistorySyncMsg message, length delimited. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.IHistorySyncMsg} message HistorySyncMsg message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySyncMsg.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HistorySyncMsg} HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySyncMsg.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HistorySyncMsg();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.message = $root.proto.WebMessageInfo.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.msgOrderId = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HistorySyncMsg} HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySyncMsg.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HistorySyncMsg message.
         * @function verify
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HistorySyncMsg.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.message != null && message.hasOwnProperty("message")) {
                var error = $root.proto.WebMessageInfo.verify(message.message);
                if (error)
                    return "message." + error;
            }
            if (message.msgOrderId != null && message.hasOwnProperty("msgOrderId"))
                if (!$util.isInteger(message.msgOrderId) && !(message.msgOrderId && $util.isInteger(message.msgOrderId.low) && $util.isInteger(message.msgOrderId.high)))
                    return "msgOrderId: integer|Long expected";
            return null;
        };

        /**
         * Creates a HistorySyncMsg message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HistorySyncMsg} HistorySyncMsg
         */
        HistorySyncMsg.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HistorySyncMsg)
                return object;
            var message = new $root.proto.HistorySyncMsg();
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.HistorySyncMsg.message: object expected");
                message.message = $root.proto.WebMessageInfo.fromObject(object.message);
            }
            if (object.msgOrderId != null)
                if ($util.Long)
                    (message.msgOrderId = $util.Long.fromValue(object.msgOrderId)).unsigned = true;
                else if (typeof object.msgOrderId === "string")
                    message.msgOrderId = parseInt(object.msgOrderId, 10);
                else if (typeof object.msgOrderId === "number")
                    message.msgOrderId = object.msgOrderId;
                else if (typeof object.msgOrderId === "object")
                    message.msgOrderId = new $util.LongBits(object.msgOrderId.low >>> 0, object.msgOrderId.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a HistorySyncMsg message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.HistorySyncMsg} message HistorySyncMsg
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HistorySyncMsg.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.message = null;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.msgOrderId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.msgOrderId = options.longs === String ? "0" : 0;
            }
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = $root.proto.WebMessageInfo.toObject(message.message, options);
            if (message.msgOrderId != null && message.hasOwnProperty("msgOrderId"))
                if (typeof message.msgOrderId === "number")
                    object.msgOrderId = options.longs === String ? String(message.msgOrderId) : message.msgOrderId;
                else
                    object.msgOrderId = options.longs === String ? $util.Long.prototype.toString.call(message.msgOrderId) : options.longs === Number ? new $util.LongBits(message.msgOrderId.low >>> 0, message.msgOrderId.high >>> 0).toNumber(true) : message.msgOrderId;
            return object;
        };

        /**
         * Converts this HistorySyncMsg to JSON.
         * @function toJSON
         * @memberof proto.HistorySyncMsg
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HistorySyncMsg.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HistorySyncMsg;
    })();

    proto.Conversation = (function() {

        /**
         * Properties of a Conversation.
         * @memberof proto
         * @interface IConversation
         * @property {string} id Conversation id
         * @property {Array.<proto.IHistorySyncMsg>|null} [messages] Conversation messages
         * @property {string|null} [newJid] Conversation newJid
         * @property {string|null} [oldJid] Conversation oldJid
         * @property {number|Long|null} [lastMsgTimestamp] Conversation lastMsgTimestamp
         * @property {number|null} [unreadCount] Conversation unreadCount
         * @property {boolean|null} [readOnly] Conversation readOnly
         * @property {boolean|null} [endOfHistoryTransfer] Conversation endOfHistoryTransfer
         * @property {number|null} [ephemeralExpiration] Conversation ephemeralExpiration
         * @property {number|Long|null} [ephemeralSettingTimestamp] Conversation ephemeralSettingTimestamp
         * @property {proto.Conversation.ConversationEndOfHistoryTransferType|null} [endOfHistoryTransferType] Conversation endOfHistoryTransferType
         * @property {number|Long|null} [conversationTimestamp] Conversation conversationTimestamp
         * @property {string|null} [name] Conversation name
         * @property {string|null} [pHash] Conversation pHash
         * @property {boolean|null} [notSpam] Conversation notSpam
         * @property {boolean|null} [archived] Conversation archived
         * @property {proto.IDisappearingMode|null} [disappearingMode] Conversation disappearingMode
         * @property {number|null} [unreadMentionCount] Conversation unreadMentionCount
         * @property {boolean|null} [markedAsUnread] Conversation markedAsUnread
         * @property {Array.<proto.IGroupParticipant>|null} [participant] Conversation participant
         * @property {Uint8Array|null} [tcToken] Conversation tcToken
         * @property {number|Long|null} [tcTokenTimestamp] Conversation tcTokenTimestamp
         * @property {Uint8Array|null} [contactPrimaryIdentityKey] Conversation contactPrimaryIdentityKey
         * @property {number|null} [pinned] Conversation pinned
         * @property {number|Long|null} [muteEndTime] Conversation muteEndTime
         * @property {proto.IWallpaperSettings|null} [wallpaper] Conversation wallpaper
         * @property {proto.MediaVisibility|null} [mediaVisibility] Conversation mediaVisibility
         * @property {number|Long|null} [tcTokenSenderTimestamp] Conversation tcTokenSenderTimestamp
         * @property {boolean|null} [suspended] Conversation suspended
         */

        /**
         * Constructs a new Conversation.
         * @memberof proto
         * @classdesc Represents a Conversation.
         * @implements IConversation
         * @constructor
         * @param {proto.IConversation=} [properties] Properties to set
         */
        function Conversation(properties) {
            this.messages = [];
            this.participant = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Conversation id.
         * @member {string} id
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.id = "";

        /**
         * Conversation messages.
         * @member {Array.<proto.IHistorySyncMsg>} messages
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.messages = $util.emptyArray;

        /**
         * Conversation newJid.
         * @member {string} newJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.newJid = "";

        /**
         * Conversation oldJid.
         * @member {string} oldJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.oldJid = "";

        /**
         * Conversation lastMsgTimestamp.
         * @member {number|Long} lastMsgTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.lastMsgTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation unreadCount.
         * @member {number} unreadCount
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.unreadCount = 0;

        /**
         * Conversation readOnly.
         * @member {boolean} readOnly
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.readOnly = false;

        /**
         * Conversation endOfHistoryTransfer.
         * @member {boolean} endOfHistoryTransfer
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.endOfHistoryTransfer = false;

        /**
         * Conversation ephemeralExpiration.
         * @member {number} ephemeralExpiration
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.ephemeralExpiration = 0;

        /**
         * Conversation ephemeralSettingTimestamp.
         * @member {number|Long} ephemeralSettingTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Conversation endOfHistoryTransferType.
         * @member {proto.Conversation.ConversationEndOfHistoryTransferType} endOfHistoryTransferType
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.endOfHistoryTransferType = 0;

        /**
         * Conversation conversationTimestamp.
         * @member {number|Long} conversationTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.conversationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation name.
         * @member {string} name
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.name = "";

        /**
         * Conversation pHash.
         * @member {string} pHash
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pHash = "";

        /**
         * Conversation notSpam.
         * @member {boolean} notSpam
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.notSpam = false;

        /**
         * Conversation archived.
         * @member {boolean} archived
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.archived = false;

        /**
         * Conversation disappearingMode.
         * @member {proto.IDisappearingMode|null|undefined} disappearingMode
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.disappearingMode = null;

        /**
         * Conversation unreadMentionCount.
         * @member {number} unreadMentionCount
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.unreadMentionCount = 0;

        /**
         * Conversation markedAsUnread.
         * @member {boolean} markedAsUnread
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.markedAsUnread = false;

        /**
         * Conversation participant.
         * @member {Array.<proto.IGroupParticipant>} participant
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.participant = $util.emptyArray;

        /**
         * Conversation tcToken.
         * @member {Uint8Array} tcToken
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcToken = $util.newBuffer([]);

        /**
         * Conversation tcTokenTimestamp.
         * @member {number|Long} tcTokenTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcTokenTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation contactPrimaryIdentityKey.
         * @member {Uint8Array} contactPrimaryIdentityKey
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.contactPrimaryIdentityKey = $util.newBuffer([]);

        /**
         * Conversation pinned.
         * @member {number} pinned
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pinned = 0;

        /**
         * Conversation muteEndTime.
         * @member {number|Long} muteEndTime
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.muteEndTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation wallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} wallpaper
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.wallpaper = null;

        /**
         * Conversation mediaVisibility.
         * @member {proto.MediaVisibility} mediaVisibility
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.mediaVisibility = 0;

        /**
         * Conversation tcTokenSenderTimestamp.
         * @member {number|Long} tcTokenSenderTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcTokenSenderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation suspended.
         * @member {boolean} suspended
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.suspended = false;

        /**
         * Creates a new Conversation instance using the specified properties.
         * @function create
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation=} [properties] Properties to set
         * @returns {proto.Conversation} Conversation instance
         */
        Conversation.create = function create(properties) {
            return new Conversation(properties);
        };

        /**
         * Encodes the specified Conversation message. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @function encode
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation} message Conversation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Conversation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            if (message.messages != null && message.messages.length)
                for (var i = 0; i < message.messages.length; ++i)
                    $root.proto.HistorySyncMsg.encode(message.messages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.newJid != null && Object.hasOwnProperty.call(message, "newJid"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.newJid);
            if (message.oldJid != null && Object.hasOwnProperty.call(message, "oldJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.oldJid);
            if (message.lastMsgTimestamp != null && Object.hasOwnProperty.call(message, "lastMsgTimestamp"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.lastMsgTimestamp);
            if (message.unreadCount != null && Object.hasOwnProperty.call(message, "unreadCount"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.unreadCount);
            if (message.readOnly != null && Object.hasOwnProperty.call(message, "readOnly"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.readOnly);
            if (message.endOfHistoryTransfer != null && Object.hasOwnProperty.call(message, "endOfHistoryTransfer"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.endOfHistoryTransfer);
            if (message.ephemeralExpiration != null && Object.hasOwnProperty.call(message, "ephemeralExpiration"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint32(message.ephemeralExpiration);
            if (message.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(message, "ephemeralSettingTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.ephemeralSettingTimestamp);
            if (message.endOfHistoryTransferType != null && Object.hasOwnProperty.call(message, "endOfHistoryTransferType"))
                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.endOfHistoryTransferType);
            if (message.conversationTimestamp != null && Object.hasOwnProperty.call(message, "conversationTimestamp"))
                writer.uint32(/* id 12, wireType 0 =*/96).uint64(message.conversationTimestamp);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.name);
            if (message.pHash != null && Object.hasOwnProperty.call(message, "pHash"))
                writer.uint32(/* id 14, wireType 2 =*/114).string(message.pHash);
            if (message.notSpam != null && Object.hasOwnProperty.call(message, "notSpam"))
                writer.uint32(/* id 15, wireType 0 =*/120).bool(message.notSpam);
            if (message.archived != null && Object.hasOwnProperty.call(message, "archived"))
                writer.uint32(/* id 16, wireType 0 =*/128).bool(message.archived);
            if (message.disappearingMode != null && Object.hasOwnProperty.call(message, "disappearingMode"))
                $root.proto.DisappearingMode.encode(message.disappearingMode, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.unreadMentionCount != null && Object.hasOwnProperty.call(message, "unreadMentionCount"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.unreadMentionCount);
            if (message.markedAsUnread != null && Object.hasOwnProperty.call(message, "markedAsUnread"))
                writer.uint32(/* id 19, wireType 0 =*/152).bool(message.markedAsUnread);
            if (message.participant != null && message.participant.length)
                for (var i = 0; i < message.participant.length; ++i)
                    $root.proto.GroupParticipant.encode(message.participant[i], writer.uint32(/* id 20, wireType 2 =*/162).fork()).ldelim();
            if (message.tcToken != null && Object.hasOwnProperty.call(message, "tcToken"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.tcToken);
            if (message.tcTokenTimestamp != null && Object.hasOwnProperty.call(message, "tcTokenTimestamp"))
                writer.uint32(/* id 22, wireType 0 =*/176).uint64(message.tcTokenTimestamp);
            if (message.contactPrimaryIdentityKey != null && Object.hasOwnProperty.call(message, "contactPrimaryIdentityKey"))
                writer.uint32(/* id 23, wireType 2 =*/186).bytes(message.contactPrimaryIdentityKey);
            if (message.pinned != null && Object.hasOwnProperty.call(message, "pinned"))
                writer.uint32(/* id 24, wireType 0 =*/192).uint32(message.pinned);
            if (message.muteEndTime != null && Object.hasOwnProperty.call(message, "muteEndTime"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint64(message.muteEndTime);
            if (message.wallpaper != null && Object.hasOwnProperty.call(message, "wallpaper"))
                $root.proto.WallpaperSettings.encode(message.wallpaper, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
            if (message.mediaVisibility != null && Object.hasOwnProperty.call(message, "mediaVisibility"))
                writer.uint32(/* id 27, wireType 0 =*/216).int32(message.mediaVisibility);
            if (message.tcTokenSenderTimestamp != null && Object.hasOwnProperty.call(message, "tcTokenSenderTimestamp"))
                writer.uint32(/* id 28, wireType 0 =*/224).uint64(message.tcTokenSenderTimestamp);
            if (message.suspended != null && Object.hasOwnProperty.call(message, "suspended"))
                writer.uint32(/* id 29, wireType 0 =*/232).bool(message.suspended);
            return writer;
        };

        /**
         * Encodes the specified Conversation message, length delimited. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation} message Conversation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Conversation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Conversation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Conversation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Conversation} Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Conversation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Conversation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                case 2:
                    if (!(message.messages && message.messages.length))
                        message.messages = [];
                    message.messages.push($root.proto.HistorySyncMsg.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.newJid = reader.string();
                    break;
                case 4:
                    message.oldJid = reader.string();
                    break;
                case 5:
                    message.lastMsgTimestamp = reader.uint64();
                    break;
                case 6:
                    message.unreadCount = reader.uint32();
                    break;
                case 7:
                    message.readOnly = reader.bool();
                    break;
                case 8:
                    message.endOfHistoryTransfer = reader.bool();
                    break;
                case 9:
                    message.ephemeralExpiration = reader.uint32();
                    break;
                case 10:
                    message.ephemeralSettingTimestamp = reader.int64();
                    break;
                case 11:
                    message.endOfHistoryTransferType = reader.int32();
                    break;
                case 12:
                    message.conversationTimestamp = reader.uint64();
                    break;
                case 13:
                    message.name = reader.string();
                    break;
                case 14:
                    message.pHash = reader.string();
                    break;
                case 15:
                    message.notSpam = reader.bool();
                    break;
                case 16:
                    message.archived = reader.bool();
                    break;
                case 17:
                    message.disappearingMode = $root.proto.DisappearingMode.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.unreadMentionCount = reader.uint32();
                    break;
                case 19:
                    message.markedAsUnread = reader.bool();
                    break;
                case 20:
                    if (!(message.participant && message.participant.length))
                        message.participant = [];
                    message.participant.push($root.proto.GroupParticipant.decode(reader, reader.uint32()));
                    break;
                case 21:
                    message.tcToken = reader.bytes();
                    break;
                case 22:
                    message.tcTokenTimestamp = reader.uint64();
                    break;
                case 23:
                    message.contactPrimaryIdentityKey = reader.bytes();
                    break;
                case 24:
                    message.pinned = reader.uint32();
                    break;
                case 25:
                    message.muteEndTime = reader.uint64();
                    break;
                case 26:
                    message.wallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                case 27:
                    message.mediaVisibility = reader.int32();
                    break;
                case 28:
                    message.tcTokenSenderTimestamp = reader.uint64();
                    break;
                case 29:
                    message.suspended = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("id"))
                throw $util.ProtocolError("missing required 'id'", { instance: message });
            return message;
        };

        /**
         * Decodes a Conversation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Conversation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Conversation} Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Conversation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Conversation message.
         * @function verify
         * @memberof proto.Conversation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Conversation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.id))
                return "id: string expected";
            if (message.messages != null && message.hasOwnProperty("messages")) {
                if (!Array.isArray(message.messages))
                    return "messages: array expected";
                for (var i = 0; i < message.messages.length; ++i) {
                    var error = $root.proto.HistorySyncMsg.verify(message.messages[i]);
                    if (error)
                        return "messages." + error;
                }
            }
            if (message.newJid != null && message.hasOwnProperty("newJid"))
                if (!$util.isString(message.newJid))
                    return "newJid: string expected";
            if (message.oldJid != null && message.hasOwnProperty("oldJid"))
                if (!$util.isString(message.oldJid))
                    return "oldJid: string expected";
            if (message.lastMsgTimestamp != null && message.hasOwnProperty("lastMsgTimestamp"))
                if (!$util.isInteger(message.lastMsgTimestamp) && !(message.lastMsgTimestamp && $util.isInteger(message.lastMsgTimestamp.low) && $util.isInteger(message.lastMsgTimestamp.high)))
                    return "lastMsgTimestamp: integer|Long expected";
            if (message.unreadCount != null && message.hasOwnProperty("unreadCount"))
                if (!$util.isInteger(message.unreadCount))
                    return "unreadCount: integer expected";
            if (message.readOnly != null && message.hasOwnProperty("readOnly"))
                if (typeof message.readOnly !== "boolean")
                    return "readOnly: boolean expected";
            if (message.endOfHistoryTransfer != null && message.hasOwnProperty("endOfHistoryTransfer"))
                if (typeof message.endOfHistoryTransfer !== "boolean")
                    return "endOfHistoryTransfer: boolean expected";
            if (message.ephemeralExpiration != null && message.hasOwnProperty("ephemeralExpiration"))
                if (!$util.isInteger(message.ephemeralExpiration))
                    return "ephemeralExpiration: integer expected";
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (!$util.isInteger(message.ephemeralSettingTimestamp) && !(message.ephemeralSettingTimestamp && $util.isInteger(message.ephemeralSettingTimestamp.low) && $util.isInteger(message.ephemeralSettingTimestamp.high)))
                    return "ephemeralSettingTimestamp: integer|Long expected";
            if (message.endOfHistoryTransferType != null && message.hasOwnProperty("endOfHistoryTransferType"))
                switch (message.endOfHistoryTransferType) {
                default:
                    return "endOfHistoryTransferType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.conversationTimestamp != null && message.hasOwnProperty("conversationTimestamp"))
                if (!$util.isInteger(message.conversationTimestamp) && !(message.conversationTimestamp && $util.isInteger(message.conversationTimestamp.low) && $util.isInteger(message.conversationTimestamp.high)))
                    return "conversationTimestamp: integer|Long expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.pHash != null && message.hasOwnProperty("pHash"))
                if (!$util.isString(message.pHash))
                    return "pHash: string expected";
            if (message.notSpam != null && message.hasOwnProperty("notSpam"))
                if (typeof message.notSpam !== "boolean")
                    return "notSpam: boolean expected";
            if (message.archived != null && message.hasOwnProperty("archived"))
                if (typeof message.archived !== "boolean")
                    return "archived: boolean expected";
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode")) {
                var error = $root.proto.DisappearingMode.verify(message.disappearingMode);
                if (error)
                    return "disappearingMode." + error;
            }
            if (message.unreadMentionCount != null && message.hasOwnProperty("unreadMentionCount"))
                if (!$util.isInteger(message.unreadMentionCount))
                    return "unreadMentionCount: integer expected";
            if (message.markedAsUnread != null && message.hasOwnProperty("markedAsUnread"))
                if (typeof message.markedAsUnread !== "boolean")
                    return "markedAsUnread: boolean expected";
            if (message.participant != null && message.hasOwnProperty("participant")) {
                if (!Array.isArray(message.participant))
                    return "participant: array expected";
                for (var i = 0; i < message.participant.length; ++i) {
                    var error = $root.proto.GroupParticipant.verify(message.participant[i]);
                    if (error)
                        return "participant." + error;
                }
            }
            if (message.tcToken != null && message.hasOwnProperty("tcToken"))
                if (!(message.tcToken && typeof message.tcToken.length === "number" || $util.isString(message.tcToken)))
                    return "tcToken: buffer expected";
            if (message.tcTokenTimestamp != null && message.hasOwnProperty("tcTokenTimestamp"))
                if (!$util.isInteger(message.tcTokenTimestamp) && !(message.tcTokenTimestamp && $util.isInteger(message.tcTokenTimestamp.low) && $util.isInteger(message.tcTokenTimestamp.high)))
                    return "tcTokenTimestamp: integer|Long expected";
            if (message.contactPrimaryIdentityKey != null && message.hasOwnProperty("contactPrimaryIdentityKey"))
                if (!(message.contactPrimaryIdentityKey && typeof message.contactPrimaryIdentityKey.length === "number" || $util.isString(message.contactPrimaryIdentityKey)))
                    return "contactPrimaryIdentityKey: buffer expected";
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                if (!$util.isInteger(message.pinned))
                    return "pinned: integer expected";
            if (message.muteEndTime != null && message.hasOwnProperty("muteEndTime"))
                if (!$util.isInteger(message.muteEndTime) && !(message.muteEndTime && $util.isInteger(message.muteEndTime.low) && $util.isInteger(message.muteEndTime.high)))
                    return "muteEndTime: integer|Long expected";
            if (message.wallpaper != null && message.hasOwnProperty("wallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.wallpaper);
                if (error)
                    return "wallpaper." + error;
            }
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                switch (message.mediaVisibility) {
                default:
                    return "mediaVisibility: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.tcTokenSenderTimestamp != null && message.hasOwnProperty("tcTokenSenderTimestamp"))
                if (!$util.isInteger(message.tcTokenSenderTimestamp) && !(message.tcTokenSenderTimestamp && $util.isInteger(message.tcTokenSenderTimestamp.low) && $util.isInteger(message.tcTokenSenderTimestamp.high)))
                    return "tcTokenSenderTimestamp: integer|Long expected";
            if (message.suspended != null && message.hasOwnProperty("suspended"))
                if (typeof message.suspended !== "boolean")
                    return "suspended: boolean expected";
            return null;
        };

        /**
         * Creates a Conversation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Conversation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Conversation} Conversation
         */
        Conversation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Conversation)
                return object;
            var message = new $root.proto.Conversation();
            if (object.id != null)
                message.id = String(object.id);
            if (object.messages) {
                if (!Array.isArray(object.messages))
                    throw TypeError(".proto.Conversation.messages: array expected");
                message.messages = [];
                for (var i = 0; i < object.messages.length; ++i) {
                    if (typeof object.messages[i] !== "object")
                        throw TypeError(".proto.Conversation.messages: object expected");
                    message.messages[i] = $root.proto.HistorySyncMsg.fromObject(object.messages[i]);
                }
            }
            if (object.newJid != null)
                message.newJid = String(object.newJid);
            if (object.oldJid != null)
                message.oldJid = String(object.oldJid);
            if (object.lastMsgTimestamp != null)
                if ($util.Long)
                    (message.lastMsgTimestamp = $util.Long.fromValue(object.lastMsgTimestamp)).unsigned = true;
                else if (typeof object.lastMsgTimestamp === "string")
                    message.lastMsgTimestamp = parseInt(object.lastMsgTimestamp, 10);
                else if (typeof object.lastMsgTimestamp === "number")
                    message.lastMsgTimestamp = object.lastMsgTimestamp;
                else if (typeof object.lastMsgTimestamp === "object")
                    message.lastMsgTimestamp = new $util.LongBits(object.lastMsgTimestamp.low >>> 0, object.lastMsgTimestamp.high >>> 0).toNumber(true);
            if (object.unreadCount != null)
                message.unreadCount = object.unreadCount >>> 0;
            if (object.readOnly != null)
                message.readOnly = Boolean(object.readOnly);
            if (object.endOfHistoryTransfer != null)
                message.endOfHistoryTransfer = Boolean(object.endOfHistoryTransfer);
            if (object.ephemeralExpiration != null)
                message.ephemeralExpiration = object.ephemeralExpiration >>> 0;
            if (object.ephemeralSettingTimestamp != null)
                if ($util.Long)
                    (message.ephemeralSettingTimestamp = $util.Long.fromValue(object.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof object.ephemeralSettingTimestamp === "string")
                    message.ephemeralSettingTimestamp = parseInt(object.ephemeralSettingTimestamp, 10);
                else if (typeof object.ephemeralSettingTimestamp === "number")
                    message.ephemeralSettingTimestamp = object.ephemeralSettingTimestamp;
                else if (typeof object.ephemeralSettingTimestamp === "object")
                    message.ephemeralSettingTimestamp = new $util.LongBits(object.ephemeralSettingTimestamp.low >>> 0, object.ephemeralSettingTimestamp.high >>> 0).toNumber();
            switch (object.endOfHistoryTransferType) {
            case "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY":
            case 0:
                message.endOfHistoryTransferType = 0;
                break;
            case "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY":
            case 1:
                message.endOfHistoryTransferType = 1;
                break;
            }
            if (object.conversationTimestamp != null)
                if ($util.Long)
                    (message.conversationTimestamp = $util.Long.fromValue(object.conversationTimestamp)).unsigned = true;
                else if (typeof object.conversationTimestamp === "string")
                    message.conversationTimestamp = parseInt(object.conversationTimestamp, 10);
                else if (typeof object.conversationTimestamp === "number")
                    message.conversationTimestamp = object.conversationTimestamp;
                else if (typeof object.conversationTimestamp === "object")
                    message.conversationTimestamp = new $util.LongBits(object.conversationTimestamp.low >>> 0, object.conversationTimestamp.high >>> 0).toNumber(true);
            if (object.name != null)
                message.name = String(object.name);
            if (object.pHash != null)
                message.pHash = String(object.pHash);
            if (object.notSpam != null)
                message.notSpam = Boolean(object.notSpam);
            if (object.archived != null)
                message.archived = Boolean(object.archived);
            if (object.disappearingMode != null) {
                if (typeof object.disappearingMode !== "object")
                    throw TypeError(".proto.Conversation.disappearingMode: object expected");
                message.disappearingMode = $root.proto.DisappearingMode.fromObject(object.disappearingMode);
            }
            if (object.unreadMentionCount != null)
                message.unreadMentionCount = object.unreadMentionCount >>> 0;
            if (object.markedAsUnread != null)
                message.markedAsUnread = Boolean(object.markedAsUnread);
            if (object.participant) {
                if (!Array.isArray(object.participant))
                    throw TypeError(".proto.Conversation.participant: array expected");
                message.participant = [];
                for (var i = 0; i < object.participant.length; ++i) {
                    if (typeof object.participant[i] !== "object")
                        throw TypeError(".proto.Conversation.participant: object expected");
                    message.participant[i] = $root.proto.GroupParticipant.fromObject(object.participant[i]);
                }
            }
            if (object.tcToken != null)
                if (typeof object.tcToken === "string")
                    $util.base64.decode(object.tcToken, message.tcToken = $util.newBuffer($util.base64.length(object.tcToken)), 0);
                else if (object.tcToken.length)
                    message.tcToken = object.tcToken;
            if (object.tcTokenTimestamp != null)
                if ($util.Long)
                    (message.tcTokenTimestamp = $util.Long.fromValue(object.tcTokenTimestamp)).unsigned = true;
                else if (typeof object.tcTokenTimestamp === "string")
                    message.tcTokenTimestamp = parseInt(object.tcTokenTimestamp, 10);
                else if (typeof object.tcTokenTimestamp === "number")
                    message.tcTokenTimestamp = object.tcTokenTimestamp;
                else if (typeof object.tcTokenTimestamp === "object")
                    message.tcTokenTimestamp = new $util.LongBits(object.tcTokenTimestamp.low >>> 0, object.tcTokenTimestamp.high >>> 0).toNumber(true);
            if (object.contactPrimaryIdentityKey != null)
                if (typeof object.contactPrimaryIdentityKey === "string")
                    $util.base64.decode(object.contactPrimaryIdentityKey, message.contactPrimaryIdentityKey = $util.newBuffer($util.base64.length(object.contactPrimaryIdentityKey)), 0);
                else if (object.contactPrimaryIdentityKey.length)
                    message.contactPrimaryIdentityKey = object.contactPrimaryIdentityKey;
            if (object.pinned != null)
                message.pinned = object.pinned >>> 0;
            if (object.muteEndTime != null)
                if ($util.Long)
                    (message.muteEndTime = $util.Long.fromValue(object.muteEndTime)).unsigned = true;
                else if (typeof object.muteEndTime === "string")
                    message.muteEndTime = parseInt(object.muteEndTime, 10);
                else if (typeof object.muteEndTime === "number")
                    message.muteEndTime = object.muteEndTime;
                else if (typeof object.muteEndTime === "object")
                    message.muteEndTime = new $util.LongBits(object.muteEndTime.low >>> 0, object.muteEndTime.high >>> 0).toNumber(true);
            if (object.wallpaper != null) {
                if (typeof object.wallpaper !== "object")
                    throw TypeError(".proto.Conversation.wallpaper: object expected");
                message.wallpaper = $root.proto.WallpaperSettings.fromObject(object.wallpaper);
            }
            switch (object.mediaVisibility) {
            case "DEFAULT":
            case 0:
                message.mediaVisibility = 0;
                break;
            case "OFF":
            case 1:
                message.mediaVisibility = 1;
                break;
            case "ON":
            case 2:
                message.mediaVisibility = 2;
                break;
            }
            if (object.tcTokenSenderTimestamp != null)
                if ($util.Long)
                    (message.tcTokenSenderTimestamp = $util.Long.fromValue(object.tcTokenSenderTimestamp)).unsigned = true;
                else if (typeof object.tcTokenSenderTimestamp === "string")
                    message.tcTokenSenderTimestamp = parseInt(object.tcTokenSenderTimestamp, 10);
                else if (typeof object.tcTokenSenderTimestamp === "number")
                    message.tcTokenSenderTimestamp = object.tcTokenSenderTimestamp;
                else if (typeof object.tcTokenSenderTimestamp === "object")
                    message.tcTokenSenderTimestamp = new $util.LongBits(object.tcTokenSenderTimestamp.low >>> 0, object.tcTokenSenderTimestamp.high >>> 0).toNumber(true);
            if (object.suspended != null)
                message.suspended = Boolean(object.suspended);
            return message;
        };

        /**
         * Creates a plain object from a Conversation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Conversation
         * @static
         * @param {proto.Conversation} message Conversation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Conversation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.messages = [];
                object.participant = [];
            }
            if (options.defaults) {
                object.id = "";
                object.newJid = "";
                object.oldJid = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.lastMsgTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.lastMsgTimestamp = options.longs === String ? "0" : 0;
                object.unreadCount = 0;
                object.readOnly = false;
                object.endOfHistoryTransfer = false;
                object.ephemeralExpiration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.ephemeralSettingTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ephemeralSettingTimestamp = options.longs === String ? "0" : 0;
                object.endOfHistoryTransferType = options.enums === String ? "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.conversationTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.conversationTimestamp = options.longs === String ? "0" : 0;
                object.name = "";
                object.pHash = "";
                object.notSpam = false;
                object.archived = false;
                object.disappearingMode = null;
                object.unreadMentionCount = 0;
                object.markedAsUnread = false;
                if (options.bytes === String)
                    object.tcToken = "";
                else {
                    object.tcToken = [];
                    if (options.bytes !== Array)
                        object.tcToken = $util.newBuffer(object.tcToken);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.tcTokenTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.tcTokenTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.contactPrimaryIdentityKey = "";
                else {
                    object.contactPrimaryIdentityKey = [];
                    if (options.bytes !== Array)
                        object.contactPrimaryIdentityKey = $util.newBuffer(object.contactPrimaryIdentityKey);
                }
                object.pinned = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.muteEndTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.muteEndTime = options.longs === String ? "0" : 0;
                object.wallpaper = null;
                object.mediaVisibility = options.enums === String ? "DEFAULT" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.tcTokenSenderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.tcTokenSenderTimestamp = options.longs === String ? "0" : 0;
                object.suspended = false;
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.messages && message.messages.length) {
                object.messages = [];
                for (var j = 0; j < message.messages.length; ++j)
                    object.messages[j] = $root.proto.HistorySyncMsg.toObject(message.messages[j], options);
            }
            if (message.newJid != null && message.hasOwnProperty("newJid"))
                object.newJid = message.newJid;
            if (message.oldJid != null && message.hasOwnProperty("oldJid"))
                object.oldJid = message.oldJid;
            if (message.lastMsgTimestamp != null && message.hasOwnProperty("lastMsgTimestamp"))
                if (typeof message.lastMsgTimestamp === "number")
                    object.lastMsgTimestamp = options.longs === String ? String(message.lastMsgTimestamp) : message.lastMsgTimestamp;
                else
                    object.lastMsgTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.lastMsgTimestamp) : options.longs === Number ? new $util.LongBits(message.lastMsgTimestamp.low >>> 0, message.lastMsgTimestamp.high >>> 0).toNumber(true) : message.lastMsgTimestamp;
            if (message.unreadCount != null && message.hasOwnProperty("unreadCount"))
                object.unreadCount = message.unreadCount;
            if (message.readOnly != null && message.hasOwnProperty("readOnly"))
                object.readOnly = message.readOnly;
            if (message.endOfHistoryTransfer != null && message.hasOwnProperty("endOfHistoryTransfer"))
                object.endOfHistoryTransfer = message.endOfHistoryTransfer;
            if (message.ephemeralExpiration != null && message.hasOwnProperty("ephemeralExpiration"))
                object.ephemeralExpiration = message.ephemeralExpiration;
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (typeof message.ephemeralSettingTimestamp === "number")
                    object.ephemeralSettingTimestamp = options.longs === String ? String(message.ephemeralSettingTimestamp) : message.ephemeralSettingTimestamp;
                else
                    object.ephemeralSettingTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.ephemeralSettingTimestamp) : options.longs === Number ? new $util.LongBits(message.ephemeralSettingTimestamp.low >>> 0, message.ephemeralSettingTimestamp.high >>> 0).toNumber() : message.ephemeralSettingTimestamp;
            if (message.endOfHistoryTransferType != null && message.hasOwnProperty("endOfHistoryTransferType"))
                object.endOfHistoryTransferType = options.enums === String ? $root.proto.Conversation.ConversationEndOfHistoryTransferType[message.endOfHistoryTransferType] : message.endOfHistoryTransferType;
            if (message.conversationTimestamp != null && message.hasOwnProperty("conversationTimestamp"))
                if (typeof message.conversationTimestamp === "number")
                    object.conversationTimestamp = options.longs === String ? String(message.conversationTimestamp) : message.conversationTimestamp;
                else
                    object.conversationTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.conversationTimestamp) : options.longs === Number ? new $util.LongBits(message.conversationTimestamp.low >>> 0, message.conversationTimestamp.high >>> 0).toNumber(true) : message.conversationTimestamp;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.pHash != null && message.hasOwnProperty("pHash"))
                object.pHash = message.pHash;
            if (message.notSpam != null && message.hasOwnProperty("notSpam"))
                object.notSpam = message.notSpam;
            if (message.archived != null && message.hasOwnProperty("archived"))
                object.archived = message.archived;
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode"))
                object.disappearingMode = $root.proto.DisappearingMode.toObject(message.disappearingMode, options);
            if (message.unreadMentionCount != null && message.hasOwnProperty("unreadMentionCount"))
                object.unreadMentionCount = message.unreadMentionCount;
            if (message.markedAsUnread != null && message.hasOwnProperty("markedAsUnread"))
                object.markedAsUnread = message.markedAsUnread;
            if (message.participant && message.participant.length) {
                object.participant = [];
                for (var j = 0; j < message.participant.length; ++j)
                    object.participant[j] = $root.proto.GroupParticipant.toObject(message.participant[j], options);
            }
            if (message.tcToken != null && message.hasOwnProperty("tcToken"))
                object.tcToken = options.bytes === String ? $util.base64.encode(message.tcToken, 0, message.tcToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.tcToken) : message.tcToken;
            if (message.tcTokenTimestamp != null && message.hasOwnProperty("tcTokenTimestamp"))
                if (typeof message.tcTokenTimestamp === "number")
                    object.tcTokenTimestamp = options.longs === String ? String(message.tcTokenTimestamp) : message.tcTokenTimestamp;
                else
                    object.tcTokenTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.tcTokenTimestamp) : options.longs === Number ? new $util.LongBits(message.tcTokenTimestamp.low >>> 0, message.tcTokenTimestamp.high >>> 0).toNumber(true) : message.tcTokenTimestamp;
            if (message.contactPrimaryIdentityKey != null && message.hasOwnProperty("contactPrimaryIdentityKey"))
                object.contactPrimaryIdentityKey = options.bytes === String ? $util.base64.encode(message.contactPrimaryIdentityKey, 0, message.contactPrimaryIdentityKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.contactPrimaryIdentityKey) : message.contactPrimaryIdentityKey;
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                object.pinned = message.pinned;
            if (message.muteEndTime != null && message.hasOwnProperty("muteEndTime"))
                if (typeof message.muteEndTime === "number")
                    object.muteEndTime = options.longs === String ? String(message.muteEndTime) : message.muteEndTime;
                else
                    object.muteEndTime = options.longs === String ? $util.Long.prototype.toString.call(message.muteEndTime) : options.longs === Number ? new $util.LongBits(message.muteEndTime.low >>> 0, message.muteEndTime.high >>> 0).toNumber(true) : message.muteEndTime;
            if (message.wallpaper != null && message.hasOwnProperty("wallpaper"))
                object.wallpaper = $root.proto.WallpaperSettings.toObject(message.wallpaper, options);
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                object.mediaVisibility = options.enums === String ? $root.proto.MediaVisibility[message.mediaVisibility] : message.mediaVisibility;
            if (message.tcTokenSenderTimestamp != null && message.hasOwnProperty("tcTokenSenderTimestamp"))
                if (typeof message.tcTokenSenderTimestamp === "number")
                    object.tcTokenSenderTimestamp = options.longs === String ? String(message.tcTokenSenderTimestamp) : message.tcTokenSenderTimestamp;
                else
                    object.tcTokenSenderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.tcTokenSenderTimestamp) : options.longs === Number ? new $util.LongBits(message.tcTokenSenderTimestamp.low >>> 0, message.tcTokenSenderTimestamp.high >>> 0).toNumber(true) : message.tcTokenSenderTimestamp;
            if (message.suspended != null && message.hasOwnProperty("suspended"))
                object.suspended = message.suspended;
            return object;
        };

        /**
         * Converts this Conversation to JSON.
         * @function toJSON
         * @memberof proto.Conversation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Conversation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ConversationEndOfHistoryTransferType enum.
         * @name proto.Conversation.ConversationEndOfHistoryTransferType
         * @enum {number}
         * @property {number} COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY=0 COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY value
         * @property {number} COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY=1 COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY value
         */
        Conversation.ConversationEndOfHistoryTransferType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY"] = 0;
            values[valuesById[1] = "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY"] = 1;
            return values;
        })();

        return Conversation;
    })();

    proto.HistorySync = (function() {

        /**
         * Properties of a HistorySync.
         * @memberof proto
         * @interface IHistorySync
         * @property {proto.HistorySync.HistorySyncHistorySyncType} syncType HistorySync syncType
         * @property {Array.<proto.IConversation>|null} [conversations] HistorySync conversations
         * @property {Array.<proto.IWebMessageInfo>|null} [statusV3Messages] HistorySync statusV3Messages
         * @property {number|null} [chunkOrder] HistorySync chunkOrder
         * @property {number|null} [progress] HistorySync progress
         * @property {Array.<proto.IPushname>|null} [pushnames] HistorySync pushnames
         * @property {proto.IGlobalSettings|null} [globalSettings] HistorySync globalSettings
         * @property {Uint8Array|null} [threadIdUserSecret] HistorySync threadIdUserSecret
         * @property {number|null} [threadDsTimeframeOffset] HistorySync threadDsTimeframeOffset
         */

        /**
         * Constructs a new HistorySync.
         * @memberof proto
         * @classdesc Represents a HistorySync.
         * @implements IHistorySync
         * @constructor
         * @param {proto.IHistorySync=} [properties] Properties to set
         */
        function HistorySync(properties) {
            this.conversations = [];
            this.statusV3Messages = [];
            this.pushnames = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HistorySync syncType.
         * @member {proto.HistorySync.HistorySyncHistorySyncType} syncType
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.syncType = 0;

        /**
         * HistorySync conversations.
         * @member {Array.<proto.IConversation>} conversations
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.conversations = $util.emptyArray;

        /**
         * HistorySync statusV3Messages.
         * @member {Array.<proto.IWebMessageInfo>} statusV3Messages
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.statusV3Messages = $util.emptyArray;

        /**
         * HistorySync chunkOrder.
         * @member {number} chunkOrder
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.chunkOrder = 0;

        /**
         * HistorySync progress.
         * @member {number} progress
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.progress = 0;

        /**
         * HistorySync pushnames.
         * @member {Array.<proto.IPushname>} pushnames
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.pushnames = $util.emptyArray;

        /**
         * HistorySync globalSettings.
         * @member {proto.IGlobalSettings|null|undefined} globalSettings
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.globalSettings = null;

        /**
         * HistorySync threadIdUserSecret.
         * @member {Uint8Array} threadIdUserSecret
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.threadIdUserSecret = $util.newBuffer([]);

        /**
         * HistorySync threadDsTimeframeOffset.
         * @member {number} threadDsTimeframeOffset
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.threadDsTimeframeOffset = 0;

        /**
         * Creates a new HistorySync instance using the specified properties.
         * @function create
         * @memberof proto.HistorySync
         * @static
         * @param {proto.IHistorySync=} [properties] Properties to set
         * @returns {proto.HistorySync} HistorySync instance
         */
        HistorySync.create = function create(properties) {
            return new HistorySync(properties);
        };

        /**
         * Encodes the specified HistorySync message. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @function encode
         * @memberof proto.HistorySync
         * @static
         * @param {proto.IHistorySync} message HistorySync message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySync.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.syncType);
            if (message.conversations != null && message.conversations.length)
                for (var i = 0; i < message.conversations.length; ++i)
                    $root.proto.Conversation.encode(message.conversations[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.statusV3Messages != null && message.statusV3Messages.length)
                for (var i = 0; i < message.statusV3Messages.length; ++i)
                    $root.proto.WebMessageInfo.encode(message.statusV3Messages[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.chunkOrder != null && Object.hasOwnProperty.call(message, "chunkOrder"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.chunkOrder);
            if (message.progress != null && Object.hasOwnProperty.call(message, "progress"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.progress);
            if (message.pushnames != null && message.pushnames.length)
                for (var i = 0; i < message.pushnames.length; ++i)
                    $root.proto.Pushname.encode(message.pushnames[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.globalSettings != null && Object.hasOwnProperty.call(message, "globalSettings"))
                $root.proto.GlobalSettings.encode(message.globalSettings, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.threadIdUserSecret != null && Object.hasOwnProperty.call(message, "threadIdUserSecret"))
                writer.uint32(/* id 9, wireType 2 =*/74).bytes(message.threadIdUserSecret);
            if (message.threadDsTimeframeOffset != null && Object.hasOwnProperty.call(message, "threadDsTimeframeOffset"))
                writer.uint32(/* id 10, wireType 0 =*/80).uint32(message.threadDsTimeframeOffset);
            return writer;
        };

        /**
         * Encodes the specified HistorySync message, length delimited. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HistorySync
         * @static
         * @param {proto.IHistorySync} message HistorySync message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySync.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HistorySync message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HistorySync
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HistorySync} HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySync.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HistorySync();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.syncType = reader.int32();
                    break;
                case 2:
                    if (!(message.conversations && message.conversations.length))
                        message.conversations = [];
                    message.conversations.push($root.proto.Conversation.decode(reader, reader.uint32()));
                    break;
                case 3:
                    if (!(message.statusV3Messages && message.statusV3Messages.length))
                        message.statusV3Messages = [];
                    message.statusV3Messages.push($root.proto.WebMessageInfo.decode(reader, reader.uint32()));
                    break;
                case 5:
                    message.chunkOrder = reader.uint32();
                    break;
                case 6:
                    message.progress = reader.uint32();
                    break;
                case 7:
                    if (!(message.pushnames && message.pushnames.length))
                        message.pushnames = [];
                    message.pushnames.push($root.proto.Pushname.decode(reader, reader.uint32()));
                    break;
                case 8:
                    message.globalSettings = $root.proto.GlobalSettings.decode(reader, reader.uint32());
                    break;
                case 9:
                    message.threadIdUserSecret = reader.bytes();
                    break;
                case 10:
                    message.threadDsTimeframeOffset = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("syncType"))
                throw $util.ProtocolError("missing required 'syncType'", { instance: message });
            return message;
        };

        /**
         * Decodes a HistorySync message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HistorySync
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HistorySync} HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySync.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HistorySync message.
         * @function verify
         * @memberof proto.HistorySync
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HistorySync.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            switch (message.syncType) {
            default:
                return "syncType: enum value expected";
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
                break;
            }
            if (message.conversations != null && message.hasOwnProperty("conversations")) {
                if (!Array.isArray(message.conversations))
                    return "conversations: array expected";
                for (var i = 0; i < message.conversations.length; ++i) {
                    var error = $root.proto.Conversation.verify(message.conversations[i]);
                    if (error)
                        return "conversations." + error;
                }
            }
            if (message.statusV3Messages != null && message.hasOwnProperty("statusV3Messages")) {
                if (!Array.isArray(message.statusV3Messages))
                    return "statusV3Messages: array expected";
                for (var i = 0; i < message.statusV3Messages.length; ++i) {
                    var error = $root.proto.WebMessageInfo.verify(message.statusV3Messages[i]);
                    if (error)
                        return "statusV3Messages." + error;
                }
            }
            if (message.chunkOrder != null && message.hasOwnProperty("chunkOrder"))
                if (!$util.isInteger(message.chunkOrder))
                    return "chunkOrder: integer expected";
            if (message.progress != null && message.hasOwnProperty("progress"))
                if (!$util.isInteger(message.progress))
                    return "progress: integer expected";
            if (message.pushnames != null && message.hasOwnProperty("pushnames")) {
                if (!Array.isArray(message.pushnames))
                    return "pushnames: array expected";
                for (var i = 0; i < message.pushnames.length; ++i) {
                    var error = $root.proto.Pushname.verify(message.pushnames[i]);
                    if (error)
                        return "pushnames." + error;
                }
            }
            if (message.globalSettings != null && message.hasOwnProperty("globalSettings")) {
                var error = $root.proto.GlobalSettings.verify(message.globalSettings);
                if (error)
                    return "globalSettings." + error;
            }
            if (message.threadIdUserSecret != null && message.hasOwnProperty("threadIdUserSecret"))
                if (!(message.threadIdUserSecret && typeof message.threadIdUserSecret.length === "number" || $util.isString(message.threadIdUserSecret)))
                    return "threadIdUserSecret: buffer expected";
            if (message.threadDsTimeframeOffset != null && message.hasOwnProperty("threadDsTimeframeOffset"))
                if (!$util.isInteger(message.threadDsTimeframeOffset))
                    return "threadDsTimeframeOffset: integer expected";
            return null;
        };

        /**
         * Creates a HistorySync message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HistorySync
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HistorySync} HistorySync
         */
        HistorySync.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HistorySync)
                return object;
            var message = new $root.proto.HistorySync();
            switch (object.syncType) {
            case "INITIAL_BOOTSTRAP":
            case 0:
                message.syncType = 0;
                break;
            case "INITIAL_STATUS_V3":
            case 1:
                message.syncType = 1;
                break;
            case "FULL":
            case 2:
                message.syncType = 2;
                break;
            case "RECENT":
            case 3:
                message.syncType = 3;
                break;
            case "PUSH_NAME":
            case 4:
                message.syncType = 4;
                break;
            }
            if (object.conversations) {
                if (!Array.isArray(object.conversations))
                    throw TypeError(".proto.HistorySync.conversations: array expected");
                message.conversations = [];
                for (var i = 0; i < object.conversations.length; ++i) {
                    if (typeof object.conversations[i] !== "object")
                        throw TypeError(".proto.HistorySync.conversations: object expected");
                    message.conversations[i] = $root.proto.Conversation.fromObject(object.conversations[i]);
                }
            }
            if (object.statusV3Messages) {
                if (!Array.isArray(object.statusV3Messages))
                    throw TypeError(".proto.HistorySync.statusV3Messages: array expected");
                message.statusV3Messages = [];
                for (var i = 0; i < object.statusV3Messages.length; ++i) {
                    if (typeof object.statusV3Messages[i] !== "object")
                        throw TypeError(".proto.HistorySync.statusV3Messages: object expected");
                    message.statusV3Messages[i] = $root.proto.WebMessageInfo.fromObject(object.statusV3Messages[i]);
                }
            }
            if (object.chunkOrder != null)
                message.chunkOrder = object.chunkOrder >>> 0;
            if (object.progress != null)
                message.progress = object.progress >>> 0;
            if (object.pushnames) {
                if (!Array.isArray(object.pushnames))
                    throw TypeError(".proto.HistorySync.pushnames: array expected");
                message.pushnames = [];
                for (var i = 0; i < object.pushnames.length; ++i) {
                    if (typeof object.pushnames[i] !== "object")
                        throw TypeError(".proto.HistorySync.pushnames: object expected");
                    message.pushnames[i] = $root.proto.Pushname.fromObject(object.pushnames[i]);
                }
            }
            if (object.globalSettings != null) {
                if (typeof object.globalSettings !== "object")
                    throw TypeError(".proto.HistorySync.globalSettings: object expected");
                message.globalSettings = $root.proto.GlobalSettings.fromObject(object.globalSettings);
            }
            if (object.threadIdUserSecret != null)
                if (typeof object.threadIdUserSecret === "string")
                    $util.base64.decode(object.threadIdUserSecret, message.threadIdUserSecret = $util.newBuffer($util.base64.length(object.threadIdUserSecret)), 0);
                else if (object.threadIdUserSecret.length)
                    message.threadIdUserSecret = object.threadIdUserSecret;
            if (object.threadDsTimeframeOffset != null)
                message.threadDsTimeframeOffset = object.threadDsTimeframeOffset >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a HistorySync message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HistorySync
         * @static
         * @param {proto.HistorySync} message HistorySync
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HistorySync.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.conversations = [];
                object.statusV3Messages = [];
                object.pushnames = [];
            }
            if (options.defaults) {
                object.syncType = options.enums === String ? "INITIAL_BOOTSTRAP" : 0;
                object.chunkOrder = 0;
                object.progress = 0;
                object.globalSettings = null;
                if (options.bytes === String)
                    object.threadIdUserSecret = "";
                else {
                    object.threadIdUserSecret = [];
                    if (options.bytes !== Array)
                        object.threadIdUserSecret = $util.newBuffer(object.threadIdUserSecret);
                }
                object.threadDsTimeframeOffset = 0;
            }
            if (message.syncType != null && message.hasOwnProperty("syncType"))
                object.syncType = options.enums === String ? $root.proto.HistorySync.HistorySyncHistorySyncType[message.syncType] : message.syncType;
            if (message.conversations && message.conversations.length) {
                object.conversations = [];
                for (var j = 0; j < message.conversations.length; ++j)
                    object.conversations[j] = $root.proto.Conversation.toObject(message.conversations[j], options);
            }
            if (message.statusV3Messages && message.statusV3Messages.length) {
                object.statusV3Messages = [];
                for (var j = 0; j < message.statusV3Messages.length; ++j)
                    object.statusV3Messages[j] = $root.proto.WebMessageInfo.toObject(message.statusV3Messages[j], options);
            }
            if (message.chunkOrder != null && message.hasOwnProperty("chunkOrder"))
                object.chunkOrder = message.chunkOrder;
            if (message.progress != null && message.hasOwnProperty("progress"))
                object.progress = message.progress;
            if (message.pushnames && message.pushnames.length) {
                object.pushnames = [];
                for (var j = 0; j < message.pushnames.length; ++j)
                    object.pushnames[j] = $root.proto.Pushname.toObject(message.pushnames[j], options);
            }
            if (message.globalSettings != null && message.hasOwnProperty("globalSettings"))
                object.globalSettings = $root.proto.GlobalSettings.toObject(message.globalSettings, options);
            if (message.threadIdUserSecret != null && message.hasOwnProperty("threadIdUserSecret"))
                object.threadIdUserSecret = options.bytes === String ? $util.base64.encode(message.threadIdUserSecret, 0, message.threadIdUserSecret.length) : options.bytes === Array ? Array.prototype.slice.call(message.threadIdUserSecret) : message.threadIdUserSecret;
            if (message.threadDsTimeframeOffset != null && message.hasOwnProperty("threadDsTimeframeOffset"))
                object.threadDsTimeframeOffset = message.threadDsTimeframeOffset;
            return object;
        };

        /**
         * Converts this HistorySync to JSON.
         * @function toJSON
         * @memberof proto.HistorySync
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HistorySync.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * HistorySyncHistorySyncType enum.
         * @name proto.HistorySync.HistorySyncHistorySyncType
         * @enum {number}
         * @property {number} INITIAL_BOOTSTRAP=0 INITIAL_BOOTSTRAP value
         * @property {number} INITIAL_STATUS_V3=1 INITIAL_STATUS_V3 value
         * @property {number} FULL=2 FULL value
         * @property {number} RECENT=3 RECENT value
         * @property {number} PUSH_NAME=4 PUSH_NAME value
         */
        HistorySync.HistorySyncHistorySyncType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "INITIAL_BOOTSTRAP"] = 0;
            values[valuesById[1] = "INITIAL_STATUS_V3"] = 1;
            values[valuesById[2] = "FULL"] = 2;
            values[valuesById[3] = "RECENT"] = 3;
            values[valuesById[4] = "PUSH_NAME"] = 4;
            return values;
        })();

        return HistorySync;
    })();

    /**
     * MediaVisibility enum.
     * @name proto.MediaVisibility
     * @enum {number}
     * @property {number} DEFAULT=0 DEFAULT value
     * @property {number} OFF=1 OFF value
     * @property {number} ON=2 ON value
     */
    proto.MediaVisibility = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "DEFAULT"] = 0;
        values[valuesById[1] = "OFF"] = 1;
        values[valuesById[2] = "ON"] = 2;
        return values;
    })();

    proto.EphemeralSetting = (function() {

        /**
         * Properties of an EphemeralSetting.
         * @memberof proto
         * @interface IEphemeralSetting
         * @property {number|null} [duration] EphemeralSetting duration
         * @property {number|Long|null} [timestamp] EphemeralSetting timestamp
         */

        /**
         * Constructs a new EphemeralSetting.
         * @memberof proto
         * @classdesc Represents an EphemeralSetting.
         * @implements IEphemeralSetting
         * @constructor
         * @param {proto.IEphemeralSetting=} [properties] Properties to set
         */
        function EphemeralSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * EphemeralSetting duration.
         * @member {number} duration
         * @memberof proto.EphemeralSetting
         * @instance
         */
        EphemeralSetting.prototype.duration = 0;

        /**
         * EphemeralSetting timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.EphemeralSetting
         * @instance
         */
        EphemeralSetting.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new EphemeralSetting instance using the specified properties.
         * @function create
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting=} [properties] Properties to set
         * @returns {proto.EphemeralSetting} EphemeralSetting instance
         */
        EphemeralSetting.create = function create(properties) {
            return new EphemeralSetting(properties);
        };

        /**
         * Encodes the specified EphemeralSetting message. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting} message EphemeralSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EphemeralSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.duration != null && Object.hasOwnProperty.call(message, "duration"))
                writer.uint32(/* id 1, wireType 5 =*/13).sfixed32(message.duration);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 1 =*/17).sfixed64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified EphemeralSetting message, length delimited. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting} message EphemeralSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EphemeralSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.EphemeralSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.EphemeralSetting} EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EphemeralSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.EphemeralSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.duration = reader.sfixed32();
                    break;
                case 2:
                    message.timestamp = reader.sfixed64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.EphemeralSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.EphemeralSetting} EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EphemeralSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an EphemeralSetting message.
         * @function verify
         * @memberof proto.EphemeralSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        EphemeralSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.duration != null && message.hasOwnProperty("duration"))
                if (!$util.isInteger(message.duration))
                    return "duration: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an EphemeralSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.EphemeralSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.EphemeralSetting} EphemeralSetting
         */
        EphemeralSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.EphemeralSetting)
                return object;
            var message = new $root.proto.EphemeralSetting();
            if (object.duration != null)
                message.duration = object.duration | 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an EphemeralSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.EphemeralSetting} message EphemeralSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        EphemeralSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.duration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            }
            if (message.duration != null && message.hasOwnProperty("duration"))
                object.duration = message.duration;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this EphemeralSetting to JSON.
         * @function toJSON
         * @memberof proto.EphemeralSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        EphemeralSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return EphemeralSetting;
    })();

    proto.InteractiveAnnotation = (function() {

        /**
         * Properties of an InteractiveAnnotation.
         * @memberof proto
         * @interface IInteractiveAnnotation
         * @property {Array.<proto.IPoint>|null} [polygonVertices] InteractiveAnnotation polygonVertices
         * @property {proto.ILocation|null} [location] InteractiveAnnotation location
         */

        /**
         * Constructs a new InteractiveAnnotation.
         * @memberof proto
         * @classdesc Represents an InteractiveAnnotation.
         * @implements IInteractiveAnnotation
         * @constructor
         * @param {proto.IInteractiveAnnotation=} [properties] Properties to set
         */
        function InteractiveAnnotation(properties) {
            this.polygonVertices = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveAnnotation polygonVertices.
         * @member {Array.<proto.IPoint>} polygonVertices
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        InteractiveAnnotation.prototype.polygonVertices = $util.emptyArray;

        /**
         * InteractiveAnnotation location.
         * @member {proto.ILocation|null|undefined} location
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        InteractiveAnnotation.prototype.location = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * InteractiveAnnotation action.
         * @member {"location"|undefined} action
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        Object.defineProperty(InteractiveAnnotation.prototype, "action", {
            get: $util.oneOfGetter($oneOfFields = ["location"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new InteractiveAnnotation instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation=} [properties] Properties to set
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation instance
         */
        InteractiveAnnotation.create = function create(properties) {
            return new InteractiveAnnotation(properties);
        };

        /**
         * Encodes the specified InteractiveAnnotation message. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation} message InteractiveAnnotation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveAnnotation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.polygonVertices != null && message.polygonVertices.length)
                for (var i = 0; i < message.polygonVertices.length; ++i)
                    $root.proto.Point.encode(message.polygonVertices[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                $root.proto.Location.encode(message.location, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified InteractiveAnnotation message, length delimited. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation} message InteractiveAnnotation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveAnnotation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveAnnotation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.polygonVertices && message.polygonVertices.length))
                        message.polygonVertices = [];
                    message.polygonVertices.push($root.proto.Point.decode(reader, reader.uint32()));
                    break;
                case 2:
                    message.location = $root.proto.Location.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveAnnotation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveAnnotation message.
         * @function verify
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveAnnotation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.polygonVertices != null && message.hasOwnProperty("polygonVertices")) {
                if (!Array.isArray(message.polygonVertices))
                    return "polygonVertices: array expected";
                for (var i = 0; i < message.polygonVertices.length; ++i) {
                    var error = $root.proto.Point.verify(message.polygonVertices[i]);
                    if (error)
                        return "polygonVertices." + error;
                }
            }
            if (message.location != null && message.hasOwnProperty("location")) {
                properties.action = 1;
                {
                    var error = $root.proto.Location.verify(message.location);
                    if (error)
                        return "location." + error;
                }
            }
            return null;
        };

        /**
         * Creates an InteractiveAnnotation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         */
        InteractiveAnnotation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveAnnotation)
                return object;
            var message = new $root.proto.InteractiveAnnotation();
            if (object.polygonVertices) {
                if (!Array.isArray(object.polygonVertices))
                    throw TypeError(".proto.InteractiveAnnotation.polygonVertices: array expected");
                message.polygonVertices = [];
                for (var i = 0; i < object.polygonVertices.length; ++i) {
                    if (typeof object.polygonVertices[i] !== "object")
                        throw TypeError(".proto.InteractiveAnnotation.polygonVertices: object expected");
                    message.polygonVertices[i] = $root.proto.Point.fromObject(object.polygonVertices[i]);
                }
            }
            if (object.location != null) {
                if (typeof object.location !== "object")
                    throw TypeError(".proto.InteractiveAnnotation.location: object expected");
                message.location = $root.proto.Location.fromObject(object.location);
            }
            return message;
        };

        /**
         * Creates a plain object from an InteractiveAnnotation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.InteractiveAnnotation} message InteractiveAnnotation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveAnnotation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.polygonVertices = [];
            if (message.polygonVertices && message.polygonVertices.length) {
                object.polygonVertices = [];
                for (var j = 0; j < message.polygonVertices.length; ++j)
                    object.polygonVertices[j] = $root.proto.Point.toObject(message.polygonVertices[j], options);
            }
            if (message.location != null && message.hasOwnProperty("location")) {
                object.location = $root.proto.Location.toObject(message.location, options);
                if (options.oneofs)
                    object.action = "location";
            }
            return object;
        };

        /**
         * Converts this InteractiveAnnotation to JSON.
         * @function toJSON
         * @memberof proto.InteractiveAnnotation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveAnnotation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveAnnotation;
    })();

    proto.DeviceListMetadata = (function() {

        /**
         * Properties of a DeviceListMetadata.
         * @memberof proto
         * @interface IDeviceListMetadata
         * @property {Uint8Array|null} [senderKeyHash] DeviceListMetadata senderKeyHash
         * @property {number|Long|null} [senderTimestamp] DeviceListMetadata senderTimestamp
         * @property {Array.<number>|null} [senderKeyIndexes] DeviceListMetadata senderKeyIndexes
         * @property {Uint8Array|null} [recipientKeyHash] DeviceListMetadata recipientKeyHash
         * @property {number|Long|null} [recipientTimestamp] DeviceListMetadata recipientTimestamp
         * @property {Array.<number>|null} [recipientKeyIndexes] DeviceListMetadata recipientKeyIndexes
         */

        /**
         * Constructs a new DeviceListMetadata.
         * @memberof proto
         * @classdesc Represents a DeviceListMetadata.
         * @implements IDeviceListMetadata
         * @constructor
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         */
        function DeviceListMetadata(properties) {
            this.senderKeyIndexes = [];
            this.recipientKeyIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceListMetadata senderKeyHash.
         * @member {Uint8Array} senderKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata senderTimestamp.
         * @member {number|Long} senderTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata senderKeyIndexes.
         * @member {Array.<number>} senderKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyIndexes = $util.emptyArray;

        /**
         * DeviceListMetadata recipientKeyHash.
         * @member {Uint8Array} recipientKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata recipientTimestamp.
         * @member {number|Long} recipientTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata recipientKeyIndexes.
         * @member {Array.<number>} recipientKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyIndexes = $util.emptyArray;

        /**
         * Creates a new DeviceListMetadata instance using the specified properties.
         * @function create
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         * @returns {proto.DeviceListMetadata} DeviceListMetadata instance
         */
        DeviceListMetadata.create = function create(properties) {
            return new DeviceListMetadata(properties);
        };

        /**
         * Encodes the specified DeviceListMetadata message. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.senderKeyHash != null && Object.hasOwnProperty.call(message, "senderKeyHash"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.senderKeyHash);
            if (message.senderTimestamp != null && Object.hasOwnProperty.call(message, "senderTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.senderTimestamp);
            if (message.senderKeyIndexes != null && message.senderKeyIndexes.length) {
                writer.uint32(/* id 3, wireType 2 =*/26).fork();
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    writer.uint32(message.senderKeyIndexes[i]);
                writer.ldelim();
            }
            if (message.recipientKeyHash != null && Object.hasOwnProperty.call(message, "recipientKeyHash"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.recipientKeyHash);
            if (message.recipientTimestamp != null && Object.hasOwnProperty.call(message, "recipientTimestamp"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint64(message.recipientTimestamp);
            if (message.recipientKeyIndexes != null && message.recipientKeyIndexes.length) {
                writer.uint32(/* id 10, wireType 2 =*/82).fork();
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    writer.uint32(message.recipientKeyIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified DeviceListMetadata message, length delimited. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceListMetadata();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.senderKeyHash = reader.bytes();
                    break;
                case 2:
                    message.senderTimestamp = reader.uint64();
                    break;
                case 3:
                    if (!(message.senderKeyIndexes && message.senderKeyIndexes.length))
                        message.senderKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.senderKeyIndexes.push(reader.uint32());
                    } else
                        message.senderKeyIndexes.push(reader.uint32());
                    break;
                case 8:
                    message.recipientKeyHash = reader.bytes();
                    break;
                case 9:
                    message.recipientTimestamp = reader.uint64();
                    break;
                case 10:
                    if (!(message.recipientKeyIndexes && message.recipientKeyIndexes.length))
                        message.recipientKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.recipientKeyIndexes.push(reader.uint32());
                    } else
                        message.recipientKeyIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceListMetadata message.
         * @function verify
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceListMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                if (!(message.senderKeyHash && typeof message.senderKeyHash.length === "number" || $util.isString(message.senderKeyHash)))
                    return "senderKeyHash: buffer expected";
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (!$util.isInteger(message.senderTimestamp) && !(message.senderTimestamp && $util.isInteger(message.senderTimestamp.low) && $util.isInteger(message.senderTimestamp.high)))
                    return "senderTimestamp: integer|Long expected";
            if (message.senderKeyIndexes != null && message.hasOwnProperty("senderKeyIndexes")) {
                if (!Array.isArray(message.senderKeyIndexes))
                    return "senderKeyIndexes: array expected";
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.senderKeyIndexes[i]))
                        return "senderKeyIndexes: integer[] expected";
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                if (!(message.recipientKeyHash && typeof message.recipientKeyHash.length === "number" || $util.isString(message.recipientKeyHash)))
                    return "recipientKeyHash: buffer expected";
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (!$util.isInteger(message.recipientTimestamp) && !(message.recipientTimestamp && $util.isInteger(message.recipientTimestamp.low) && $util.isInteger(message.recipientTimestamp.high)))
                    return "recipientTimestamp: integer|Long expected";
            if (message.recipientKeyIndexes != null && message.hasOwnProperty("recipientKeyIndexes")) {
                if (!Array.isArray(message.recipientKeyIndexes))
                    return "recipientKeyIndexes: array expected";
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.recipientKeyIndexes[i]))
                        return "recipientKeyIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a DeviceListMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         */
        DeviceListMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceListMetadata)
                return object;
            var message = new $root.proto.DeviceListMetadata();
            if (object.senderKeyHash != null)
                if (typeof object.senderKeyHash === "string")
                    $util.base64.decode(object.senderKeyHash, message.senderKeyHash = $util.newBuffer($util.base64.length(object.senderKeyHash)), 0);
                else if (object.senderKeyHash.length)
                    message.senderKeyHash = object.senderKeyHash;
            if (object.senderTimestamp != null)
                if ($util.Long)
                    (message.senderTimestamp = $util.Long.fromValue(object.senderTimestamp)).unsigned = true;
                else if (typeof object.senderTimestamp === "string")
                    message.senderTimestamp = parseInt(object.senderTimestamp, 10);
                else if (typeof object.senderTimestamp === "number")
                    message.senderTimestamp = object.senderTimestamp;
                else if (typeof object.senderTimestamp === "object")
                    message.senderTimestamp = new $util.LongBits(object.senderTimestamp.low >>> 0, object.senderTimestamp.high >>> 0).toNumber(true);
            if (object.senderKeyIndexes) {
                if (!Array.isArray(object.senderKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.senderKeyIndexes: array expected");
                message.senderKeyIndexes = [];
                for (var i = 0; i < object.senderKeyIndexes.length; ++i)
                    message.senderKeyIndexes[i] = object.senderKeyIndexes[i] >>> 0;
            }
            if (object.recipientKeyHash != null)
                if (typeof object.recipientKeyHash === "string")
                    $util.base64.decode(object.recipientKeyHash, message.recipientKeyHash = $util.newBuffer($util.base64.length(object.recipientKeyHash)), 0);
                else if (object.recipientKeyHash.length)
                    message.recipientKeyHash = object.recipientKeyHash;
            if (object.recipientTimestamp != null)
                if ($util.Long)
                    (message.recipientTimestamp = $util.Long.fromValue(object.recipientTimestamp)).unsigned = true;
                else if (typeof object.recipientTimestamp === "string")
                    message.recipientTimestamp = parseInt(object.recipientTimestamp, 10);
                else if (typeof object.recipientTimestamp === "number")
                    message.recipientTimestamp = object.recipientTimestamp;
                else if (typeof object.recipientTimestamp === "object")
                    message.recipientTimestamp = new $util.LongBits(object.recipientTimestamp.low >>> 0, object.recipientTimestamp.high >>> 0).toNumber(true);
            if (object.recipientKeyIndexes) {
                if (!Array.isArray(object.recipientKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.recipientKeyIndexes: array expected");
                message.recipientKeyIndexes = [];
                for (var i = 0; i < object.recipientKeyIndexes.length; ++i)
                    message.recipientKeyIndexes[i] = object.recipientKeyIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a DeviceListMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.DeviceListMetadata} message DeviceListMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceListMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.senderKeyIndexes = [];
                object.recipientKeyIndexes = [];
            }
            if (options.defaults) {
                if (options.bytes === String)
                    object.senderKeyHash = "";
                else {
                    object.senderKeyHash = [];
                    if (options.bytes !== Array)
                        object.senderKeyHash = $util.newBuffer(object.senderKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.senderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.senderTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.recipientKeyHash = "";
                else {
                    object.recipientKeyHash = [];
                    if (options.bytes !== Array)
                        object.recipientKeyHash = $util.newBuffer(object.recipientKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.recipientTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.recipientTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                object.senderKeyHash = options.bytes === String ? $util.base64.encode(message.senderKeyHash, 0, message.senderKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderKeyHash) : message.senderKeyHash;
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (typeof message.senderTimestamp === "number")
                    object.senderTimestamp = options.longs === String ? String(message.senderTimestamp) : message.senderTimestamp;
                else
                    object.senderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.senderTimestamp) : options.longs === Number ? new $util.LongBits(message.senderTimestamp.low >>> 0, message.senderTimestamp.high >>> 0).toNumber(true) : message.senderTimestamp;
            if (message.senderKeyIndexes && message.senderKeyIndexes.length) {
                object.senderKeyIndexes = [];
                for (var j = 0; j < message.senderKeyIndexes.length; ++j)
                    object.senderKeyIndexes[j] = message.senderKeyIndexes[j];
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                object.recipientKeyHash = options.bytes === String ? $util.base64.encode(message.recipientKeyHash, 0, message.recipientKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.recipientKeyHash) : message.recipientKeyHash;
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (typeof message.recipientTimestamp === "number")
                    object.recipientTimestamp = options.longs === String ? String(message.recipientTimestamp) : message.recipientTimestamp;
                else
                    object.recipientTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.recipientTimestamp) : options.longs === Number ? new $util.LongBits(message.recipientTimestamp.low >>> 0, message.recipientTimestamp.high >>> 0).toNumber(true) : message.recipientTimestamp;
            if (message.recipientKeyIndexes && message.recipientKeyIndexes.length) {
                object.recipientKeyIndexes = [];
                for (var j = 0; j < message.recipientKeyIndexes.length; ++j)
                    object.recipientKeyIndexes[j] = message.recipientKeyIndexes[j];
            }
            return object;
        };

        /**
         * Converts this DeviceListMetadata to JSON.
         * @function toJSON
         * @memberof proto.DeviceListMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceListMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeviceListMetadata;
    })();

    proto.MessageContextInfo = (function() {

        /**
         * Properties of a MessageContextInfo.
         * @memberof proto
         * @interface IMessageContextInfo
         * @property {proto.IDeviceListMetadata|null} [deviceListMetadata] MessageContextInfo deviceListMetadata
         * @property {number|null} [deviceListMetadataVersion] MessageContextInfo deviceListMetadataVersion
         */

        /**
         * Constructs a new MessageContextInfo.
         * @memberof proto
         * @classdesc Represents a MessageContextInfo.
         * @implements IMessageContextInfo
         * @constructor
         * @param {proto.IMessageContextInfo=} [properties] Properties to set
         */
        function MessageContextInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MessageContextInfo deviceListMetadata.
         * @member {proto.IDeviceListMetadata|null|undefined} deviceListMetadata
         * @memberof proto.MessageContextInfo
         * @instance
         */
        MessageContextInfo.prototype.deviceListMetadata = null;

        /**
         * MessageContextInfo deviceListMetadataVersion.
         * @member {number} deviceListMetadataVersion
         * @memberof proto.MessageContextInfo
         * @instance
         */
        MessageContextInfo.prototype.deviceListMetadataVersion = 0;

        /**
         * Creates a new MessageContextInfo instance using the specified properties.
         * @function create
         * @memberof proto.MessageContextInfo
         * @static
         * @param {proto.IMessageContextInfo=} [properties] Properties to set
         * @returns {proto.MessageContextInfo} MessageContextInfo instance
         */
        MessageContextInfo.create = function create(properties) {
            return new MessageContextInfo(properties);
        };

        /**
         * Encodes the specified MessageContextInfo message. Does not implicitly {@link proto.MessageContextInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.MessageContextInfo
         * @static
         * @param {proto.IMessageContextInfo} message MessageContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MessageContextInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.deviceListMetadata != null && Object.hasOwnProperty.call(message, "deviceListMetadata"))
                $root.proto.DeviceListMetadata.encode(message.deviceListMetadata, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.deviceListMetadataVersion != null && Object.hasOwnProperty.call(message, "deviceListMetadataVersion"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.deviceListMetadataVersion);
            return writer;
        };

        /**
         * Encodes the specified MessageContextInfo message, length delimited. Does not implicitly {@link proto.MessageContextInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MessageContextInfo
         * @static
         * @param {proto.IMessageContextInfo} message MessageContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MessageContextInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MessageContextInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MessageContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MessageContextInfo} MessageContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MessageContextInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MessageContextInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.deviceListMetadata = $root.proto.DeviceListMetadata.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.deviceListMetadataVersion = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MessageContextInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MessageContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MessageContextInfo} MessageContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MessageContextInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MessageContextInfo message.
         * @function verify
         * @memberof proto.MessageContextInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MessageContextInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.deviceListMetadata != null && message.hasOwnProperty("deviceListMetadata")) {
                var error = $root.proto.DeviceListMetadata.verify(message.deviceListMetadata);
                if (error)
                    return "deviceListMetadata." + error;
            }
            if (message.deviceListMetadataVersion != null && message.hasOwnProperty("deviceListMetadataVersion"))
                if (!$util.isInteger(message.deviceListMetadataVersion))
                    return "deviceListMetadataVersion: integer expected";
            return null;
        };

        /**
         * Creates a MessageContextInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MessageContextInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MessageContextInfo} MessageContextInfo
         */
        MessageContextInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MessageContextInfo)
                return object;
            var message = new $root.proto.MessageContextInfo();
            if (object.deviceListMetadata != null) {
                if (typeof object.deviceListMetadata !== "object")
                    throw TypeError(".proto.MessageContextInfo.deviceListMetadata: object expected");
                message.deviceListMetadata = $root.proto.DeviceListMetadata.fromObject(object.deviceListMetadata);
            }
            if (object.deviceListMetadataVersion != null)
                message.deviceListMetadataVersion = object.deviceListMetadataVersion | 0;
            return message;
        };

        /**
         * Creates a plain object from a MessageContextInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MessageContextInfo
         * @static
         * @param {proto.MessageContextInfo} message MessageContextInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MessageContextInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.deviceListMetadata = null;
                object.deviceListMetadataVersion = 0;
            }
            if (message.deviceListMetadata != null && message.hasOwnProperty("deviceListMetadata"))
                object.deviceListMetadata = $root.proto.DeviceListMetadata.toObject(message.deviceListMetadata, options);
            if (message.deviceListMetadataVersion != null && message.hasOwnProperty("deviceListMetadataVersion"))
                object.deviceListMetadataVersion = message.deviceListMetadataVersion;
            return object;
        };

        /**
         * Converts this MessageContextInfo to JSON.
         * @function toJSON
         * @memberof proto.MessageContextInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MessageContextInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MessageContextInfo;
    })();

    proto.AdReplyInfo = (function() {

        /**
         * Properties of an AdReplyInfo.
         * @memberof proto
         * @interface IAdReplyInfo
         * @property {string|null} [advertiserName] AdReplyInfo advertiserName
         * @property {proto.AdReplyInfo.AdReplyInfoMediaType|null} [mediaType] AdReplyInfo mediaType
         * @property {Uint8Array|null} [jpegThumbnail] AdReplyInfo jpegThumbnail
         * @property {string|null} [caption] AdReplyInfo caption
         */

        /**
         * Constructs a new AdReplyInfo.
         * @memberof proto
         * @classdesc Represents an AdReplyInfo.
         * @implements IAdReplyInfo
         * @constructor
         * @param {proto.IAdReplyInfo=} [properties] Properties to set
         */
        function AdReplyInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AdReplyInfo advertiserName.
         * @member {string} advertiserName
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.advertiserName = "";

        /**
         * AdReplyInfo mediaType.
         * @member {proto.AdReplyInfo.AdReplyInfoMediaType} mediaType
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.mediaType = 0;

        /**
         * AdReplyInfo jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * AdReplyInfo caption.
         * @member {string} caption
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.caption = "";

        /**
         * Creates a new AdReplyInfo instance using the specified properties.
         * @function create
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo=} [properties] Properties to set
         * @returns {proto.AdReplyInfo} AdReplyInfo instance
         */
        AdReplyInfo.create = function create(properties) {
            return new AdReplyInfo(properties);
        };

        /**
         * Encodes the specified AdReplyInfo message. Does not implicitly {@link proto.AdReplyInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo} message AdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AdReplyInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.advertiserName != null && Object.hasOwnProperty.call(message, "advertiserName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.advertiserName);
            if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaType);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 17, wireType 2 =*/138).string(message.caption);
            return writer;
        };

        /**
         * Encodes the specified AdReplyInfo message, length delimited. Does not implicitly {@link proto.AdReplyInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo} message AdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AdReplyInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AdReplyInfo} AdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AdReplyInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AdReplyInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.advertiserName = reader.string();
                    break;
                case 2:
                    message.mediaType = reader.int32();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.caption = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AdReplyInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AdReplyInfo} AdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AdReplyInfo message.
         * @function verify
         * @memberof proto.AdReplyInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AdReplyInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                if (!$util.isString(message.advertiserName))
                    return "advertiserName: string expected";
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                switch (message.mediaType) {
                default:
                    return "mediaType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            return null;
        };

        /**
         * Creates an AdReplyInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AdReplyInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AdReplyInfo} AdReplyInfo
         */
        AdReplyInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AdReplyInfo)
                return object;
            var message = new $root.proto.AdReplyInfo();
            if (object.advertiserName != null)
                message.advertiserName = String(object.advertiserName);
            switch (object.mediaType) {
            case "NONE":
            case 0:
                message.mediaType = 0;
                break;
            case "IMAGE":
            case 1:
                message.mediaType = 1;
                break;
            case "VIDEO":
            case 2:
                message.mediaType = 2;
                break;
            }
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.caption != null)
                message.caption = String(object.caption);
            return message;
        };

        /**
         * Creates a plain object from an AdReplyInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.AdReplyInfo} message AdReplyInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AdReplyInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.advertiserName = "";
                object.mediaType = options.enums === String ? "NONE" : 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.caption = "";
            }
            if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                object.advertiserName = message.advertiserName;
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                object.mediaType = options.enums === String ? $root.proto.AdReplyInfo.AdReplyInfoMediaType[message.mediaType] : message.mediaType;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            return object;
        };

        /**
         * Converts this AdReplyInfo to JSON.
         * @function toJSON
         * @memberof proto.AdReplyInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AdReplyInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * AdReplyInfoMediaType enum.
         * @name proto.AdReplyInfo.AdReplyInfoMediaType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} IMAGE=1 IMAGE value
         * @property {number} VIDEO=2 VIDEO value
         */
        AdReplyInfo.AdReplyInfoMediaType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "IMAGE"] = 1;
            values[valuesById[2] = "VIDEO"] = 2;
            return values;
        })();

        return AdReplyInfo;
    })();

    proto.ExternalAdReplyInfo = (function() {

        /**
         * Properties of an ExternalAdReplyInfo.
         * @memberof proto
         * @interface IExternalAdReplyInfo
         * @property {string|null} [title] ExternalAdReplyInfo title
         * @property {string|null} [body] ExternalAdReplyInfo body
         * @property {proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType|null} [mediaType] ExternalAdReplyInfo mediaType
         * @property {string|null} [thumbnailUrl] ExternalAdReplyInfo thumbnailUrl
         * @property {string|null} [mediaUrl] ExternalAdReplyInfo mediaUrl
         * @property {Uint8Array|null} [thumbnail] ExternalAdReplyInfo thumbnail
         * @property {string|null} [sourceType] ExternalAdReplyInfo sourceType
         * @property {string|null} [sourceId] ExternalAdReplyInfo sourceId
         * @property {string|null} [sourceUrl] ExternalAdReplyInfo sourceUrl
         */

        /**
         * Constructs a new ExternalAdReplyInfo.
         * @memberof proto
         * @classdesc Represents an ExternalAdReplyInfo.
         * @implements IExternalAdReplyInfo
         * @constructor
         * @param {proto.IExternalAdReplyInfo=} [properties] Properties to set
         */
        function ExternalAdReplyInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExternalAdReplyInfo title.
         * @member {string} title
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.title = "";

        /**
         * ExternalAdReplyInfo body.
         * @member {string} body
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.body = "";

        /**
         * ExternalAdReplyInfo mediaType.
         * @member {proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType} mediaType
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.mediaType = 0;

        /**
         * ExternalAdReplyInfo thumbnailUrl.
         * @member {string} thumbnailUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.thumbnailUrl = "";

        /**
         * ExternalAdReplyInfo mediaUrl.
         * @member {string} mediaUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.mediaUrl = "";

        /**
         * ExternalAdReplyInfo thumbnail.
         * @member {Uint8Array} thumbnail
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.thumbnail = $util.newBuffer([]);

        /**
         * ExternalAdReplyInfo sourceType.
         * @member {string} sourceType
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceType = "";

        /**
         * ExternalAdReplyInfo sourceId.
         * @member {string} sourceId
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceId = "";

        /**
         * ExternalAdReplyInfo sourceUrl.
         * @member {string} sourceUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceUrl = "";

        /**
         * Creates a new ExternalAdReplyInfo instance using the specified properties.
         * @function create
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo=} [properties] Properties to set
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo instance
         */
        ExternalAdReplyInfo.create = function create(properties) {
            return new ExternalAdReplyInfo(properties);
        };

        /**
         * Encodes the specified ExternalAdReplyInfo message. Does not implicitly {@link proto.ExternalAdReplyInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalAdReplyInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
            if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.body);
            if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.mediaType);
            if (message.thumbnailUrl != null && Object.hasOwnProperty.call(message, "thumbnailUrl"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.thumbnailUrl);
            if (message.mediaUrl != null && Object.hasOwnProperty.call(message, "mediaUrl"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.mediaUrl);
            if (message.thumbnail != null && Object.hasOwnProperty.call(message, "thumbnail"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.thumbnail);
            if (message.sourceType != null && Object.hasOwnProperty.call(message, "sourceType"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.sourceType);
            if (message.sourceId != null && Object.hasOwnProperty.call(message, "sourceId"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.sourceId);
            if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.sourceUrl);
            return writer;
        };

        /**
         * Encodes the specified ExternalAdReplyInfo message, length delimited. Does not implicitly {@link proto.ExternalAdReplyInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalAdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExternalAdReplyInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalAdReplyInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExternalAdReplyInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.title = reader.string();
                    break;
                case 2:
                    message.body = reader.string();
                    break;
                case 3:
                    message.mediaType = reader.int32();
                    break;
                case 4:
                    message.thumbnailUrl = reader.string();
                    break;
                case 5:
                    message.mediaUrl = reader.string();
                    break;
                case 6:
                    message.thumbnail = reader.bytes();
                    break;
                case 7:
                    message.sourceType = reader.string();
                    break;
                case 8:
                    message.sourceId = reader.string();
                    break;
                case 9:
                    message.sourceUrl = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExternalAdReplyInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalAdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExternalAdReplyInfo message.
         * @function verify
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExternalAdReplyInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.body != null && message.hasOwnProperty("body"))
                if (!$util.isString(message.body))
                    return "body: string expected";
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                switch (message.mediaType) {
                default:
                    return "mediaType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                if (!$util.isString(message.thumbnailUrl))
                    return "thumbnailUrl: string expected";
            if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                if (!$util.isString(message.mediaUrl))
                    return "mediaUrl: string expected";
            if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                if (!(message.thumbnail && typeof message.thumbnail.length === "number" || $util.isString(message.thumbnail)))
                    return "thumbnail: buffer expected";
            if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                if (!$util.isString(message.sourceType))
                    return "sourceType: string expected";
            if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                if (!$util.isString(message.sourceId))
                    return "sourceId: string expected";
            if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                if (!$util.isString(message.sourceUrl))
                    return "sourceUrl: string expected";
            return null;
        };

        /**
         * Creates an ExternalAdReplyInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         */
        ExternalAdReplyInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExternalAdReplyInfo)
                return object;
            var message = new $root.proto.ExternalAdReplyInfo();
            if (object.title != null)
                message.title = String(object.title);
            if (object.body != null)
                message.body = String(object.body);
            switch (object.mediaType) {
            case "NONE":
            case 0:
                message.mediaType = 0;
                break;
            case "IMAGE":
            case 1:
                message.mediaType = 1;
                break;
            case "VIDEO":
            case 2:
                message.mediaType = 2;
                break;
            }
            if (object.thumbnailUrl != null)
                message.thumbnailUrl = String(object.thumbnailUrl);
            if (object.mediaUrl != null)
                message.mediaUrl = String(object.mediaUrl);
            if (object.thumbnail != null)
                if (typeof object.thumbnail === "string")
                    $util.base64.decode(object.thumbnail, message.thumbnail = $util.newBuffer($util.base64.length(object.thumbnail)), 0);
                else if (object.thumbnail.length)
                    message.thumbnail = object.thumbnail;
            if (object.sourceType != null)
                message.sourceType = String(object.sourceType);
            if (object.sourceId != null)
                message.sourceId = String(object.sourceId);
            if (object.sourceUrl != null)
                message.sourceUrl = String(object.sourceUrl);
            return message;
        };

        /**
         * Creates a plain object from an ExternalAdReplyInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.ExternalAdReplyInfo} message ExternalAdReplyInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExternalAdReplyInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.title = "";
                object.body = "";
                object.mediaType = options.enums === String ? "NONE" : 0;
                object.thumbnailUrl = "";
                object.mediaUrl = "";
                if (options.bytes === String)
                    object.thumbnail = "";
                else {
                    object.thumbnail = [];
                    if (options.bytes !== Array)
                        object.thumbnail = $util.newBuffer(object.thumbnail);
                }
                object.sourceType = "";
                object.sourceId = "";
                object.sourceUrl = "";
            }
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.body != null && message.hasOwnProperty("body"))
                object.body = message.body;
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                object.mediaType = options.enums === String ? $root.proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType[message.mediaType] : message.mediaType;
            if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                object.thumbnailUrl = message.thumbnailUrl;
            if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                object.mediaUrl = message.mediaUrl;
            if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                object.thumbnail = options.bytes === String ? $util.base64.encode(message.thumbnail, 0, message.thumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnail) : message.thumbnail;
            if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                object.sourceType = message.sourceType;
            if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                object.sourceId = message.sourceId;
            if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                object.sourceUrl = message.sourceUrl;
            return object;
        };

        /**
         * Converts this ExternalAdReplyInfo to JSON.
         * @function toJSON
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExternalAdReplyInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ExternalAdReplyInfoMediaType enum.
         * @name proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} IMAGE=1 IMAGE value
         * @property {number} VIDEO=2 VIDEO value
